/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.properties.sections;

import com.ez.common.ui.properties.sections.AbstractWidgetSection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableSection
extends AbstractWidgetSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger logger = LoggerFactory.getLogger(AbstractTableSection.class);
    protected Table table;
    protected List<TableColumn> columns;
    protected boolean isVirtual = false;
    private Map colIndexes;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout compositeLayout = this.getParentCompositeLayout();
        this.composite.setLayout((Layout)compositeLayout);
        this.findAndSetupScrolledComposite();
        this.addElementsBeforeTable();
        this.createTable();
        this.addElementsAfterTable();
        this.computeWidgetAbscice();
    }

    protected GridLayout getParentCompositeLayout() {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginLeft = 5;
        compositeLayout.marginTop = 5;
        compositeLayout.marginRight = 5;
        compositeLayout.marginBottom = 5;
        return compositeLayout;
    }

    protected void createTable() {
        int style = 66306;
        if (this.isVirtual) {
            style |= 0x10000000;
        }
        this.table = this.getWidgetFactory().createTable(this.composite, style);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.columns = new ArrayList<TableColumn>();
        this.colIndexes = this.getColumnLabelsAndIndexes();
        if (this.colIndexes != null && !this.colIndexes.isEmpty()) {
            TreeSet st = new TreeSet();
            st.addAll(this.colIndexes.keySet());
            for (Integer id : st) {
                int index = id;
                String[] names = (String[])this.colIndexes.get(id);
                String label = names[0];
                String tip = names[1];
                TableColumn column = new TableColumn(this.table, 0, index);
                if (label != null) {
                    column.setText(label);
                }
                if (tip != null) {
                    column.setToolTipText(tip);
                }
                this.columns.add(column);
            }
        }
        this.addSelectionColorToWidget();
        this.addColumnSelectionListeners();
        GridData data = this.getTableLayout();
        this.table.setLayoutData((Object)data);
    }

    protected void addColumnSelectionListeners() {
        int i = 0;
        for (TableColumn column : this.columns) {
            final int index = i++;
            column.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableItem[] items = AbstractTableSection.this.table.getItems();
                    Collator collator = Collator.getInstance(Locale.getDefault());
                    int i = 1;
                    while (i < items.length) {
                        String value1 = items[i].getText(index);
                        int j = 0;
                        while (j < i) {
                            String value2 = items[j].getText(index);
                            if (collator.compare(value1, value2) < 0) {
                                String[] values = new String[AbstractTableSection.this.columns.size()];
                                int cc = 0;
                                while (cc < AbstractTableSection.this.columns.size()) {
                                    values[cc] = items[i].getText(cc);
                                    ++cc;
                                }
                                items[i].dispose();
                                TableItem item = new TableItem(AbstractTableSection.this.table, 0, j);
                                item.setText(values);
                                items = AbstractTableSection.this.table.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    protected GridData getTableLayout() {
        GridData data = new GridData(4, 4, true, true);
        data.verticalAlignment = 128;
        return data;
    }

    public void refresh() {
        boolean repaint = false;
        if (!this.allowRefresh()) {
            return;
        }
        if (this.isWidgetAvailable(new Widget[]{this.table}) && this.table.getSelectionCount() > 0) {
            this.showSelection(false, true);
        }
        if (this.currentSelectedItem != null && this.currentSelectedItem == this.selectedItem) {
            if (this.isWidgetAvailable(new Widget[]{this.table})) {
                this.table.setVisible(true);
            }
            return;
        }
        if (this.table != null && this.table.isDisposed()) {
            return;
        }
        if (this.isWidgetAvailable(new Widget[]{this.table})) {
            this.table.deselectAll();
        }
        this.currentSelectedItem = this.selectedItem;
        ArrayList<TableItem> selectionList = new ArrayList<TableItem>();
        if (this.displayedResource == null || this.displayedResource != null && this.resource != null && !this.displayedResource.getFullPath().equals((Object)this.resource.getFullPath()) || this.table.getItemCount() == 0) {
            this.table.setVisible(false);
            repaint = true;
            this.displayedResource = this.resource;
            this.fillTable();
            Rectangle rect3 = this.getWidget().getBounds();
            rect3 = this.composite.getBounds();
            int totalHeight = this.getTotalHeight();
            if (totalHeight > rect3.height) {
                rect3.height = totalHeight;
            }
            if (this.getWidget().getBounds().height < rect3.height) {
                this.getWidget().setBounds(rect3);
            }
            if (this.composite.getParent().getParent().getBounds().height < rect3.height) {
                this.composite.getParent().getParent().setBounds(rect3);
            }
            this.resizeScrolledComposite();
        }
        this.displayedResource = this.resource;
        if (this.table.isVisible() && repaint) {
            this.table.setVisible(false);
        }
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object data = item.getData();
            if (this.table.isVisible() && repaint) {
                this.table.setVisible(false);
            }
            if (this.isSelected(data)) {
                selectionList.add(item);
            }
            ++i;
        }
        if (!selectionList.isEmpty()) {
            this.table.setSelection(selectionList.toArray(new TableItem[0]));
        }
        if (this.table.isVisible() && repaint) {
            this.table.setVisible(false);
        }
        this.scrolledComposite.setVisible(true);
        if (!selectionList.isEmpty()) {
            this.table.showSelection();
        }
        if (!this.started) {
            this.started = true;
            this.computeWidgetAbscice();
            this.scrolledComposite.layout(true, true);
            this.resizeScrolledComposite();
        }
        this.refreshWidgets();
        this.showSelection();
        this.scrolledComposite.layout(true, true);
        Rectangle rect = this.scrolledComposite.getBounds();
        int height = this.getTotalHeight();
        if (height < rect.height) {
            height = rect.height;
        }
        this.scrolledComposite.setMinHeight(height + 1);
        if (this.composite.getParent().getParent().getBounds().height < height + 10) {
            Rectangle rect4 = this.composite.getParent().getParent().getBounds();
            rect4.height = height + 100;
            this.composite.getParent().getParent().setBounds(rect4);
        }
        if (!this.table.isVisible()) {
            this.table.setVisible(true);
        }
        this.resizeScrolledComposite();
        this.scrolledComposite.setVisible(true);
        this.refreshWidgets();
        this.scrolledComposite.redraw();
        this.scrolledComposite.getVerticalBar().setVisible(true);
    }

    protected void showSelection(boolean doLayout, boolean doListeners) {
        if (this.isWidgetAvailable(new Widget[]{this.getWidget()})) {
            ScrollBar bar;
            float i = this.findTotalSelectionPercentage();
            if (this.scrolledComposite != null && (bar = this.scrolledComposite.getVerticalBar()) != null) {
                Listener[] l;
                int maxValue = this.getTotalHeight();
                int maximum = bar.getMaximum();
                if (doLayout) {
                    bar.setVisible(true);
                    this.scrolledComposite.layout(true, true);
                }
                maximum = maxValue;
                bar.setMaximum(maximum);
                bar.setIncrement(10);
                int max = bar.getMaximum();
                int selection = (int)(i * (float)max);
                bar.setSelection(selection);
                if (doListeners && (l = bar.getListeners(13)) != null && l.length > 0) {
                    int j = 0;
                    while (j < l.length) {
                        Listener li = l[j];
                        Event e = new Event();
                        li.handleEvent(e);
                        ++j;
                    }
                }
            }
        }
    }

    protected void fillTable() {
        Set rows;
        this.table.removeAll();
        this.table.setVisible(false);
        Control[] childrens = this.table.getChildren();
        if (childrens != null) {
            int i = 0;
            while (i < childrens.length) {
                Control c = childrens[i];
                c.dispose();
                ++i;
            }
        }
        if ((rows = this.getOwnedRows()) != null) {
            for (Object next : rows) {
                Object objNextKey = this.getKeyForRow(next);
                if (this.table.isVisible()) {
                    this.table.setVisible(false);
                }
                int k = -1;
                if (objNextKey != null) {
                    k = 0;
                    int size = this.table.getItemCount();
                    while (k < size) {
                        Object objCurrentKey = this.getKeyForRow(this.table.getItem(k).getData());
                        if (objCurrentKey != null) {
                            if (objNextKey instanceof Object[]) {
                                Object[] arrayNextKey = (Object[])objNextKey;
                                String pathNextKey = (String)arrayNextKey[0];
                                Object[] arrayCurrentKey = (Object[])objCurrentKey;
                                String pathCurrentKey = (String)arrayCurrentKey[0];
                                if (pathNextKey.compareToIgnoreCase(pathCurrentKey) < 0) break;
                                if (pathNextKey.compareToIgnoreCase(pathCurrentKey) == 0) {
                                    Integer lineNextKey = arrayNextKey[1] != null ? (Integer)arrayNextKey[1] : 0;
                                    Integer lineCurrentKey = arrayCurrentKey[1] != null ? (Integer)arrayCurrentKey[1] : 0;
                                    if (lineCurrentKey > lineNextKey) break;
                                    if (lineCurrentKey == lineNextKey) {
                                        Integer colNextKey = arrayNextKey[2] != null ? (Integer)arrayNextKey[2] : 0;
                                        Integer colCurrentKey = arrayCurrentKey[2] != null ? (Integer)arrayCurrentKey[2] : 0;
                                        if (colCurrentKey > colNextKey) {
                                            break;
                                        }
                                    }
                                }
                            } else if (objNextKey instanceof String) {
                                String strKey = (String)objNextKey;
                                if (strKey.compareToIgnoreCase(objCurrentKey.toString()) < 0) {
                                    break;
                                }
                            } else if (objNextKey instanceof Integer) {
                                Integer intKey = (Integer)objNextKey;
                                Integer currKey = (Integer)objCurrentKey;
                                if (intKey.compareTo(currKey) < 0) {
                                    break;
                                }
                            } else {
                                logger.warn("keys for your table item must be String or Integer");
                            }
                        }
                        ++k;
                    }
                }
                if (this.table.isVisible()) {
                    this.table.setVisible(false);
                }
                TableItem item = k != -1 ? new TableItem(this.table, 0, k) : new TableItem(this.table, 0);
                String[] values = new String[this.columns.size()];
                List valuesForRow = this.getValuesForRow(next);
                if (this.table.isVisible()) {
                    this.table.setVisible(false);
                }
                int j = 0;
                while (j < this.columns.size()) {
                    Object val = valuesForRow.get(j);
                    if (val instanceof Boolean) {
                        TableEditor editor = new TableEditor(this.table);
                        Button button = new Button((Composite)this.table, 32);
                        button.pack();
                        button.setEnabled(false);
                        boolean bool = (Boolean)val;
                        button.setSelection(bool);
                        editor.minimumWidth = button.getSize().x;
                        editor.horizontalAlignment = 0x1000000;
                        editor.setEditor((Control)button, item, j);
                    } else {
                        String strVal = val != null && !(val instanceof String) ? val.toString() : (String)val;
                        values[j] = strVal;
                    }
                    ++j;
                }
                if (this.table.isVisible()) {
                    this.table.setVisible(false);
                }
                item.setText(values);
                item.setData(next);
            }
        } else {
            logger.info("no rows!!");
        }
        for (TableColumn column : this.columns) {
            column.pack();
        }
    }

    @Override
    protected void showSelection() {
        super.showSelection();
    }

    @Override
    protected float findSelectionPercentage() {
        float result = 0.0f;
        if (this.isWidgetAvailable(new Widget[]{this.table})) {
            int wholeHeight;
            int clientHeight;
            if (this.table.getSelectionCount() > 0) {
                int firstIndex = this.table.getSelectionIndices()[0];
                int totalItems = this.table.getItemCount();
                int headerHeight = 0;
                if (this.table.getHeaderVisible()) {
                    headerHeight = this.table.getHeaderHeight();
                }
                int selectionHeight = firstIndex * this.table.getItemHeight() + headerHeight;
                int totalHeight = totalItems * this.table.getItemHeight() + headerHeight;
                result = (float)selectionHeight / (float)totalHeight;
            }
            if ((clientHeight = this.scrolledComposite.getClientArea().height) - (wholeHeight = this.table.getBounds().height) > -5) {
                result = 0.0f;
            }
        }
        return result;
    }

    @Override
    protected int getWidgetItemHeight() {
        int result = 0;
        if (this.isWidgetAvailable(new Widget[]{this.table})) {
            result = this.table.getItemHeight();
        }
        return result;
    }

    protected abstract Set getOwnedRows();

    protected abstract Object getKeyForRow(Object var1);

    protected abstract List getValuesForRow(Object var1);

    @Override
    protected Composite getWidget() {
        return this.table;
    }

    protected abstract Map getColumnLabelsAndIndexes();

    protected abstract int getHeightHint();

    protected abstract int getWidthHint();

    protected abstract void addElementsBeforeTable();

    protected abstract void addElementsAfterTable();
}

