/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.properties.sections;

import com.ez.common.ui.guielements.IEzPropertySelection;
import com.ez.common.ui.guielements.TabType;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEZSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected Composite composite;
    protected ScrolledComposite scrolledComposite;
    protected IResource resource;
    protected Object selectedItem;
    protected TabbedPropertySheetPage page;
    protected boolean showAlways = false;

    public void aboutToBeShown() {
        if (this.isWidgetAvailable(new Widget[]{this.composite})) {
            Composite composite = this.getParentComposite();
        }
        super.aboutToBeShown();
    }

    protected void checkSelectedItem() {
        if (this.resource != null && this.resource instanceof IEzPropertySelection) {
            IEzPropertySelection prop = (IEzPropertySelection)this.resource;
            if (prop.getSelectionLabel() != null) {
                this.selectedItem = prop.getFoundObject().getObject();
                TabType type = prop.getSelectionType();
                Set<TabType> parentTabs = this.getParentTabs();
                if (parentTabs != null && !parentTabs.isEmpty() && type != null) {
                    if (!parentTabs.contains((Object)type)) {
                        this.selectedItem = null;
                    } else {
                        prop.getFiredSelection().remove((Object)TabType.STARTED);
                    }
                }
            } else {
                this.selectedItem = null;
            }
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            if (input instanceof IResource) {
                this.resource = (IResource)input;
                this.checkSelectedItem();
                if (this.isShowingOtherTab(selection)) {
                    this.resource = null;
                } else {
                    this.setSectionInput(part, selection);
                }
            } else {
                this.showAlways = true;
                this.setSectionInput(part, selection);
            }
        }
    }

    protected abstract void setSectionInput(IWorkbenchPart var1, ISelection var2);

    protected boolean allowRefresh() {
        boolean result = false;
        if (this.resource != null || this.showAlways) {
            if (this.isWidgetAvailable(new Widget[]{this.composite}) && !this.composite.isVisible() && this.isWidgetAvailable(new Widget[]{this.scrolledComposite})) {
                this.scrolledComposite.setVisible(false);
                this.scrolledComposite.setVisible(true);
            }
            if (this.isWidgetAvailable(new Widget[]{this.composite})) {
                this.composite.setVisible(true);
                result = true;
            }
            result = true;
        } else if (this.isWidgetAvailable(new Widget[]{this.composite})) {
            this.composite.setVisible(false);
        }
        return result;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.composite = this.getWidgetFactory().createComposite(parent);
        this.findScrolledComposite();
        this.composite.setVisible(false);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage, boolean flatForm) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.composite = !flatForm ? this.getWidgetFactory().createComposite(parent) : this.getWidgetFactory().createFlatFormComposite(parent);
        this.findScrolledComposite();
        this.composite.setVisible(false);
    }

    private Composite getParentComposite() {
        Composite result = null;
        if (this.composite != null && !this.composite.isDisposed()) {
            result = this.composite.getParent().getParent();
            result = (Composite)this.scrolledComposite.getContent();
        }
        return result;
    }

    public void aboutToBeHidden() {
        if (this.isWidgetAvailable(new Widget[]{this.composite})) {
            Composite composite = this.getParentComposite();
        }
        super.aboutToBeHidden();
    }

    protected void findScrolledComposite() {
        if (this.composite != null) {
            Composite c = this.composite;
            while (c.getParent() != null && this.scrolledComposite == null) {
                if (c instanceof ScrolledComposite) {
                    this.scrolledComposite = (ScrolledComposite)c;
                }
                c = c.getParent();
            }
            if (this.scrolledComposite == null && c instanceof ScrolledComposite) {
                this.scrolledComposite = (ScrolledComposite)c;
            }
        }
    }

    protected boolean isWidgetAvailable(Widget ... w) {
        boolean result = false;
        if (w != null) {
            boolean allAreOK = true;
            int i = 0;
            while (i < w.length) {
                Widget widget = w[i];
                if (widget == null || widget.isDisposed()) {
                    allAreOK = false;
                    break;
                }
                ++i;
            }
            result = allAreOK;
        }
        return result;
    }

    protected abstract Set<TabType> getParentTabs();

    protected abstract boolean isShowingOtherTab(ISelection var1);

    protected void hideWidgets(Control ... widgets) {
        GridData hide = new GridData(0, 0);
        hide.exclude = true;
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            widget.setVisible(false);
            widget.setLayoutData((Object)hide);
            ++n2;
        }
    }

    protected void showWidgets(Control ... widgets) {
        GridData show = new GridData();
        show.grabExcessHorizontalSpace = true;
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            widget.setVisible(true);
            if (widget instanceof Label) {
                widget.setLayoutData(null);
            } else {
                widget.setLayoutData((Object)show);
            }
            widget.pack();
            ++n2;
        }
    }
}

