/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.preferences.pages;

import com.ez.common.ui.internal.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnpackedLibsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UnpackedLibsPreferencePage.class);
    public static final String PAGE_ID = "com.ez.common.ui.preferences.pages.UnpackedLibsPreferencePage";
    private IWorkspaceRoot root;
    private List<QualifiedName> qnames = new ArrayList<QualifiedName>();
    private static Map<QualifiedName, String> unpackedlibs = null;
    private List<Text> textBoxJarsDllLoc;

    private void getQualifiedNamesList() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ez.common.ui.unpacked.libs");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                IConfigurationElement[] configElements = ext.getConfigurationElements();
                if (configElements != null) {
                    int j = 0;
                    while (j < configElements.length) {
                        String libName = null;
                        String category = null;
                        String[] stringArray = configElements[j].getAttributeNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String attribute = stringArray[n2];
                            if (attribute.equals("name")) {
                                libName = configElements[j].getAttribute(attribute);
                            } else if (attribute.equals("category")) {
                                category = configElements[j].getAttribute(attribute);
                            }
                            ++n2;
                        }
                        this.qnames.add(new QualifiedName(category, libName));
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite linksParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        linksParent.setLayout((Layout)layout);
        linksParent.setFont(parent.getFont());
        this.getQualifiedNamesList();
        Collections.sort(this.qnames, new Comparator<QualifiedName>(){

            @Override
            public int compare(QualifiedName o1, QualifiedName o2) {
                int res = o1.getQualifier().compareTo(o2.getQualifier());
                if (res == 0) {
                    res = o1.getLocalName().compareTo(o2.getLocalName());
                }
                return res;
            }
        });
        Text description = new Text(linksParent, 8);
        description.setText(Messages.getString(UnpackedLibsPreferencePage.class, "description"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        description.setLayoutData((Object)gridData);
        String category = "";
        for (final QualifiedName qn : this.qnames) {
            if (!category.equals(qn.getQualifier())) {
                GridData gd = new GridData();
                gd.horizontalSpan = 3;
                Text categoryLabel = new Text(linksParent, 16392);
                categoryLabel.setText(qn.getQualifier());
                categoryLabel.setLayoutData((Object)gd);
                category = qn.getQualifier();
            }
            Label jarsDllLabel = new Label(linksParent, 0x1000000);
            jarsDllLabel.setText(String.valueOf(qn.getLocalName()) + ":");
            jarsDllLabel.setAlignment(16384);
            final GridData locgd = new GridData(768);
            final Text jarDllLoc = new Text(linksParent, 2048);
            try {
                this.root = ResourcesPlugin.getWorkspace().getRoot();
                if (this.root.getPersistentProperty(qn) != null && !this.root.getPersistentProperty(qn).isEmpty()) {
                    jarDllLoc.setText(this.root.getPersistentProperty(qn));
                } else {
                    jarDllLoc.setText("");
                }
            }
            catch (CoreException e) {
                L.error("error when accessing persistent properties", (Throwable)e);
            }
            jarDllLoc.setLayoutData((Object)locgd);
            jarDllLoc.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    Text text = (Text)event.widget;
                    String path = text.getText();
                    if (path == null || !path.isEmpty()) {
                        File fdPath = new File(path);
                        if (!fdPath.isFile()) {
                            UnpackedLibsPreferencePage.this.setErrorMessage(Messages.getString(UnpackedLibsPreferencePage.class, "nopath.error.message"));
                        } else {
                            UnpackedLibsPreferencePage.this.setErrorMessage(null);
                        }
                    } else {
                        UnpackedLibsPreferencePage.this.setErrorMessage(null);
                        if (unpackedlibs == null) {
                            unpackedlibs = new Hashtable();
                        }
                        unpackedlibs.put(qn, "");
                    }
                }
            });
            if (this.textBoxJarsDllLoc == null) {
                this.textBoxJarsDllLoc = new ArrayList<Text>();
            }
            this.textBoxJarsDllLoc.add(jarDllLoc);
            Button openFD = new Button(linksParent, 0);
            openFD.setText(Messages.getString(UnpackedLibsPreferencePage.class, "browse.button"));
            final Shell shell = this.getShell();
            openFD.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (e.type == 13) {
                        FileDialog fd = new FileDialog(shell, 4096);
                        fd.setFilterPath(UnpackedLibsPreferencePage.this.getLastPath(jarDllLoc.getText()));
                        fd.open();
                        if (unpackedlibs == null) {
                            unpackedlibs = new Hashtable();
                        }
                        StringBuilder sb = new StringBuilder(String.valueOf(fd.getFilterPath()) + File.separator + fd.getFileName());
                        unpackedlibs.put(qn, sb.toString());
                        jarDllLoc.setText(sb.toString());
                        jarDllLoc.setLayoutData((Object)locgd);
                    }
                }
            });
        }
        return linksParent;
    }

    public String getLastPath(String filename) {
        File last = new File(filename);
        return last.getParent();
    }

    private void setunpackedlibs() {
        if (unpackedlibs != null) {
            for (QualifiedName qn : unpackedlibs.keySet()) {
                try {
                    this.root.setPersistentProperty(qn, unpackedlibs.get(qn));
                }
                catch (CoreException e) {
                    L.error("error when setting persistent properties", (Throwable)e);
                }
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (unpackedlibs != null) {
            for (QualifiedName qn : unpackedlibs.keySet()) {
                try {
                    this.root.setPersistentProperty(qn, "");
                }
                catch (CoreException e) {
                    L.error("error when cleaning persistent properties", (Throwable)e);
                }
            }
        }
        unpackedlibs = null;
        if (this.root != null) {
            try {
                Map qnMap = this.root.getPersistentProperties();
                for (QualifiedName qn : qnMap.keySet()) {
                    if (!qn.getQualifier().equals("cross") && !qn.getQualifier().equals("sap")) continue;
                    this.root.setPersistentProperty(qn, "");
                }
            }
            catch (CoreException e) {
                L.error("error when cleaning persistent properties", (Throwable)e);
            }
        }
        if (this.textBoxJarsDllLoc != null) {
            for (Text textBox : this.textBoxJarsDllLoc) {
                textBox.setText("");
            }
        }
    }

    public boolean performOk() {
        boolean res = this.isValid();
        if (res) {
            this.setunpackedlibs();
        }
        return res;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        Button applyButton = this.getApplyButton();
        if (newMessage == null) {
            applyButton.setEnabled(true);
            this.setValid(true);
        } else {
            applyButton.setEnabled(false);
            this.setValid(false);
        }
    }

    public boolean isValid() {
        boolean isV = true;
        if (this.getErrorMessage() != null) {
            isV = false;
        }
        return isV;
    }
}

