/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.preferences.pages;

import com.ez.common.ui.guielements.PasswordFieldEditor;
import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.preferences.pages.EZFieldEditorPreferencePage;
import com.ibm.ad.internal.PasswordUtils;
import java.util.Map;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class GlobalWebServicePrefPage
extends EZFieldEditorPreferencePage {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String P_HOST = "host";
    protected static final String P_PORT = "port";
    protected static final String DEF_PORT = "9080";
    protected static final String P_PROTOCOL = "protocol";
    protected static final String P_AUTH_TYPE = "authentication.type";
    protected static final String P_USER = "authentication.username";
    protected static final String P_PASW = "authentication.password";
    protected StringFieldEditor hostFieldEditor;
    protected IntegerFieldEditor portFieldEditor;
    protected ComboFieldEditor protocolFieldEditor;
    protected RadioGroupFieldEditor authenticationFieldEditor;
    protected StringFieldEditor usrFieldEditor;
    protected PasswordFieldEditor passwFieldEditor;
    private Composite parent;
    private Button noneBtn;
    protected Map<String, String> prefKeys = null;

    public GlobalWebServicePrefPage(String pageDescription, IPreferenceStore prefStore) {
        super(1);
        this.setDescription(pageDescription);
        this.globalStore = prefStore;
        this.setPreferenceStore(this.globalStore);
    }

    @Override
    protected void createMainFieldEditors(Composite parent) {
        Control[] btns;
        this.parent = parent;
        this.hostFieldEditor = new StringFieldEditor(this.prefKeys.get(P_HOST), Messages.getString(GlobalWebServicePrefPage.class, "host.label"), parent);
        this.addField((FieldEditor)this.hostFieldEditor);
        this.portFieldEditor = new IntegerFieldEditor(this.prefKeys.get(P_PORT), Messages.getString(GlobalWebServicePrefPage.class, "port.label"), parent);
        this.addField((FieldEditor)this.portFieldEditor);
        String[][] protoNamesAndValues = new String[][]{{"http", "http"}, {"https", "https"}};
        this.protocolFieldEditor = new ComboFieldEditor(this.prefKeys.get(P_PROTOCOL), Messages.getString(GlobalWebServicePrefPage.class, "protocol.label"), protoNamesAndValues, parent);
        this.addField((FieldEditor)this.protocolFieldEditor);
        String noneValue = "none";
        String[][] authNamesAndValues = new String[][]{{Messages.getString(GlobalWebServicePrefPage.class, "auth.label.none"), noneValue}, {Messages.getString(GlobalWebServicePrefPage.class, "auth.label.basic"), "basic"}};
        this.authenticationFieldEditor = new RadioGroupFieldEditor(this.prefKeys.get(P_AUTH_TYPE), Messages.getString(GlobalWebServicePrefPage.class, "auth.label"), 2, authNamesAndValues, parent, true);
        this.addField((FieldEditor)this.authenticationFieldEditor);
        Composite radioBoxControl = this.authenticationFieldEditor.getRadioBoxControl(parent);
        Control[] controlArray = btns = radioBoxControl.getChildren();
        int n = btns.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c.getData().equals(noneValue)) {
                this.noneBtn = (Button)c;
                break;
            }
            ++n2;
        }
        if (this.noneBtn != null) {
            this.noneBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GlobalWebServicePrefPage.this.enableAuth();
                }
            });
        }
        this.usrFieldEditor = new StringFieldEditor(this.prefKeys.get(P_USER), Messages.getString(GlobalWebServicePrefPage.class, "user.label"), radioBoxControl);
        this.addField((FieldEditor)this.usrFieldEditor);
        this.passwFieldEditor = new PasswordFieldEditor(this.prefKeys.get(P_PASW), Messages.getString(GlobalWebServicePrefPage.class, "passw.label"), radioBoxControl){

            protected void doStore() {
                String t = this.getTextControl().getText();
                String s = PasswordUtils.encrypt((String)t);
                this.getPreferenceStore().setValue(this.getPreferenceName(), s);
            }

            protected void doLoad() {
                if (this.getTextControl() != null) {
                    String value = this.getPreferenceStore().getString(this.getPreferenceName());
                    value = PasswordUtils.decrypt((String)value);
                    this.getTextControl().setText(value);
                    this.oldValue = value;
                }
            }

            public String getStringValue() {
                if (this.getTextControl() != null) {
                    return this.getTextControl().getText();
                }
                String pref = this.getPreferenceStore().getString(this.getPreferenceName());
                return PasswordUtils.decrypt((String)pref);
            }

            public void setStringValue(String value) {
                value = PasswordUtils.decrypt((String)value);
                Text textField = this.getTextControl();
                if (textField != null) {
                    if (value == null) {
                        value = "";
                    }
                    if (!textField.isDisposed()) {
                        this.oldValue = textField.getText();
                        if (!this.oldValue.equals(value)) {
                            textField.setText(value);
                            this.valueChanged();
                        }
                    }
                }
            }
        };
        this.addField((FieldEditor)this.passwFieldEditor);
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        ((GridLayout)this.parent.getLayout()).numColumns = 2;
        Composite radioBoxControl = this.authenticationFieldEditor.getRadioBoxControl(this.parent);
        GridLayout lay = (GridLayout)radioBoxControl.getLayout();
        lay.marginHeight = 5;
        lay.marginWidth = 5;
        Control[] ctrls = radioBoxControl.getChildren();
        GridData data = new GridData();
        data.horizontalIndent = 5;
        data.verticalIndent = 5;
        ctrls[0].setLayoutData((Object)data);
        data = new GridData();
        data.horizontalIndent = 5;
        data.verticalIndent = 5;
        ctrls[1].setLayoutData((Object)data);
        data = new GridData();
        data.horizontalIndent = 5;
        ctrls[2].setLayoutData((Object)data);
        data = new GridData();
        data.horizontalIndent = 5;
        ctrls[4].setLayoutData((Object)data);
    }

    @Override
    protected abstract String getGlobalPageID();

    private void enableAuth() {
        Composite parent = this.noneBtn.getParent();
        boolean selected = this.noneBtn.getSelection();
        if (selected) {
            this.usrFieldEditor.getTextControl(parent).setEnabled(false);
            this.passwFieldEditor.getTextControl(parent).setEnabled(false);
        } else {
            this.usrFieldEditor.getTextControl(parent).setEnabled(true);
            this.passwFieldEditor.getTextControl(parent).setEnabled(true);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.noneBtn != null && this.isLocal.booleanValue()) {
            this.enableAuth();
        }
    }
}

