/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.preferences.pages;

import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.preferences.PreferencesUtil;
import com.ez.common.ui.swt.Controls;
import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.EnvironmentService;
import com.ez.mu.utils.ExternalizeMessages;
import com.ez.ssdp.ServiceLocation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(GlobalPreferencePage.class);
    static final String PAGE_ID = "com.ez.common.ui.preferences.pages.ServerPreferencePage";
    private static final String RESTART_MESSAGE = Messages.getString(GlobalPreferencePage.class, "needRestart.message");
    private LinkedList<Environment> envs;
    private Combo choose;
    private Environment env;
    private Composite sharedGroup = null;
    private Composite localGroup = null;
    private Text txtIP = null;
    private Text txtPort = null;
    private Text txtId = null;
    private Text txtName = null;
    private Button btnLocal = null;
    private Environment localEnv = null;

    public GlobalPreferencePage() {
        this.setDescription(Messages.getString(GlobalPreferencePage.class, "page.description"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PreferencesUtil.getStore());
        this.resetEnvs();
        this.loadSelected();
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 10;
        layout.marginWidth = 0;
        c.setLayout((Layout)layout);
        c.setFont(parent.getFont());
        c.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createMainContent(c);
        this.createEditArea(c);
        Map<String, IConfigurationElement> toAdd = PreferencesUtil.getChildrenPages(PAGE_ID);
        if (toAdd != null && !toAdd.isEmpty()) {
            Label lblSeparator = new Label(parent, 258);
            GridData data = new GridData(4, 128, true, false);
            lblSeparator.setLayoutData((Object)data);
            Composite linkParent = new Composite(parent, 0);
            GridLayout lay = new GridLayout();
            lay.numColumns = 1;
            lay.marginHeight = 10;
            lay.marginWidth = 0;
            linkParent.setLayout((Layout)lay);
            linkParent.setFont(parent.getFont());
            linkParent.setLayoutData((Object)new GridData(4, 128, true, true));
            PreferencesUtil.addLinksToPages(toAdd, linkParent);
        }
        return parent;
    }

    private Control createMainContent(Composite parent) {
        this.sharedGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        this.sharedGroup.setLayout((Layout)layout);
        this.choose = new Combo(this.sharedGroup, 12);
        GridData d = new GridData();
        d.widthHint = 400;
        this.choose.setLayoutData((Object)d);
        Button refresh = new Button(this.sharedGroup, 8);
        refresh.setText(ExternalizeMessages.getString(((Object)((Object)this)).getClass(), (String)"refresh.text", null));
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalPreferencePage.this.resetEnvs();
                GlobalPreferencePage.this.populateCombo();
            }
        });
        this.choose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                Combo combo = GlobalPreferencePage.this.choose;
                int index = combo.getSelectionIndex();
                if (index > 0) {
                    Environment e = (Environment)GlobalPreferencePage.this.envs.get(index - 1);
                    GlobalPreferencePage.this.onEnvSelected(e);
                } else {
                    GlobalPreferencePage.this.onEnvSelected(null);
                }
            }
        });
        this.populateCombo();
        return this.sharedGroup;
    }

    private void createEditArea(Composite parent) {
        this.btnLocal = new Button(parent, 32);
        this.btnLocal.setText(Messages.getString(((Object)((Object)this)).getClass(), "use.localConfig", null));
        this.localGroup = new Composite(parent, 2048);
        GridData gd = new GridData(16384, 128, true, true);
        gd.horizontalIndent = 15;
        this.localGroup.setLayoutData((Object)gd);
        GridLayout lay = new GridLayout(2, false);
        lay.marginWidth = 8;
        lay.marginHeight = 8;
        lay.marginTop = 2;
        this.localGroup.setLayout((Layout)lay);
        int widthHint = 295;
        Label l = new Label(this.localGroup, 0);
        l.setText(Messages.getString(((Object)((Object)this)).getClass(), "localConfig.host", null));
        this.txtIP = new Text(this.localGroup, 2052);
        gd = new GridData();
        gd.widthHint = widthHint;
        this.txtIP.setLayoutData((Object)gd);
        this.txtIP.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }
        });
        this.txtIP.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        l = new Label(this.localGroup, 0);
        l.setText(Messages.getString(((Object)((Object)this)).getClass(), "localConfig.port", null));
        this.txtPort = new Text(this.localGroup, 2052);
        this.txtPort.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }
        });
        this.txtPort.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        gd = new GridData();
        gd.widthHint = widthHint;
        this.txtPort.setLayoutData((Object)gd);
        l = new Label(this.localGroup, 0);
        l.setText(Messages.getString(((Object)((Object)this)).getClass(), "localConfig.id", null));
        this.txtId = new Text(this.localGroup, 2052);
        gd = new GridData();
        gd.widthHint = widthHint;
        this.txtId.setLayoutData((Object)gd);
        this.txtId.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }
        });
        this.txtId.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        l = new Label(this.localGroup, 0);
        l.setText(Messages.getString(((Object)((Object)this)).getClass(), "localConfig.name", null));
        this.txtName = new Text(this.localGroup, 2052);
        gd = new GridData();
        gd.widthHint = widthHint;
        this.txtName.setLayoutData((Object)gd);
        this.txtName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }
        });
        this.txtName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GlobalPreferencePage.this.validateEntries();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Controls.setEnabled(this.localGroup, false);
        this.btnLocal.setSelection(this.localEnv != null);
        this.performUseLocal(this.localEnv != null);
        this.btnLocal.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = GlobalPreferencePage.this.btnLocal.getSelection();
                GlobalPreferencePage.this.performUseLocal(selected);
                if (!selected) {
                    GlobalPreferencePage.this.setErrorMessage(null);
                    GlobalPreferencePage.this.setValid(true);
                } else {
                    GlobalPreferencePage.this.validateEntries();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean isIpValid() {
        boolean isValid = false;
        String str = this.txtIP.getText();
        if (str != null && !str.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(RESTART_MESSAGE, 2);
            this.setValid(true);
            isValid = true;
        } else {
            this.setErrorMessage(Messages.getString(((Object)((Object)this)).getClass(), "ip.errorMessage", null));
            this.setValid(false);
        }
        return isValid;
    }

    private boolean isPortValid() {
        boolean isValid = false;
        String str = this.txtPort.getText();
        try {
            Integer.valueOf(str);
            this.setErrorMessage(null);
            this.setMessage(RESTART_MESSAGE, 2);
            this.setValid(true);
            isValid = true;
        }
        catch (Exception exception) {
            this.setErrorMessage(Messages.getString(((Object)((Object)this)).getClass(), "port.errorMessage", null));
            this.setValid(false);
        }
        return isValid;
    }

    private boolean isIdValid() {
        boolean isValid = false;
        String str = this.txtId.getText();
        try {
            UUID.fromString(str);
            this.setErrorMessage(null);
            this.setMessage(RESTART_MESSAGE, 2);
            this.setValid(true);
            isValid = true;
        }
        catch (Exception exception) {
            this.setErrorMessage(Messages.getString(((Object)((Object)this)).getClass(), "id.errorMessage", null));
            this.setValid(false);
        }
        return isValid;
    }

    private boolean isNameValid() {
        boolean isValid = false;
        String str = this.txtName.getText();
        if (str != null && !str.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(RESTART_MESSAGE, 2);
            this.setValid(true);
            isValid = true;
        } else {
            this.setErrorMessage(Messages.getString(((Object)((Object)this)).getClass(), "name.errorMessage"));
            this.setValid(false);
        }
        return isValid;
    }

    private void validateEntries() {
        if (!this.isIpValid()) {
            return;
        }
        if (!this.isPortValid()) {
            return;
        }
        if (!this.isIdValid()) {
            return;
        }
        if (!this.isNameValid()) {
            return;
        }
    }

    private void loadLocal() {
        if (this.localEnv != null) {
            ServiceLocation sl = (ServiceLocation)this.localEnv.getLocations().iterator().next();
            this.txtIP.setText(sl.getHost());
            this.txtPort.setText("" + sl.getPort());
            this.txtName.setText(this.localEnv.getName());
            this.txtId.setText(this.localEnv.getId());
        } else {
            this.txtIP.setText("");
            this.txtPort.setText("");
            this.txtName.setText("");
            this.txtId.setText("");
        }
    }

    private void populateCombo() {
        Environment newSelection = null;
        int newIndex = -1;
        this.choose.removeAll();
        this.choose.add("");
        this.choose.select(0);
        int i = 1;
        for (Environment e : this.envs) {
            if (this.env != null && this.env.equals((Object)e)) {
                newSelection = e;
                newIndex = i;
            }
            this.choose.add(this.getDisplayString(e));
            ++i;
        }
        if (newSelection != null) {
            this.onEnvSelected(newSelection);
            this.choose.select(newIndex);
        }
    }

    private void resetEnvs() {
        this.envs = new LinkedList();
        EnvironmentService es = this.getEnvService();
        if (es != null) {
            for (Environment e : es.getEnvironments().values()) {
                this.envs.add(e);
            }
        }
    }

    private EnvironmentService getEnvService() {
        EnvironmentService es = null;
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(EnvironmentService.class);
        if (ref == null) {
            L.error("Cant' get reference to {}", EnvironmentService.class);
        } else {
            es = (EnvironmentService)bundleContext.getService(ref);
        }
        return es;
    }

    private void onEnvSelected(Environment env) {
        this.env = env;
    }

    private void loadSelected() {
        try {
            Boolean local;
            IPreferenceStore store = PreferencesUtil.getStore();
            Boolean bl = local = store == null ? null : Boolean.valueOf(store.getBoolean("hasLocalEnvironment"));
            if (local != null && local.booleanValue()) {
                this.localEnv = PreferencesUtil.getEnvironment();
            } else {
                this.env = PreferencesUtil.getEnvironment();
            }
        }
        catch (RuntimeException ex) {
            L.error("", (Throwable)ex);
        }
    }

    private String getDisplayString(Environment e) {
        boolean continueList;
        StringBuilder b = new StringBuilder();
        String name = e.getName();
        if (name != null) {
            b.append(e.getName());
            b.append(" (id: ");
            continueList = true;
        } else {
            b.append(e.getId());
            b.append(" (");
            continueList = false;
        }
        b.append(e.getId());
        int i = 0;
        for (ServiceLocation l : e.getLocations()) {
            if (i > 0 || continueList) {
                b.append(", ");
            }
            b.append(l.getHost());
            b.append(":");
            b.append(l.getPort());
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.btnLocal.setSelection(false);
        IPreferenceStore store = PreferencesUtil.getStore();
        if (store != null) {
            store.setValue("hasLocalEnvironment", false);
            this.performUseLocal(false);
        } else {
            L.warn("no store environment; performDefault cannot be done!");
        }
    }

    public boolean performOk() {
        IPreferenceStore store = PreferencesUtil.getStore();
        if (store != null) {
            if (this.btnLocal.getSelection()) {
                store.setValue("hasLocalEnvironment", true);
                String localHost = this.txtIP.getText();
                Integer localPort = new Integer(this.txtPort.getText());
                String localId = this.txtId.getText();
                String localName = this.txtName.getText();
                HashSet<ServiceLocation> locations = new HashSet<ServiceLocation>();
                locations.add(new ServiceLocation("ezz", localHost, localPort));
                this.localEnv = new Environment(localId, localName, locations);
                PreferencesUtil.setEnvironment(this.localEnv);
            } else {
                store.setValue("hasLocalEnvironment", false);
                PreferencesUtil.setEnvironment(this.env);
            }
        } else {
            L.warn("no store environment; performOk cannot be done!");
        }
        return true;
    }

    private void performUseLocal(boolean selected) {
        Controls.setEnabled(this.localGroup, selected);
        Controls.setEnabled(this.sharedGroup, !selected);
        if (selected) {
            try {
                this.localEnv = PreferencesUtil.getEnvironment();
            }
            catch (Exception ex) {
                L.error("error getting environment", (Throwable)ex);
                this.localEnv = null;
            }
        } else {
            this.localEnv = null;
        }
        this.loadLocal();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resetEnvs();
            this.loadSelected();
            this.loadLocal();
        }
    }
}

