/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.preferences.pages;

import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.preferences.PreferencesUtil;
import com.ez.common.ui.swt.Controls;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class EZFieldEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String OVERWRITE_GLOBAL_CONFIG = "ez.meta.overwrite";
    protected IPreferenceStore globalStore = null;
    protected Composite mainArea;
    protected BooleanFieldEditor mainAreaSwitch;
    protected Boolean isLocal = false;
    Composite headerArea;

    public EZFieldEditorPreferencePage(int layout) {
        super(layout);
    }

    protected void createFieldEditors() {
        Composite parent = new Composite(this.getFieldEditorParent(), 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.isLocal.booleanValue()) {
            this.createHeader(parent);
        }
        this.mainArea = new Composite(parent, 0);
        GridData d = new GridData(4, 4, true, true);
        d.verticalIndent = 5;
        this.mainArea.setLayoutData((Object)d);
        this.mainArea.setLayout((Layout)new GridLayout());
        this.createMainFieldEditors(this.mainArea);
    }

    public boolean performOk() {
        if (this.isLocal.booleanValue()) {
            return super.performOk();
        }
        return true;
    }

    protected void createHeader(Composite parent) {
        this.headerArea = new Composite(parent, 0);
        this.headerArea.setLayoutData((Object)new GridData(4, 128, true, false));
        this.mainAreaSwitch = new BooleanFieldEditor(OVERWRITE_GLOBAL_CONFIG, Messages.getString(EZFieldEditorPreferencePage.class, "mainAreaSwitch.label"), this.headerArea);
        this.addField((FieldEditor)this.mainAreaSwitch);
        Composite linksParent = new Composite(this.headerArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        linksParent.setLayout((Layout)layout);
        linksParent.setFont(parent.getFont());
        Map<String, IConfigurationElement> pages = PreferencesUtil.getPreferencePage(this.getGlobalPageID());
        PreferencesUtil.addLinksToPages(pages, linksParent);
        Label lblSeparator = new Label(this.headerArea, 258);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        lblSeparator.setLayoutData((Object)data);
    }

    protected abstract void createMainFieldEditors(Composite var1);

    protected abstract String getGlobalPageID();

    protected void initialize() {
        super.initialize();
        if (!this.isLocal.booleanValue()) {
            this.noDefaultAndApplyButton();
        }
        if (this.isLocal.booleanValue()) {
            Boolean allowOverwrite = this.overwriteAllowed();
            if (this.mainAreaSwitch != null) {
                this.mainAreaSwitch.getDescriptionControl(this.headerArea).setEnabled(allowOverwrite != null ? allowOverwrite : true);
            }
        }
        this.disableContent();
    }

    protected Boolean overwriteAllowed() {
        if (this.globalStore == null) {
            throw new RuntimeException("please set a global store for page!");
        }
        this.globalStore.setDefault("ez.meta.allow_overwrite", true);
        Boolean allowOverwrite = this.globalStore.getBoolean("ez.meta.allow_overwrite");
        return allowOverwrite;
    }

    protected void disableContent() {
        Controls.setEnabled(this.mainArea, this.isLocal.booleanValue() ? (this.overwriteAllowed().booleanValue() ? (this.mainAreaSwitch == null ? true : this.mainAreaSwitch.getBooleanValue()) : false) : false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String changedProperty;
        if (this.isLocal.booleanValue() && (changedProperty = ((FieldEditor)event.getSource()).getPreferenceName()).equals(OVERWRITE_GLOBAL_CONFIG)) {
            this.overwritePropertyChanged();
        }
        super.propertyChange(event);
    }

    protected void overwritePropertyChanged() {
        this.disableContent();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean isValid() {
        if (this.isLocal.booleanValue() && (this.mainAreaSwitch == null || this.mainAreaSwitch.getBooleanValue())) {
            return super.isValid();
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
    }
}

