/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.preferences;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.persistence.Persister;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreferencesUtil.class);
    private static IPreferenceStore PREF_STORE;
    private static final Object G;

    static {
        G = new Object();
    }

    public static Map<String, IConfigurationElement> getChildrenPages(String parentPageID) {
        HashMap<String, IConfigurationElement> toAdd = new HashMap<String, IConfigurationElement>();
        IExtensionPoint ext = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.preferencePages");
        IExtension[] eee = ext.getExtensions();
        int i = 0;
        while (i < eee.length) {
            IExtension e = eee[i];
            if (e.getNamespaceIdentifier().startsWith("com.ez") || e.getNamespaceIdentifier().startsWith("com.ibm.ez")) {
                IConfigurationElement[] elems = e.getConfigurationElements();
                int j = 0;
                while (j < elems.length) {
                    String name;
                    IConfigurationElement existing;
                    IConfigurationElement el = elems[j];
                    String categ = el.getAttribute("category");
                    if (parentPageID.equalsIgnoreCase(categ) && (existing = toAdd.put(name = el.getAttribute("name"), el)) != null) {
                        L.warn("two pages with the same label; this will be ignored: {}", (Object)existing.getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return toAdd.isEmpty() ? null : toAdd;
    }

    public static Map<String, IConfigurationElement> getPreferencePage(String pageId) {
        HashMap<String, IConfigurationElement> result = new HashMap<String, IConfigurationElement>();
        IExtensionPoint ext = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.preferencePages");
        IExtension[] eee = ext.getExtensions();
        int i = 0;
        while (i < eee.length) {
            IExtension e = eee[i];
            if (e.getNamespaceIdentifier().startsWith("com.ez") || e.getNamespaceIdentifier().startsWith("com.ibm.ez")) {
                IConfigurationElement[] elems = e.getConfigurationElements();
                int j = 0;
                while (j < elems.length) {
                    String name;
                    IConfigurationElement existing;
                    IConfigurationElement el = elems[j];
                    String elId = el.getAttribute("id");
                    if (elId.equalsIgnoreCase(pageId) && (existing = result.put(name = el.getAttribute("name"), el)) != null) {
                        L.warn("two pages with the same label; this will be ignored: {}", (Object)existing.getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.isEmpty() ? null : result;
    }

    public static void addLinksToPages(Map<String, IConfigurationElement> toAdd, Composite parent) {
        if (toAdd != null && !toAdd.isEmpty()) {
            ArrayList<String> sorted = new ArrayList<String>(toAdd.keySet());
            Collections.sort(sorted);
            for (String name : sorted) {
                IConfigurationElement el = toAdd.get(name);
                String categ = el.getAttribute("category");
                final String target = el.getAttribute("id");
                L.trace("id={}", (Object)target);
                L.trace("category={}", (Object)categ);
                final Link link = new Link(parent, 0);
                String linkText = "<A>" + name + "</A>";
                link.setText(linkText);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        org.eclipse.ui.dialogs.PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)target, null, null);
                    }
                });
                GridData data = new GridData(4, 0x1000000, true, false);
                data.horizontalSpan = 2;
                link.setLayoutData((Object)data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(IPreferenceStore prefStore) {
        Object object = G;
        synchronized (object) {
            PREF_STORE = prefStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPreferenceStore getStore() {
        Object object = G;
        synchronized (object) {
            return PREF_STORE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Environment getEnvironment() {
        Object object = G;
        synchronized (object) {
            String strValue = null;
            Environment e = null;
            if (PREF_STORE == null) {
                throw new IllegalStateException("Not initialized.");
            }
            strValue = PreferencesUtil.getValue(PREF_STORE, "environment");
            if (strValue != null) {
                try {
                    e = Persister.readEnvironment((Reader)new StringReader(strValue));
                }
                catch (Exception ex) {
                    L.error("Can't read persisted environment.", (Throwable)ex);
                }
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnvironment(Environment e) {
        Object object = G;
        synchronized (object) {
            if (PREF_STORE == null) {
                throw new IllegalStateException("Not initialized.");
            }
            if (e == null) {
                PREF_STORE.setValue("environment", PREF_STORE.getDefaultString("environment"));
            } else {
                StringWriter w = new StringWriter();
                try {
                    Persister.writeEnvironment((Environment)e, (Writer)w);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Can't write preferences.", ex);
                }
                PREF_STORE.setValue("environment", w.toString());
            }
        }
    }

    private static String getValue(IPreferenceStore s, String key) {
        String strValue = s.getString(key);
        if (strValue != null && strValue.length() == 0) {
            strValue = null;
        }
        return strValue;
    }
}

