/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.model.BaseListable;
import com.ez.common.ui.internal.Activator;
import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.listselection.AbstractTreeSelectionUI;
import com.ez.common.ui.listselection.AvailableFilteredTree;
import com.ez.common.ui.listselection.EZListLabelProvider;
import com.ez.common.ui.listselection.EZListViewerSorter;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.ListableComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSelectionUI<T extends BaseListable>
extends AbstractTreeSelectionUI<BaseListable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TreeSelectionUI.class);
    private TreeViewer selTreeViewer;
    private Button addButton;
    private Button remButton;
    private Button addAllButton;
    private Button remAllButton;
    private Text leftCountTxt;
    private Text rightCountTxt;
    private Image imageButonForeward;
    private Image imageButonBackward;
    private Image imageButonFForeward;
    private Image imageButonBBackward;
    private IContentProvider treeContentProvider;
    private ViewerFilter viewerFilter;
    protected Set<T> selListElements = new HashSet<T>();

    public TreeSelectionUI(Composite parent, String objectType, IContentProvider cp, ViewerFilter vf) {
        this.treeContentProvider = cp;
        this.viewerFilter = vf;
        this.init(objectType, parent);
        this.avTreeViewer.setContentProvider(cp);
        this.avTreeViewer.addFilter(vf);
    }

    @Override
    protected void init(String objectType, Composite parent) {
        super.init(objectType, parent);
        ImageDescriptor desc = Activator.getImageDescriptor("icons/listselection/foreward.png");
        this.imageButonForeward = this.getImage(desc);
        desc = Activator.getImageDescriptor("icons/listselection/fforward.png");
        this.imageButonFForeward = this.getImage(desc);
        desc = Activator.getImageDescriptor("icons/listselection/backward.png");
        this.imageButonBackward = this.getImage(desc);
        desc = Activator.getImageDescriptor("icons/listselection/bbackward.png");
        this.imageButonBBackward = this.getImage(desc);
        this.leftCountTxt = new Text((Composite)this.availableGroup, 0);
        this.leftCountTxt.setEditable(false);
        this.leftCountTxt.setText("");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.leftCountTxt.setLayoutData((Object)data);
        this.leftCountTxt.setForeground(this.GREY_COLOR);
        this.createButtonsGroup(this.panel);
        Group selectedGroup = new Group(this.panel, 0);
        String lbl = Messages.getString(TreeSelectionUI.class, "selected.label", new String[]{objectType});
        selectedGroup.setText(lbl);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 5;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        selectedGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 10;
        selectedGroup.setLayout((Layout)gl);
        AvailableFilteredTree selTree = new AvailableFilteredTree((Composite)selectedGroup, 68354, new PatternFilter());
        this.selTreeViewer = selTree.getViewer();
        this.selTreeViewer.setUseHashlookup(true);
        this.selTreeViewer.setLabelProvider((IBaseLabelProvider)new EZListLabelProvider());
        this.selTreeViewer.setSorter((ViewerSorter)new EZListViewerSorter());
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        selTree.setLayoutData(data);
        this.selTreeViewer.setContentProvider(this.treeContentProvider);
        this.selTreeViewer.addFilter(this.viewerFilter);
        this.rightCountTxt = new Text((Composite)selectedGroup, 0);
        this.rightCountTxt.setEditable(false);
        this.rightCountTxt.setText("");
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.rightCountTxt.setLayoutData((Object)data);
        this.rightCountTxt.setForeground(this.GREY_COLOR);
    }

    @Override
    protected void createMainComposite2Lists(Composite parent) {
        this.panel = new Composite(parent, parent.getStyle());
        GridLayout gl = new GridLayout(11, true);
        gl.horizontalSpacing = 0;
        this.panel.setLayout((Layout)gl);
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(0, 39);
        fData.right = new FormAttachment(100, 0);
        this.panel.setLayoutData((Object)fData);
    }

    @Override
    public void setAvailable(List available) {
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        this.avTreeViewer.setInput((Object)available);
        this.selTreeViewer.setInput((Object)available);
        if (this.avTreeViewer.getTree().getItemCount() > 0) {
            TreeItem item = this.avTreeViewer.getTree().getItem(0);
            this.avTreeViewer.setSelection((ISelection)new StructuredSelection(item.getData()));
            this.avTreeViewer.expandAll();
            this.selTreeViewer.expandAll();
        }
    }

    @Override
    protected void createButtonsGroup(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 0;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0x1000000;
        data.verticalIndent = -25;
        buttonsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 5;
        gl.marginLeft = 8;
        gl.marginRight = 8;
        buttonsGroup.setLayout((Layout)gl);
        this.addButton = new Button(buttonsGroup, 8);
        this.addButton.setImage(this.imageButonForeward);
        this.addButton.setEnabled(false);
        data = new GridData();
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 23;
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeItem[] selItems;
                        TreeItem[] treeItemArray = selItems = (this).TreeSelectionUI.this.avTreeViewer.getTree().getSelection();
                        int n = selItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            List leafs = TreeSelectionUI.this.computeLeafs(item);
                            (this).TreeSelectionUI.this.selListElements.addAll(leafs);
                            ++n2;
                        }
                    }
                });
                TreeSelectionUI.this.listChange();
                TreeSelectionUI.this.manageButtons();
            }
        });
        this.addAllButton = new Button(buttonsGroup, 8);
        this.addAllButton.setImage(this.imageButonFForeward);
        this.addAllButton.setEnabled(false);
        data = new GridData();
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 23;
        this.addAllButton.setLayoutData((Object)data);
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeItem[] items;
                        (this).TreeSelectionUI.this.avTreeViewer.expandAll();
                        (this).TreeSelectionUI.this.avTreeViewer.getTree().selectAll();
                        TreeItem[] treeItemArray = items = (this).TreeSelectionUI.this.avTreeViewer.getTree().getSelection();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            List leafs = TreeSelectionUI.this.computeLeafs(item);
                            (this).TreeSelectionUI.this.selListElements.addAll(leafs);
                            ++n2;
                        }
                    }
                });
                TreeSelectionUI.this.listChange();
                TreeSelectionUI.this.manageButtons();
            }
        });
        this.remButton = new Button(buttonsGroup, 8);
        this.remButton.setImage(this.imageButonBackward);
        this.remButton.setLayoutData((Object)data);
        this.remButton.setEnabled(false);
        data.heightHint = 23;
        this.remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeItem[] selItems;
                        TreeItem[] treeItemArray = selItems = TreeSelectionUI.this.selTreeViewer.getTree().getSelection();
                        int n = selItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem itm = treeItemArray[n2];
                            (this).TreeSelectionUI.this.selListElements.remove(itm.getData());
                            ++n2;
                        }
                    }
                });
                TreeSelectionUI.this.listChange();
                TreeSelectionUI.this.manageButtons();
            }
        });
        this.remAllButton = new Button(buttonsGroup, 8);
        this.remAllButton.setImage(this.imageButonBBackward);
        this.remAllButton.setLayoutData((Object)data);
        this.remAllButton.setEnabled(false);
        data.heightHint = 23;
        this.remAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).TreeSelectionUI.this.selListElements.clear();
                    }
                });
                TreeSelectionUI.this.listChange();
                TreeSelectionUI.this.manageButtons();
            }
        });
    }

    private List<T> computeLeafs(TreeItem item) {
        ArrayList<Object> l = new ArrayList<Object>();
        TreeItem[] itms = item.getItems();
        Object data = item.getData();
        if (itms.length == 0) {
            l.add((BaseListable)data);
        } else {
            TreeItem[] treeItemArray = itms;
            int n = itms.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem itm = treeItemArray[n2];
                itm.getData();
                l.addAll(this.computeLeafs(itm));
                ++n2;
            }
        }
        return l;
    }

    private void displaySelectionCount() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int count = TreeSelectionUI.this.selTreeViewer.getTree().getSelectionCount();
                TreeSelectionUI.this.rightCountTxt.setText(Messages.getString(TreeSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(count)}));
                TreeSelectionUI.this.leftCountTxt.setText(Messages.getString(TreeSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(TreeSelectionUI.this.avTreeViewer.getTree().getSelectionCount())}));
            }
        });
    }

    @Override
    public void listChange() {
        this.displaySelectionCount();
        ListChangeEvent chanev = new ListChangeEvent(this, this.selTreeViewer.getTree().getItemCount());
        int size = this.changeListeners.size();
        int i = 0;
        while (i < size) {
            ListChangeListener listener = (ListChangeListener)this.changeListeners.elementAt(i);
            listener.listChangeEventHappend(chanev);
            ++i;
        }
    }

    public synchronized void updateAll() {
        this.displaySelectionCount();
        this.manageButtons();
    }

    @Override
    public synchronized void manageButtons() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean avIsSelected = TreeSelectionUI.this.avTreeViewer.getTree().getSelectionCount() > 0;
                boolean selIsSelected = TreeSelectionUI.this.selTreeViewer.getTree().getSelectionCount() > 0;
                boolean avContainsElements = TreeSelectionUI.this.avTreeViewer.getTree().getItemCount() > 0;
                boolean selContainsElements = TreeSelectionUI.this.selTreeViewer.getTree().getItemCount() > 0;
                TreeSelectionUI.this.addButton.setEnabled(avIsSelected);
                TreeSelectionUI.this.remButton.setEnabled(selIsSelected);
                TreeSelectionUI.this.addAllButton.setEnabled(avContainsElements);
                TreeSelectionUI.this.remAllButton.setEnabled(selContainsElements);
            }
        });
    }

    @Override
    public void clearUILists() {
        super.clearUILists();
        this.selTreeViewer.refresh();
    }

    public List getSelObjectList() {
        ArrayList<T> list = new ArrayList<T>(this.selListElements);
        Collections.sort(list, new ListableComparator());
        return list;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.avTreeViewer.addSelectionChangedListener(listener);
        this.selTreeViewer.addSelectionChangedListener(listener);
    }
}

