/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.ui.listselection.AbstractPaginationOrientDB;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.Listable;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePaginationOrientDB<T extends Listable>
extends AbstractPaginationOrientDB<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SinglePaginationOrientDB.class);
    private AvailableObjectSelectionListener avSelectionListener;

    protected SinglePaginationOrientDB() {
    }

    public SinglePaginationOrientDB(Composite parent, String objectType, boolean useFilters) {
        this.useFilters = useFilters;
        this.isMultiSelection = false;
        this.init(objectType, parent);
    }

    public SinglePaginationOrientDB(Composite parent, String objectType) {
        this.isMultiSelection = false;
        this.init(objectType, parent);
    }

    @Override
    protected void init(String objectType, Composite parent) {
        super.init(objectType, parent);
        this.avSelectionListener = new AvailableObjectSelectionListener();
        this.avTable.addSelectionListener((SelectionListener)this.avSelectionListener);
    }

    @Override
    protected void createMainComposite2Lists(Composite parent) {
        this.panel = new Composite(parent, parent.getStyle());
        this.panel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (SinglePaginationOrientDB.this.visibleExpandedFrame) {
                    FormData data = (FormData)SinglePaginationOrientDB.this.panel.getLayoutData();
                    data.left = new FormAttachment(0, 129);
                    SinglePaginationOrientDB.this.panel.setLayoutData((Object)data);
                } else {
                    FormData data = (FormData)SinglePaginationOrientDB.this.panel.getLayoutData();
                    data.left = new FormAttachment(0, 39);
                    SinglePaginationOrientDB.this.panel.setLayoutData((Object)data);
                }
            }
        });
        GridLayout gl = new GridLayout(5, true);
        gl.horizontalSpacing = 0;
        this.panel.setLayout((Layout)gl);
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(0, 39);
        fData.right = new FormAttachment(100, 0);
        this.panel.setLayoutData((Object)fData);
    }

    @Override
    public void setAvailable(List available) {
        this.allObjects = available;
        if (this.allObjects != null && this.allObjects.size() > 0) {
            this.avListElements.addAll(this.allObjects);
            if (this.avListElements.size() > 14) {
                this.avTableViewer.setItemCount(15);
                this.avTableViewer.setInput(this.avListElements.subList(0, 15));
            } else {
                this.avTableViewer.setItemCount(this.avListElements.size());
            }
        }
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        this.avTableViewer.refresh();
    }

    @Override
    public void setSelected(List selected) {
    }

    @Override
    public void setSelList(List selected) {
    }

    @Override
    public void listChange() {
        ListChangeEvent chanev = new ListChangeEvent(this, this.avTable.getItemCount());
        int size = this.changeListeners.size();
        int i = 0;
        while (i < size) {
            ListChangeListener listener = (ListChangeListener)this.changeListeners.elementAt(i);
            listener.listChangeEventHappend(chanev);
            ++i;
        }
    }

    @Override
    public void addChangeListener(ListChangeListener listener) {
        this.changeListeners.addElement(listener);
    }

    @Override
    public void removeChangeListener(ListChangeListener listener) {
        this.changeListeners.removeElement(listener);
    }

    @Override
    public void clearSelected() {
        this.selListElements.clear();
    }

    @Override
    protected void createButtonsGroup(Composite parent) {
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public void manageButtons() {
    }

    @Override
    public void makeSelectionIfSingle() {
        Collection input = (Collection)this.avTableViewer.getInput();
        if (input != null && input.size() == 1) {
            Listable inp = (Listable)input.iterator().next();
            if (!this.selListElements.contains(inp)) {
                this.selListElements.add(inp);
            }
            this.avTable.setSelection(0);
            this.listChange();
        }
    }

    private class AvailableObjectSelectionListener
    extends SelectionAdapter {
        private AvailableObjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection = SinglePaginationOrientDB.this.avTableViewer.getSelection();
            SinglePaginationOrientDB.this.clearSelected();
            StructuredSelection sel = (StructuredSelection)selection;
            Object[] se = sel.toArray();
            int i = 0;
            while (i < se.length) {
                Listable listElement = (Listable)se[i];
                if (!SinglePaginationOrientDB.this.selListElements.contains(listElement)) {
                    SinglePaginationOrientDB.this.selListElements.add(listElement);
                }
                ++i;
            }
            SinglePaginationOrientDB.this.listChange();
        }
    }
}

