/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.ui.internal.Activator;
import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.listselection.AbstractSelectionUI;
import com.ez.common.ui.listselection.EZListContentProvider;
import com.ez.common.ui.listselection.EZListLabelProvider;
import com.ez.common.ui.listselection.EZListSelectionChangedListener;
import com.ez.common.ui.listselection.EZListViewerSorter;
import com.ez.common.ui.listselection.FastKeySelectionOnList;
import com.ez.common.ui.listselection.IOperationHandler;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.Listable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSelectionUI<T extends Listable>
extends AbstractSelectionUI<Listable> {
    private static final Logger L = LoggerFactory.getLogger(ListSelectionUI.class);
    protected static final int MIN_SELECTION_SIZE_VALUE_TO_ACTIVATE_OPERATION_HANDLER = 300;
    private Group selectedGroup;
    private Table selTable;
    private TableViewer selTableViewer;
    private AvailableObjectSelectionListener avSelectionListener;
    private Button addButton;
    private Button remButton;
    private Button addAllButton;
    private Button remAllButton;
    private Button importButton;
    private Text leftCountTxt;
    private Text rightCountTxt;
    private SelectedObjectSelectionListener selSelectionListener;
    private Image imageButonForeward;
    private Image imageButonBackward;
    private Image imageButonFForeward;
    private Image imageButonBBackward;
    private Image imageImport;
    private ImageDescriptor desc;
    private String rightLabel;
    private int maxSelectionNumber = -1;
    private IOperationHandler operationWorker;

    private ListSelectionUI() {
    }

    public ListSelectionUI(Composite parent, boolean useFilters) {
        this.useFilters = useFilters;
        this.init(parent);
    }

    public ListSelectionUI(Composite parent, String objectType, boolean useFilters, boolean useImport) {
        this.useFilters = useFilters;
        this.useImport = useImport;
        this.init(parent);
    }

    public ListSelectionUI(Composite parent) {
        this.init(parent);
    }

    @Override
    protected void init(Composite parent) {
        super.init(parent);
        this.desc = Activator.getImageDescriptor("icons/listselection/foreward.png");
        this.imageButonForeward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/fforward.png");
        this.imageButonFForeward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/backward.png");
        this.imageButonBackward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/bbackward.png");
        this.imageButonBBackward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/import.png");
        this.imageImport = this.getImage(this.desc);
        this.avSelectionListener = new AvailableObjectSelectionListener();
        this.avTable.addListener(2, (Listener)this.avSelectionListener);
        this.avTable.addSelectionListener((SelectionListener)this.avSelectionListener);
        Accessible accessibleTbl = this.avTable.getAccessible();
        accessibleTbl.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                event.result = ListSelectionUI.this.leftCountTxt.getText();
                L.trace("availableTable.getDescription: {}", (Object)event.result);
            }
        });
        this.leftCountTxt = new Text((Composite)this.availableGroup, 0);
        this.leftCountTxt.setEditable(false);
        this.leftCountTxt.setText("");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.leftCountTxt.setLayoutData((Object)data);
        this.leftCountTxt.setForeground(this.GREY_COLOR);
        this.createButtonsGroup(this.panel);
        this.selectedGroup = new Group(this.panel, 0);
        String lbl = this.rightLabel != null ? this.rightLabel : Messages.getString(ListSelectionUI.class, "selected.group.label");
        this.selectedGroup.setText(lbl);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 5;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.selectedGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 10;
        this.selectedGroup.setLayout((Layout)gl);
        this.selTableViewer = new TableViewer((Composite)this.selectedGroup, 268503810);
        this.selTableViewer.setUseHashlookup(true);
        this.selTableViewer.setContentProvider((IContentProvider)new EZListContentProvider());
        this.selTableViewer.setLabelProvider((IBaseLabelProvider)new EZListLabelProvider());
        this.selTableViewer.setSorter((ViewerSorter)new EZListViewerSorter());
        this.selTableViewer.addSelectionChangedListener((ISelectionChangedListener)new EZListSelectionChangedListener());
        this.selTableViewer.setInput((Object)this.selListElements);
        this.selTable = this.selTableViewer.getTable();
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = 150;
        this.selTable.setLayoutData((Object)data);
        this.selSelectionListener = new SelectedObjectSelectionListener();
        this.selTable.addListener(2, (Listener)this.avSelectionListener);
        this.selTable.addSelectionListener((SelectionListener)this.avSelectionListener);
        this.selTable.addKeyListener((KeyListener)new FastKeySelectionOnList(this.selTable));
        accessibleTbl = this.selTable.getAccessible();
        accessibleTbl.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent event) {
                event.result = ListSelectionUI.this.rightCountTxt.getText();
                L.trace("selectedTable.getDescription: {}", (Object)event.result);
            }
        });
        this.rightCountTxt = new Text((Composite)this.selectedGroup, 0);
        this.rightCountTxt.setEditable(false);
        this.rightCountTxt.setText("");
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.rightCountTxt.setLayoutData((Object)data);
        this.rightCountTxt.setForeground(this.GREY_COLOR);
    }

    @Override
    protected void createMainComposite2Lists(Composite parent) {
        this.panel = new Composite(parent, parent.getStyle());
        GridLayout gl = new GridLayout(11, true);
        gl.horizontalSpacing = 0;
        this.panel.setLayout((Layout)gl);
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(0, 44);
        fData.right = new FormAttachment(100, 0);
        this.panel.setLayoutData((Object)fData);
    }

    @Override
    public void setAvailable(List available) {
        this.allObjects = available;
        if (this.allObjects != null && this.allObjects.size() > 0) {
            this.avListElements.addAll(this.allObjects);
            this.avTableViewer.setItemCount(this.avListElements.size());
        }
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        this.avTableViewer.refresh();
        if (this.avListElements.size() > 0) {
            this.avTable.select(0);
        }
        this.rightCountTxt.setText(Messages.getString(ListSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(this.selTable.getSelectionCount())}));
        this.leftCountTxt.setText(Messages.getString(ListSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(this.avTable.getSelectionCount())}));
        this.manageButtons();
    }

    @Override
    public void setAvList(List available) {
        this.avListElements.clear();
        this.avListElements.addAll(available);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.avListElements.size() > 0) {
            this.avTableViewer.setItemCount(this.avListElements.size());
            this.avTableViewer.refresh();
            this.avTable.select(0);
        }
        this.leftCountTxt.setText(Messages.getString(ListSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(this.avTable.getSelectionCount())}));
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    @Override
    public void setSelected(List selected) {
        this.selListElements.clear();
        this.selListElements.addAll(selected);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.selListElements.size() > 0) {
            this.selTable.select(0);
        }
        this.selTableViewer.refresh();
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    @Override
    public void setSelList(List selected) {
        this.selListElements.clear();
        this.selListElements.addAll(selected);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.selListElements.size() > 0) {
            this.selTableViewer.setItemCount(this.selListElements.size());
            this.selTableViewer.refresh();
            this.selTable.select(0);
        }
        this.rightCountTxt.setText(Messages.getString(ListSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(this.selTable.getSelectionCount())}));
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    @Override
    protected void createButtonsGroup(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 0;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0x1000000;
        data.verticalIndent = -25;
        buttonsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 5;
        gl.marginLeft = 8;
        gl.marginRight = 8;
        buttonsGroup.setLayout((Layout)gl);
        this.addButton = new Button(buttonsGroup, 8);
        this.addButton.setImage(this.imageButonForeward);
        this.addButton.setEnabled(false);
        data = new GridData();
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 23;
        this.addButton.setLayoutData((Object)data);
        this.addButton.setToolTipText(Messages.getString(ListSelectionUI.class, "add.tooltip"));
        this.addButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(ListSelectionUI.class, "add.tooltip");
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            final ISelection[] selectionArray = new ISelection[1];

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        selectionArray[0] = (this).ListSelectionUI.this.avTableViewer.getSelection();
                    }
                });
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pmonitor) {
                        pmonitor.setTaskName(Messages.getString(ListSelectionUI.class, "updating.wizard.page"));
                        StructuredSelection sel = (StructuredSelection)selectionArray[0];
                        Object[] se = sel.toArray();
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)se.length);
                        monitor.subTask(Messages.getString(ListSelectionUI.class, "refresh.page"));
                        ArrayList<Listable> removed = new ArrayList<Listable>();
                        int i = 0;
                        while (i < se.length) {
                            Listable listElement = (Listable)se[i];
                            if (!(this).ListSelectionUI.this.selListElements.contains(listElement)) {
                                (this).ListSelectionUI.this.selListElements.add(listElement);
                                removed.add(listElement);
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        (this).ListSelectionUI.this.avListElements.removeAll(removed);
                    }
                };
                if (ListSelectionUI.this.operationWorker == null || ((StructuredSelection)this.selectionArray[0]).size() < 300) {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        L.error("", (Throwable)e1);
                    }
                    catch (InterruptedException e1) {
                        L.error("", (Throwable)e1);
                    }
                } else {
                    ListSelectionUI.this.operationWorker.execute(runnable);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListSelectionUI.this.selTableViewer.refresh();
                        (this).ListSelectionUI.this.avTableViewer.refresh();
                        if ((this).ListSelectionUI.this.avTable.getItemCount() > 0) {
                            (this).ListSelectionUI.this.avTable.setSelection(0);
                        }
                        ListSelectionUI.this.selTableViewer.getTable().setSelection(new int[0]);
                        ListSelectionUI.this.selTableViewer.setSelection(selectionArray[0]);
                    }
                });
                ListSelectionUI.this.listChange();
                ListSelectionUI.this.manageButtons();
            }
        });
        if (this.maxSelectionNumber < 0) {
            this.addAllButton = new Button(buttonsGroup, 8);
            this.addAllButton.setImage(this.imageButonFForeward);
            this.addAllButton.setEnabled(false);
            this.addAllButton.setToolTipText(Messages.getString(ListSelectionUI.class, "addall.tooltip"));
            this.addAllButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent event) {
                    event.result = Messages.getString(ListSelectionUI.class, "addall.tooltip");
                }
            });
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.heightHint = 23;
            this.addAllButton.setLayoutData((Object)data);
            this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final ISelection[] selectionArray = new ISelection[1];
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ListSelectionUI.this.avTable.selectAll();
                            selectionArray[0] = (this).ListSelectionUI.this.avTableViewer.getSelection();
                        }
                    });
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pmonitor) {
                            pmonitor.setTaskName(Messages.getString(ListSelectionUI.class, "updating.wizard.page"));
                            StructuredSelection sel = (StructuredSelection)selectionArray[0];
                            Object[] se = sel.toArray();
                            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)se.length);
                            monitor.subTask(Messages.getString(ListSelectionUI.class, "refresh.page"));
                            ArrayList<Listable> removed = new ArrayList<Listable>();
                            int i = 0;
                            while (i < se.length) {
                                Listable listElement = (Listable)se[i];
                                if (!(this).ListSelectionUI.this.selListElements.contains(listElement)) {
                                    (this).ListSelectionUI.this.selListElements.add(listElement);
                                    removed.add(listElement);
                                }
                                monitor.worked(1);
                                ++i;
                            }
                            (this).ListSelectionUI.this.avListElements.removeAll(removed);
                        }
                    };
                    if (ListSelectionUI.this.operationWorker == null || ((StructuredSelection)selectionArray[0]).size() < 300) {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e1) {
                            L.error("", (Throwable)e1);
                        }
                        catch (InterruptedException e1) {
                            L.error("", (Throwable)e1);
                        }
                    } else {
                        ListSelectionUI.this.operationWorker.execute(runnable);
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListSelectionUI.this.selTableViewer.refresh();
                            (this).ListSelectionUI.this.avTableViewer.refresh();
                            ListSelectionUI.this.selTableViewer.getTable().setSelection(new int[0]);
                            ListSelectionUI.this.selTableViewer.setSelection(selectionArray[0]);
                        }
                    });
                    ListSelectionUI.this.listChange();
                    ListSelectionUI.this.manageButtons();
                }
            });
        }
        this.remButton = new Button(buttonsGroup, 8);
        this.remButton.setImage(this.imageButonBackward);
        this.remButton.setLayoutData((Object)data);
        this.remButton.setToolTipText(Messages.getString(ListSelectionUI.class, "rem.tooltip"));
        this.remButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(ListSelectionUI.class, "rem.tooltip");
            }
        });
        this.remButton.setEnabled(false);
        data.heightHint = 23;
        this.remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ISelection[] selectionArray = new ISelection[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        selectionArray[0] = ListSelectionUI.this.selTableViewer.getSelection();
                    }
                });
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pmonitor) {
                        pmonitor.setTaskName(Messages.getString(ListSelectionUI.class, "updating.wizard.page"));
                        StructuredSelection sel = (StructuredSelection)selectionArray[0];
                        Object[] se = sel.toArray();
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)se.length);
                        monitor.subTask(Messages.getString(ListSelectionUI.class, "refresh.page"));
                        ArrayList<Listable> removed = new ArrayList<Listable>();
                        int i = 0;
                        while (i < se.length) {
                            Listable listElement = (Listable)se[i];
                            if (!(this).ListSelectionUI.this.avListElements.contains(listElement)) {
                                (this).ListSelectionUI.this.avListElements.add(listElement);
                                removed.add(listElement);
                                monitor.worked(1);
                            }
                            ++i;
                        }
                        (this).ListSelectionUI.this.selListElements.removeAll(removed);
                    }
                };
                if (ListSelectionUI.this.operationWorker == null || ((StructuredSelection)selectionArray[0]).size() < 300) {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        L.error("", (Throwable)e1);
                    }
                    catch (InterruptedException e1) {
                        L.error("", (Throwable)e1);
                    }
                } else {
                    ListSelectionUI.this.operationWorker.execute(runnable);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ListSelectionUI.this.avTableViewer.refresh();
                        ListSelectionUI.this.selTableViewer.refresh();
                        if (ListSelectionUI.this.selTable.getItemCount() > 0) {
                            ListSelectionUI.this.selTable.setSelection(0);
                        }
                        (this).ListSelectionUI.this.avTableViewer.getTable().setSelection(new int[0]);
                        (this).ListSelectionUI.this.avTableViewer.setSelection((ISelection)new StructuredSelection(((StructuredSelection)selectionArray[0]).toList()));
                    }
                });
                ListSelectionUI.this.listChange();
                ListSelectionUI.this.manageButtons();
            }
        });
        this.remAllButton = new Button(buttonsGroup, 8);
        this.remAllButton.setImage(this.imageButonBBackward);
        this.remAllButton.setLayoutData((Object)data);
        this.remAllButton.setEnabled(false);
        this.remAllButton.setToolTipText(Messages.getString(ListSelectionUI.class, "remall.tooltip"));
        this.remAllButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = Messages.getString(ListSelectionUI.class, "remall.tooltip");
            }
        });
        data.heightHint = 23;
        this.remAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ISelection[] selectionArray = new ISelection[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListSelectionUI.this.selTable.selectAll();
                        selectionArray[0] = ListSelectionUI.this.selTableViewer.getSelection();
                    }
                });
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pmonitor) {
                        pmonitor.setTaskName(Messages.getString(ListSelectionUI.class, "updating.wizard.page"));
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(this).ListSelectionUI.this.selListElements.size());
                        monitor.subTask(Messages.getString(ListSelectionUI.class, "refresh.page"));
                        for (Listable o : (this).ListSelectionUI.this.selListElements) {
                            if (!(this).ListSelectionUI.this.avListElements.contains(o)) {
                                (this).ListSelectionUI.this.avListElements.add(o);
                            }
                            monitor.worked(1);
                        }
                        (this).ListSelectionUI.this.selListElements.clear();
                    }
                };
                if (ListSelectionUI.this.operationWorker == null || ((StructuredSelection)selectionArray[0]).size() < 300) {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        L.error("", (Throwable)e1);
                    }
                    catch (InterruptedException e1) {
                        L.error("", (Throwable)e1);
                    }
                } else {
                    ListSelectionUI.this.operationWorker.execute(runnable);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ListSelectionUI.this.avTableViewer.refresh();
                        ListSelectionUI.this.selTableViewer.refresh();
                        (this).ListSelectionUI.this.avTableViewer.getTable().setSelection(new int[0]);
                        (this).ListSelectionUI.this.avTableViewer.setSelection(selectionArray[0]);
                    }
                });
                ListSelectionUI.this.listChange();
                ListSelectionUI.this.manageButtons();
            }
        });
        if (this.useImport) {
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.heightHint = 23;
            this.importButton = new Button(buttonsGroup, 8);
            this.importButton.setImage(this.imageImport);
            this.importButton.setLayoutData((Object)data);
            this.importButton.setEnabled(true);
            this.importButton.setToolTipText(Messages.getString(ListSelectionUI.class, "import.tooltip"));
            this.importButton.setLayoutData((Object)data);
            this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = Display.getDefault().getActiveShell();
                    FileDialog fd = new FileDialog(shell);
                    String fName = fd.open();
                    if (fName != null) {
                        block17: {
                            ListSelectionUI.this.avTable.deselectAll();
                            ListSelectionUI.this.selTable.deselectAll();
                            BufferedReader br = null;
                            try {
                                try {
                                    String vName;
                                    br = new BufferedReader(new FileReader(new File(fName)));
                                    ArrayList<Listable> removed = new ArrayList<Listable>();
                                    while ((vName = br.readLine()) != null) {
                                        if ((vName = vName.trim()).isEmpty()) continue;
                                        for (Object item : ListSelectionUI.this.avListElements) {
                                            if (!vName.equals(((Listable)item).getListableName()) || ListSelectionUI.this.selListElements.contains(item)) continue;
                                            ListSelectionUI.this.selListElements.add((Listable)item);
                                            removed.add((Listable)item);
                                        }
                                    }
                                    ListSelectionUI.this.avListElements.removeAll(removed);
                                }
                                catch (Exception ex) {
                                    L.error("could not load file {}", (Object)fName, (Object)ex);
                                    if (br != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (IOException ex1) {
                                            L.error("can't close {}", (Object)fName, (Object)ex1);
                                        }
                                    }
                                    break block17;
                                }
                            }
                            catch (Throwable throwable) {
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (IOException ex1) {
                                        L.error("can't close {}", (Object)fName, (Object)ex1);
                                    }
                                }
                                throw throwable;
                            }
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException ex1) {
                                    L.error("can't close {}", (Object)fName, (Object)ex1);
                                }
                            }
                        }
                        ListSelectionUI.this.selTableViewer.refresh();
                        ListSelectionUI.this.avTableViewer.refresh();
                    }
                    ListSelectionUI.this.listChange();
                    ListSelectionUI.this.manageButtons();
                }
            });
        }
    }

    private void displaySelectionCount() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int count = ListSelectionUI.this.selTable.getSelectionCount();
                String newMsg = Messages.getString(ListSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(count)});
                if (!newMsg.equals(ListSelectionUI.this.rightCountTxt.getText())) {
                    ListSelectionUI.this.rightCountTxt.setText(newMsg);
                    ListSelectionUI.this.selTable.getAccessible().sendEvent(32781, null);
                }
                count = ListSelectionUI.this.avTable.getSelectionCount();
                newMsg = Messages.getString(ListSelectionUI.class, "count.selected.items.label", new String[]{String.valueOf(count)});
                if (!newMsg.equals(ListSelectionUI.this.leftCountTxt.getText())) {
                    ListSelectionUI.this.leftCountTxt.setText(newMsg);
                    ListSelectionUI.this.avTable.getAccessible().sendEvent(32781, null);
                }
            }
        });
    }

    @Override
    public void listChange() {
        this.displaySelectionCount();
        ListChangeEvent chanev = new ListChangeEvent(this, this.selTable.getItemCount());
        int size = this.changeListeners.size();
        int i = 0;
        while (i < size) {
            ListChangeListener listener = (ListChangeListener)this.changeListeners.elementAt(i);
            listener.listChangeEventHappend(chanev);
            ++i;
        }
    }

    public void setSelectionReadOnly(boolean readOnly) {
        this.avTable.setEnabled(!readOnly);
        this.selTable.setEnabled(!readOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.avTable.removeListener(2, (Listener)this.avSelectionListener);
            this.selTable.removeListener(2, (Listener)this.selSelectionListener);
            this.avTable.removeSelectionListener((SelectionListener)this.avSelectionListener);
            this.selTable.removeSelectionListener((SelectionListener)this.selSelectionListener);
        } else {
            if (!this.avTable.isListening(14)) {
                this.avTable.addListener(2, (Listener)this.avSelectionListener);
                this.avTable.addSelectionListener((SelectionListener)this.avSelectionListener);
            }
            if (!this.selTable.isListening(13)) {
                this.avTable.addListener(2, (Listener)this.avSelectionListener);
                this.selTable.addSelectionListener((SelectionListener)this.selSelectionListener);
            }
        }
        if (this.addAllButton != null) {
            this.addAllButton.setEnabled(!readOnly);
        }
        this.addButton.setEnabled(!readOnly);
        this.remAllButton.setEnabled(!readOnly);
        this.remButton.setEnabled(!readOnly);
        if (!readOnly) {
            this.manageButtons();
        }
    }

    private synchronized void updateAll() {
        this.displaySelectionCount();
        this.manageButtons();
    }

    @Override
    public synchronized void manageButtons() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean selectionSizeExceeded = ListSelectionUI.this.maxSelectionNumber >= 0 && ListSelectionUI.this.avTable.getSelectionCount() + ListSelectionUI.this.selTable.getItemCount() > ListSelectionUI.this.maxSelectionNumber;
                boolean avIsSelected = ListSelectionUI.this.avTable.getSelectionCount() > 0;
                boolean selIsSelected = ListSelectionUI.this.selTable.getSelectionCount() > 0;
                boolean avContainsElements = ListSelectionUI.this.avTable.getItemCount() > 0;
                boolean selContainsElements = ListSelectionUI.this.selTable.getItemCount() > 0;
                ListSelectionUI.this.addButton.setEnabled(avIsSelected && !selectionSizeExceeded);
                ListSelectionUI.this.remButton.setEnabled(selIsSelected);
                if (ListSelectionUI.this.addAllButton != null) {
                    ListSelectionUI.this.addAllButton.setEnabled(avContainsElements);
                }
                ListSelectionUI.this.remAllButton.setEnabled(selContainsElements);
            }
        });
    }

    @Override
    public void clearSelected() {
        this.selListElements.clear();
        this.selTableViewer.refresh();
    }

    @Override
    public void clearUILists() {
        super.clearUILists();
        this.selTableViewer.refresh();
    }

    @Override
    public void makeSelectionIfSingle() {
    }

    public void setRightGroupLabel(String label) {
        this.rightLabel = label;
        if (this.selectedGroup != null) {
            this.selectedGroup.setText(this.rightLabel);
        }
    }

    /* synthetic */ ListSelectionUI(ListSelectionUI listSelectionUI) {
        this();
    }

    private class AvailableObjectSelectionListener
    implements Listener,
    SelectionListener {
        private AvailableObjectSelectionListener() {
        }

        public void handleEvent(Event event) {
            ListSelectionUI.this.updateAll();
        }

        public void widgetSelected(SelectionEvent e) {
            ListSelectionUI.this.updateAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ListSelectionUI.this.updateAll();
        }
    }

    public static class Builder<T extends Listable> {
        private Composite parent;
        protected boolean useFilters = false;
        protected boolean useImport = false;
        private int maxSelectionNumber = -1;
        private IOperationHandler operationHandler;

        public Builder(Composite parent) {
            if (parent == null) {
                throw new IllegalArgumentException("parent must not be null");
            }
            this.parent = parent;
        }

        public Builder<T> useFilters(boolean useFilters) {
            this.useFilters = useFilters;
            return this;
        }

        public Builder<T> useImport(boolean useImport) {
            this.useFilters = useImport;
            return this;
        }

        public Builder<T> maxSelectionNumber(int maxSelectionNumber) {
            this.maxSelectionNumber = maxSelectionNumber;
            return this;
        }

        public Builder<T> operationWorker(IOperationHandler operationWorker) {
            this.operationHandler = operationWorker;
            return this;
        }

        public ListSelectionUI<T> createInstance() {
            ListSelectionUI listSelectionUI = new ListSelectionUI(null);
            listSelectionUI.useFilters = this.useFilters;
            listSelectionUI.useImport = this.useImport;
            listSelectionUI.maxSelectionNumber = this.maxSelectionNumber;
            listSelectionUI.operationWorker = this.operationHandler;
            listSelectionUI.init(this.parent);
            return listSelectionUI;
        }
    }

    private class SelectedObjectSelectionListener
    implements Listener,
    SelectionListener {
        private SelectedObjectSelectionListener() {
        }

        public void handleEvent(Event event) {
            ListSelectionUI.this.updateAll();
        }

        public void widgetSelected(SelectionEvent e) {
            ListSelectionUI.this.updateAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ListSelectionUI.this.updateAll();
        }
    }
}

