/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.ui.internal.Activator;
import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.listselection.AbstractPaginationOrientDB;
import com.ez.common.ui.listselection.EZListContentProvider;
import com.ez.common.ui.listselection.EZListLabelProvider;
import com.ez.common.ui.listselection.EZListSelectionChangedListener;
import com.ez.common.ui.listselection.EZListViewerSorter;
import com.ez.common.ui.listselection.FastKeySelectionOnList;
import com.ez.common.ui.listselection.IOperationHandler;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.Listable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListPaginationOrientDB<T extends Listable>
extends AbstractPaginationOrientDB<Listable> {
    private static final Logger L = LoggerFactory.getLogger(ListPaginationOrientDB.class);
    protected static final int MIN_SELECTION_SIZE_VALUE_TO_ACTIVATE_OPERATION_HANDLER = 300;
    private Group selectedGroup;
    private Table selTable;
    private TableViewer selTableViewer;
    private AvailableObjectSelectionListener avSelectionListener;
    private Button addButton;
    private Button remButton;
    private Button addAllButton;
    private Button remAllButton;
    private Button importButton;
    private SelectedObjectSelectionListener selSelectionListener;
    private Image imageButonForeward;
    private Image imageButonBackward;
    private Image imageButonFForeward;
    private Image imageButonBBackward;
    private Image imageImport;
    private ImageDescriptor desc;
    private String rightLabel;
    private int maxSelectionNumber = -1;
    private IOperationHandler operationWorker;

    private ListPaginationOrientDB() {
    }

    public ListPaginationOrientDB(Composite parent, String objectType, boolean useFilters) {
        this.useFilters = useFilters;
        this.init(objectType, parent);
    }

    public ListPaginationOrientDB(Composite parent, String objectType, boolean useFilters, boolean useImport) {
        this.useFilters = useFilters;
        this.useImport = useImport;
        this.init(objectType, parent);
    }

    public ListPaginationOrientDB(Composite parent, String objectType) {
        this.init(objectType, parent);
    }

    @Override
    protected void init(String objectType, Composite parent) {
        super.init(objectType, parent);
        this.desc = Activator.getImageDescriptor("icons/listselection/foreward.png");
        this.imageButonForeward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/fforward.png");
        this.imageButonFForeward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/backward.png");
        this.imageButonBackward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/bbackward.png");
        this.imageButonBBackward = this.getImage(this.desc);
        this.desc = Activator.getImageDescriptor("icons/listselection/import.png");
        this.imageImport = this.getImage(this.desc);
        this.avSelectionListener = new AvailableObjectSelectionListener();
        this.avTable.addListener(2, (Listener)this.avSelectionListener);
        this.avTable.addSelectionListener((SelectionListener)this.avSelectionListener);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.createButtonsGroup(this.panel);
        this.selectedGroup = new Group(this.panel, 0);
        String lbl = this.rightLabel != null ? this.rightLabel : Messages.getString(ListPaginationOrientDB.class, "selected.label", new String[]{objectType});
        this.selectedGroup.setText(lbl);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 5;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.selectedGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 10;
        this.selectedGroup.setLayout((Layout)gl);
        this.selTableViewer = new TableViewer((Composite)this.selectedGroup, 268503810);
        this.selTableViewer.setUseHashlookup(true);
        this.selTableViewer.setContentProvider((IContentProvider)new EZListContentProvider());
        this.selTableViewer.setLabelProvider((IBaseLabelProvider)new EZListLabelProvider());
        this.selTableViewer.setSorter((ViewerSorter)new EZListViewerSorter());
        this.selTableViewer.addSelectionChangedListener((ISelectionChangedListener)new EZListSelectionChangedListener());
        this.selTableViewer.setInput((Object)this.selListElements);
        this.selTable = this.selTableViewer.getTable();
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.selTable.setLayoutData((Object)data);
        this.selSelectionListener = new SelectedObjectSelectionListener();
        this.selTable.addListener(2, (Listener)this.avSelectionListener);
        this.selTable.addSelectionListener((SelectionListener)this.avSelectionListener);
        this.selTable.addKeyListener((KeyListener)new FastKeySelectionOnList(this.selTable));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
    }

    @Override
    protected void createMainComposite2Lists(Composite parent) {
        this.panel = new Composite(parent, parent.getStyle());
        this.panel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ListPaginationOrientDB.this.visibleExpandedFrame) {
                    FormData data = (FormData)ListPaginationOrientDB.this.panel.getLayoutData();
                    data.left = new FormAttachment(0, 129);
                    ListPaginationOrientDB.this.panel.setLayoutData((Object)data);
                } else {
                    FormData data = (FormData)ListPaginationOrientDB.this.panel.getLayoutData();
                    data.left = new FormAttachment(0, 39);
                    ListPaginationOrientDB.this.panel.setLayoutData((Object)data);
                }
            }
        });
        GridLayout gl = new GridLayout(11, true);
        gl.horizontalSpacing = 0;
        this.panel.setLayout((Layout)gl);
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(0, 39);
        fData.right = new FormAttachment(100, 0);
        this.panel.setLayoutData((Object)fData);
    }

    @Override
    public void setAvailable(List available) {
        this.allObjects = available;
        if (this.allObjects != null && this.allObjects.size() > 0) {
            this.avListElements.addAll(this.allObjects);
            if (this.avListElements.size() > 14) {
                this.avTableViewer.setItemCount(15);
                this.avTableViewer.setInput(this.avListElements.subList(0, 15));
            } else {
                this.avTableViewer.setItemCount(this.avListElements.size());
            }
        }
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        this.avTableViewer.refresh();
        if (this.avListElements.size() > 0) {
            this.avTable.select(0);
        }
        this.manageButtons();
    }

    @Override
    public void setAvList(List available) {
        this.avListElements.clear();
        this.avListElements.addAll(available);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.avListElements.size() > 0) {
            this.avTableViewer.setItemCount(this.avListElements.size());
            this.avTableViewer.refresh();
            this.avTable.select(0);
        }
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    @Override
    public void setSelected(List selected) {
        this.selListElements.clear();
        this.selListElements.addAll(selected);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.selListElements.size() > 0) {
            this.selTable.select(0);
        }
        this.selTableViewer.refresh();
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    @Override
    public void setSelList(List selected) {
        this.selListElements.clear();
        this.selListElements.addAll(selected);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.selListElements.size() > 0) {
            this.selTableViewer.setItemCount(this.selListElements.size());
            this.selTableViewer.refresh();
            this.selTable.select(0);
        }
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    @Override
    protected void createButtonsGroup(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 0;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0x1000000;
        data.verticalIndent = -25;
        buttonsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 5;
        gl.marginLeft = 8;
        gl.marginRight = 8;
        buttonsGroup.setLayout((Layout)gl);
        this.addButton = new Button(buttonsGroup, 8);
        this.addButton.setImage(this.imageButonForeward);
        this.addButton.setEnabled(false);
        data = new GridData();
        data.verticalAlignment = 0x1000000;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 23;
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            final ISelection[] selectionArray = new ISelection[1];

            public void widgetSelected(SelectionEvent e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        selectionArray[0] = (this).ListPaginationOrientDB.this.avTableViewer.getSelection();
                    }
                });
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pmonitor) {
                        pmonitor.setTaskName(Messages.getString(ListPaginationOrientDB.class, "updating.wizard.page"));
                        StructuredSelection sel = (StructuredSelection)selectionArray[0];
                        Object[] se = sel.toArray();
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)se.length);
                        monitor.subTask(Messages.getString(ListPaginationOrientDB.class, "refresh.page"));
                        ArrayList<Listable> removed = new ArrayList<Listable>();
                        int i = 0;
                        while (i < se.length) {
                            Listable listElement = (Listable)se[i];
                            if (!(this).ListPaginationOrientDB.this.selListElements.contains(listElement)) {
                                (this).ListPaginationOrientDB.this.selListElements.add(listElement);
                                removed.add(listElement);
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        (this).ListPaginationOrientDB.this.avListElements.removeAll(removed);
                    }
                };
                if (ListPaginationOrientDB.this.operationWorker == null || ((StructuredSelection)this.selectionArray[0]).size() < 300) {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        L.error("", (Throwable)e1);
                    }
                    catch (InterruptedException e1) {
                        L.error("", (Throwable)e1);
                    }
                } else {
                    ListPaginationOrientDB.this.operationWorker.execute(runnable);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListPaginationOrientDB.this.selTableViewer.refresh();
                        (this).ListPaginationOrientDB.this.avTableViewer.refresh();
                        if ((this).ListPaginationOrientDB.this.avTable.getItemCount() > 0) {
                            (this).ListPaginationOrientDB.this.avTable.setSelection(0);
                        }
                        ListPaginationOrientDB.this.selTableViewer.getTable().setSelection(new int[0]);
                        ListPaginationOrientDB.this.selTableViewer.setSelection(selectionArray[0]);
                    }
                });
                ListPaginationOrientDB.this.listChange();
                ListPaginationOrientDB.this.manageButtons();
            }
        });
        if (this.maxSelectionNumber < 0) {
            this.addAllButton = new Button(buttonsGroup, 8);
            this.addAllButton.setImage(this.imageButonFForeward);
            this.addAllButton.setEnabled(false);
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.heightHint = 23;
            this.addAllButton.setLayoutData((Object)data);
            this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final ISelection[] selectionArray = new ISelection[1];
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ListPaginationOrientDB.this.avTable.selectAll();
                            selectionArray[0] = (this).ListPaginationOrientDB.this.avTableViewer.getSelection();
                        }
                    });
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pmonitor) {
                            pmonitor.setTaskName(Messages.getString(ListPaginationOrientDB.class, "updating.wizard.page"));
                            StructuredSelection sel = (StructuredSelection)selectionArray[0];
                            Object[] se = sel.toArray();
                            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)se.length);
                            monitor.subTask(Messages.getString(ListPaginationOrientDB.class, "refresh.page"));
                            ArrayList<Listable> removed = new ArrayList<Listable>();
                            int i = 0;
                            while (i < se.length) {
                                Listable listElement = (Listable)se[i];
                                if (!(this).ListPaginationOrientDB.this.selListElements.contains(listElement)) {
                                    (this).ListPaginationOrientDB.this.selListElements.add(listElement);
                                    removed.add(listElement);
                                }
                                monitor.worked(1);
                                ++i;
                            }
                            (this).ListPaginationOrientDB.this.avListElements.removeAll(removed);
                        }
                    };
                    if (ListPaginationOrientDB.this.operationWorker == null || ((StructuredSelection)selectionArray[0]).size() < 300) {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e1) {
                            L.error("", (Throwable)e1);
                        }
                        catch (InterruptedException e1) {
                            L.error("", (Throwable)e1);
                        }
                    } else {
                        ListPaginationOrientDB.this.operationWorker.execute(runnable);
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListPaginationOrientDB.this.selTableViewer.refresh();
                            (this).ListPaginationOrientDB.this.avTableViewer.refresh();
                            ListPaginationOrientDB.this.selTableViewer.getTable().setSelection(new int[0]);
                            ListPaginationOrientDB.this.selTableViewer.setSelection(selectionArray[0]);
                        }
                    });
                    ListPaginationOrientDB.this.listChange();
                    ListPaginationOrientDB.this.manageButtons();
                }
            });
        }
        this.remButton = new Button(buttonsGroup, 8);
        this.remButton.setImage(this.imageButonBackward);
        this.remButton.setLayoutData((Object)data);
        this.remButton.setEnabled(false);
        data.heightHint = 23;
        this.remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ISelection[] selectionArray = new ISelection[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        selectionArray[0] = ListPaginationOrientDB.this.selTableViewer.getSelection();
                    }
                });
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pmonitor) {
                        pmonitor.setTaskName(Messages.getString(ListPaginationOrientDB.class, "updating.wizard.page"));
                        StructuredSelection sel = (StructuredSelection)selectionArray[0];
                        Object[] se = sel.toArray();
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)se.length);
                        monitor.subTask(Messages.getString(ListPaginationOrientDB.class, "refresh.page"));
                        ArrayList<Listable> removed = new ArrayList<Listable>();
                        int i = 0;
                        while (i < se.length) {
                            Listable listElement = (Listable)se[i];
                            if (!(this).ListPaginationOrientDB.this.avListElements.contains(listElement)) {
                                (this).ListPaginationOrientDB.this.avListElements.add(listElement);
                                removed.add(listElement);
                                monitor.worked(1);
                            }
                            ++i;
                        }
                        (this).ListPaginationOrientDB.this.selListElements.removeAll(removed);
                    }
                };
                if (ListPaginationOrientDB.this.operationWorker == null || ((StructuredSelection)selectionArray[0]).size() < 300) {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        L.error("", (Throwable)e1);
                    }
                    catch (InterruptedException e1) {
                        L.error("", (Throwable)e1);
                    }
                } else {
                    ListPaginationOrientDB.this.operationWorker.execute(runnable);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ListPaginationOrientDB.this.avTableViewer.refresh();
                        ListPaginationOrientDB.this.selTableViewer.refresh();
                        if (ListPaginationOrientDB.this.selTable.getItemCount() > 0) {
                            ListPaginationOrientDB.this.selTable.setSelection(0);
                        }
                        (this).ListPaginationOrientDB.this.avTableViewer.getTable().setSelection(new int[0]);
                        (this).ListPaginationOrientDB.this.avTableViewer.setSelection((ISelection)new StructuredSelection(((StructuredSelection)selectionArray[0]).toList()));
                    }
                });
                ListPaginationOrientDB.this.listChange();
                ListPaginationOrientDB.this.manageButtons();
            }
        });
        this.remAllButton = new Button(buttonsGroup, 8);
        this.remAllButton.setImage(this.imageButonBBackward);
        this.remAllButton.setLayoutData((Object)data);
        this.remAllButton.setEnabled(false);
        data.heightHint = 23;
        this.remAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ISelection[] selectionArray = new ISelection[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListPaginationOrientDB.this.selTable.selectAll();
                        selectionArray[0] = ListPaginationOrientDB.this.selTableViewer.getSelection();
                    }
                });
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pmonitor) {
                        pmonitor.setTaskName(Messages.getString(ListPaginationOrientDB.class, "updating.wizard.page"));
                        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(this).ListPaginationOrientDB.this.selListElements.size());
                        monitor.subTask(Messages.getString(ListPaginationOrientDB.class, "refresh.page"));
                        for (Listable o : (this).ListPaginationOrientDB.this.selListElements) {
                            if (!(this).ListPaginationOrientDB.this.avListElements.contains(o)) {
                                (this).ListPaginationOrientDB.this.avListElements.add(o);
                            }
                            monitor.worked(1);
                        }
                        (this).ListPaginationOrientDB.this.selListElements.clear();
                    }
                };
                if (ListPaginationOrientDB.this.operationWorker == null || ((StructuredSelection)selectionArray[0]).size() < 300) {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e1) {
                        L.error("", (Throwable)e1);
                    }
                    catch (InterruptedException e1) {
                        L.error("", (Throwable)e1);
                    }
                } else {
                    ListPaginationOrientDB.this.operationWorker.execute(runnable);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ListPaginationOrientDB.this.avTableViewer.refresh();
                        ListPaginationOrientDB.this.selTableViewer.refresh();
                        (this).ListPaginationOrientDB.this.avTableViewer.getTable().setSelection(new int[0]);
                        (this).ListPaginationOrientDB.this.avTableViewer.setSelection(selectionArray[0]);
                    }
                });
                ListPaginationOrientDB.this.listChange();
                ListPaginationOrientDB.this.manageButtons();
            }
        });
        if (this.useImport) {
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.heightHint = 23;
            this.importButton = new Button(buttonsGroup, 8);
            this.importButton.setImage(this.imageImport);
            this.importButton.setLayoutData((Object)data);
            this.importButton.setEnabled(true);
            this.importButton.setToolTipText(Messages.getString(ListPaginationOrientDB.class, "import.tooltip"));
            this.importButton.setLayoutData((Object)data);
            this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = Display.getDefault().getActiveShell();
                    FileDialog fd = new FileDialog(shell);
                    String fName = fd.open();
                    if (fName != null) {
                        block17: {
                            ListPaginationOrientDB.this.avTable.deselectAll();
                            ListPaginationOrientDB.this.selTable.deselectAll();
                            BufferedReader br = null;
                            try {
                                try {
                                    String vName;
                                    br = new BufferedReader(new FileReader(new File(fName)));
                                    ArrayList<Listable> removed = new ArrayList<Listable>();
                                    while ((vName = br.readLine()) != null) {
                                        if ((vName = vName.trim()).isEmpty()) continue;
                                        for (Object item : ListPaginationOrientDB.this.avListElements) {
                                            if (!vName.equals(((Listable)item).getListableName()) || ListPaginationOrientDB.this.selListElements.contains(item)) continue;
                                            ListPaginationOrientDB.this.selListElements.add((Listable)item);
                                            removed.add((Listable)item);
                                        }
                                    }
                                    ListPaginationOrientDB.this.avListElements.removeAll(removed);
                                }
                                catch (Exception ex) {
                                    L.error("could not load file {}", (Object)fName, (Object)ex);
                                    if (br != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (IOException ex1) {
                                            L.error("can't close {}", (Object)fName, (Object)ex1);
                                        }
                                    }
                                    break block17;
                                }
                            }
                            catch (Throwable throwable) {
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (IOException ex1) {
                                        L.error("can't close {}", (Object)fName, (Object)ex1);
                                    }
                                }
                                throw throwable;
                            }
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException ex1) {
                                    L.error("can't close {}", (Object)fName, (Object)ex1);
                                }
                            }
                        }
                        ListPaginationOrientDB.this.selTableViewer.refresh();
                        ListPaginationOrientDB.this.avTableViewer.refresh();
                    }
                    ListPaginationOrientDB.this.listChange();
                    ListPaginationOrientDB.this.manageButtons();
                }
            });
        }
    }

    @Override
    public void listChange() {
        ListChangeEvent chanev = new ListChangeEvent(this, this.selTable.getItemCount());
        int size = this.changeListeners.size();
        int i = 0;
        while (i < size) {
            ListChangeListener listener = (ListChangeListener)this.changeListeners.elementAt(i);
            listener.listChangeEventHappend(chanev);
            ++i;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.avTable.removeListener(2, (Listener)this.avSelectionListener);
            this.selTable.removeListener(2, (Listener)this.selSelectionListener);
            this.avTable.removeSelectionListener((SelectionListener)this.avSelectionListener);
            this.selTable.removeSelectionListener((SelectionListener)this.selSelectionListener);
        } else {
            if (!this.avTable.isListening(14)) {
                this.avTable.addListener(2, (Listener)this.avSelectionListener);
                this.avTable.addSelectionListener((SelectionListener)this.avSelectionListener);
            }
            if (!this.selTable.isListening(13)) {
                this.avTable.addListener(2, (Listener)this.avSelectionListener);
                this.selTable.addSelectionListener((SelectionListener)this.selSelectionListener);
            }
        }
        if (this.addAllButton != null) {
            this.addAllButton.setEnabled(!readOnly);
        }
        this.addButton.setEnabled(!readOnly);
        this.remAllButton.setEnabled(!readOnly);
        this.remButton.setEnabled(!readOnly);
        if (!readOnly) {
            this.manageButtons();
        }
    }

    private synchronized void updateAll() {
        this.manageButtons();
    }

    @Override
    public synchronized void manageButtons() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean selectionSizeExceeded = ListPaginationOrientDB.this.maxSelectionNumber >= 0 && ListPaginationOrientDB.this.avTable.getSelectionCount() + ListPaginationOrientDB.this.selTable.getItemCount() > ListPaginationOrientDB.this.maxSelectionNumber;
                boolean avIsSelected = ListPaginationOrientDB.this.avTable.getSelectionCount() > 0;
                boolean selIsSelected = ListPaginationOrientDB.this.selTable.getSelectionCount() > 0;
                boolean avContainsElements = ListPaginationOrientDB.this.avTable.getItemCount() > 0;
                boolean selContainsElements = ListPaginationOrientDB.this.selTable.getItemCount() > 0;
                ListPaginationOrientDB.this.addButton.setEnabled(avIsSelected && !selectionSizeExceeded);
                ListPaginationOrientDB.this.remButton.setEnabled(selIsSelected);
                if (ListPaginationOrientDB.this.addAllButton != null) {
                    ListPaginationOrientDB.this.addAllButton.setEnabled(avContainsElements);
                }
                ListPaginationOrientDB.this.remAllButton.setEnabled(selContainsElements);
            }
        });
    }

    @Override
    public void clearSelected() {
        this.selListElements.clear();
        this.selTableViewer.refresh();
    }

    @Override
    public void clearUILists() {
        super.clearUILists();
        this.selTableViewer.refresh();
    }

    @Override
    public void makeSelectionIfSingle() {
    }

    public void setRightGroupLabel(String label) {
        this.rightLabel = label;
        if (this.selectedGroup != null) {
            this.selectedGroup.setText(this.rightLabel);
        }
    }

    /* synthetic */ ListPaginationOrientDB(ListPaginationOrientDB listPaginationOrientDB) {
        this();
    }

    private class AvailableObjectSelectionListener
    implements Listener,
    SelectionListener {
        private AvailableObjectSelectionListener() {
        }

        public void handleEvent(Event event) {
            ListPaginationOrientDB.this.updateAll();
        }

        public void widgetSelected(SelectionEvent e) {
            ListPaginationOrientDB.this.updateAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ListPaginationOrientDB.this.updateAll();
        }
    }

    public static class Builder<T extends Listable> {
        private Composite parent;
        private String objectType;
        protected boolean useFilters = false;
        protected boolean useImport = false;
        private int maxSelectionNumber = -1;
        private IOperationHandler operationHandler;

        public Builder(Composite parent, String objectType) {
            if (parent == null) {
                throw new IllegalArgumentException("parent must not be null");
            }
            if (objectType == null) {
                throw new IllegalArgumentException("objectType must not be null");
            }
            this.parent = parent;
            this.objectType = objectType;
        }

        public Builder<T> useFilters(boolean useFilters) {
            this.useFilters = useFilters;
            return this;
        }

        public Builder<T> useImport(boolean useImport) {
            this.useFilters = useImport;
            return this;
        }

        public Builder<T> maxSelectionNumber(int maxSelectionNumber) {
            this.maxSelectionNumber = maxSelectionNumber;
            return this;
        }

        public Builder<T> operationWorker(IOperationHandler operationWorker) {
            this.operationHandler = operationWorker;
            return this;
        }

        public ListPaginationOrientDB<T> createInstance() {
            ListPaginationOrientDB listSelectionUI = new ListPaginationOrientDB(null);
            listSelectionUI.useFilters = this.useFilters;
            listSelectionUI.useImport = this.useImport;
            listSelectionUI.maxSelectionNumber = this.maxSelectionNumber;
            listSelectionUI.operationWorker = this.operationHandler;
            listSelectionUI.init(this.objectType, this.parent);
            return listSelectionUI;
        }
    }

    private class SelectedObjectSelectionListener
    implements Listener,
    SelectionListener {
        private SelectedObjectSelectionListener() {
        }

        public void handleEvent(Event event) {
            ListPaginationOrientDB.this.updateAll();
        }

        public void widgetSelected(SelectionEvent e) {
            ListPaginationOrientDB.this.updateAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ListPaginationOrientDB.this.updateAll();
        }
    }
}

