/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import java.util.HashSet;
import java.util.Set;

public class ItemType {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Set<Integer> avTypes = new HashSet<Integer>();

    private ItemType() {
    }

    public ItemType(Integer dbType) {
        this();
        this.avTypes.add(dbType);
    }

    public void addType(Integer dbType) {
        this.avTypes.add(dbType);
    }

    public Set<Integer> getTypes() {
        return this.avTypes;
    }

    public static ItemType getItemType(Integer dbType) {
        return ItemType.getItemType(dbType, false);
    }

    public static ItemType getItemType(Integer dbType, boolean considerAssChildren) {
        ItemType type = new ItemType(dbType);
        if (!(considerAssChildren || dbType != 15 && dbType != 16 && dbType != 8)) {
            type.addType(8);
            type.addType(15);
            type.addType(16);
        }
        return type;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.avTypes == null ? 0 : this.avTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemType other = (ItemType)obj;
        return !(this.avTypes == null ? other.avTypes != null : !this.avTypes.equals(other.avTypes));
    }

    public String toString() {
        return "ItemType [avTypes=" + this.avTypes.toString() + "]";
    }
}

