/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastKeySelectionOnList
extends KeyAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FastKeySelectionOnList.class);
    private Table table = null;

    public FastKeySelectionOnList(Table table) {
        this.table = table;
    }

    public synchronized void keyPressed(KeyEvent e) {
        char character;
        if (((e.keyCode | e.stateMask) & 0x10000) == 0 && ((e.keyCode | e.stateMask) & 0x20000) == 0 && ((e.keyCode | e.stateMask) & 0x40000) == 0 && Pattern.matches("[0-9a-zA-Z]", String.valueOf(character = e.character))) {
            this.selectInTree(character);
        }
    }

    private void selectInTree(char character) {
        String searchText = String.valueOf(character).toUpperCase();
        L.debug("search text starting with {} in table", (Object)searchText);
        int itemCount = this.table.getItemCount();
        int currentSelection = this.table.getSelectionCount() > 1 ? -1 : this.table.getSelectionIndex();
        if (currentSelection < 0) {
            currentSelection = -1;
        }
        int index = -1;
        int i = currentSelection + 1;
        while (i < itemCount) {
            if (this.table.getItem(i).getText().toUpperCase().startsWith(searchText)) {
                L.debug("selecting {}: {}", (Object)this.table.getItem(i), (Object)i);
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            i = 0;
            while (i < currentSelection) {
                if (this.table.getItem(i).getText().toUpperCase().startsWith(searchText)) {
                    L.debug("selecting 2 {}: {}", (Object)this.table.getItem(i), (Object)i);
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.table.deselectAll();
            this.table.select(index);
            Rectangle selectedItemBounds = this.table.getItem(index).getBounds();
            Rectangle tableBounds = this.table.getBounds();
            if (selectedItemBounds.y < 0 || selectedItemBounds.y > tableBounds.height - selectedItemBounds.height) {
                this.table.setTopIndex(index);
            }
        }
    }
}

