/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.ui.listselection.Listable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class EZListViewerFilter<T extends Listable>
extends ViewerFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<Integer> allTypes = new ArrayList<Integer>();
    private String patternName;
    private String patternType;
    private boolean isRegularExpr = false;

    public String getPatternName() {
        return this.patternName;
    }

    public void addType(Integer type) {
        if (type != null && !this.allTypes.contains(type)) {
            this.allTypes.add(type);
        }
    }

    public void removeType(Integer type) {
        if (type != null && this.allTypes.contains(type)) {
            this.allTypes.remove(type);
        }
    }

    public void setExclusivePatternName(String patternName, boolean isRegularExpr) {
        this.patternName = patternName;
        this.patternType = null;
        this.isRegularExpr = isRegularExpr;
    }

    public String getPatternType() {
        return this.patternType;
    }

    public void setExclusivePatternType(String patternType) {
        this.patternType = patternType;
        this.patternName = null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String name = "";
        Integer type = null;
        Listable lelement = (Listable)element;
        name = lelement.getListableName();
        type = lelement.getTypeCode();
        if (this.allTypes.size() > 0) {
            if (type == null) {
                return true;
            }
            if (!this.allTypes.contains(type)) {
                return false;
            }
        }
        if (this.patternType != null) {
            String textType = type.toString();
            return this.isValid(this.patternType, textType);
        }
        if (this.patternName != null) {
            return this.isValid(this.patternName, name);
        }
        return true;
    }

    public void resetFilter() {
        this.patternName = null;
        this.patternType = null;
        this.isRegularExpr = false;
        this.allTypes.clear();
    }

    private boolean isValid(String pattern, String element) {
        if (pattern == null || element == null) {
            boolean bl = false;
        }
        boolean res = this.isRegularExpr ? (pattern.isEmpty() ? true : Pattern.matches(pattern, element)) : element.toLowerCase().contains(pattern.toLowerCase());
        return res;
    }
}

