/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.model.BaseListable;
import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.listselection.AvailableFilteredTree;
import com.ez.common.ui.listselection.EZListLabelProvider;
import com.ez.common.ui.listselection.EZListViewerSorter;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.swt.DpiScaler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeSelectionUI<T extends BaseListable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractTreeSelectionUI.class);
    protected Composite panel;
    protected Group availableGroup;
    protected TreeViewer avTreeViewer;
    private String objectType;
    protected boolean useImport = false;
    protected Vector<ListChangeListener> changeListeners = new Vector();
    protected final Color GREY_COLOR = new Color(null, 130, 130, 130);
    private final Color RED_COLOR = new Color(null, 255, 0, 0);
    private final Color BLACK_COLOR = new Color(null, 0, 0, 0);
    protected Composite parentComposite;
    protected ToolBar toolbarImageFilter;
    private ArrayList<ToolItem> toolItems = new ArrayList();
    protected boolean visibleExpandedFrame = false;
    protected final int LEFT_ICONS_WIDTH = 39;
    private static final int LEFT_ADDITIONAL_WIDITH_DELTA = 22;
    protected final int LEFT_ADDITIONAL_MAX_WIDTH = 90;
    protected final int LEFT_ITEMS_MIN_LETTERS = 7;
    private int leftAdditionalWidth = 90;
    protected final int HORIZ_SPAN_ALL = 11;
    private final int LEFT_ICONS_WIDTH_ALL = 60;
    private Set<Image> allImages = new HashSet<Image>();
    private static final String TOOL_ITEM_DATA_KEY = new String("tool.item.data.key");
    private static final String TOOL_ITEM_DATA_TEXT = new String("tool.item.data.text");
    private static final String TOOL_ITEM_DATA_SHORT_TEXT = new String("tool.item.data.short.text");
    protected boolean isMultiSelection = true;
    private Composite visibleIcons;
    private boolean fDisposed;
    private ResourceManager fResourceManager;

    protected void init(String objectType, Composite parent) {
        this.objectType = objectType;
        this.parentComposite = new Composite(parent, parent.getStyle());
        this.parentComposite.setLayout((Layout)new FormLayout());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.parentComposite.setLayoutData((Object)data);
        this.createMainComposite2Lists(this.parentComposite);
        this.availableGroup = new Group(this.panel, 0);
        String availableLabelText = Messages.getString(AbstractTreeSelectionUI.class, "available.label", new String[]{this.objectType});
        this.availableGroup.setText(availableLabelText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 5;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.availableGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 10;
        this.availableGroup.setLayout((Layout)gl);
        int style = 0x10010B00;
        if (this.isMultiSelection) {
            style |= 2;
        }
        PatternFilter avViewerFilter = new PatternFilter();
        AvailableFilteredTree avTree = new AvailableFilteredTree((Composite)this.availableGroup, style, avViewerFilter);
        this.avTreeViewer = avTree.getViewer();
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = DpiScaler.getScaledSize(150);
        this.avTreeViewer.getTree().setLayoutData((Object)data);
        this.avTreeViewer.setUseHashlookup(true);
        this.avTreeViewer.setLabelProvider((IBaseLabelProvider)new EZListLabelProvider());
        this.avTreeViewer.setData("AVAILABLE", (Object)Boolean.TRUE);
        this.avTreeViewer.setSorter((ViewerSorter)new EZListViewerSorter());
    }

    protected abstract void createMainComposite2Lists(Composite var1);

    public abstract void setAvailable(List<T> var1);

    protected abstract void listChange();

    protected void setText4ToolItems() {
        for (ToolItem item : this.toolItems) {
            if (item.isDisposed()) continue;
            this.setItemText(item);
            this.leftAdditionalWidth = item.getWidth() - 22;
        }
        this.toolbarImageFilter.getParent().layout();
    }

    private void setItemText(ToolItem item) {
        String text = (String)item.getData(TOOL_ITEM_DATA_SHORT_TEXT);
        String shortText = null;
        if (text == null) {
            text = (String)item.getData(TOOL_ITEM_DATA_TEXT);
            item.setText(text);
            if (item.getWidth() < 112) {
                item.setData(TOOL_ITEM_DATA_SHORT_TEXT, (Object)text);
            } else {
                shortText = text;
                for (int size = 7; text.length() > size; ++size) {
                    shortText = text.substring(0, size).concat("...");
                    item.setText(shortText);
                    if (item.getWidth() < 112) {
                        item.setData(TOOL_ITEM_DATA_SHORT_TEXT, (Object)shortText);
                        continue;
                    }
                    shortText = (String)item.getData(TOOL_ITEM_DATA_SHORT_TEXT);
                    item.setText(shortText);
                    break;
                }
            }
        } else {
            item.setText(text);
        }
    }

    protected void setEmptyText4ToolItems() {
        for (ToolItem item : this.toolItems) {
            if (item.isDisposed()) continue;
            item.setText("");
        }
    }

    protected abstract void createButtonsGroup(Composite var1);

    public void resetPanel() {
        this.GREY_COLOR.dispose();
        this.BLACK_COLOR.dispose();
        this.RED_COLOR.dispose();
        this.fDisposed = true;
        if (!this.allImages.isEmpty()) {
            for (Image image : this.allImages) {
                if (image == null || image.isDisposed()) continue;
                image.dispose();
            }
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
        }
    }

    private ResourceManager getResourceManager() {
        if (this.fDisposed) {
            return null;
        }
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public Image getImage(ImageDescriptor desc) {
        ResourceManager rm = this.getResourceManager();
        return rm.createImage(desc);
    }

    public void addChangeListener(ListChangeListener listener) {
        this.changeListeners.addElement(listener);
    }

    public void removeChangeListener(ListChangeListener listener) {
        this.changeListeners.removeElement(listener);
    }

    public abstract void manageButtons();

    public void setOjectType(String objectType) {
        this.objectType = objectType;
    }

    public void clearUILists() {
        this.avTreeViewer.refresh();
    }
}

