/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.listselection;

import com.ez.common.ui.internal.Activator;
import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.listselection.EZListContentProvider;
import com.ez.common.ui.listselection.EZListLabelProvider;
import com.ez.common.ui.listselection.EZListSelectionChangedListener;
import com.ez.common.ui.listselection.EZListViewerFilter;
import com.ez.common.ui.listselection.EZListViewerSorter;
import com.ez.common.ui.listselection.FastKeySelectionOnList;
import com.ez.common.ui.listselection.ImageDescriptorProvider;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.Listable;
import com.ez.common.ui.listselection.ListableComparator;
import com.ez.common.ui.swt.DpiScaler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectionUI<T extends Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractSelectionUI.class);
    protected Composite panel;
    protected Group availableGroup;
    protected Table avTable;
    protected TableViewer avTableViewer;
    protected List<T> avListElements = new ArrayList<T>();
    protected List<T> allObjects;
    protected List<T> selListElements = new ArrayList<T>();
    protected boolean useFilters = false;
    protected boolean useImport = false;
    protected Vector<ListChangeListener> changeListeners = new Vector();
    protected final Color GREY_COLOR = new Color(null, 130, 130, 130);
    private final Color RED_COLOR = new Color(null, 255, 0, 0);
    private final Color BLACK_COLOR = new Color(null, 0, 0, 0);
    protected Composite parentComposite;
    protected ToolBar toolbarImageFilter;
    private ArrayList<ToolItem> toolItems = new ArrayList();
    protected boolean visibleExpandedFrame = false;
    private Image imageAllSelection;
    private ToolItem allAreSelectedToolItem;
    private Text textFilterNameType;
    private Composite leftBarComposite;
    private ScrolledComposite sc2;
    private static final String COMBO_STRING_NAME = Messages.getString(AbstractSelectionUI.class, "combo.name.label");
    private EZListViewerFilter<T> avViewerFilter;
    private ToolItem widenToolItemButton;
    protected final int LEFT_ICONS_WIDTH = 44;
    private static final int LEFT_ADDITIONAL_WIDITH_DELTA = 22;
    protected final int LEFT_ADDITIONAL_MAX_WIDTH = 90;
    @Deprecated
    protected final int LEFT_ITEMS_MIN_LETTERS = 7;
    private int leftAdditionalWidth = 90;
    protected final int HORIZ_SPAN_ALL = 11;
    private final int LEFT_ICONS_WIDTH_ALL = 60;
    protected final int TOTAL_EXPANSION_IN_PIXELS = DpiScaler.getScaledSize(104 + this.leftAdditionalWidth);
    private Label filterByNameLabel;
    private Button filterRegExprBtn;
    private ImageDescriptorProvider imageDescriptorProvider;
    private static final String TOOL_ITEM_DATA_KEY = new String("tool.item.data.key");
    private static final String TOOL_ITEM_DATA_TEXT = new String("tool.item.data.text");
    private static final String TOOL_ITEM_DATA_SHORT_TEXT = new String("tool.item.data.short.text");
    protected boolean isMultiSelection = true;
    private Composite visibleIcons;
    private boolean fDisposed;
    private ResourceManager fResourceManager;

    protected void init(Composite parent) {
        this.parentComposite = new Composite(parent, parent.getStyle());
        this.parentComposite.setLayout((Layout)new FormLayout());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.parentComposite.setLayoutData((Object)data);
        ImageDescriptor desc = Activator.getImageDescriptor("icons/listselection/all.png");
        this.imageAllSelection = this.getImage(desc);
        this.createMainComposite2Lists(this.parentComposite);
        if (this.useFilters) {
            this.createCompositeLeftBar(this.parentComposite);
        }
        this.availableGroup = new Group(this.panel, 0);
        String availableLabelText = Messages.getString(AbstractSelectionUI.class, "available.group.label");
        this.availableGroup.setText(availableLabelText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 5;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.availableGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginTop = 10;
        this.availableGroup.setLayout((Layout)gl);
        int style = 0x10010B00;
        if (this.isMultiSelection) {
            style |= 2;
        }
        this.avTableViewer = new TableViewer((Composite)this.availableGroup, style);
        this.avTableViewer.setUseHashlookup(true);
        this.avTableViewer.setContentProvider((IContentProvider)new EZListContentProvider());
        this.avTableViewer.setLabelProvider((IBaseLabelProvider)new EZListLabelProvider());
        this.avViewerFilter = new EZListViewerFilter();
        this.avTableViewer.addFilter(this.avViewerFilter);
        this.avTableViewer.setSorter((ViewerSorter)new EZListViewerSorter());
        this.avTableViewer.addSelectionChangedListener((ISelectionChangedListener)new EZListSelectionChangedListener());
        this.avTableViewer.setInput(this.avListElements);
        this.avTable = this.avTableViewer.getTable();
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = DpiScaler.getScaledSize(150);
        this.avTable.setLayoutData((Object)data);
        this.avTable.addKeyListener((KeyListener)new FastKeySelectionOnList(this.avTable));
        Composite filterComposite = new Composite((Composite)this.availableGroup, 0);
        FormLayout formLayout = new FormLayout();
        filterComposite.setLayout((Layout)formLayout);
        GridData gridData = new GridData(768);
        filterComposite.setLayoutData((Object)gridData);
        this.filterByNameLabel = new Label(filterComposite, 16);
        this.filterByNameLabel.setText(COMBO_STRING_NAME);
        this.textFilterNameType = new Text(filterComposite, 2048);
        FormData dataCombo = new FormData();
        dataCombo.top = new FormAttachment(0, 2);
        dataCombo.bottom = new FormAttachment(100, 0);
        dataCombo.left = new FormAttachment(0, 2);
        this.filterByNameLabel.setLayoutData((Object)dataCombo);
        this.textFilterNameType.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AbstractSelectionUI.this.applyFilter();
            }
        });
        this.textFilterNameType.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AbstractSelectionUI.this.applyFilter();
            }
        });
        this.filterRegExprBtn = new Button(filterComposite, 2);
        this.filterRegExprBtn.setText("(.)*");
        this.filterRegExprBtn.setToolTipText(Messages.getString(AbstractSelectionUI.class, "reg.expr.tooltip"));
        FormData fdata = new FormData();
        fdata.top = new FormAttachment(0, 0);
        fdata.bottom = new FormAttachment(100, 0);
        fdata.right = new FormAttachment(100, 0);
        this.filterRegExprBtn.setLayoutData((Object)fdata);
        this.filterRegExprBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AbstractSelectionUI.this.applyFilter();
            }
        });
        FormData dataText = new FormData();
        dataText.top = new FormAttachment(0, 0);
        dataText.bottom = new FormAttachment(100, 0);
        dataText.left = new FormAttachment((Control)this.filterByNameLabel, 2);
        dataText.right = new FormAttachment((Control)this.filterRegExprBtn, 0);
        this.textFilterNameType.setLayoutData((Object)dataText);
    }

    private void applyFilter() {
        boolean useRegEx;
        String text = "";
        this.textFilterNameType.setForeground(this.BLACK_COLOR);
        if (this.textFilterNameType != null) {
            text = this.textFilterNameType.getText();
        }
        if (useRegEx = this.filterRegExprBtn.getSelection()) {
            try {
                Pattern.compile(text);
                this.avViewerFilter.setExclusivePatternName(text, useRegEx);
                this.avTableViewer.refresh();
                this.manageButtons();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.textFilterNameType.setForeground(this.RED_COLOR);
            }
        } else {
            this.avViewerFilter.setExclusivePatternName(text, useRegEx);
            this.avTableViewer.refresh();
            this.manageButtons();
        }
    }

    protected abstract void createMainComposite2Lists(Composite var1);

    private void createCompositeLeftBar(Composite parent) {
        int margin;
        this.leftBarComposite = new Composite(parent, 0);
        GridLayout lay = new GridLayout();
        lay.numColumns = 1;
        lay.marginBottom = margin = -4;
        lay.marginLeft = margin;
        lay.marginRight = margin;
        lay.marginTop = margin;
        lay.horizontalSpacing = 0;
        this.leftBarComposite.setLayout((Layout)lay);
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(0, 0);
        fData.right = new FormAttachment(0, 44);
        this.leftBarComposite.setLayoutData((Object)fData);
        Composite visible = new Composite(this.leftBarComposite, parent.getStyle());
        GridLayout la = new GridLayout();
        la.numColumns = 2;
        la.marginBottom = margin;
        la.marginLeft = margin;
        la.marginRight = margin;
        la.marginTop = margin;
        la.horizontalSpacing = 0;
        visible.setLayout((Layout)la);
        GridData data1 = new GridData(1808);
        data1.minimumWidth = 60;
        visible.setLayoutData((Object)data1);
        Composite visibleMove = new Composite(visible, parent.getStyle());
        FormLayout lay2 = new FormLayout();
        lay2.marginBottom = margin;
        lay2.marginLeft = -5;
        lay2.marginRight = margin;
        lay2.marginTop = margin;
        visibleMove.setLayout((Layout)lay2);
        GridData data3 = new GridData(1808);
        data3.minimumWidth = 10;
        visibleMove.setLayoutData((Object)data3);
        this.sc2 = new ScrolledComposite(visible, 768);
        this.sc2.setExpandHorizontal(true);
        this.sc2.setExpandVertical(true);
        this.sc2.setLayoutData((Object)new GridData(1808));
        this.sc2.setLayout((Layout)new GridLayout());
        this.visibleIcons = new Composite((Composite)this.sc2, parent.getStyle());
        this.sc2.setContent((Control)this.visibleIcons);
        GridLayout lay4 = new GridLayout();
        this.visibleIcons.setLayout((Layout)lay4);
        GridData data4 = new GridData(1808);
        this.visibleIcons.setLayoutData((Object)data4);
        this.toolbarImageFilter = new ToolBar(this.visibleIcons, 0x820200);
        GridData tifd = new GridData(1808);
        this.toolbarImageFilter.setLayoutData((Object)tifd);
        String allText = Messages.getString(AbstractSelectionUI.class, "selectAll");
        this.allAreSelectedToolItem = new ToolItem(this.toolbarImageFilter, 32);
        this.allAreSelectedToolItem.setImage(this.imageAllSelection);
        this.allAreSelectedToolItem.setData(TOOL_ITEM_DATA_TEXT, (Object)allText);
        this.allAreSelectedToolItem.setData(TOOL_ITEM_DATA_KEY, null);
        this.allAreSelectedToolItem.setToolTipText(allText);
        this.allAreSelectedToolItem.setSelection(true);
        this.toolItems.add(this.allAreSelectedToolItem);
        this.allAreSelectedToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ToolItem item : AbstractSelectionUI.this.toolItems) {
                    if (item.isDisposed() || item == AbstractSelectionUI.this.allAreSelectedToolItem) continue;
                    item.setSelection(false);
                }
                AbstractSelectionUI.this.allAreSelectedToolItem.setSelection(true);
                AbstractSelectionUI.this.resetFilterTypes();
            }
        });
        ToolBar toolBarWiden = new ToolBar(visibleMove, 8520256);
        FormData d = new FormData();
        d.top = new FormAttachment(40, 0);
        d.bottom = new FormAttachment(60, 0);
        d.left = new FormAttachment(0, 0);
        d.right = new FormAttachment(100, 0);
        toolBarWiden.setLayoutData((Object)d);
        ImageDescriptor desc = Activator.getImageDescriptor("icons/listselection/widen.png");
        final Image imageWiden = this.getImage(desc);
        desc = Activator.getImageDescriptor("icons/listselection/shorten.png");
        final Image imageShorten = this.getImage(desc);
        this.widenToolItemButton = new ToolItem(toolBarWiden, 512);
        this.widenToolItemButton.setImage(imageWiden);
        this.widenToolItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = AbstractSelectionUI.this.parentComposite.getShell();
                Rectangle r = shell.getBounds();
                if (!AbstractSelectionUI.this.visibleExpandedFrame) {
                    AbstractSelectionUI.this.setText4ToolItems();
                    FormData data = (FormData)AbstractSelectionUI.this.panel.getLayoutData();
                    data.left = new FormAttachment(0, 60 + AbstractSelectionUI.this.leftAdditionalWidth);
                    AbstractSelectionUI.this.panel.setLayoutData((Object)data);
                    data = (FormData)AbstractSelectionUI.this.leftBarComposite.getLayoutData();
                    data.right = new FormAttachment(0, AbstractSelectionUI.this.leftAdditionalWidth + 60);
                    AbstractSelectionUI.this.leftBarComposite.setLayoutData((Object)data);
                    AbstractSelectionUI.this.widenToolItemButton.setImage(imageShorten);
                    GridData data4 = new GridData(1808);
                    AbstractSelectionUI.this.visibleIcons.setLayoutData((Object)data4);
                    shell.setBounds(r.x, r.y, r.width + AbstractSelectionUI.this.TOTAL_EXPANSION_IN_PIXELS, r.height);
                } else {
                    FormData data = (FormData)AbstractSelectionUI.this.panel.getLayoutData();
                    data.left = new FormAttachment(0, 44);
                    AbstractSelectionUI.this.panel.setLayoutData((Object)data);
                    data = (FormData)AbstractSelectionUI.this.leftBarComposite.getLayoutData();
                    data.right = new FormAttachment(0, 44);
                    AbstractSelectionUI.this.leftBarComposite.setLayoutData((Object)data);
                    AbstractSelectionUI.this.widenToolItemButton.setImage(imageWiden);
                    AbstractSelectionUI.this.setEmptyText4ToolItems();
                    shell.setBounds(r.x, r.y, r.width - AbstractSelectionUI.this.TOTAL_EXPANSION_IN_PIXELS, r.height);
                }
                AbstractSelectionUI.this.visibleExpandedFrame = !AbstractSelectionUI.this.visibleExpandedFrame;
            }
        });
        this.sc2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AbstractSelectionUI.this.sc2.setMinSize(AbstractSelectionUI.this.visibleIcons.computeSize(-1, -1));
                AbstractSelectionUI.this.sc2.getParent().layout();
                AbstractSelectionUI.this.sc2.getParent().getParent().layout();
            }
        });
    }

    public abstract void setAvailable(List<T> var1);

    public void setAvList(List<T> available) {
        this.avListElements.clear();
        this.avListElements.addAll(available);
        if (this.visibleExpandedFrame) {
            this.setText4ToolItems();
        } else {
            this.setEmptyText4ToolItems();
        }
        if (this.avListElements.size() > 0) {
            this.avTableViewer.setItemCount(this.avListElements.size());
            this.avTableViewer.refresh();
            this.avTable.select(0);
        }
        this.manageButtons();
        this.panel.redraw();
        this.panel.update();
        this.parentComposite.pack();
        this.parentComposite.getParent().layout();
    }

    public List<T> getAvObjectList() {
        Collections.sort(this.avListElements, new ListableComparator());
        return this.avListElements;
    }

    public abstract void setSelected(List<T> var1);

    public abstract void setSelList(List<T> var1);

    public List getSelObjectList() {
        Collections.sort(this.selListElements, new ListableComparator());
        return this.selListElements;
    }

    protected void addImageAndTextToFilter(Image image, String text, ItemType type, ItemSelectionAdapter selectionAdapter) {
        ToolItem item = new ToolItem(this.toolbarImageFilter, 544);
        item.setImage(image);
        item.setToolTipText(text);
        item.setData(TOOL_ITEM_DATA_TEXT, (Object)text);
        item.setData(TOOL_ITEM_DATA_KEY, (Object)type);
        this.toolItems.add(item);
        item.addSelectionListener((SelectionListener)selectionAdapter);
    }

    protected abstract void listChange();

    protected void setText4ToolItems() {
        int max = 0;
        for (ToolItem item : this.toolItems) {
            if (item.isDisposed()) continue;
            this.setItemText(item);
            item.getParent().getSize();
            this.leftAdditionalWidth = item.getWidth() + item.getText().length();
            if (max >= this.leftAdditionalWidth) continue;
            max = this.leftAdditionalWidth;
        }
        this.leftAdditionalWidth = max;
        this.toolbarImageFilter.layout();
    }

    private void setItemText(ToolItem item) {
        String text = (String)item.getData(TOOL_ITEM_DATA_TEXT);
        item.setText(text);
        int size = text.length();
        while (item.getWidth() > 90 && size > 0) {
            item.setText(text.substring(0, size).concat("..."));
            --size;
        }
    }

    protected void setEmptyText4ToolItems() {
        for (ToolItem item : this.toolItems) {
            if (item.isDisposed()) continue;
            item.setText("");
        }
    }

    private void resetFilterTypes() {
        this.avViewerFilter.resetFilter();
        this.avTableViewer.refresh();
        this.manageButtons();
    }

    protected abstract void createButtonsGroup(Composite var1);

    public Composite getPanel() {
        return this.panel;
    }

    public void resetPanel() {
        this.GREY_COLOR.dispose();
        this.BLACK_COLOR.dispose();
        this.RED_COLOR.dispose();
        this.fDisposed = true;
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
        }
    }

    private ResourceManager getResourceManager() {
        if (this.fDisposed) {
            return null;
        }
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public Image getImage(ImageDescriptor desc) {
        ResourceManager rm = this.getResourceManager();
        return rm.createImage(desc);
    }

    public void addChangeListener(ListChangeListener listener) {
        this.changeListeners.addElement(listener);
    }

    public void removeChangeListener(ListChangeListener listener) {
        this.changeListeners.removeElement(listener);
    }

    public abstract void setReadOnly(boolean var1);

    public abstract void makeSelectionIfSingle();

    public abstract void manageButtons();

    public void setImageDescriptorProvider(ImageDescriptorProvider imageDescriptorProvider) {
        this.imageDescriptorProvider = imageDescriptorProvider;
    }

    public abstract void clearSelected();

    public void clearUILists() {
        this.avListElements.clear();
        this.selListElements.clear();
        this.avTableViewer.refresh();
        this.textFilterNameType.setText("");
        this.applyFilter();
    }

    public void setAvailableImages(List<ImageObj4Wizard> availableImages) {
        ToolItem[] items = this.toolbarImageFilter.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (!item.equals(this.allAreSelectedToolItem)) {
                item.dispose();
            }
            ++i;
        }
        if (this.useFilters && availableImages != null && !availableImages.isEmpty()) {
            ItemSelectionAdapter selectionAdapter = new ItemSelectionAdapter();
            for (ImageObj4Wizard obj : availableImages) {
                ItemType type = obj.getTypeCode();
                String textType = obj.getTypeText();
                Image image = null;
                ImageDescriptor image_desc = obj.getTypeImageDescriptor();
                if (image_desc != null) {
                    image = this.getImage(image_desc);
                    this.addImageAndTextToFilter(image, textType, type, selectionAdapter);
                    continue;
                }
                L.error("type/filter image not found for {}", (Object)textType);
            }
            this.allAreSelectedToolItem.setSelection(true);
            this.resetFilterTypes();
            this.sc2.setMinSize(this.visibleIcons.computeSize(-1, -1));
            this.sc2.getParent().layout();
        }
    }

    public void setLeftGroupLabel(String label) {
        this.availableGroup.setText(label);
    }

    protected class ItemSelectionAdapter
    extends SelectionAdapter {
        protected ItemSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (AbstractSelectionUI.this.allAreSelectedToolItem.getSelection()) {
                AbstractSelectionUI.this.allAreSelectedToolItem.setSelection(false);
            }
            boolean noneSelected = true;
            for (ToolItem elem : AbstractSelectionUI.this.toolItems) {
                if (!elem.isDisposed()) {
                    Set<Integer> avTypes;
                    ItemType types = (ItemType)elem.getData(TOOL_ITEM_DATA_KEY);
                    if (elem.getSelection()) {
                        noneSelected = false;
                        if (types == null) continue;
                        avTypes = types.getTypes();
                        for (Integer type : avTypes) {
                            AbstractSelectionUI.this.avViewerFilter.addType(type);
                        }
                        continue;
                    }
                    if (types == null) continue;
                    avTypes = types.getTypes();
                    for (Integer type : avTypes) {
                        AbstractSelectionUI.this.avViewerFilter.removeType(type);
                    }
                    continue;
                }
                L.debug("item is disposed");
            }
            if (noneSelected) {
                AbstractSelectionUI.this.allAreSelectedToolItem.setSelection(true);
                AbstractSelectionUI.this.resetFilterTypes();
            } else {
                AbstractSelectionUI.this.avTableViewer.refresh();
                AbstractSelectionUI.this.manageButtons();
                AbstractSelectionUI.this.listChange();
            }
        }
    }
}

