/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.guielements.preferences;

import com.ez.common.ui.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CustomComboFieldEditor
extends FieldEditor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Combo fCombo;
    private String fValue;
    private Composite fDataComposite;
    private String[][] fEntryNamesAndValues;
    private Text fText;
    private int numColumns;
    private Button fUseTextCheck;
    private String fUseTextCheckPropertyName;
    private static String INVALID_MSG = Messages.getString(CustomComboFieldEditor.class, "invalid.msg");

    public CustomComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this(name, null, labelText, entryNamesAndValues, parent);
    }

    public CustomComboFieldEditor(String name, String fUseTextCheckPropertyName, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        this.fUseTextCheckPropertyName = fUseTextCheckPropertyName;
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            if (this.fCombo != null) {
                ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
            } else {
                ((GridData)this.fText.getLayoutData()).horizontalSpan = left;
            }
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.numColumns = numColumns;
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        if (this.fDataComposite == null) {
            this.fDataComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.fDataComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalIndent = 0;
            gridData.verticalIndent = 0;
            gridData.horizontalAlignment = 4;
            this.fDataComposite.setLayoutData((Object)gridData);
        }
        this.fUseTextCheck = new Button(this.fDataComposite, 160);
        this.fUseTextCheck.setToolTipText(Messages.getString(CustomComboFieldEditor.class, "text.check.btn.tooltip.label"));
        this.fUseTextCheck.setSelection(true);
        this.addComboBoxChangeevents();
        this.addDataBox(this.fDataComposite, this.fUseTextCheck.getSelection());
    }

    private void addDataBox(Composite parent, boolean textBox) {
        int comboC = 1;
        if (this.numColumns > 1) {
            comboC = this.numColumns - 1;
        }
        Control control = this.getDataBoxControl(this.fDataComposite, textBox);
        GridData gd = new GridData(768);
        gd.horizontalSpan = comboC;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
        parent.layout();
    }

    private void addComboBoxChangeevents() {
        this.fUseTextCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CustomComboFieldEditor.this.fUseTextCheckChanged();
            }
        });
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
        Boolean useTextBox = null;
        if (this.fUseTextCheckPropertyName != null) {
            useTextBox = this.getPreferenceStore().getBoolean(this.fUseTextCheckPropertyName);
        }
        if (useTextBox == null) {
            useTextBox = true;
            if (this.fValue != null) {
                String[][] stringArray = this.fEntryNamesAndValues;
                int n = this.fEntryNamesAndValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] ss = stringArray[n2];
                    if (this.fValue.equals(ss[1])) {
                        useTextBox = false;
                    }
                    ++n2;
                }
            }
        }
        if (this.fUseTextCheck.getSelection() != useTextBox.booleanValue()) {
            this.fUseTextCheck.setSelection(useTextBox.booleanValue());
            this.fUseTextCheckChanged();
        }
        if (this.fUseTextCheckPropertyName != null) {
            this.getPreferenceStore().setValue(this.fUseTextCheckPropertyName, useTextBox.booleanValue());
        }
    }

    protected void doLoadDefault() {
        this.fUseTextCheck.setSelection(this.getPreferenceStore().getDefaultBoolean(this.fUseTextCheckPropertyName));
        this.fUseTextCheckChanged();
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Control getDataBoxControl(Composite parent, boolean textBox) {
        Text control;
        if (this.fCombo == null) {
            if (textBox) {
                this.fText = new Text(parent, 2048);
                this.fText.setFont(parent.getFont());
                this.fText.addListener(27, new Listener(){

                    public void handleEvent(Event event) {
                        CustomComboFieldEditor.this.fTextUpdated();
                    }
                });
                this.fText.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        CustomComboFieldEditor.this.fTextUpdated();
                    }
                });
                control = this.fText;
            } else {
                this.fCombo = new Combo(parent, 8);
                this.fCombo.setFont(parent.getFont());
                int i = 0;
                while (i < this.fEntryNamesAndValues.length) {
                    this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                    ++i;
                }
                this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        CustomComboFieldEditor.this.fComboUpdated();
                    }
                });
                control = this.fCombo;
            }
        } else {
            control = null;
        }
        return control;
    }

    private void fTextUpdated() {
        String oldValue = this.fValue;
        this.fValue = this.fText.getText();
        this.setPresentsDefaultValue(false);
        this.refreshValidState();
        this.showErrorMessage(this.isValid() ? null : INVALID_MSG);
        this.fireValueChanged("field_editor_value", oldValue, this.fValue);
    }

    private void fComboUpdated() {
        String oldValue = this.fValue;
        String name = this.fCombo.getText();
        this.fValue = this.getValueForName(name);
        this.setPresentsDefaultValue(false);
        this.refreshValidState();
        this.fireValueChanged("field_editor_value", oldValue, this.fValue);
    }

    private void fUseTextCheckChanged() {
        boolean selection = this.fUseTextCheck.getSelection();
        if (this.fCombo != null) {
            this.fCombo.dispose();
            this.fCombo = null;
        }
        if (this.fText != null) {
            this.fText.dispose();
            this.fText = null;
        }
        this.addDataBox(this.fDataComposite, selection);
        if (this.fUseTextCheckPropertyName != null) {
            this.getPreferenceStore().setValue(this.fUseTextCheckPropertyName, selection);
        }
        if (this.fText != null) {
            this.fText.setText(this.fValue);
            this.refreshValidState();
            this.showErrorMessage(this.isValid() ? null : INVALID_MSG);
        }
        if (this.fCombo != null) {
            this.updateComboForValue(this.fValue);
            this.clearErrorMessage();
        }
    }

    private String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String value) {
        if (this.fCombo != null) {
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                if (value.equals(this.fEntryNamesAndValues[i][1])) {
                    if (this.fCombo != null) {
                        this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                        this.fComboUpdated();
                    }
                    return;
                }
                ++i;
            }
            if (this.fEntryNamesAndValues.length > 0) {
                value = this.fEntryNamesAndValues[0][1];
                this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
                this.fComboUpdated();
            }
            this.fValue = value;
        } else {
            this.fText.setText(value);
            this.fValue = value;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getDataBoxControl(parent, false).setEnabled(enabled);
    }

    public String getTextValue() {
        if (this.fText == null) {
            return null;
        }
        return this.fText.getText();
    }

    public Accessible getAccessible() {
        return this.fUseTextCheck.getAccessible();
    }
}

