/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.guielements;

import com.ez.common.ui.internal.Messages;
import com.ez.common.ui.swt.DpiScaler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatePicker
extends Composite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String DATE_FORMAT = ((SimpleDateFormat)SimpleDateFormat.getDateInstance(2, Locale.getDefault())).toPattern();
    private String DATE_FORMAT_LOCALIZED = ((SimpleDateFormat)SimpleDateFormat.getDateInstance(2, Locale.getDefault())).toLocalizedPattern();
    private Composite compositeCalendar;
    private Composite compositeHeader;
    private Composite compositeBody;
    private Composite compositeYear;
    private Composite compositeParent;
    private Shell shellComposite;
    private Widget widgetYear;
    private GridLayout layoutYearComposite;
    private GridData gridYearComposite;
    private Calendar calendar = new GregorianCalendar();
    private PropertyChangeListener listener;
    private static Color black = new Color(null, 0, 0, 0);
    private static Color gray = new Color(null, 127, 127, 127);
    private static Color blue = new Color(null, 0, 106, 213);
    private static Color white = new Color(null, 255, 255, 255);
    private static Color todayColor = new Color(null, 157, 156, 151);
    private static Color compositeBackgroundColor = new Color(null, 255, 255, 255);
    private static Color compositeHeaderColor = new Color(null, 170, 170, 170);
    private static Color compositeBodyColor = new Color(null, 255, 255, 255);
    private static Color selectionBackground = new Color(null, 255, 255, 255);
    private static Color weekNrBackgroundColor = new Color(null, 214, 214, 214);
    private static Color gray230 = new Color(null, 230, 230, 230);
    private Color currentForeground;
    private Color currentBackground;
    private DateFormatSymbols dfs;
    private MenuItem[] item;
    private Menu menuMonth;
    private Button buttonShow;
    private Button buttonBack;
    private Button buttonNext;
    private Text textField;
    private Label labelMonth;
    private Label selection;
    private Label[][] labels;
    private String[] years;
    private String stringAddYear = "    ";
    private String stringAddMonth = "    ";
    private Calendar oldValue;
    private int index;
    private boolean showCalendar = false;
    private MouseListener mouseListenerFocus = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            if (e.getSource() instanceof Composite) {
                ((Composite)e.getSource()).setFocus();
                ((Composite)e.getSource()).forceFocus();
            }
            if (e.getSource() instanceof Label) {
                ((Label)e.getSource()).setFocus();
                ((Label)e.getSource()).forceFocus();
            }
            if (e.getSource() instanceof Button) {
                ((Button)e.getSource()).setFocus();
                ((Button)e.getSource()).forceFocus();
            }
        }
    };
    private KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000003: {
                    DatePicker.this.goDay(-1);
                    break;
                }
                case 0x1000004: {
                    DatePicker.this.goDay(1);
                    break;
                }
                case 0x1000001: {
                    DatePicker.this.goDay(-7);
                    break;
                }
                case 0x1000002: {
                    DatePicker.this.goDay(7);
                }
            }
            DatePicker.this.setStringIntoText();
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 27) {
                if (DatePicker.this.oldValue != null) {
                    DatePicker.this.calendar = DatePicker.this.oldValue;
                    DatePicker.this.setStringIntoText();
                }
                DatePicker.this.popup(false);
            }
            if (e.keyCode == 13) {
                DatePicker.this.setStringIntoText();
                DatePicker.this.popup(false);
            }
        }
    };

    public DatePicker(Composite parent, int style) {
        super(parent, 0);
        this.compositeParent = parent;
        this.createControl(style);
        this.createShellBody(parent);
    }

    private void createWindow(Composite parent) {
        this.shellComposite = new Shell(parent.getDisplay(), 65548);
        this.shellComposite.setSize(230, 190);
        this.shellComposite.setLayout((Layout)new GridLayout());
        FormLayout formLayout = new FormLayout();
        this.shellComposite.setLayout((Layout)formLayout);
        this.shellComposite.setVisible(false);
        this.shellComposite.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                DatePicker.this.setStringIntoText();
                DatePicker.this.popup(false);
            }
        });
        this.shellComposite.addKeyListener(this.keyListener);
    }

    private void createControl(int style) {
        this.setBackground(this.getBackground());
        FormLayout fl = new FormLayout();
        this.setLayout((Layout)fl);
        this.textField = new Text((Composite)this, style | 8);
        FormData fd = new FormData();
        this.textField.setLayoutData((Object)fd);
        this.dfs = new DateFormatSymbols();
        this.buttonShow = new Button((Composite)this, 4);
        this.buttonShow.setLayoutData((Object)fd);
        this.buttonShow.setToolTipText(Messages.getString(DatePicker.class, "openCalendar.button.tooltip"));
        this.buttonShow.setBackground(this.getBackground());
        this.buttonShow.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DatePicker.this.showButtonAction((TypedEvent)e);
            }
        });
        this.buttonShow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    DatePicker.this.showButtonAction((TypedEvent)e);
                }
            }
        });
        this.textField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == ' ') {
                    DatePicker.this.showButtonAction((TypedEvent)e);
                }
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.textField, 0);
        this.buttonShow.setLayoutData((Object)fd);
        this.buttonShow.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 8: 
                    case 16: {
                        e.doit = true;
                    }
                }
            }
        });
        this.textField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                DatePicker.this.buttonShow.forceFocus();
            }
        });
    }

    private void showButtonAction(TypedEvent e) {
        Point location;
        if (e instanceof KeyEvent) {
            Point relativeLocationInWizard = this.getShell().getSize();
            Point wizardLocationOnScreens = this.getShell().getLocation();
            wizardLocationOnScreens.x += relativeLocationInWizard.x / 2;
            wizardLocationOnScreens.y += relativeLocationInWizard.y / 2;
            location = wizardLocationOnScreens;
        } else {
            location = e.display.getCursorLocation();
        }
        this.shellComposite.setLocation(location);
        this.setShown(!this.showCalendar);
    }

    private void popup(boolean visible) {
        if (visible) {
            this.setShown(true);
        } else {
            this.shellComposite.setVisible(visible);
            this.layout();
        }
    }

    private void createShellBody(Composite parent) {
        this.labels = new Label[7][8];
        this.createWindow(this);
        this.createCompositeCalendar();
        this.createHeaderComposite();
        this.createBodyComposite();
        this.createBodyElements();
        this.createWeekDayLabel();
        this.createMenu();
        this.updateDates();
        this.setNewLook();
        this.labelMonth.setFocus();
        this.labelMonth.forceFocus();
        this.compositeCalendar.setEnabled(true);
        this.textFieldAction();
        this.compositeCalendar.pack();
        this.shellComposite.pack(true);
        this.setEmptyDate();
    }

    private void createWeekDayLabel() {
        int firstDayOfWeek = 0;
        int i = 1;
        while (i < 8) {
            String s = this.dfs.getShortWeekdays()[1 + (firstDayOfWeek + i - 1) % 7];
            this.labels[0][i].setText(s);
            ++i;
        }
    }

    private void createCompositeCalendar() {
        this.compositeCalendar = new Composite((Composite)this.shellComposite, 2048);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 8;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginTop = 2;
        gridLayout.marginLeft = 2;
        gridLayout.marginBottom = 2;
        gridLayout.marginRight = 2;
        this.compositeCalendar.setLayout((Layout)gridLayout);
        this.compositeCalendar.setVisible(false);
        this.compositeCalendar.addKeyListener(this.keyListener);
        this.compositeCalendar.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                DatePicker.this.setStringIntoText();
                DatePicker.this.popup(false);
            }
        });
    }

    private void setHeaderComponents() {
        this.years = new String[25];
        int year = this.calendar.get(1);
        int i = 0;
        while (i < this.years.length) {
            this.years[i] = String.valueOf(year + i);
            ++i;
        }
        GridData gridData = new GridData();
        this.buttonBack = new Button(this.compositeHeader, 16388);
        this.buttonBack.setBackground(compositeHeaderColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 2;
        this.buttonBack.setLayoutData((Object)gridData);
        this.buttonBack.addMouseListener(this.mouseListenerFocus);
        this.buttonBack.addKeyListener(this.keyListener);
        this.buttonBack.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DatePicker.this.goMonth(-1);
                DatePicker.this.setStringIntoText();
            }
        });
        this.labelMonth = new Label(this.compositeHeader, 0);
        this.labelMonth.setBackground(compositeHeaderColor);
        gridData = new GridData(1808);
        gridData.widthHint = DpiScaler.getScaledSize(90);
        gridData.heightHint = DpiScaler.getScaledSize(20);
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 0x1000000;
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.labelMonth.setLayoutData((Object)gridData);
        this.labelMonth.addMouseListener(this.mouseListenerFocus);
        this.selectMonth(this.calendar.get(2));
        this.createYearComposite();
        this.buttonNext = new Button(this.compositeHeader, 131076);
        this.buttonNext.setBackground(compositeHeaderColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 2;
        this.buttonNext.setLayoutData((Object)gridData);
        this.buttonNext.addMouseListener(this.mouseListenerFocus);
        this.buttonNext.addKeyListener(this.keyListener);
        this.buttonNext.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DatePicker.this.goMonth(1);
                DatePicker.this.setStringIntoText();
            }
        });
    }

    private void goDay(int delta) {
        this.calendar.add(5, delta);
        this.selectMonth(this.calendar.get(2));
        this.selectYear(this.calendar.get(1));
        this.updateDates();
        this.autoChangeSelection();
    }

    private void createExchangeYearWidgets(boolean which) {
        GridData gridData = new GridData();
        if (which) {
            if (this.widgetYear != null) {
                this.widgetYear.dispose();
            }
            this.widgetYear = null;
            this.compositeYear.setLayout(null);
            this.compositeYear.setLayout((Layout)this.layoutYearComposite);
            this.compositeYear.setLayoutData((Object)this.gridYearComposite);
            this.widgetYear = new Label(this.compositeYear, 0);
            gridData = new GridData(1808);
            gridData.heightHint = DpiScaler.getScaledSize(40);
            gridData.horizontalSpan = 1;
            gridData.verticalAlignment = 2;
            gridData.horizontalAlignment = 2;
            ((Label)this.widgetYear).setLayoutData((Object)gridData);
            ((Label)this.widgetYear).setBackground(compositeHeaderColor);
            this.selectYear(this.calendar.get(1));
            ((Label)this.widgetYear).pack(true);
            this.compositeYear.layout(true);
            ((Label)this.widgetYear).addMouseListener(this.mouseListenerFocus);
            ((Label)this.widgetYear).addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    DatePicker.this.createExchangeYearWidgets(false);
                }

                public void mouseUp(MouseEvent e) {
                }
            });
        } else {
            if (this.widgetYear != null) {
                this.widgetYear.dispose();
            }
            this.widgetYear = null;
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 1;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginRight = 0;
            this.widgetYear = new Spinner(this.compositeYear, 0x800800);
            FontRegistry fontRegistry = new FontRegistry(this.compositeHeader.getDisplay());
            fontRegistry.put("button-text", new FontData[]{new FontData("Arial", 8, 1)});
            ((Spinner)this.widgetYear).setMinimum(0);
            ((Spinner)this.widgetYear).setMaximum(3000);
            ((Spinner)this.widgetYear).setSelection(this.calendar.get(1));
            ((Spinner)this.widgetYear).setIncrement(1);
            ((Spinner)this.widgetYear).setPageIncrement(100);
            gridData = new GridData(0x1000000, 0x1000000, true, true);
            gridData.horizontalSpan = 1;
            ((Spinner)this.widgetYear).setLayoutData((Object)gridData);
            ((Spinner)this.widgetYear).setBounds(0, -1, 49, 19);
            ((Spinner)this.widgetYear).addMouseListener(this.mouseListenerFocus);
            ((Spinner)this.widgetYear).setFocus();
            ((Spinner)this.widgetYear).addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    DatePicker.this.spinnerDeactivated(event);
                }
            });
            ((Spinner)this.widgetYear).addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    DatePicker.this.spinnerDeactivated(null);
                }
            });
            ((Spinner)this.widgetYear).addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 13) {
                        DatePicker.this.spinnerDeactivated(null);
                        DatePicker.this.setStringIntoText();
                    } else {
                        DatePicker.this.setStringIntoText();
                    }
                }
            });
            ((Spinner)this.widgetYear).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int year = ((Spinner)DatePicker.this.widgetYear).getSelection();
                    int month = DatePicker.this.calendar.get(2);
                    DatePicker.this.calendarChange(year, month);
                }
            });
        }
        this.compositeYear.layout(true);
        this.compositeHeader.layout(true);
    }

    private void spinnerDeactivated(Event e) {
        if (this.widgetYear instanceof Spinner) {
            int intYear = ((Spinner)this.widgetYear).getSelection();
            int month = this.calendar.get(2);
            this.calendarChange(intYear, month);
            this.createExchangeYearWidgets(true);
            this.selectYear(intYear);
        }
    }

    private void createYearComposite() {
        this.compositeYear = new Composite(this.compositeHeader, 0);
        GridLayout layoutYearComposite = new GridLayout();
        layoutYearComposite.numColumns = 0;
        layoutYearComposite.marginTop = 0;
        layoutYearComposite.marginLeft = 0;
        layoutYearComposite.marginBottom = 0;
        layoutYearComposite.marginRight = 0;
        layoutYearComposite.horizontalSpacing = 0;
        layoutYearComposite.verticalSpacing = 0;
        this.compositeYear.setLayout((Layout)layoutYearComposite);
        GridData gridYearComposite = new GridData();
        gridYearComposite = new GridData();
        gridYearComposite.verticalAlignment = 2;
        this.compositeYear.setLayoutData((Object)gridYearComposite);
        this.compositeYear.setBackground(compositeHeaderColor);
        this.compositeYear.setBackground(blue);
        this.compositeYear.addMouseListener(this.mouseListenerFocus);
        this.compositeYear.addKeyListener(this.keyListener);
        this.createExchangeYearWidgets(true);
    }

    private void createHeaderComposite() {
        this.compositeHeader = new Composite(this.compositeCalendar, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.compositeHeader.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        gridData.verticalAlignment = 2;
        this.compositeHeader.setLayoutData((Object)gridData);
        this.compositeHeader.setBackground(compositeHeaderColor);
        this.compositeHeader.addMouseListener(this.mouseListenerFocus);
        this.compositeHeader.addKeyListener(this.keyListener);
        this.setHeaderComponents();
    }

    private void createBodyElements() {
        GridData gridData = new GridData();
        int week = 0;
        while (week < 7) {
            int i = 0;
            while (i < 8) {
                final Label fLabel = new Label(this.compositeBody, 0);
                gridData = new GridData(1808);
                gridData.widthHint = DpiScaler.getScaledSize(30);
                gridData.heightHint = DpiScaler.getScaledSize(19);
                gridData.verticalAlignment = 0x1000000;
                gridData.horizontalAlignment = 0x1000000;
                fLabel.setLayoutData((Object)gridData);
                if (week == 1) {
                    gridData.verticalSpan = 1;
                }
                this.labels[week][i] = fLabel;
                if (week > 0 && i > 0) {
                    this.labels[week][i].addKeyListener(this.keyListener);
                    this.labels[week][i].addMouseListener(this.mouseListenerFocus);
                    this.labels[week][i].addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent e) {
                            if (!DatePicker.this.selectDisabledDates(fLabel)) {
                                DatePicker.this.setSelection(fLabel);
                                DatePicker.this.setStringIntoText();
                            }
                            DatePicker.this.popup(false);
                            DatePicker.this.compositeParent.layout();
                        }

                        public void mouseDown(MouseEvent e) {
                            if (!DatePicker.this.selectDisabledDates(fLabel)) {
                                DatePicker.this.setSelection(fLabel);
                                DatePicker.this.setStringIntoText();
                            }
                        }
                    });
                }
                ++i;
            }
            ++week;
        }
    }

    private void createBodyComposite() {
        this.compositeBody = new Composite(this.compositeCalendar, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.compositeBody.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        this.compositeBody.setLayoutData((Object)gridData);
        this.compositeBody.setBackground(compositeBodyColor);
        this.compositeBody.addKeyListener(this.keyListener);
        this.compositeBody.addMouseListener(this.mouseListenerFocus);
    }

    private void setNewLook() {
        this.compositeCalendar.setBackground(compositeBackgroundColor);
        this.compositeBody.setBackground(compositeBodyColor);
    }

    public void setStringIntoText() {
        if (this.textField != null && !this.textField.isDisposed()) {
            this.textField.setText(this.dateToString(this.calendar));
        }
    }

    private String dateToString(Calendar calendar) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.DATE_FORMAT, Locale.getDefault());
        String formattedDate = formatter.format(calendar.getTime());
        return formattedDate;
    }

    private void setShown(boolean shown) {
        this.compositeParent.layout(true);
        this.compositeCalendar.setVisible(true);
        this.shellComposite.setVisible(true);
        this.compositeCalendar.pack();
        this.shellComposite.pack();
        this.getParent().layout();
        this.shellComposite.forceActive();
        if (shown && !this.compositeCalendar.isDisposed()) {
            this.buttonNext.forceFocus();
            this.calendar.set(1, this.getDateCalendar().get(1));
            this.calendar.set(2, this.getDateCalendar().get(2));
            this.calendar.set(5, this.getDateCalendar().get(5));
            this.selectDate(this.calendar);
            this.updateDates();
            this.oldValue = new GregorianCalendar(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5), this.calendar.get(11), this.calendar.get(12), this.calendar.get(13));
            int i = 0;
            while (i < this.labels.length) {
                int j = 1;
                while (j < this.labels[0].length) {
                    if (this.labels[i][j].getText().equals(String.valueOf(this.calendar.get(5))) && !this.equals(this.labels[i][j].getForeground(), gray)) {
                        this.setSelection(this.labels[i][j]);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.oldValue = this.calendar;
    }

    public void setEmptyDate() {
        this.textField.setText("                     ");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.buttonShow.setEnabled(enabled);
    }

    private void selectMonth(int month) {
        this.labelMonth.setText(String.valueOf(this.stringAddMonth) + this.dfs.getMonths()[month]);
        if (this.compositeYear != null && !this.compositeYear.isDisposed()) {
            this.compositeYear.layout(true);
        }
        if (this.compositeHeader != null && !this.compositeHeader.isDisposed()) {
            this.compositeHeader.layout(true);
        }
    }

    private void selectYear(int year) {
        if (this.widgetYear instanceof Label) {
            if ((Label)this.widgetYear != null && !((Label)this.widgetYear).isDisposed()) {
                ((Label)this.widgetYear).setText(String.valueOf(String.valueOf(year)) + this.stringAddYear);
            }
        } else if ((Spinner)this.widgetYear != null && !((Spinner)this.widgetYear).isDisposed()) {
            ((Spinner)this.widgetYear).setSelection(year);
        }
    }

    private void createMenu() {
        this.menuMonth = new Menu((Control)this.labelMonth.getParent());
        this.item = new MenuItem[this.dfs.getMonths().length];
        int i = 0;
        while (i < this.dfs.getMonths().length) {
            if (this.dfs.getMonths()[i] != null && this.dfs.getMonths()[i].length() > 0) {
                this.item[i] = new MenuItem(this.menuMonth, 8);
                this.item[i].setText(this.dfs.getMonths()[i]);
            }
            ++i;
        }
        this.labelMonth.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                DatePicker.this.menuMonth.setVisible(true);
            }
        });
        this.index = 0;
        while (this.index < this.item.length) {
            if (this.item[this.index] != null) {
                this.item[this.index].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem selItem = (MenuItem)e.widget;
                        String s = selItem.getText();
                        int j = 0;
                        while (j < DatePicker.this.item.length) {
                            if (DatePicker.this.menuMonth.getItem(j) != null && DatePicker.this.menuMonth.getItem(j).getText().equals(s)) {
                                DatePicker.this.selectMonth(j);
                                DatePicker.this.calendarChange(DatePicker.this.calendar.get(1), j);
                                DatePicker.this.setStringIntoText();
                                return;
                            }
                            ++j;
                        }
                    }
                });
            }
            ++this.index;
        }
        this.labelMonth.setMenu(this.menuMonth);
    }

    private void updateDates() {
        int i;
        GregorianCalendar firstDay = (GregorianCalendar)this.calendar.clone();
        firstDay.set(5, 1);
        int month = this.calendar.get(2);
        int year = this.calendar.get(1);
        GregorianCalendar today = new GregorianCalendar();
        int todayD = today.get(5);
        int todayM = today.get(2) + 1;
        int todayY = today.get(1);
        GregorianCalendar calendarDay = (GregorianCalendar)firstDay.clone();
        calendarDay.add(5, -firstDay.get(7) + 1 + Calendar.getInstance().getFirstDayOfWeek() - 1);
        int week = 1;
        int endMonth = (month + 1) % 12;
        while (true) {
            i = 1;
            while (i < 8) {
                int iterateDay = calendarDay.get(5);
                int iterateMonth = calendarDay.get(2);
                this.labels[0][i].setBackground(gray230);
                this.labels[0][0].setBackground(gray230);
                this.labels[0][i].setForeground(blue);
                this.labels[0][i].setAlignment(0x1000000);
                this.labels[week][i].setAlignment(0x1000000);
                this.labels[week][0].setBackground(weekNrBackgroundColor);
                this.labels[week][0].setForeground(black);
                this.labels[week][0].setAlignment(0x1000000);
                this.labels[week][i].setForeground(month == iterateMonth ? black : gray);
                this.labels[week][i].setBackground(calendarDay.equals(this.calendar) ? selectionBackground : this.getBackground());
                this.labels[week][i].setBackground(compositeBackgroundColor);
                if (calendarDay.equals(this.calendar)) {
                    this.selection = this.labels[week][i];
                }
                String add = "";
                this.labels[week][i].setText(String.valueOf(add) + String.valueOf(iterateDay));
                this.labels[week][i].setData((Object)calendarDay.getTime());
                String stringNrOfWeek = String.valueOf(calendarDay.get(3));
                this.labels[week][0].setText(stringNrOfWeek);
                if (year == todayY && month == todayM - 1 && i > 0 && Integer.parseInt(this.labels[week][i].getText()) == todayD) {
                    this.labels[week][i].setBackground(todayColor);
                }
                calendarDay.add(5, 1);
                ++i;
            }
            if (endMonth == calendarDay.get(2)) break;
            ++week;
        }
        i = 0;
        while (i < 8) {
            this.labels[6][i].setVisible(5 < week);
            ++i;
        }
    }

    private void selectDate(Calendar calendar) {
        this.calendarChange(calendar.get(1), calendar.get(2));
        this.selection.setText(String.valueOf(calendar.get(5)));
        this.autoChangeSelection();
        this.selectMonth(calendar.get(2));
        this.selectYear(calendar.get(1));
    }

    private boolean equals(Color a, Color b) {
        if (a.getBlue() != b.getBlue()) {
            return false;
        }
        if (a.getRed() != b.getRed()) {
            return false;
        }
        return a.getGreen() == b.getGreen();
    }

    private void calendarChange(int year, int month) {
        this.calendar.set(2, month);
        this.calendar.set(1, year);
        this.updateDates();
        this.autoChangeSelection();
    }

    private void autoChangeSelection() {
        String stringDay = this.selection.getText();
        int i = 0;
        while (i < this.labels.length) {
            int j = 1;
            while (j < this.labels[0].length) {
                if (this.labels[i][j].getText().toString().equals(stringDay) && this.equals(this.labels[i][j].getForeground(), black)) {
                    this.setSelection(this.labels[i][j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void goMonth(int delta) {
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int monthDelta = month + delta;
        int sign = 1;
        if (delta < 0) {
            sign = -1;
        }
        if (monthDelta < 0) {
            monthDelta += 13;
        }
        year += sign * (Math.abs(monthDelta) / 12);
        if (monthDelta >= 12 && sign < 0) {
            --monthDelta;
        }
        month = monthDelta % 12;
        this.calendar.set(2, month);
        while (this.calendar.get(2) != month) {
            this.calendar.add(5, -1);
        }
        this.calendar.set(1, year);
        while (this.calendar.get(2) != month) {
            this.calendar.add(5, -1);
        }
        this.selectMonth(this.calendar.get(2));
        this.selectYear(this.calendar.get(1));
        this.updateDates();
        this.autoChangeSelection();
    }

    private boolean selectDisabledDates(Label toSelect) {
        String stringSelect = toSelect.getText();
        if (this.equals(toSelect.getForeground(), gray)) {
            String stringDate = toSelect.getText();
            int intDate = Integer.parseInt(stringDate);
            this.selection.setText(stringDate);
            this.selection.setData(toSelect.getData());
            this.currentBackground = compositeBackgroundColor;
            this.currentForeground = black;
            if (intDate < 15) {
                this.goMonth(1);
            } else {
                this.goMonth(-1);
            }
            int i = 0;
            while (i < this.labels.length) {
                int j = 1;
                while (j < this.labels[0].length) {
                    if (this.labels[i][j].getText().equals(stringSelect) && this.equals(this.labels[i][j].getForeground(), black)) {
                        this.setSelection(this.labels[i][j]);
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isToday(Label selection) {
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = Integer.parseInt(selection.getText());
        if (this.equals(selection.getForeground(), gray)) {
            return false;
        }
        GregorianCalendar today = new GregorianCalendar();
        int yearT = today.get(1);
        int monthT = today.get(2);
        int dayT = today.get(5);
        if (year != yearT) {
            return false;
        }
        if (month != monthT) {
            return false;
        }
        return day == dayT;
    }

    private void setSelection(Label selection) {
        if (this.currentBackground != null) {
            this.selection.setBackground(this.currentBackground);
        } else if (this.isToday(this.selection)) {
            this.selection.setBackground(todayColor);
        } else {
            this.selection.setBackground(compositeBackgroundColor);
        }
        if (this.currentForeground != null) {
            this.selection.setForeground(this.currentForeground);
        } else {
            this.selection.setForeground(black);
        }
        if (this.isToday(this.selection)) {
            this.selection.setBackground(todayColor);
        }
        this.selection = selection;
        this.currentForeground = selection.getForeground();
        selection.setBackground(blue);
        selection.setForeground(white);
        this.calendar.set(5, Integer.parseInt(selection.getText()));
        if (this.listener != null) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "calendar", null, this.calendar);
            this.listener.propertyChange(event);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, hHint, changed);
    }

    public void setListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public Date getDate() {
        String s = this.textField.getText();
        if (s == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        Date d = null;
        SimpleDateFormat formatter = new SimpleDateFormat(this.DATE_FORMAT, Locale.getDefault());
        try {
            d = formatter.parse(s);
        }
        catch (ParseException parseException) {
            return null;
        }
        calendar.setTime(d);
        calendar.clear(11);
        calendar.clear(10);
        calendar.clear(12);
        calendar.clear(13);
        return calendar.getTime();
    }

    private GregorianCalendar getDateCalendar() {
        String s = this.textField.getText();
        if (s == null) {
            return new GregorianCalendar();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(this.DATE_FORMAT, Locale.getDefault());
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTime(formatter.parse(s));
        }
        catch (ParseException parseException) {
            return new GregorianCalendar();
        }
        return new GregorianCalendar(c.get(1), c.get(2), c.get(5));
    }

    private void textFieldAction() {
        this.textField.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.textField.addListener(25, new Listener(){
            boolean ignore;

            public void handleEvent(Event e) {
                if (this.ignore) {
                    return;
                }
                e.doit = false;
                StringBuffer buffer = new StringBuffer(e.text);
                DatePicker.this.textField.setSelection(e.start, e.end);
                this.ignore = true;
                DatePicker.this.textField.insert(buffer.toString());
                this.ignore = false;
                DatePicker.this.textField.setSelection(e.start, e.start);
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.textField.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.textField.removeModifyListener(listener);
    }

    public void setDate(Calendar c) {
        this.textField.setText(this.dateToString(c));
    }
}

