/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui.guielements;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class CompositeList
extends ScrolledComposite {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private int selectionBorderWidth = 1;
    private final Color defaultSelectionBorderColor;
    private Color selectionBorderColor = this.defaultSelectionBorderColor = new Color((Device)this.getDisplay(), 10, 255, 255);
    private int selectedItem = -1;
    private KeyNavigator keyNavigator = new KeyNavigator();
    private MouseNavigator mouseNavigator = new MouseNavigator();
    private Composite body;
    private ListenerList selectionListeners = new ListenerList();

    public MouseListener getMouseListener() {
        return this.mouseNavigator;
    }

    public int getSelectionBorderWidth() {
        return this.selectionBorderWidth;
    }

    public void setSelectionBorderWidth(int selectionBorderWidth) {
        this.selectionBorderWidth = selectionBorderWidth;
    }

    public Color getSelectionBorderColor() {
        return this.selectionBorderColor;
    }

    public void setSelectionBorderColor(Color selectionBorderColor) {
        if (selectionBorderColor != null) {
            this.selectionBorderColor = selectionBorderColor;
        }
    }

    public final Composite getBody() {
        return this.body;
    }

    public CompositeList(Composite parent, int style) {
        super(parent, style);
        this.body = new Composite((Composite)this, 0);
        GridLayout gl = new GridLayout();
        this.body.setLayout((Layout)gl);
        this.selectionBorderColor = new Color((Device)this.getDisplay(), 0, 0, 255);
        this.body.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control[] children = CompositeList.this.getBody().getChildren();
                if (CompositeList.this.selectedItem != -1 && children.length > CompositeList.this.selectedItem) {
                    GC gc = e.gc;
                    Control c = children[CompositeList.this.selectedItem];
                    Rectangle bounds = c.getBounds();
                    bounds.x -= CompositeList.this.selectionBorderWidth;
                    bounds.y -= CompositeList.this.selectionBorderWidth;
                    bounds.width += CompositeList.this.selectionBorderWidth;
                    bounds.height += CompositeList.this.selectionBorderWidth;
                    gc.setForeground(CompositeList.this.selectionBorderColor);
                    gc.drawRectangle(bounds);
                }
            }
        });
        this.body.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompositeList.this.defaultSelectionBorderColor.dispose();
            }
        });
        this.setContent((Control)this.body);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
    }

    public void addChild(Control c) {
        if (c.getParent() != this.body) {
            throw new RuntimeException("children must have the getBody() of this CompositeList as parent.");
        }
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)gd);
        c.addMouseListener((MouseListener)this.mouseNavigator);
        c.addKeyListener((KeyListener)this.keyNavigator);
        this.setMinSize(this.body.computeSize(-1, -1));
    }

    Control getBodyControlFor(Control control) {
        if (control == null || control.isDisposed()) {
            return null;
        }
        Control c = control;
        Composite parent = control.getParent();
        while (parent != null && !(parent instanceof Shell)) {
            if (this.body == parent) {
                return c;
            }
            c = parent;
            parent = parent.getParent();
        }
        return null;
    }

    public void setSelection(int i) {
        if (i < this.body.getChildren().length) {
            this.selectedItem = i;
        }
        if (this.selectedItem < 0) {
            this.selectedItem = -1;
        }
        this.body.redraw();
        if (this.selectedItem >= 0) {
            Object[] listeners = this.selectionListeners.getListeners();
            Event e = new Event();
            e.index = i;
            Control[] children = this.body.getChildren();
            e.widget = children[this.selectedItem];
            SelectionEvent se = new SelectionEvent(e);
            se.item = children[this.selectedItem];
            children[this.selectedItem].setFocus();
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                ((SelectionListener)((TypedListener)l).getEventListener()).widgetSelected(se);
                ++n2;
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.body.addListener(13, (Listener)typedListener);
        this.selectionListeners.add((Object)typedListener);
    }

    public void removeSelectionListener(TypedListener typedListener) {
        this.selectionListeners.remove((Object)typedListener);
    }

    private class KeyNavigator
    extends KeyAdapter {
        private KeyNavigator() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000002) {
                CompositeList.this.setSelection(CompositeList.this.selectedItem + 1 >= CompositeList.this.body.getChildren().length ? 0 : CompositeList.this.selectedItem + 1);
            }
            if (e.keyCode == 0x1000001) {
                int n = CompositeList.this.selectedItem - 1 >= 0 ? CompositeList.this.selectedItem - 1 : CompositeList.this.body.getChildren().length - 1;
                CompositeList.this.selectedItem = n;
                CompositeList.this.setSelection(n);
            }
        }
    }

    private class MouseNavigator
    extends MouseAdapter {
        private MouseNavigator() {
        }

        public void mouseDown(MouseEvent e) {
            Control target;
            int i = -1;
            if (e.widget instanceof Control && (target = CompositeList.this.getBodyControlFor((Control)e.widget)) != null) {
                Control[] controlArray = CompositeList.this.body.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    ++i;
                    if (target == c) break;
                    ++n2;
                }
                CompositeList.this.setSelection(i);
            }
            super.mouseDown(e);
        }
    }
}

