/*
 * Decompiled with CFR 0.152.
 */
package com.ez.common.ui;

import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;

public class EzDirectoryFieldEditor
extends DirectoryFieldEditor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private boolean customState = false;
    private boolean considerCustomCheck = false;
    private String adjacentErrorMessage;

    public EzDirectoryFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.setValidateStrategy(0);
        this.createControl(parent);
    }

    public EzDirectoryFieldEditor(String name, String labelText, Composite parent, boolean customCheck) {
        this(name, labelText, parent);
        this.considerCustomCheck = customCheck;
    }

    public void setCustomState(boolean state) {
        this.customState = state;
    }

    public void setAdjacentErrorMessage(String adjacentErrorMessage) {
        this.adjacentErrorMessage = adjacentErrorMessage;
    }

    protected boolean doCheckState() {
        boolean state = super.doCheckState();
        if (this.considerCustomCheck) {
            boolean myState;
            boolean bl = myState = this.customState && state;
            if (!myState && this.adjacentErrorMessage != null) {
                this.setErrorMessage(this.adjacentErrorMessage);
            }
            return myState;
        }
        return state;
    }
}

