/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection;

import java.util.Map;
import java.util.TreeMap;

public enum ServerType {
    Access(1, "ACCESS"),
    SqlServer(2, "sqlserver"),
    Db2(3, "db2"),
    Db2Z(4, "db2z");

    String name;
    int value;

    private ServerType(int value, String name) {
        this.name = name;
        this.value = value;
        GLOBAL.all.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static ServerType findByValue(int value) {
        ServerType t = null;
        for (ServerType st : GLOBAL.all.values()) {
            if (st.getValue() != value) continue;
            t = st;
            break;
        }
        if (t == null) {
            throw new IllegalArgumentException("No ServerType with this value: " + value);
        }
        return t;
    }

    public static ServerType findByName(String name) {
        ServerType t = GLOBAL.all.get(name);
        if (t == null) {
            throw new IllegalArgumentException("No ServerType with this name: " + name);
        }
        return t;
    }

    private static class GLOBAL {
        static Map<String, ServerType> all = new TreeMap<String, ServerType>();

        private GLOBAL() {
        }
    }
}

