/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection;

import com.ez.ezdao.api.DatabaseException;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezsource.connection.ProjectInfo;
import com.ez.ezsource.connection.ServerType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInfoFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger logger = LoggerFactory.getLogger(ProjectInfoFactory.class);
    public static final int FLAG_FUJITSU = (int)Math.pow(2.0, 0.0);
    public static final int FLAG_MVS = (int)Math.pow(2.0, 1.0);
    public static final int FLAG_PL1 = (int)Math.pow(2.0, 2.0);
    public static final int FLAG_NATURAL = (int)Math.pow(2.0, 3.0);
    public static final int FLAG_VSE = (int)Math.pow(2.0, 4.0);
    public static final int FLAG_PT_AS400_COBOL = (int)Math.pow(2.0, 5.0);
    public static final int FLAG_PT_AS400_CL = (int)Math.pow(2.0, 6.0);
    public static final int FLAG_PT_ASSEMBLER = (int)Math.pow(2.0, 7.0);
    public static final int FLAG_PT_REXX = (int)Math.pow(2.0, 8.0);
    public static final int FLAG_PT_ADS = (int)Math.pow(2.0, 9.0);
    public static final int FLAG_PT_VME_COBOL = (int)Math.pow(2.0, 10.0);
    public static final int FLAG_PT_VME_AM = (int)Math.pow(2.0, 11.0);
    public static final int FLAG_JAVA = (int)Math.pow(2.0, 14.0);
    public static final int FLAG_DB_AIM = (int)Math.pow(2.0, 16.0);
    public static final int FLAG_DB_ADABAS = (int)Math.pow(2.0, 17.0);
    public static final int FLAG_DB_RELATIONAL = (int)Math.pow(2.0, 18.0);
    public static final int FLAG_DB_IDMS = (int)Math.pow(2.0, 19.0);
    public static final int FLAG_DB_IMS = (int)Math.pow(2.0, 20.0);
    public static final int FLAG_DBT_DB400 = (int)Math.pow(2.0, 21.0);
    public static final int FLAG_DB_IDMSX = (int)Math.pow(2.0, 22.0);
    public static final int FLAG_DB_DATACOM = (int)Math.pow(2.0, 23.0);
    public static final int FLAG_MPT_BMS = (int)Math.pow(2.0, 24.0);
    public static final int FLAG_MPT_MFS = (int)Math.pow(2.0, 25.0);
    public static final int FLAG_MPT_LNM = (int)Math.pow(2.0, 26.0);
    public static final int FLAG_MPT_DDS = (int)Math.pow(2.0, 27.0);
    public static final int FLAG_MPT_ADS = (int)Math.pow(2.0, 27.0);
    public static final int FLAG_MPT_TPMSX = (int)Math.pow(2.0, 29.0);
    public static final int FLAG_MPT_AM_Screens = (int)Math.pow(2.0, 30.0);
    ProjectInfo pi;

    @Deprecated
    public ProjectInfoFactory(String projectName, Long projectType, String path, DatabaseInfo dbi, boolean useBRD, boolean useCross, UUID projectUUID) {
        this(true, projectName, projectType, path, dbi, useBRD, useCross, projectUUID);
    }

    public ProjectInfoFactory(String projectName) {
        this.pi = new ProjectInfo(projectName);
    }

    public ProjectInfoFactory(ProjectInfo pi) {
        this.pi = pi;
    }

    public ProjectInfoFactory(boolean fillProjInfo, String projectName, Long projectType, String path, DatabaseInfo dbi, boolean useBRD, boolean useCross, UUID projectUUID) {
        this.pi = new ProjectInfo(projectName);
        this.initialize(fillProjInfo, projectType, path, dbi, useBRD, useCross, projectUUID);
    }

    public ProjectInfo build() {
        try {
            ProjectInfo projectInfo = this.pi;
            return projectInfo;
        }
        finally {
            this.pi = null;
        }
    }

    public void setDatabaseInfo(DatabaseInfo databaseInfo) {
        this.pi.databaseInfo = databaseInfo;
    }

    public void setLanguages(List languages) {
        this.pi.languages = languages;
    }

    public void setDbTypes(List dbTypes) {
        this.pi.dbTypes = Collections.unmodifiableList(dbTypes);
    }

    public void setMapTypes(List mapTypes) {
        this.pi.mapTypes = Collections.unmodifiableList(mapTypes);
    }

    public void setDrive(String drive) {
        this.pi.drive = drive;
    }

    public void setUMCDB(boolean isUMCDB) {
        this.pi.isUMCDB = isUMCDB;
    }

    public void setDbEngine(ServerType dbEngine) {
        this.pi.dbEngine = dbEngine;
    }

    public void setOnMainframe(boolean onMainframe) {
        this.pi.onMainframe = onMainframe;
    }

    public void setEnvironment(String environment) {
        this.pi.environment = environment;
    }

    public void setProjectLocation(String projectLocation) {
        this.pi.projectLocation = projectLocation;
        this.pi.drive = this.getDrive(this.pi.projectLocation);
    }

    public void setUseCross(boolean isCross) {
        this.pi.useCross = isCross;
    }

    public void setUSeBRD(boolean useBRD) {
        this.pi.useBRD = useBRD;
    }

    public void setLastBuild(String lastBuild) {
        this.pi.lastBuild = lastBuild;
    }

    public void setMetadataJson(JsonObject metadataJson) {
        this.pi.metadataJson = metadataJson;
    }

    private void initialize(boolean fillProjInfo, Long projectType, String path, DatabaseInfo dbi, boolean useBRD, boolean useCross, UUID projectUUID) {
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        if (projectType == null) {
            if (fillProjInfo) {
                throw new IllegalArgumentException("projectType");
            }
            logger.debug("projectType is null for fillProjectType false");
        }
        if (projectUUID == null) {
            throw new IllegalArgumentException("missing UUID");
        }
        if (projectType == null || projectType != null && !projectType.equals(Long.valueOf("16384"))) {
            if (dbi == null) {
                throw new IllegalArgumentException("dbi");
            }
            String serverType = dbi.getServerType();
            if (serverType.equalsIgnoreCase("db2")) {
                this.pi.dbEngine = ServerType.Db2;
            } else if (serverType.equalsIgnoreCase("db2z")) {
                this.pi.dbEngine = ServerType.Db2Z;
            } else if (serverType.equalsIgnoreCase("sqlserver")) {
                this.pi.dbEngine = ServerType.SqlServer;
            } else {
                throw new DatabaseException("Unknown server type: " + serverType);
            }
        }
        this.setProjectLocation(path);
        this.pi.databaseInfo = dbi;
        if (fillProjInfo) {
            this.fillProjectInfo(this.pi, projectType);
        }
        this.pi.useBRD = useBRD;
        this.pi.projectUUID = projectUUID;
        this.pi.useCross = useCross;
    }

    private String getDrive(String projectPath) {
        int i = projectPath.indexOf(":");
        String drive = null;
        if (i > 0) {
            drive = projectPath.substring(0, i + 1);
        }
        return drive;
    }

    private void fillProjectInfo(ProjectInfo projectInfo, Long projectType) {
        if (projectType != null) {
            if ((projectType & (long)FLAG_VSE) == (long)FLAG_VSE) {
                logger.trace("prj environment = VSE");
                projectInfo.environment = "VSE";
            } else if ((projectType & (long)FLAG_PT_AS400_COBOL) == (long)FLAG_PT_AS400_COBOL || (projectType & (long)FLAG_PT_AS400_CL) == (long)FLAG_PT_AS400_CL) {
                logger.trace("prj environment = SMART");
                projectInfo.environment = "SMART AS/400";
            } else if ((projectType & (long)FLAG_FUJITSU) == (long)FLAG_FUJITSU) {
                logger.trace("prj environment = FUJITSU");
                projectInfo.environment = "FUJITSU";
            } else if ((projectType & (long)FLAG_PT_VME_AM) == (long)FLAG_PT_VME_AM || (projectType & (long)FLAG_PT_VME_COBOL) == (long)FLAG_PT_VME_COBOL) {
                logger.trace("prj environment = VME");
                projectInfo.environment = "VME";
            } else if ((projectType & (long)FLAG_JAVA) == (long)FLAG_JAVA) {
                logger.trace("prj environment = JVM");
                projectInfo.environment = "JVM";
            } else {
                logger.trace("prj environment = MVS");
                projectInfo.environment = "MVS";
            }
            ArrayList<String> values = new ArrayList<String>();
            if ((projectType & (long)FLAG_FUJITSU) == (long)FLAG_FUJITSU) {
                logger.trace("fujitsu_cobol language found");
                values.add("COBOL");
            }
            if ((projectType & (long)FLAG_MVS) == (long)FLAG_MVS && !projectInfo.getEnvironment().equals("VME")) {
                logger.trace("mvs_cobol language found");
                values.add("COBOL");
            }
            if ((projectType & (long)FLAG_PL1) == (long)FLAG_PL1) {
                logger.trace("PL1 language found");
                values.add("PL1");
            }
            if ((projectType & (long)FLAG_NATURAL) == (long)FLAG_NATURAL) {
                logger.trace("NATURAL language found");
                values.add("NATURAL");
            }
            if ((projectType & (long)FLAG_PT_AS400_CL) == (long)FLAG_PT_AS400_CL) {
                logger.trace("AS400_CL language found");
                values.add("CL");
            }
            if ((projectType & (long)FLAG_PT_ASSEMBLER) == (long)FLAG_PT_ASSEMBLER) {
                logger.trace("ASSEMBLER language found");
                values.add("ASSEMBLER");
            }
            if ((projectType & (long)FLAG_PT_REXX) == (long)FLAG_PT_REXX) {
                logger.trace("REXX language found");
                values.add("REXX");
            }
            if ((projectType & (long)FLAG_PT_ADS) == (long)FLAG_PT_ADS) {
                logger.trace("ADS language found");
                values.add("ADS");
            }
            if ((projectType & (long)FLAG_PT_VME_AM) == (long)FLAG_PT_VME_AM) {
                logger.trace("VME_AM language found");
                values.add("VME AM");
            }
            if ((projectType & (long)FLAG_PT_VME_COBOL) == (long)FLAG_PT_VME_COBOL) {
                logger.trace("VME COBOL language found");
                values.add("VME COBOL");
            }
            if ((projectType & (long)FLAG_JAVA) == (long)FLAG_JAVA) {
                logger.trace("JAVA language found");
                values.add("JAVA");
            }
            if (!values.isEmpty()) {
                projectInfo.languages = new ArrayList(values);
                values.clear();
            }
            if ((projectType & (long)FLAG_DB_AIM) == (long)FLAG_DB_AIM) {
                logger.trace("AIM database found");
                values.add("AIM/DB");
            }
            if ((projectType & (long)FLAG_DB_ADABAS) == (long)FLAG_DB_ADABAS) {
                logger.trace("ADABAS database found");
                values.add("ADABAS");
            }
            if ((projectType & (long)FLAG_DB_RELATIONAL) == (long)FLAG_DB_RELATIONAL) {
                logger.trace("Relational database found");
                values.add("RELATIONAL");
            }
            if ((projectType & (long)FLAG_DB_IDMS) == (long)FLAG_DB_IDMS) {
                logger.trace("IDMS database found");
                values.add("IDMS");
            }
            if ((projectType & (long)FLAG_DB_IMS) == (long)FLAG_DB_IMS) {
                logger.trace("IMS database found");
                values.add("IMS/DB");
            }
            if ((projectType & (long)FLAG_DBT_DB400) == (long)FLAG_DBT_DB400) {
                logger.trace("DB400 database found");
                values.add("DB400");
            }
            if ((projectType & (long)FLAG_DB_IDMSX) == (long)FLAG_DB_IDMSX) {
                logger.trace("IDMSX database found");
                values.add("IDMSX");
            }
            if ((projectType & (long)FLAG_DB_DATACOM) == (long)FLAG_DB_DATACOM) {
                logger.trace("DATACOM database found");
                values.add("DATACOM");
            }
            if (!values.isEmpty()) {
                projectInfo.dbTypes = new ArrayList(values);
                values.clear();
            }
            if ((projectType & (long)FLAG_MPT_BMS) == (long)FLAG_MPT_BMS) {
                logger.trace("BMS map (CICS) found");
                values.add("CICS");
            }
            if ((projectType & (long)FLAG_MPT_MFS) == (long)FLAG_MPT_MFS) {
                logger.trace("MFS map (IMS/DC) found");
                values.add("IMS/DC");
            }
            if ((projectType & (long)FLAG_MPT_LNM) == (long)FLAG_MPT_LNM) {
                logger.trace("LNM map (Natural) found");
                values.add("NATURAL(LNM)");
            }
            if ((projectType & (long)FLAG_MPT_DDS) == (long)FLAG_MPT_DDS) {
                logger.trace("DDS map (screens) found");
                values.add("DD SCREENS");
            }
            if ((projectType & (long)FLAG_MPT_ADS) == (long)FLAG_MPT_ADS) {
                logger.trace("ADS map found");
                values.add("ADS Maps");
            }
            if ((projectType & (long)FLAG_MPT_TPMSX) == (long)FLAG_MPT_TPMSX) {
                logger.trace("TPMSX maps found");
                values.add("TPMSX Maps");
            }
            if ((projectType & (long)FLAG_MPT_AM_Screens) == (long)FLAG_MPT_AM_Screens) {
                logger.trace("Application Master screens (maps) found");
                values.add("AM SCREENS");
            }
            if (!values.isEmpty()) {
                projectInfo.mapTypes = new ArrayList(values);
            }
        }
    }
}

