/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezsource.connection.ServerType;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.json.JsonObject;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ProjectInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    String drive;
    String projectName;
    String projectLocation;
    UUID projectUUID;
    String environment;
    List languages = new LinkedList();
    List dbTypes = new LinkedList();
    List mapTypes = new LinkedList();
    String sqlHost;
    Integer sqlPort;
    boolean isUMCDB = false;
    boolean onMainframe = false;
    ServerType dbEngine;
    DatabaseInfo databaseInfo;
    boolean useBRD = false;
    boolean useCross = false;
    String lastBuild;
    JsonObject metadataJson = null;
    public static final String FUJITSU_ENVIRONMENT = "FUJITSU";
    public static final String MVS_ENVIRONMENT = "MVS";
    public static final String VSE_ENVIRONMENT = "VSE";
    public static final String SMART_AS400_ENVIRONMENT = "SMART AS/400";
    public static final String VME_ENVIRONMENT = "VME";
    public static final String JVM_ENVIRONMENT = "JVM";
    public static final String COBOL_LANGUAGE = "COBOL";
    public static final String PL1_LANGUAGE = "PL1";
    public static final String NATURAL_LANGUAGE = "NATURAL";
    public static final String CL_LANGUAGE = "CL";
    public static final String ASSEMBLER_LANGUAGE = "ASSEMBLER";
    public static final String ADS_LANGUAGE = "ADS";
    public static final String REXX_LANGUAGE = "REXX";
    public static final String JAVA_LANGUAGE = "JAVA";
    public static final String VME_AM_LANGUAGE = "VME AM";
    public static final String VME_COBOL_LANGUAGE = "VME COBOL";
    public static final String AIM_DBTYPE = "AIM/DB";
    public static final String ADABAS_DBTYPE = "ADABAS";
    public static final String IDMS_DBTYPE = "IDMS";
    public static final String RELATIONAL_DBTYPE = "RELATIONAL";
    public static final String IMS_DBTYPE = "IMS/DB";
    public static final String DB400_DBTYPE = "DB400";
    public static final String IDMSX_DBTYPE = "IDMSX";
    public static final String DATACOM_DBTYPE = "DATACOM";
    public static final String CICS_MAPTYPE = "CICS";
    public static final String IMS_MAPTYPE = "IMS/DC";
    public static final String NATURAL_MAPTYPE = "NATURAL(LNM)";
    public static final String DDSCREENS_MAPTYPE = "DD SCREENS";
    public static final String ADS_MAPTYPE = "ADS Maps";
    public static final String TPMSX_MAPTYPE = "TPMSX Maps";
    public static final String AMSCREENS_MAPTYPE = "AM SCREENS";
    public static final int DBENGINE_ACCESS = 1;
    public static final int DBENGINE_SQLSEVER = 2;

    ProjectInfo(String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException("'projectName' is null.");
        }
        this.projectName = projectName;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public boolean isOnMainframe() {
        return this.onMainframe;
    }

    public boolean isUMCDB() {
        return this.isUMCDB;
    }

    public String getDrive() {
        return this.drive;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public List getLanguages() {
        return this.languages;
    }

    public List getDbTypes() {
        return this.dbTypes;
    }

    public List getMapTypes() {
        return this.mapTypes;
    }

    public String getProjectLocation() {
        return this.projectLocation;
    }

    public ServerType getDbEngine() {
        return this.dbEngine;
    }

    public boolean useBRD() {
        return this.useBRD;
    }

    public boolean useCross() {
        return this.useCross;
    }

    public UUID getProjectUUID() {
        return this.projectUUID;
    }

    public String getLastBuild() {
        return this.lastBuild;
    }

    public JsonObject getMetadataJson() {
        return this.metadataJson;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }
}

