/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection;

import com.ez.ezsource.connection.ConnectionConfiguration;
import com.ez.ezsource.connection.DatabaseAccessType;
import com.ez.ezsource.connection.ProjectMode;
import org.apache.commons.lang.Validate;

public class ConnectionConfigurationBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    ConnectionConfiguration conf;

    ConnectionConfigurationBuilder(ConnectionConfiguration conf) {
        this.conf = conf;
    }

    public ConnectionConfigurationBuilder setProjectName(String projectName) {
        this.conf.projectName = projectName;
        return this;
    }

    public ConnectionConfigurationBuilder setDbAccessType(DatabaseAccessType dbAccessType) {
        this.conf.dbAccessType = dbAccessType;
        return this;
    }

    public ConnectionConfiguration build() {
        ConnectionConfiguration r = this.conf;
        if (r == null) {
            throw new IllegalStateException("Already built.");
        }
        if (this.conf.projectMode.equals((Object)ProjectMode.Environmental)) {
            Validate.notNull((Object)this.conf.projectName, (String)("Project name mandatory for mode " + (Object)((Object)this.conf.projectMode)));
        }
        this.conf = null;
        return r;
    }
}

