/*
 * Decompiled with CFR 0.152.
 */
package com.ez.log4j.util;

import com.ez.eclient.logging.preferences.PreferenceConstants;
import com.ez.log4j.util.DummyAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public class LoggerUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String EASY_LOG4J_CF = "LogConfigurator.properties";
    public static final String LOG4J_CF = "log4j2.xml";
    public static final String LOG_FILE_NAME = "ez.log";
    private static final String LOG_ROLLINGAPPENDER = "RollingFile";
    public static final String LOG_LOGGER_COM_EZ = "com.ez";
    private static final Logger L = LogManager.getLogger(LoggerUtil.class);

    public static void standardReconfigureLog(String log4jConfigFilePath, String logDir) {
        System.out.println("StandardReconfigureLog log");
        String noLog = System.getProperty("noEZLog");
        if (noLog == null) {
            try {
                File logConfigPathFile = new File(log4jConfigFilePath);
                boolean wasConfingurationFileSet = false;
                if (!logConfigPathFile.exists() || !logConfigPathFile.isFile()) {
                    System.out.println("File is not a regular file or the file was not found: " + log4jConfigFilePath + " using defaults from conf/development.xml.");
                    File logDirectoryFile = new File(logDir);
                    if (logDirectoryFile.exists() && !logDirectoryFile.isFile()) {
                        System.err.println("File is not a regular file: " + logDirectoryFile);
                    } else {
                        URL res = LoggerUtil.class.getResource("conf/development.xml");
                        if (res != null) {
                            System.setProperty("log4j.location", logDirectoryFile.toString());
                            if (System.getProperty("log4j.level") == null) {
                                System.setProperty("log4j.level", "WARN");
                            }
                            System.setProperty("log4j.configurationFile", res.toString());
                            wasConfingurationFileSet = true;
                        } else {
                            System.out.println("File conf/development.xml doesn't exist or is not a regular file: ");
                        }
                    }
                } else {
                    System.setProperty("log4j.configurationFile", log4jConfigFilePath);
                    wasConfingurationFileSet = true;
                }
                if (wasConfingurationFileSet) {
                    LoggerContextFactory factory = LogManager.getFactory();
                    ContextSelector selector = ((Log4jContextFactory)factory).getSelector();
                    List contexts = selector.getLoggerContexts();
                    for (LoggerContext context : contexts) {
                        String contextName = context.getName();
                        File file = new File(System.getProperty("log4j.configurationFile"));
                        context.setConfigLocation(file.toURI());
                        context.reconfigure();
                        Logger log = LogManager.getLogger((String)contextName);
                        log.warn("Logger reconfigured with: " + System.getProperty("log4j.configurationFile"));
                    }
                }
            }
            catch (Exception ex) {
                L.error("Logger could not be initialised", (Throwable)ex);
            }
        }
    }

    public static void easyReconfigureLog(String configPath, String logPath) {
        block10: {
            String noLog = System.getProperty("noEZLog");
            if (noLog == null) {
                System.out.println("Easy reconfigure log");
                try {
                    URL res = LoggerUtil.class.getResource("conf/development.xml");
                    File configPathFile = new File(configPath);
                    if (res != null) {
                        boolean hasConfigChanged;
                        boolean isPathChanged;
                        String suffix = File.separator.concat(LOG_FILE_NAME);
                        if (logPath.endsWith(suffix)) {
                            logPath = logPath.replace(suffix, "").trim();
                        }
                        boolean bl = isPathChanged = !logPath.equals(PreferenceConstants.OLD_LOGGING_PATH);
                        if (isPathChanged) {
                            LoggerUtil.updatePath(logPath);
                            LoggerUtil.updateAppenders(logPath);
                        }
                        boolean bl2 = hasConfigChanged = configPathFile.exists() && configPathFile.isFile();
                        if (hasConfigChanged) {
                            LoggerUtil.reloadEasyLogConfiguration(configPath);
                        }
                        break block10;
                    }
                    System.out.println("Not found development.xml config file");
                }
                catch (FactoryConfigurationError e) {
                    L.error("Error:", (Throwable)e);
                }
                catch (Exception fe) {
                    if (fe instanceof FileNotFoundException) {
                        System.out.println("Not found development.xml config file");
                        break block10;
                    }
                    L.error("Error:", (Throwable)fe);
                }
            } else {
                System.out.println("ezlog was disabled; remove <noEZLog> argument");
            }
        }
    }

    private static void updatePath(String logPath) {
        File logPathFile = new File(logPath);
        System.setProperty("log4j.location", logPathFile.getAbsolutePath());
        System.setProperty("log4j.dir", logPathFile.getAbsolutePath());
        PreferenceConstants.OLD_LOGGING_PATH = logPath;
        URL log4j2Resource = LoggerUtil.class.getResource("conf/log4j2.xml");
        if (log4j2Resource != null) {
            System.setProperty("log4j.configurationFile", log4j2Resource.toString());
        }
    }

    private static void updateAppenders(String newLogPath) {
        LoggerContextFactory factory = LogManager.getFactory();
        ContextSelector selector = ((Log4jContextFactory)factory).getSelector();
        List contexts = selector.getLoggerContexts();
        for (LoggerContext context : contexts) {
            Map appenders = context.getConfiguration().getAppenders();
            for (String key : appenders.keySet()) {
                if (!LOG_ROLLINGAPPENDER.equals(key)) continue;
                RollingFileAppender rollingFileAppender = (RollingFileAppender)appenders.get(key);
                DummyAppender dummyAppender = DummyAppender.createAppender(rollingFileAppender, newLogPath);
                appenders.put(key, dummyAppender);
            }
            context.reconfigure();
            context.updateLoggers();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void reloadEasyLogConfiguration(String configPath) {
        block19: {
            block18: {
                block20: {
                    if (configPath == null) {
                        return;
                    }
                    prop = null;
                    try {
                        try {
                            inputStream = new FileInputStream(configPath);
                            prop = new Properties();
                            prop.load(inputStream);
                            inputStream.close();
                            break block18;
                        }
                        catch (IOException v0) {
                            System.out.println("Error: The file: " + configPath + " does not exist");
                            if (prop == null || prop.isEmpty()) break block19;
                            factory = LogManager.getFactory();
                            selector = ((Log4jContextFactory)factory).getSelector();
                            contexts = selector.getLoggerContexts();
                            ** for (context : contexts)
                        }
                    }
                    catch (Throwable var3_36) {
                        if (prop == null || prop.isEmpty()) break block20;
                        factory = LogManager.getFactory();
                        selector = ((Log4jContextFactory)factory).getSelector();
                        contexts = selector.getLoggerContexts();
                        ** for (context : contexts)
                    }
lbl-1000:
                    // 1 sources

                    {
                        config = context.getConfiguration();
                        for (String key : prop.keySet()) {
                            value = prop.getProperty(key);
                            level = LoggerUtil.getLvl(value = value.toUpperCase());
                            if (level == null) {
                                System.out.println(String.valueOf(value) + " will be ignored for package " + key);
                                continue;
                            }
                            loggerConfigPackage = config.getLoggerConfig(key);
                            if (!loggerConfigPackage.getName().equals(key)) {
                                loggerConfigPackage = new LoggerConfig(key, level, true);
                                loggerConfigPackage.setParent(config.getLoggerConfig(""));
                                config.addLogger(key, loggerConfigPackage);
                                continue;
                            }
                            loggerConfigPackage.setLevel(level);
                        }
                        context.updateLoggers();
                        continue;
lbl35:
                        // 1 sources

                        break block19;
                    }
lbl-1000:
                    // 1 sources

                    {
                        config = context.getConfiguration();
                        for (String key : prop.keySet()) {
                            value = prop.getProperty(key);
                            level = LoggerUtil.getLvl(value = value.toUpperCase());
                            if (level == null) {
                                System.out.println(String.valueOf(value) + " will be ignored for package " + key);
                                continue;
                            }
                            loggerConfigPackage = config.getLoggerConfig(key);
                            if (!loggerConfigPackage.getName().equals(key)) {
                                loggerConfigPackage = new LoggerConfig(key, level, true);
                                loggerConfigPackage.setParent(config.getLoggerConfig(""));
                                config.addLogger(key, loggerConfigPackage);
                                continue;
                            }
                            loggerConfigPackage.setLevel(level);
                        }
                        context.updateLoggers();
                        continue;
                    }
                }
                throw var3_36;
            }
            if (prop != null && !prop.isEmpty()) {
                factory = LogManager.getFactory();
                selector = ((Log4jContextFactory)factory).getSelector();
                contexts = selector.getLoggerContexts();
                for (LoggerContext context : contexts) {
                    config = context.getConfiguration();
                    for (String key : prop.keySet()) {
                        value = prop.getProperty(key);
                        level = LoggerUtil.getLvl(value = value.toUpperCase());
                        if (level == null) {
                            System.out.println(String.valueOf(value) + " will be ignored for package " + key);
                            continue;
                        }
                        loggerConfigPackage = config.getLoggerConfig(key);
                        if (!loggerConfigPackage.getName().equals(key)) {
                            loggerConfigPackage = new LoggerConfig(key, level, true);
                            loggerConfigPackage.setParent(config.getLoggerConfig(""));
                            config.addLogger(key, loggerConfigPackage);
                            continue;
                        }
                        loggerConfigPackage.setLevel(level);
                    }
                    context.updateLoggers();
                }
            }
        }
    }

    private static Level getLvl(String value) {
        char firstChar = value.charAt(0);
        Level lvl = null;
        switch (firstChar) {
            case 'A': {
                lvl = Level.ALL;
                break;
            }
            case 'T': {
                lvl = Level.TRACE;
                break;
            }
            case 'D': {
                lvl = Level.DEBUG;
                break;
            }
            case 'I': {
                lvl = Level.INFO;
                break;
            }
            case 'W': {
                lvl = Level.WARN;
                break;
            }
            case 'E': {
                lvl = Level.ERROR;
                break;
            }
            case 'F': {
                lvl = Level.FATAL;
                break;
            }
            case 'O': {
                lvl = Level.OFF;
            }
        }
        return lvl;
    }

    public static void changeToDebug(boolean debug) {
        System.out.println("Change log to DEBUG --> " + debug);
        try {
            LoggerContextFactory factory = LogManager.getFactory();
            ContextSelector selector = ((Log4jContextFactory)factory).getSelector();
            List contexts = selector.getLoggerContexts();
            for (LoggerContext context : contexts) {
                String key;
                Configuration config = context.getConfiguration();
                LoggerConfig loggerConfigPackage = config.getLoggerConfig(key = LOG_LOGGER_COM_EZ);
                if (!loggerConfigPackage.getName().equals(key)) {
                    loggerConfigPackage = new LoggerConfig(key, debug ? Level.DEBUG : Level.WARN, true);
                    loggerConfigPackage.setParent(config.getLoggerConfig(""));
                    config.addLogger(key, loggerConfigPackage);
                } else {
                    loggerConfigPackage.setLevel(debug ? Level.DEBUG : Level.WARN);
                }
                context.updateLoggers();
            }
        }
        catch (FactoryConfigurationError e) {
            L.error("Error:", (Throwable)e);
        }
        catch (Exception fe) {
            if (fe instanceof FileNotFoundException) {
                System.out.println("Log file not found");
            }
            L.error("Error:", (Throwable)fe);
        }
    }
}

