/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.rsrv.resolutions.lock;

import com.ez.eclient.service.rsrv.resolutions.lock.LockImplementation;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionImpl;
import com.ez.keeper.client.lock.LockState;
import com.ez.keeper.client.lock.ReadWriteLock;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLockImplementation
implements LockImplementation {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String LOCK_PATH_TPL = "/ez/ad/environment/environment-%s/synchro/journallock/project-%s";
    private static final Logger L = LoggerFactory.getLogger(ZkLockImplementation.class);
    private final ZkSession session;
    private final UUID environmentId;
    private final UUID appSessionId;
    private final long lockAcquireWaitTimeout;
    private String projectName;
    private UUID projectId;
    private ReadWriteLock lock = null;

    ZkLockImplementation(ZkSession session, String projectName, UUID environmentId, UUID projectId, UUID appSessionId, long lockAcquireWaitTimeout) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        if (environmentId == null) {
            throw new IllegalArgumentException("environmentId");
        }
        if (appSessionId == null) {
            throw new IllegalArgumentException("appSessionId");
        }
        this.session = session;
        this.projectName = projectName;
        this.environmentId = environmentId;
        this.projectId = projectId;
        this.appSessionId = appSessionId;
        this.lockAcquireWaitTimeout = lockAcquireWaitTimeout;
    }

    public void openProject(String projectName, UUID projectId) {
        if (projectName == null) {
            throw new IllegalArgumentException("projectName");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("projectId");
        }
        this.projectId = projectId;
        this.projectName = projectName;
    }

    public void closeProject() {
    }

    @Override
    public boolean acquireProjectLock(LockState type, long lockTimeout) {
        return this.doAcquireProjectLock(type, lockTimeout);
    }

    @Override
    public boolean acquireProjectLock(LockState type) {
        return this.doAcquireProjectLock(type, null);
    }

    @Override
    public boolean acquireProjectLock(LockState type, long timeout, Map<String, String> debugInfo) {
        return this.doAcquireProjectLock(type, timeout, debugInfo);
    }

    @Override
    public boolean releaseProjectLock() {
        boolean ok;
        block7: {
            block5: {
                LockState state;
                block6: {
                    ok = false;
                    state = null;
                    L.info("Project {} (id: {}, envid: {}): releasing lock...", new Object[]{this.projectName, this.projectId, this.environmentId});
                    try {
                        state = this.lock.release();
                        ok = true;
                        if (!ok) break block5;
                        if (state != LockState.None) break block6;
                        this.lock = null;
                    }
                    catch (Throwable throwable) {
                        if (ok) {
                            if (state == LockState.None) {
                                this.lock = null;
                            }
                            L.info("Project {} (id: {}, envid: {}): lock released; new state: {}", new Object[]{this.projectName, this.projectId, this.environmentId, state});
                        } else {
                            L.info("Project {} (id: {}, envid: {}): lock NOT released.", new Object[]{this.projectName, this.projectId, this.environmentId});
                        }
                        throw throwable;
                    }
                }
                L.info("Project {} (id: {}, envid: {}): lock released; new state: {}", new Object[]{this.projectName, this.projectId, this.environmentId, state});
                break block7;
            }
            L.info("Project {} (id: {}, envid: {}): lock NOT released.", new Object[]{this.projectName, this.projectId, this.environmentId});
        }
        return ok;
    }

    @Override
    public LockState getProjectLockType() {
        if (this.lock == null) {
            return LockState.None;
        }
        return this.lock.getState();
    }

    String getProjectName() {
        return this.projectName;
    }

    private boolean doAcquireProjectLock(LockState state, Long lockTimeout) {
        return this.doAcquireProjectLock(state, lockTimeout, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("threadName", Thread.currentThread().getName());
            }
        });
    }

    private boolean doAcquireProjectLock(LockState state, Long lockTimeout, Map<String, String> debugInfo) {
        if (state == null || state == LockState.None) {
            throw new IllegalArgumentException("type");
        }
        String lockPath = String.format(LOCK_PATH_TPL, this.environmentId.toString(), this.projectId.toString());
        if (lockTimeout == null) {
            L.debug("Lock timeout not provided, using default.");
            lockTimeout = this.lockAcquireWaitTimeout;
        }
        if (this.lock == null) {
            this.lock = new ReadWriteLock((ZkSessionImpl)this.session, this.appSessionId, lockPath, debugInfo);
        }
        L.info("Project {} (id: {}, envid: {}): acquiring lock {}...", new Object[]{this.projectName, this.projectId, this.environmentId, state});
        L.info("Lock path: {}", (Object)lockPath);
        L.debug("Will wait for at most {}ms", (Object)lockTimeout);
        boolean acquired = this.lock.acquire(state, lockTimeout.longValue());
        if (acquired) {
            L.info("Project {} (id: {}, envid: {}): acquired lock {}", new Object[]{this.projectName, this.projectId, this.environmentId, state});
        } else {
            L.info("Project {} (id: {}, envid: {}): lock {} FAILED", new Object[]{this.projectName, this.projectId, this.environmentId, state});
        }
        return acquired;
    }
}

