/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.rsrv.resolutions.impl;

import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.IGenericEntity;
import com.ez.eclient.service.rsrv.DefaultAbstractRsrvService;
import com.ez.eclient.service.rsrv.ServiceEntityAdapterFactoryImpl;
import com.ez.eclient.service.rsrv.ZkServiceInfo;
import com.ez.eclient.service.rsrv.resolutions.ManualResolutionsService;
import com.ez.eclient.service.rsrv.resolutions.impl.ZkManualResServiceInfoBuilder;
import com.ez.eclient.service.rsrv.resolutions.impl.ZkResolutionSrvInfo;
import com.ez.eclient.service.rsrv.resolutions.lock.LockImplementation;
import com.ez.eclient.service.rsrv.resolutions.lock.LockImplementationFactory;
import com.ez.eclient.service.rsrv.resolutions.lock.ZkLockImplementationFactory;
import com.ez.json.tools.binding.Path;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import com.ez.keeper.client.lock.LockState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManualResolutionsService
extends DefaultAbstractRsrvService
implements ManualResolutionsService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultManualResolutionsService.class);
    public static final long LOCK_ACQUIRE_WAIT_DEFAULT_VALUE = 60000L;
    private LockImplementationFactory lockFactory;
    private Map<UUID, LockImplementation> lockFacades;
    private UUID envId;
    private UUID instanceSid;

    public DefaultManualResolutionsService() {
    }

    public DefaultManualResolutionsService(ZkSessionFactory sessionFactory, UUID environmentId, UUID instanceId, IAppLogger logger) {
        super(sessionFactory.getSession(), environmentId.toString(), logger, new ResolutionsAdapterFactoryImpl());
        this.envId = environmentId;
        this.instanceSid = instanceId;
        this.lockFactory = new ZkLockImplementationFactory(sessionFactory, this.envId, this.instanceSid, 60000L);
        this.lockFactory.initialize();
        this.lockFacades = new HashMap<UUID, LockImplementation>();
    }

    @Override
    protected void registerObjects() {
        this.registerObject("resolutionserv", (List<String>)new ArrayList<String>(){
            {
                this.add("metadata");
            }
        }, "metad");
    }

    @Override
    protected void init(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        super.init(session, environmentId, logger, adapterFactory);
    }

    @Override
    public String getFilesEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).getFiles;
        }
        return null;
    }

    @Override
    public String getCurrentResolutionEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).current;
        }
        return null;
    }

    @Override
    public String getMatchingResolutionEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).matching;
        }
        return null;
    }

    @Override
    public String getLastResolutionEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).last;
        }
        return null;
    }

    @Override
    public String getAppliedResEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).applied;
        }
        return null;
    }

    @Override
    public String getRegisterEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).register;
        }
        return null;
    }

    @Override
    public String getDeleteEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).delete;
        }
        return null;
    }

    @Override
    public String getReapplyendpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).reapply;
        }
        return null;
    }

    @Override
    protected String getObjectType() {
        return "resolutionserv";
    }

    @Override
    public String getUpdateFilesEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkResolutionSrvInfo)srv).updateFiles;
        }
        return null;
    }

    @Override
    public boolean acquireProjectLock(String projectName, UUID prjID, LockState type, long lockTimeout) {
        return this.doAcquireProjectLock(projectName, prjID, type, lockTimeout, null);
    }

    @Override
    public boolean acquireProjectLock(String projectName, UUID prjID, LockState type, long lockTimeout, Map<String, String> debugInfo) {
        return this.doAcquireProjectLock(projectName, prjID, type, lockTimeout, debugInfo);
    }

    boolean doAcquireProjectLock(String projectName, UUID prjID, LockState type, long lockTimeout, Map<String, String> debugInfo) {
        boolean ok = false;
        try {
            LockImplementation lockFacade = this.lockFacades.get(prjID);
            if (lockFacade == null) {
                lockFacade = this.lockFactory.create(projectName, prjID);
                this.lockFacades.put(prjID, lockFacade);
            }
            ok = debugInfo == null ? lockFacade.acquireProjectLock(type, lockTimeout) : lockFacade.acquireProjectLock(type, lockTimeout, debugInfo);
        }
        catch (Exception ex) {
            L.error("error acquiring journalLock for project {} (UUID={})", new Object[]{projectName, prjID, ex});
            throw ex;
        }
        return ok;
    }

    @Override
    public boolean releaseProjectLock(String projectName, UUID prjID) {
        boolean ok = false;
        LockImplementation lockFacade = this.lockFacades.get(prjID);
        if (lockFacade == null) {
            throw new RuntimeException("no lockFacade for project: " + projectName);
        }
        ok = lockFacade.releaseProjectLock();
        return ok;
    }

    static class ResolutionsAdapterFactoryImpl
    extends ServiceEntityAdapterFactoryImpl {
        public ResolutionsAdapterFactoryImpl() {
            super("metadata.service.base");
        }

        @Override
        public Object create(IGenericEntity entity, String type) {
            Object data = entity.getData();
            String id = (String)Path.getObject((Object)data, (String)"metadata.id", String.class, (int)0);
            String current = (String)Path.getObject((Object)data, (String)"metadata.service.current", String.class, (int)0);
            String matching = (String)Path.getObject((Object)data, (String)"metadata.service.matching", String.class, (int)0);
            String last = (String)Path.getObject((Object)data, (String)"metadata.service.last", String.class, (int)0);
            String applied = (String)Path.getObject((Object)data, (String)"metadata.service.applied", String.class, (int)0);
            String register = (String)Path.getObject((Object)data, (String)"metadata.service.register", String.class, (int)0);
            String delete = (String)Path.getObject((Object)data, (String)"metadata.service.delete", String.class, (int)0);
            String reapply = (String)Path.getObject((Object)data, (String)"metadata.service.reapply", String.class, (int)0);
            String files = (String)Path.getObject((Object)data, (String)"metadata.service.getFiles", String.class, (int)0);
            String updatefiles = (String)Path.getObject((Object)data, (String)"metadata.service.updateFiles", String.class, (int)0);
            return new ZkManualResServiceInfoBuilder(UUID.fromString(id), this.getBaseAddress(data)).create(current, matching, last, applied, register, delete, reapply, files, updatefiles);
        }
    }
}

