/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.rsrv.fileservice.impl;

import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.IGenericEntity;
import com.ez.eclient.service.rsrv.DefaultAbstractRsrvService;
import com.ez.eclient.service.rsrv.ServiceEntityAdapterFactoryImpl;
import com.ez.eclient.service.rsrv.ZkServiceInfo;
import com.ez.eclient.service.rsrv.fileservice.FileServerService;
import com.ez.eclient.service.rsrv.fileservice.impl.ZkFileServiceInfoBuilder;
import com.ez.eclient.service.rsrv.fileservice.impl.ZkFileSrvInfo;
import com.ez.json.tools.binding.Path;
import com.ez.keeper.client.ZkSession;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DefaultFileServerService
extends DefaultAbstractRsrvService
implements FileServerService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public DefaultFileServerService(ZkSession session, String environmentId, IAppLogger logger) {
        super(session, environmentId, logger, new FileServiceAdapterFactoryImpl());
    }

    @Override
    protected void registerObjects() {
        this.registerObject("fileservice", (List<String>)new ArrayList<String>(){
            {
                this.add("metadata");
            }
        }, "metad");
    }

    @Override
    public String getFileContentEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkFileSrvInfo)srv).getFileContentEndpoint();
        }
        return null;
    }

    @Override
    public String getLAOEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkFileSrvInfo)srv).getLAOEndpoint();
        }
        return null;
    }

    @Override
    public String getLANEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkFileSrvInfo)srv).getLANEndpoint();
        }
        return null;
    }

    @Override
    public String getFileExtraEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkFileSrvInfo)srv).getFileExtraEndpoint();
        }
        return null;
    }

    @Override
    protected String getObjectType() {
        return "fileservice";
    }

    static class FileServiceAdapterFactoryImpl
    extends ServiceEntityAdapterFactoryImpl {
        public FileServiceAdapterFactoryImpl() {
            super("metadata.fileservice.base");
        }

        @Override
        public Object create(IGenericEntity entity, String type) {
            Object data = entity.getData();
            String id = (String)Path.getObject((Object)data, (String)"metadata.id", String.class, (int)0);
            String filecontent = (String)Path.getObject((Object)data, (String)"metadata.fileservice.file", String.class, (int)0);
            String fas = (String)Path.getObject((Object)data, (String)"metadata.fileservice.fas", String.class, (int)0);
            String lao = (String)Path.getObject((Object)data, (String)"metadata.fileservice.lao", String.class, (int)0);
            String lan = (String)Path.getObject((Object)data, (String)"metadata.fileservice.lan", String.class, (int)0);
            return new ZkFileServiceInfoBuilder(UUID.fromString(id), this.getBaseAddress(data)).create(filecontent, fas, lao, lan);
        }
    }
}

