/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.rsrv.cross.impl;

import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.IGenericEntity;
import com.ez.eclient.service.rsrv.DefaultAbstractRsrvService;
import com.ez.eclient.service.rsrv.ServiceEntityAdapterFactoryImpl;
import com.ez.eclient.service.rsrv.ZkServiceInfo;
import com.ez.eclient.service.rsrv.cross.CrossService;
import com.ez.eclient.service.rsrv.cross.impl.ZkCrossServiceInfoBuilder;
import com.ez.eclient.service.rsrv.cross.impl.ZkCrossSrvInfo;
import com.ez.json.tools.binding.Path;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.ZkSessionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCrossService
extends DefaultAbstractRsrvService
implements CrossService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultCrossService.class);
    public static final long LOCK_ACQUIRE_WAIT_DEFAULT_VALUE = 60000L;

    public DefaultCrossService(ZkSessionFactory sessionFactory, UUID environmentId, UUID instanceId, IAppLogger logger) {
        super(sessionFactory.getSession(), environmentId.toString(), logger, new CrossServiceAdapterFactoryImpl());
    }

    @Override
    protected void registerObjects() {
        this.registerObject("crossreposervice", (List<String>)new ArrayList<String>(){
            {
                this.add("metadata");
            }
        }, "metad");
    }

    @Override
    public String getMakeRepoEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkCrossSrvInfo)srv).makeCrossDatabase;
        }
        return null;
    }

    @Override
    protected void init(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        super.init(session, environmentId, logger, adapterFactory);
    }

    @Override
    public String getQueryResultEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkCrossSrvInfo)srv).getQueryResult;
        }
        return null;
    }

    @Override
    protected String getObjectType() {
        return "crossreposervice";
    }

    static class CrossServiceAdapterFactoryImpl
    extends ServiceEntityAdapterFactoryImpl {
        public CrossServiceAdapterFactoryImpl() {
            super("metadata.crossreposervice.base");
        }

        @Override
        public Object create(IGenericEntity entity, String type) {
            Object data = entity.getData();
            String id = (String)Path.getObject((Object)data, (String)"metadata.id", String.class, (int)0);
            String getMake = (String)Path.getObject((Object)data, (String)"metadata.crossreposervice.makeDbEndpoint", String.class, (int)0);
            String getQResult = (String)Path.getObject((Object)data, (String)"metadata.crossreposervice.getResultEndpoint", String.class, (int)0);
            return new ZkCrossServiceInfoBuilder(UUID.fromString(id), this.getBaseAddress(data)).create(getMake, getQResult);
        }
    }
}

