/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.rsrv;

import com.ez.eclient.service.DefaultAbstractService;
import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.eclient.service.rsrv.RsrvServiceChangeListener;
import com.ez.eclient.service.rsrv.ZkServiceInfo;
import com.ez.keeper.binding.ObjectEvent;
import com.ez.keeper.binding.ObjectListener;
import com.ez.keeper.client.ZkSession;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAbstractRsrvService
extends DefaultAbstractService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultAbstractRsrvService.class);
    protected static final String SERVICE_METADATA = "metad";
    protected static final String DEFFAULT_ID_NULL_VALUE = "";
    private Map<UUID, GenericEntityImpl> servers;
    private String defaultID = "";
    private Set<RsrvServiceChangeListener> listeners;

    protected DefaultAbstractRsrvService() {
    }

    public DefaultAbstractRsrvService(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        super(session, environmentId, logger, adapterFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZkServiceInfo getServiceInfo() {
        ZkServiceInfo srv = null;
        String id = null;
        Object object = this.defaultID;
        synchronized (object) {
            id = this.defaultID;
        }
        if (id == null || id.isEmpty()) {
            object = this.servers;
            synchronized (object) {
                if (this.servers != null && !this.servers.isEmpty()) {
                    id = this.servers.keySet().iterator().next().toString();
                    L.info("default id is null; {} it will be considered!", (Object)id);
                }
            }
        }
        if (id != null && !id.isEmpty()) {
            Map<UUID, Object> data = null;
            Map<UUID, GenericEntityImpl> map = this.servers;
            synchronized (map) {
                data = this.getEntitiesFromData(this.servers);
            }
            if (data != null && !data.isEmpty()) {
                UUID uid = UUID.fromString(id);
                Object srvObj = data.get(uid);
                if (srvObj != null) {
                    srv = (ZkServiceInfo)srvObj;
                } else {
                    L.warn("service with id {} not found", (Object)uid);
                }
            }
        } else {
            L.warn("no service data!");
        }
        return srv;
    }

    @Override
    protected void init(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        super.init(session, environmentId, logger, adapterFactory);
        this.rootPath = this.rootPath + "/rsrv";
        this.servers = new HashMap<UUID, GenericEntityImpl>();
    }

    protected abstract String getObjectType();

    @Override
    protected ObjectListener getDispatcherListener() {
        ObjectListener dispatcherListener = new ObjectListener(){

            public void notify(ObjectEvent e) {
                String objectType = e.getId().getType();
                boolean defaultChanged = false;
                if (DefaultAbstractRsrvService.this.getObjectType().equals(objectType)) {
                    switch (e.getType()) {
                        case Deleted: {
                            defaultChanged = DefaultAbstractRsrvService.this.onServerDeleted((UUID)e.getId().getId());
                            break;
                        }
                        case Created: {
                            DefaultAbstractRsrvService.this.onServerAvailable((GenericEntityImpl)e.getArgs().get(0), false);
                            break;
                        }
                        case Updated: {
                            DefaultAbstractRsrvService.this.onServerAvailable((GenericEntityImpl)e.getArgs().get(0), true);
                        }
                    }
                } else if (DefaultAbstractRsrvService.SERVICE_METADATA.equals(objectType)) {
                    L.info("metadata of server with type={} was changed; eventType={}", (Object)objectType, (Object)e.getType());
                    defaultChanged = true;
                    switch (e.getType()) {
                        case Deleted: {
                            DefaultAbstractRsrvService.this.defaultRemoved();
                            break;
                        }
                        case Created: 
                        case Updated: {
                            DefaultAbstractRsrvService.this.defaultChanged(e);
                        }
                    }
                }
                if (defaultChanged) {
                    DefaultAbstractRsrvService.this.notifyListeners(e);
                }
            }
        };
        return dispatcherListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onServerDeleted(UUID id) {
        boolean ret = false;
        Object object = this.servers;
        synchronized (object) {
            this.servers.remove(id);
        }
        L.info("server {} deleted", (Object)id);
        if (this.defaultID != null) {
            object = this.defaultID;
            synchronized (object) {
                if (this.defaultID != null && !this.defaultID.isEmpty() && UUID.fromString(this.defaultID).equals(id)) {
                    this.defaultRemoved();
                    ret = true;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerAvailable(GenericEntityImpl ent, boolean isUpdate) {
        Map<UUID, GenericEntityImpl> map = this.servers;
        synchronized (map) {
            this.servers.put(ent.getId(), ent);
        }
        L.info("server with id={} and type={} was {}", new Object[]{ent.getId(), ent.getAdapter(), isUpdate ? "updated" : "created"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultChanged(ObjectEvent e) {
        Map val = (Map)e.getArgs().get(0);
        String newVal = (String)val.get("default");
        L.info("default service changes from {} to {}", (Object)this.defaultID, (Object)newVal);
        String string = this.defaultID;
        synchronized (string) {
            this.defaultID = newVal != null ? newVal : DEFFAULT_ID_NULL_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultRemoved() {
        String string = this.defaultID;
        synchronized (string) {
            this.defaultID = DEFFAULT_ID_NULL_VALUE;
        }
        L.warn("default value was deleted!!");
    }

    @Override
    public synchronized void stop(boolean releaseSession) {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        super.stop(releaseSession);
    }

    public void registerListener(RsrvServiceChangeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new HashSet<RsrvServiceChangeListener>();
            }
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(RsrvServiceChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(ObjectEvent e) {
        if (this.listeners != null) {
            for (RsrvServiceChangeListener l : this.listeners) {
                switch (e.getType()) {
                    case Deleted: 
                    case Created: 
                    case Updated: {
                        l.serviceChanged();
                    }
                }
            }
        }
    }
}

