/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.database.impl;

import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IGenericEntity;
import java.util.Map;
import java.util.UUID;

public final class GenericEntityImpl
implements IGenericEntity {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final UUID id;
    private final Map data;
    private String type;
    private Object adapter;
    private EntityAdapterFactory adapterFactory;

    public GenericEntityImpl(UUID id, Map data, String type, EntityAdapterFactory adapterFactory) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (data == null) {
            throw new IllegalArgumentException("data");
        }
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        this.id = id;
        this.data = data;
        this.type = type;
        this.adapter = adapterFactory != null ? adapterFactory.create(this, type) : this;
        this.adapterFactory = adapterFactory;
    }

    public GenericEntityImpl(UUID id, Map data, String type) {
        this(id, data, type, null);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public GenericEntityImpl clone() {
        return new GenericEntityImpl(this.id, this.data, this.type, this.adapterFactory);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getName());
        b.append("[");
        b.append("id: ");
        b.append(this.id);
        b.append(", data: ");
        b.append(this.data);
        b.append("]");
        return b.toString();
    }

    @Override
    public Object getAdapter() {
        return this.adapter;
    }
}

