/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.database.impl;

import com.ez.eclient.service.DefaultAbstractService;
import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.database.DatabaseService;
import com.ez.eclient.service.database.DatabaseServiceListener;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.keeper.binding.ObjectEvent;
import com.ez.keeper.binding.ObjectListener;
import com.ez.keeper.client.ZkSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseService
extends DefaultAbstractService
implements DatabaseService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultDatabaseService.class);
    private Map<UUID, GenericEntityImpl> sqlServers;
    private Set<DatabaseServiceListener> listeners;

    public DefaultDatabaseService() {
    }

    public DefaultDatabaseService(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        super(session, environmentId, logger, adapterFactory);
        this.sqlServers = new HashMap<UUID, GenericEntityImpl>();
    }

    @Override
    public void configure(ZkSession session, String envirnmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        this.init(session, envirnmentId, logger, adapterFactory);
        this.sqlServers = new HashMap<UUID, GenericEntityImpl>();
    }

    @Override
    protected ObjectListener getDispatcherListener() {
        ObjectListener dispatcherListener = new ObjectListener(){

            public void notify(ObjectEvent e) {
                String objectType = e.getId().getType();
                if ("sqldb".equals(objectType)) {
                    switch (e.getType()) {
                        case Deleted: {
                            DefaultDatabaseService.this.onSqlServerDeleted((UUID)e.getId().getId());
                            break;
                        }
                        case Created: {
                            DefaultDatabaseService.this.onSqlServerAvailable((GenericEntityImpl)e.getArgs().get(0));
                            break;
                        }
                        case Updated: {
                            DefaultDatabaseService.this.onSqlServerAvailable((GenericEntityImpl)e.getArgs().get(0));
                        }
                    }
                    DefaultDatabaseService.this.notifyListeners(e);
                }
            }
        };
        return dispatcherListener;
    }

    @Override
    protected void registerObjects() {
        this.registerObject("sqldb", (List<String>)new ArrayList<String>(){
            {
                this.add("metadata");
            }
        });
    }

    private synchronized void onSqlServerAvailable(GenericEntityImpl e) {
        if (this.sqlServers.put(e.getId(), e) != null) {
            L.info("SQL server updated: " + e);
        } else {
            L.info("SQL server: " + e);
        }
    }

    private synchronized void onSqlServerDeleted(UUID uid) {
        GenericEntityImpl ui = this.sqlServers.remove(uid);
        if (ui == null) {
            L.error("No such SQL server: " + uid);
        } else {
            L.info("SQL server: " + uid);
        }
    }

    @Override
    public synchronized Map<UUID, Object> getEntities() {
        return this.getEntitiesFromData(this.sqlServers);
    }

    @Override
    public synchronized void stop(boolean releaseSession) {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        super.stop(releaseSession);
    }

    @Override
    public void registerListener(DatabaseServiceListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new HashSet<DatabaseServiceListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(DatabaseServiceListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(ObjectEvent e) {
        if (this.listeners != null) {
            for (DatabaseServiceListener l : this.listeners) {
                switch (e.getType()) {
                    case Deleted: {
                        l.databaseServerDeleted(e);
                        break;
                    }
                    case Created: 
                    case Updated: {
                        l.databaseServerChanged(e);
                    }
                }
            }
        }
    }
}

