/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.configuration.waziproxy.impl;

import com.ez.eclient.service.DefaultAbstractService;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.IGenericEntity;
import com.ez.eclient.service.configuration.waziproxy.IWaziProxyService;
import com.ez.eclient.service.configuration.waziproxy.IWaziProxyServiceChangeListener;
import com.ez.eclient.service.configuration.waziproxy.impl.ZkWaziProxySrvInfo;
import com.ez.eclient.service.configuration.waziproxy.impl.ZkWaziProxySrvInfoBuilder;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.eclient.service.rsrv.ServiceEntityAdapterFactoryImpl;
import com.ez.eclient.service.rsrv.ZkServiceInfo;
import com.ez.json.tools.binding.Path;
import com.ez.keeper.binding.ObjectEvent;
import com.ez.keeper.binding.ObjectListener;
import com.ez.keeper.client.ZkSession;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWaziProxyService
extends DefaultAbstractService
implements IWaziProxyService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultWaziProxyService.class);
    private Map<UUID, GenericEntityImpl> servers;
    private Set<IWaziProxyServiceChangeListener> listeners;

    public DefaultWaziProxyService(ZkSession session, String environmentId, IAppLogger logger, String configurationId) {
        super(session, environmentId, logger, new WaziProxySrvAdapterFactoryImpl());
        if (configurationId == null || configurationId.trim().isEmpty()) {
            throw new IllegalStateException("Illegal configurationId.");
        }
        this.servers = new HashMap<UUID, GenericEntityImpl>();
        this.rootPath = this.rootPath + "/configuration/configuration-" + configurationId + "/common/general/webservice";
    }

    @Override
    protected void registerObjects() {
        this.registerObject("waziproxy", (List<String>)new ArrayList<String>(){
            {
                this.add("metadata");
            }
        });
    }

    @Override
    protected ObjectListener getDispatcherListener() {
        ObjectListener dispatcherListener = new ObjectListener(){

            public void notify(ObjectEvent e) {
                String objectType = e.getId().getType();
                if ("waziproxy".equals(objectType)) {
                    switch (e.getType()) {
                        case Deleted: {
                            DefaultWaziProxyService.this.onServerDeleted((UUID)e.getId().getId());
                            break;
                        }
                        case Created: 
                        case Updated: {
                            DefaultWaziProxyService.this.onServerAvailable((GenericEntityImpl)e.getArgs().get(0));
                        }
                    }
                    DefaultWaziProxyService.this.notifyListeners(e);
                }
            }
        };
        return dispatcherListener;
    }

    private synchronized void onServerAvailable(GenericEntityImpl e) {
        if (this.servers.put(e.getId(), e) != null) {
            L.info("Wazi Proxy server updated: " + e);
        } else {
            L.info("Wazi Proxy server: " + e);
        }
    }

    private synchronized void onServerDeleted(UUID uid) {
        if (this.servers.remove(uid) == null) {
            L.error("No such Wazi Proxy server: " + uid);
        } else {
            L.info("Wazi Proxy server: " + uid);
        }
    }

    @Override
    public void registerListener(IWaziProxyServiceChangeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new HashSet<IWaziProxyServiceChangeListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(IWaziProxyServiceChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZkServiceInfo getServiceInfo() {
        ZkServiceInfo srv = null;
        String id = null;
        Map<UUID, GenericEntityImpl> map = this.servers;
        synchronized (map) {
            if (this.servers != null && !this.servers.isEmpty()) {
                id = this.servers.keySet().iterator().next().toString();
                L.info("{} id will be considered!", (Object)id);
            }
        }
        if (id != null && !id.isEmpty()) {
            Map<UUID, Object> data = null;
            Map<UUID, GenericEntityImpl> map2 = this.servers;
            synchronized (map2) {
                data = this.getEntitiesFromData(this.servers);
            }
            if (data != null && !data.isEmpty()) {
                UUID uid = UUID.fromString(id);
                Object srvObj = data.get(uid);
                if (srvObj != null) {
                    srv = (ZkServiceInfo)srvObj;
                } else {
                    L.warn("service with id {} not found", (Object)uid);
                }
            }
        } else {
            L.warn("no service data!");
        }
        return srv;
    }

    @Override
    public String getJavaCallGraphEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getJavaCallGraphEndpoint();
        }
        return null;
    }

    @Override
    public String getHypercubeStatusEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getHypercubeStatusEndpoint();
        }
        return null;
    }

    @Override
    public String getHypercubeLoadEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getHypercubeLoadEndpoint();
        }
        return null;
    }

    @Override
    public String getHypercubeUnloadEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getHypercubeUnloadEndpoint();
        }
        return null;
    }

    @Override
    public String getInventoryPackagesEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getInventoryPackagesEndpoint();
        }
        return null;
    }

    @Override
    public String getInventoryClassesEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getInventoryClassesEndpoint();
        }
        return null;
    }

    @Override
    public String getInventoryMethodsEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getInventoryMethodsEndpoint();
        }
        return null;
    }

    @Override
    public String getViewSourceEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getViewSource();
        }
        return null;
    }

    @Override
    public String getUsagesEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getUsages();
        }
        return null;
    }

    @Override
    public String getJavaCrossCallGraphEndpoint() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return srv.getBaseLink() + ((ZkWaziProxySrvInfo)srv).getJavaCrossCallGraphEndpoint();
        }
        return null;
    }

    @Override
    public Integer getUnloadInterval() {
        ZkServiceInfo srv = this.getServiceInfo();
        if (srv != null) {
            return ((ZkWaziProxySrvInfo)srv).getUnloadInterval();
        }
        return null;
    }

    private void notifyListeners(ObjectEvent e) {
        if (this.listeners != null) {
            for (IWaziProxyServiceChangeListener l : this.listeners) {
                switch (e.getType()) {
                    case Deleted: 
                    case Created: 
                    case Updated: {
                        l.serviceChanged(e);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void stop(boolean releaseSession) {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        super.stop(releaseSession);
    }

    static class WaziProxySrvAdapterFactoryImpl
    extends ServiceEntityAdapterFactoryImpl {
        public WaziProxySrvAdapterFactoryImpl() {
            super("metadata.baseUrl");
        }

        @Override
        public Object create(IGenericEntity entity, String type) {
            Object data = entity.getData();
            String id = (String)Path.getObject((Object)data, (String)"metadata.id", String.class, (int)0);
            String javaCallGraph = (String)Path.getObject((Object)data, (String)"metadata.endpoints.javaGraph", String.class, (int)0);
            String hypercubeStatus = (String)Path.getObject((Object)data, (String)"metadata.endpoints.hypercubeStatus", String.class, (int)0);
            String hypercubeLoad = (String)Path.getObject((Object)data, (String)"metadata.endpoints.hypercubeLoad", String.class, (int)0);
            String hypercubeUnload = (String)Path.getObject((Object)data, (String)"metadata.endpoints.hypercubeUnload", String.class, (int)0);
            String inventoryPackages = (String)Path.getObject((Object)data, (String)"metadata.endpoints.inventoryPackages", String.class, (int)0);
            String inventoryClasses = (String)Path.getObject((Object)data, (String)"metadata.endpoints.inventoryClasses", String.class, (int)0);
            String inventoryMethods = (String)Path.getObject((Object)data, (String)"metadata.endpoints.inventoryMethods", String.class, (int)0);
            String viewSource = (String)Path.getObject((Object)data, (String)"metadata.endpoints.viewSource", String.class, (int)0);
            String usages = (String)Path.getObject((Object)data, (String)"metadata.endpoints.viewUsages", String.class, (int)0);
            String javaCrossCallGraph = (String)Path.getObject((Object)data, (String)"metadata.endpoints.javaCrossGraph", String.class, (int)0);
            Integer unloadInterval = ((BigDecimal)Path.getObject((Object)data, (String)"metadata.unloadInterval", BigDecimal.class, (int)0)).intValue();
            return new ZkWaziProxySrvInfoBuilder(UUID.fromString(id), this.getBaseAddress(data)).create(unloadInterval, javaCallGraph, hypercubeStatus, hypercubeLoad, hypercubeUnload, inventoryPackages, inventoryClasses, inventoryMethods, viewSource, usages, javaCrossCallGraph);
        }
    }
}

