/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service.configuration.impl;

import com.ez.eclient.service.DefaultAbstractService;
import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.IGenericEntity;
import com.ez.eclient.service.configuration.IConfigurationService;
import com.ez.eclient.service.configuration.IConfigurationServiceChangeListener;
import com.ez.eclient.service.configuration.impl.ZkConfigurationSrvInfoBuilder;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.eclient.service.rsrv.ServiceEntityAdapterFactoryImpl;
import com.ez.eclient.service.rsrv.ZkServiceInfo;
import com.ez.json.tools.binding.Path;
import com.ez.keeper.binding.ObjectEvent;
import com.ez.keeper.binding.ObjectListener;
import com.ez.keeper.client.ZkSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationService
extends DefaultAbstractService
implements IConfigurationService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultConfigurationService.class);
    private Map<UUID, GenericEntityImpl> servers;
    private Set<IConfigurationServiceChangeListener> listeners;

    public DefaultConfigurationService(ZkSession session, String environmentId, IAppLogger logger) {
        super(session, environmentId, logger, new ConfigurationSrvAdapterFactoryImpl());
    }

    @Override
    protected void init(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        super.init(session, environmentId, logger, adapterFactory);
        this.servers = new HashMap<UUID, GenericEntityImpl>();
    }

    @Override
    protected void registerObjects() {
        this.registerObject("configuration", (List<String>)new ArrayList<String>(){
            {
                this.add("metadata");
            }
        });
    }

    @Override
    protected ObjectListener getDispatcherListener() {
        ObjectListener dispatcherListener = new ObjectListener(){

            public void notify(ObjectEvent e) {
                String objectType = e.getId().getType();
                if ("configuration".equals(objectType)) {
                    switch (e.getType()) {
                        case Deleted: {
                            DefaultConfigurationService.this.onServerDeleted((UUID)e.getId().getId());
                            break;
                        }
                        case Created: 
                        case Updated: {
                            DefaultConfigurationService.this.onServerAvailable((GenericEntityImpl)e.getArgs().get(0));
                        }
                    }
                    DefaultConfigurationService.this.notifyListeners(e);
                }
            }
        };
        return dispatcherListener;
    }

    private synchronized void onServerAvailable(GenericEntityImpl e) {
        if (this.servers.put(e.getId(), e) != null) {
            L.info("Configuration server updated: " + e);
        } else {
            L.info("Configuration server: " + e);
        }
    }

    private synchronized void onServerDeleted(UUID uid) {
        if (this.servers.remove(uid) == null) {
            L.error("No such Configuration server: " + uid);
        } else {
            L.info("Configuration server: " + uid);
        }
    }

    @Override
    public void registerListener(IConfigurationServiceChangeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new HashSet<IConfigurationServiceChangeListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(IConfigurationServiceChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZkServiceInfo getServiceInfo() {
        ZkServiceInfo srv = null;
        String id = null;
        Map<UUID, GenericEntityImpl> map = this.servers;
        synchronized (map) {
            if (this.servers != null && !this.servers.isEmpty()) {
                id = this.servers.keySet().iterator().next().toString();
                L.info("{} id will be considered!", (Object)id);
            }
        }
        if (id != null && !id.isEmpty()) {
            Map<UUID, Object> data = null;
            Map<UUID, GenericEntityImpl> map2 = this.servers;
            synchronized (map2) {
                data = this.getEntitiesFromData(this.servers);
            }
            if (data != null && !data.isEmpty()) {
                UUID uid = UUID.fromString(id);
                Object srvObj = data.get(uid);
                if (srvObj != null) {
                    srv = (ZkServiceInfo)srvObj;
                } else {
                    L.warn("service with id {} not found", (Object)uid);
                }
            }
        } else {
            L.warn("no service data!");
        }
        return srv;
    }

    private void notifyListeners(ObjectEvent e) {
        if (this.listeners != null) {
            for (IConfigurationServiceChangeListener l : this.listeners) {
                switch (e.getType()) {
                    case Deleted: 
                    case Created: 
                    case Updated: {
                        l.serviceChanged(e);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void stop(boolean releaseSession) {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        super.stop(releaseSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfigurationId() {
        String id = null;
        Map<UUID, GenericEntityImpl> map = this.servers;
        synchronized (map) {
            if (this.servers != null && !this.servers.isEmpty()) {
                id = this.servers.keySet().iterator().next().toString();
                L.info("com.ez.eclient.service.configuration.impl.DefaultConfigurationService.getConfigurationId return: {} !", (Object)id);
            }
        }
        return id;
    }

    static class ConfigurationSrvAdapterFactoryImpl
    extends ServiceEntityAdapterFactoryImpl {
        public ConfigurationSrvAdapterFactoryImpl() {
            super("");
        }

        @Override
        public Object create(IGenericEntity entity, String type) {
            Object data = entity.getData();
            String id = (String)Path.getObject((Object)data, (String)"metadata.id", String.class, (int)0);
            return new ZkConfigurationSrvInfoBuilder(UUID.fromString(id)).create();
        }
    }
}

