/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service;

import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.json.tools.binding.JsonParser;
import com.ez.keeper.binding.ObjectDescriptor;
import com.ez.keeper.binding.ObjectId;
import com.ez.keeper.binding.ObjectMapper;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.cache.CacheChildrenEntry;
import com.ez.keeper.client.cache.CacheDataEntry;
import com.ez.keeper.client.cache.CacheEvent;
import com.ez.keeper.client.cache.LocalCache;
import com.ez.keeper.client.cache.NodeAvailableEvent;
import com.ez.keeper.client.cache.NodeDeletedEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.JsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMapperImpl
implements ObjectMapper {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ObjectMapperImpl.class);
    String root;
    String type;
    String prefix;
    List<String> childNodes;
    String syncNode;
    EntityAdapterFactory adapterFactory;
    String parentMeta = null;

    public ObjectMapperImpl(String root, String type, String prefix, List<String> childNodes, String syncNode, EntityAdapterFactory adapterFactory, String parentMeta) {
        this(root, type, prefix, childNodes, syncNode, adapterFactory);
        this.parentMeta = parentMeta;
    }

    public ObjectMapperImpl(String root, String type, String prefix, List<String> childNodes, String syncNode, EntityAdapterFactory adapterFactory) {
        this.root = root;
        this.type = type;
        this.prefix = prefix;
        this.childNodes = Collections.unmodifiableList(childNodes);
        this.syncNode = syncNode;
        this.adapterFactory = adapterFactory;
    }

    public boolean accept(CacheEvent e) {
        String[] segs;
        if (!(e instanceof NodeDeletedEvent) && !(e instanceof NodeAvailableEvent)) {
            return false;
        }
        String node = e.getNode();
        String parent = ZkPath.join((String)this.root, (String[])new String[]{this.type});
        String relative = ZkPath.relative((String)parent, (String)node);
        return relative != null && (segs = ZkPath.split((String)relative)).length == 2 && segs[1].equals(this.syncNode);
    }

    public List<ObjectDescriptor> initialize(String node, LocalCache cache) {
        LinkedList<ObjectDescriptor> odl;
        block11: {
            odl = new LinkedList<ObjectDescriptor>();
            String parent = ZkPath.join((String)this.root, (String[])new String[]{this.type});
            L.debug("Initializing {} ...", (Object)node);
            try {
                CacheDataEntry cde;
                CacheChildrenEntry cce = cache.getChildren(parent, 0);
                if (cce == null) break block11;
                for (String child : cce.getChildren()) {
                    String id = child.replace(this.prefix, "");
                    if (id == null) continue;
                    UUID uid = null;
                    try {
                        uid = UUID.fromString(id);
                    }
                    catch (IllegalArgumentException ex) {
                        L.error(String.format("Parse path: %s; invalid uuid: %s", node, id));
                        continue;
                    }
                    String entityRoot = ZkPath.join((String)parent, (String[])new String[]{child});
                    String entitySyncPath = ZkPath.join((String)entityRoot, (String[])new String[]{this.syncNode});
                    CacheDataEntry cde2 = null;
                    cde2 = cache.getData(entitySyncPath, 0);
                    if (cde2 == null) continue;
                    Object o = null;
                    try {
                        o = this.readEntity(cache, entityRoot, uid, cde2.getTxid());
                    }
                    catch (JsonException ex) {
                        L.error("Read entity error.", (Throwable)ex);
                        continue;
                    }
                    if (o == null) continue;
                    odl.add(new ObjectDescriptor(new ObjectId(this.type, (Object)uid), o, false));
                }
                if (this.parentMeta == null || (cde = cache.getData(parent, 0)) == null) break block11;
                Map data = null;
                try {
                    data = this.parseJson(parent, cde.getData());
                }
                catch (JsonException ex) {
                    L.error("Read entity error.", (Throwable)ex);
                }
                if (data == null) {
                    L.error("Can't parse data: " + data);
                } else {
                    odl.add(new ObjectDescriptor(new ObjectId(this.parentMeta, (Object)""), (Object)data, false));
                }
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
        return odl;
    }

    public ObjectDescriptor notify(CacheEvent e, LocalCache cache) {
        String[] segs;
        String node = e.getNode();
        String parent = ZkPath.join((String)this.root, (String[])new String[]{this.type});
        String relative = ZkPath.relative((String)parent, (String)node);
        String id = null;
        String entityRoot = null;
        ObjectDescriptor od = null;
        if (relative != null && (segs = ZkPath.split((String)relative)).length == 2 && segs[1].equals(this.syncNode)) {
            String compoundEntityId = segs[0];
            id = compoundEntityId.replace(this.prefix, "");
            entityRoot = ZkPath.join((String)parent, (String[])new String[]{compoundEntityId});
        }
        if (id != null) {
            UUID uid = null;
            try {
                uid = UUID.fromString(id);
            }
            catch (IllegalArgumentException ex) {
                L.error(String.format("Parse path: %s; invalid uuid: %s", node, id));
            }
            if (uid != null) {
                NodeAvailableEvent nae;
                Object o;
                if (e instanceof NodeDeletedEvent) {
                    od = new ObjectDescriptor(new ObjectId(this.type, (Object)uid), null, true);
                } else if (e instanceof NodeAvailableEvent && (o = this.readEntity(cache, entityRoot, uid, (nae = (NodeAvailableEvent)e).getData().getTxid())) != null) {
                    od = new ObjectDescriptor(new ObjectId(this.type, (Object)uid), o, false);
                }
            }
        }
        return od;
    }

    private Object readEntity(LocalCache cache, String path, UUID uid, long txid) {
        L.trace("Read entity from: {}", (Object)path);
        HashMap<String, Map> objectData = new HashMap<String, Map>();
        boolean abort = false;
        for (String child : this.childNodes) {
            String absChild = ZkPath.join((String)path, (String[])new String[]{child});
            CacheDataEntry cde = null;
            cde = cache.getData(absChild, 0);
            if (cde == null) {
                cde = cache.getData(absChild, 1);
            }
            if (cde == null) {
                L.error("Path not found: {}", (Object)absChild);
                abort = true;
                break;
            }
            if (cde.getTxid() > txid) {
                L.error("Path data changed: {}", (Object)absChild);
                abort = true;
                break;
            }
            Map childData = this.parseJson(absChild, cde.getData());
            if (childData == null) {
                L.error("Can't parse data: {}", (Object)absChild);
                abort = true;
                break;
            }
            objectData.put(child, childData);
        }
        if (!abort) {
            L.trace("Entity read from: {}", (Object)path);
            return new GenericEntityImpl(uid, objectData, this.type, this.adapterFactory);
        }
        return null;
    }

    public Map parseJson(String path, byte[] data) {
        Map metadata = null;
        if (data != null) {
            try {
                metadata = (Map)JsonParser.parseJson((Reader)new StringReader(new String(data, "utf8")));
            }
            catch (UnsupportedEncodingException ex) {
                throw new JsonException("", (Throwable)ex);
            }
        } else {
            L.debug("null data not parsed!");
        }
        return metadata;
    }
}

