/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.service;

import com.ez.eclient.service.EntityAdapterFactory;
import com.ez.eclient.service.IAppLogger;
import com.ez.eclient.service.ObjectMapperImpl;
import com.ez.eclient.service.database.impl.GenericEntityImpl;
import com.ez.keeper.binding.ObjectListener;
import com.ez.keeper.binding.ObjectMapper;
import com.ez.keeper.binding.ObjectSession;
import com.ez.keeper.binding.impl.DefaultObjectSession;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.ZkSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAbstractService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(DefaultAbstractService.class);
    static final String ENTITY_SYNC_NODE = "ez_sync";
    protected static final String ALL_CHILD_METADATA = "metadata";
    protected String rootPath;
    protected IAppLogger logger;
    protected ObjectSession objectSession;
    protected ZkSession session;
    protected EntityAdapterFactory adapterFactory;
    protected boolean started = false;

    public DefaultAbstractService() {
    }

    public DefaultAbstractService(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        this.init(session, environmentId, logger, adapterFactory);
    }

    protected void init(ZkSession session, String environmentId, IAppLogger logger, EntityAdapterFactory adapterFactory) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        if (environmentId == null) {
            throw new IllegalArgumentException("environmentId");
        }
        this.rootPath = "/ez/ad/environment/environment-" + environmentId;
        this.adapterFactory = adapterFactory;
        this.session = session;
        if (logger == null) {
            logger = new IAppLogger(){

                @Override
                public void info(String message) {
                }

                @Override
                public void error(String message) {
                }

                @Override
                public void error(String message, Throwable t) {
                }
            };
        }
        this.logger = logger;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("Service already started.");
        }
        this.objectSession = new DefaultObjectSession(this.session);
        try {
            this.objectSession.registerListener(this.getDispatcherListener());
            this.registerObjects();
            this.started = true;
        }
        finally {
            if (!this.started) {
                try {
                    this.objectSession.close();
                }
                catch (Exception ex) {
                    L.error("Can't close session.", (Throwable)ex);
                }
            }
        }
        L.info("{} service started.", (Object)this.getClass().getName());
    }

    protected abstract void registerObjects();

    protected abstract ObjectListener getDispatcherListener();

    protected void registerObject(String type, List<String> childNodes, String parentMeta) {
        String path = ZkPath.join((String)this.rootPath, (String[])new String[]{type});
        this.objectSession.registerObjectMapper(type, path, (ObjectMapper)new ObjectMapperImpl(this.rootPath, type, type + "-", childNodes, ENTITY_SYNC_NODE, this.adapterFactory, parentMeta));
    }

    protected void registerObject(String type, List<String> childNodes) {
        this.registerObject(type, childNodes, null);
    }

    protected Map<UUID, Object> getEntitiesFromData(Map<UUID, GenericEntityImpl> data) {
        HashMap<UUID, Object> r = new HashMap<UUID, Object>();
        if (data != null) {
            for (GenericEntityImpl e : data.values()) {
                r.put(e.getId(), e.getAdapter() != null ? e.getAdapter() : e);
            }
        }
        return r;
    }

    public synchronized void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean releaseSession) {
        if (!this.started) {
            throw new IllegalStateException("Service not started.");
        }
        try {
            this.objectSession.close();
        }
        catch (Exception ex) {
            L.error("Can't stop object session.", (Throwable)ex);
        }
        finally {
            this.objectSession = null;
            this.started = false;
        }
        if (releaseSession) {
            try {
                this.session.release();
            }
            catch (Exception ex) {
                L.error("Can't release ccs session.", (Throwable)ex);
            }
            finally {
                this.session = null;
                this.started = false;
            }
        }
        L.info("{} service stopped.", (Object)this.getClass().getName());
    }

    public synchronized boolean isStarted() {
        return this.started;
    }
}

