/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezsource.connection.manager;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionFactory;
import com.ez.ezsource.connection.EZSourceFactoryProvider;
import com.ez.ezsource.connection.EZSourceNotificationListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZSourceConnectionManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Logger L = LoggerFactory.getLogger(EZSourceConnectionManager.class);
    private static State STATE = State.Created;
    private static EZSourceConnectionFactory FACTORY = null;
    private static Properties FACTORY_PROP;
    private static EZSourceNotificationListener LISTENER;
    private static boolean ALLOW_REINIT;
    private static final Object FACTORY_GUARD;

    private EZSourceConnectionManager() {
    }

    public static void initialize(Properties connectionFactoryProperties) {
        EZSourceConnectionManager.initialize(connectionFactoryProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Properties connectionFactoryProperties, EZSourceNotificationListener notificationListener) {
        if (connectionFactoryProperties == null) {
            throw new IllegalArgumentException("connectionFactoryProperties");
        }
        Object object = FACTORY_GUARD;
        synchronized (object) {
            if (STATE != State.Created) {
                throw new IllegalStateException(String.format("%s, expected %s.", new Object[]{STATE, State.Created}));
            }
            FACTORY_PROP = connectionFactoryProperties;
            LISTENER = notificationListener;
            ALLOW_REINIT = false;
            STATE = State.Initialized;
            L.debug(String.format("initialize(): %s", new Object[]{STATE}));
            EZSourceConnectionManager.initFactory();
            STATE = State.FactoryInitialized;
            L.debug(String.format("initialize(): %s", new Object[]{STATE}));
        }
    }

    public static void uninitialize() {
        EZSourceConnectionManager.uninitialize(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninitialize(boolean allowReinit) {
        Object object = FACTORY_GUARD;
        synchronized (object) {
            if (STATE == State.Shutdown) {
                L.debug(String.format("initialize(): %s, nothing to do.", new Object[]{STATE}));
            } else {
                if (STATE != State.Initialized && STATE != State.FactoryInitialized && STATE != State.WaitFactoryClose) {
                    throw new IllegalStateException(String.format("%s, expected %s, %s or %s", new Object[]{STATE, State.Initialized, State.FactoryInitialized, State.WaitFactoryClose}));
                }
                ALLOW_REINIT = allowReinit;
                if (STATE == State.Initialized) {
                    STATE = allowReinit ? State.Created : State.Shutdown;
                    L.debug(String.format("uninitialize(%s): State: %s", new Object[]{ALLOW_REINIT, STATE}));
                } else if (STATE == State.FactoryInitialized) {
                    try {
                        FACTORY.uninitialize();
                    }
                    catch (Exception ex) {
                        L.error("Can't clean up the factory.", (Throwable)ex);
                    }
                    if (FACTORY.isClosed()) {
                        FACTORY = null;
                        STATE = allowReinit ? State.Created : State.Shutdown;
                        L.debug(String.format("uninitialize(%s): State: %s", new Object[]{ALLOW_REINIT, STATE}));
                    } else {
                        STATE = State.WaitFactoryClose;
                        L.debug(String.format("uninitialize(%s): State: %s", new Object[]{ALLOW_REINIT, STATE}));
                    }
                } else if (STATE == State.WaitFactoryClose) {
                    L.debug(String.format("uninitialize(%s): already %s, do nothing.", new Object[]{ALLOW_REINIT, STATE}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EZSourceConnection getCurrent() {
        Object object = FACTORY_GUARD;
        synchronized (object) {
            if (STATE != State.Initialized && STATE != State.FactoryInitialized) {
                throw new IllegalStateException(String.format("%s, expected %s or %s.", new Object[]{STATE, State.Initialized, State.FactoryInitialized}));
            }
            if (STATE == State.Initialized) {
                EZSourceConnectionManager.initFactory();
                STATE = State.FactoryInitialized;
                L.debug(String.format("getCurrent(): %s", new Object[]{STATE}));
            }
            return FACTORY.getCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(EZSourceConnection connection) {
        Object object = FACTORY_GUARD;
        synchronized (object) {
            if (STATE != State.FactoryInitialized && STATE != State.WaitFactoryClose) {
                throw new IllegalStateException(String.format("%s, expected %s or %s.", new Object[]{STATE, State.FactoryInitialized, State.WaitFactoryClose}));
            }
            EZSourceConnectionFactory factory = FACTORY;
            factory.release(connection);
            if (factory.isClosed()) {
                FACTORY = null;
                if (STATE == State.WaitFactoryClose) {
                    STATE = ALLOW_REINIT ? State.Initialized : State.Shutdown;
                } else if (STATE == State.FactoryInitialized) {
                    STATE = State.Initialized;
                }
                L.debug(String.format("release(): %s", new Object[]{STATE}));
            } else {
                L.debug(String.format("release(): factory still alive, state unchanged: %s", new Object[]{STATE}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EZSourceConnectionFactory getFactory() {
        Object object = FACTORY_GUARD;
        synchronized (object) {
            return FACTORY;
        }
    }

    private static void initFactory() {
        EZSourceFactoryProvider factoryProvider = null;
        EZSourceConnectionFactory factory = null;
        String providerClass = FACTORY_PROP.getProperty("factoryProviderClass");
        if (providerClass == null) {
            providerClass = "com.ez.ezsource.connection.remote.EZSourceRemoteFactoryProvider";
        }
        try {
            factoryProvider = (EZSourceFactoryProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate connection factory provider", e);
        }
        factory = factoryProvider.createFactory(FACTORY_PROP);
        factory.initialize();
        if (LISTENER != null) {
            factory.addListener(LISTENER);
        }
        FACTORY = factory;
    }

    static {
        FACTORY_GUARD = new Object();
    }

    private static enum State {
        Created,
        Initialized,
        FactoryInitialized,
        WaitFactoryClose,
        Shutdown;

    }
}

