/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.synchro.service;

import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import com.ez.eclient.configuration.synchro.service.PropertiesInterceptor;
import java.util.regex.Pattern;

public class ConfigurationDescription {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected final String mirrorLocation;
    protected final String localFile;
    protected final ConfigurationFormat format;
    protected final String uniqueId;
    protected final String namespace;
    protected final boolean isHotSwappable;
    final String categoryName;
    final String categoryShortName;
    private PropertiesInterceptor intercept;
    private static final Pattern PATTERN_ID = Pattern.compile("[^./]+([.][^./]+)*");

    public ConfigurationDescription(String uniqueId, String namespace, String mirrorLocation, String localFile, ConfigurationFormat format, boolean isHotSwappable, String categoryName, String categoryShortName) {
        if (uniqueId == null) {
            throw new IllegalArgumentException("uniqueId is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is null");
        }
        if (format == null) {
            throw new IllegalArgumentException("format is null");
        }
        if (categoryName == null) {
            throw new IllegalArgumentException("categoryName is null");
        }
        if (categoryShortName == null) {
            throw new IllegalArgumentException("categoryShortName is null");
        }
        this.uniqueId = uniqueId;
        this.namespace = namespace;
        this.localFile = localFile;
        this.mirrorLocation = mirrorLocation;
        this.format = format;
        this.isHotSwappable = isHotSwappable;
        this.categoryName = categoryName;
        this.categoryShortName = categoryShortName;
    }

    public ConfigurationDescription(String uniqueId, String namespace, String mirrorLocation, String localFile, ConfigurationFormat format, boolean isHotSwappable, String categoryName, String categoryShortName, PropertiesInterceptor configInterceptor) {
        this(uniqueId, namespace, mirrorLocation, localFile, format, isHotSwappable, categoryName, categoryShortName);
        this.intercept = configInterceptor;
    }

    public static boolean validateUniqueId(String uniqueId) {
        return PATTERN_ID.matcher(uniqueId).matches();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getMirrorLocation() {
        return this.mirrorLocation;
    }

    public String getLocalFile() {
        return this.localFile;
    }

    public ConfigurationFormat getFormat() {
        return this.format;
    }

    public boolean isHotSwappable() {
        return this.isHotSwappable;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getCategoryShortName() {
        return this.categoryShortName;
    }

    public PropertiesInterceptor getConfigurationInterceptor() {
        return this.intercept;
    }

    public ConfigurationDescription copy(String mirrorLocation) {
        ConfigurationDescription desc = new ConfigurationDescription(this.getUniqueId(), this.getNamespace(), mirrorLocation, this.getLocalFile(), this.getFormat(), this.isHotSwappable(), this.getCategoryName(), this.getCategoryShortName());
        if (this.intercept != null) {
            desc.intercept = this.intercept;
        }
        return desc;
    }
}

