/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.resolutions.model;

import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resolution {
    private static final Logger L = LoggerFactory.getLogger(Resolution.class);
    public static final Integer CONTEXT_SEQUENCE_DEFAULT_VALUE = new Integer(1);
    public static final Integer DEFAULT_PROGRAM_TYPE = new Integer(1);
    public static final String COMPILER_USER = "";
    public static final String EMPTY_STR = "@@EZ_EMPTY_STR@@";
    public static final String SEPARATOR = "|";
    public static final String INSIDE_VALUES_SEPARATOR = ":";
    public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd' 'HH:mm:ss");
    public String path;
    public Integer line;
    public Integer stmtType;
    public Integer resType;
    public int index = -1;
    public int priority = 0;
    public Set<ValuesTriplet<String, Integer, String>> values = new HashSet<ValuesTriplet<String, Integer, String>>();
    public String contextName;
    public String contextPath;
    public Integer contextSeq = CONTEXT_SEQUENCE_DEFAULT_VALUE;
    public Date creationDate;
    boolean manual = false;
    protected boolean solved = true;
    public static final String VALUES_SEPARATOR = ";";

    public String generateDefinition() {
        return this.generateDefinition(SEPARATOR, EMPTY_STR);
    }

    public String generateDefinition(String separator, String emptyStr) {
        StringBuilder buff = new StringBuilder();
        if (this.path != null) {
            buff.append('\"');
            buff.append(this.path);
            buff.append('\"');
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        if (this.line != null) {
            buff.append(this.line);
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        if (this.stmtType != null) {
            buff.append(this.stmtType);
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        if (this.resType != null) {
            buff.append(this.resType);
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        buff.append(this.index);
        buff.append(separator);
        buff.append(this.priority);
        buff.append(separator);
        if (this.values != null && !this.values.isEmpty()) {
            buff.append("[");
            for (ValuesTriplet<String, Integer, String> p : this.values) {
                String val = p.getFirst();
                Integer valType = p.getSecond();
                String ancestor = p.getThird();
                buff.append(val);
                buff.append(INSIDE_VALUES_SEPARATOR);
                if (valType == null) {
                    buff.append(DEFAULT_PROGRAM_TYPE);
                } else {
                    buff.append(valType);
                }
                if (ancestor != null && !ancestor.isEmpty()) {
                    buff.append(INSIDE_VALUES_SEPARATOR);
                    buff.append(ancestor);
                }
                buff.append(VALUES_SEPARATOR);
            }
            buff = buff.deleteCharAt(buff.length() - 1);
            buff.append("]");
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        if (this.contextName != null) {
            buff.append(this.contextName);
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        if (this.contextPath != null) {
            buff.append('\"');
            buff.append(this.contextPath);
            buff.append('\"');
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        if (this.contextSeq != null) {
            buff.append(this.contextSeq);
        } else {
            buff.append(emptyStr);
        }
        buff.append(separator);
        buff.append(this.isManual());
        buff.append(separator);
        buff.append(this.isSolved());
        if (this.creationDate != null) {
            buff.append(separator);
            buff.append(sdf.format(this.creationDate));
        } else {
            buff.append(emptyStr);
        }
        return buff.toString();
    }

    public boolean isSolved() {
        return this.solved;
    }

    public boolean isManual() {
        return this.manual;
    }

    public String toString() {
        return this.generateDefinition();
    }

    public ResolutionType getType() {
        return this.isManual() ? ResolutionType.MANUALLY_RESOLVED : (this.isSolved() ? ResolutionType.AUTOMATICALLY_RESOLVED : ResolutionType.NOT_RESOLVED);
    }

    public boolean equalNoValues(Resolution other) {
        if (this.contextName == null ? other.contextName != null : !this.contextName.equals(other.contextName)) {
            return false;
        }
        if (this.contextPath == null ? other.contextPath != null : !this.contextPath.equals(other.contextPath)) {
            return false;
        }
        if (this.contextSeq == null ? other.contextSeq != null : !this.contextSeq.equals(other.contextSeq)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
            return false;
        }
        if (this.manual != other.manual) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.resType == null ? other.resType != null : !this.resType.equals(other.resType)) {
            return false;
        }
        if (this.solved != other.solved) {
            return false;
        }
        return !(this.stmtType == null ? other.stmtType != null : !this.stmtType.equals(other.stmtType));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contextName == null ? 0 : this.contextName.hashCode());
        result = 31 * result + (this.contextPath == null ? 0 : this.contextPath.hashCode());
        result = 31 * result + (this.contextSeq == null ? 0 : this.contextSeq.hashCode());
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.resType == null ? 0 : this.resType.hashCode());
        result = 31 * result + (this.solved ? 1231 : 1237);
        result = 31 * result + (this.stmtType == null ? 0 : this.stmtType.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resolution other = (Resolution)obj;
        if (this.contextName == null ? other.contextName != null : !this.contextName.equals(other.contextName)) {
            return false;
        }
        if (this.contextPath == null ? other.contextPath != null : !this.contextPath.equals(other.contextPath)) {
            return false;
        }
        if (this.contextSeq == null ? other.contextSeq != null : !this.contextSeq.equals(other.contextSeq)) {
            return false;
        }
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.resType == null ? other.resType != null : !this.resType.equals(other.resType)) {
            return false;
        }
        if (this.solved != other.solved) {
            return false;
        }
        if (this.stmtType == null ? other.stmtType != null : !this.stmtType.equals(other.stmtType)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public static enum ResolutionType {
        NOT_RESOLVED{

            public String toString() {
                return "resolutionType.notResolved";
            }
        }
        ,
        AUTOMATICALLY_RESOLVED{

            public String toString() {
                return "resolutionType.automaticallyResolved";
            }
        }
        ,
        MANUALLY_RESOLVED{

            public String toString() {
                return "resolutionType.manual";
            }
        };

    }
}

