/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.gui.editresolutionanalysis;

import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.override.gui.ResolutionValuesComparator;
import com.ez.mainframe.override.gui.internal.Messages;
import com.ez.mainframe.override.resolutions.ResolutionsProxy;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowHistoryDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ShowHistoryDialog.class);
    Button btnChoose;
    Table tbl;
    Map<Date, JournalEntry> inpt;
    JournalEntry selected;
    EntryComparator comp = new EntryComparator();

    protected ShowHistoryDialog(Shell shell) {
        super(shell);
    }

    public ShowHistoryDialog(Shell shell, Map<Date, JournalEntry> resrs) {
        this(shell);
        this.inpt = resrs;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        if (this.inpt != null) {
            ArrayList<JournalEntry> tmp = new ArrayList<JournalEntry>(this.inpt.values());
            Collections.sort(tmp, this.comp);
            JournalEntry prevRes = null;
            for (JournalEntry entry : tmp) {
                Resolution r = entry.resolution;
                boolean showIt = true;
                if (prevRes != null && !prevRes.resolution.isManual() && !r.isManual() && prevRes.user.equals(entry.user) && "".equals(entry.user)) {
                    showIt = false;
                    break;
                }
                if (!showIt) continue;
                TableItem itm = new TableItem(this.tbl, 0);
                String date = "";
                if (r.creationDate != null) {
                    date = Resolution.sdf.format(entry.date);
                }
                itm.setText(0, date);
                itm.setText(1, ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)r.getType()));
                itm.setText(2, entry.user);
                itm.setData((Object)entry);
                prevRes = entry;
            }
        }
        this.btnChoose.setEnabled(this.tbl.getSelectionCount() > 0);
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(2, false));
        this.tbl = new Table(container, 67588);
        this.tbl.setHeaderVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 150;
        gd.minimumWidth = 250;
        this.tbl.setLayoutData((Object)gd);
        TableColumn c1 = new TableColumn(this.tbl, 16384);
        c1.setText(Messages.getString(ShowHistoryDialog.class, "column.date"));
        c1.setWidth(150);
        TableColumn c2 = new TableColumn(this.tbl, 0x1000000);
        c2.setText(Messages.getString(ShowHistoryDialog.class, "column.type"));
        c2.setWidth(90);
        TableColumn c3 = new TableColumn(this.tbl, 16384);
        c3.setText(Messages.getString(ShowHistoryDialog.class, "column.user"));
        c3.setWidth(70);
        final List lstValues = new List(container, 2820);
        gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 150;
        gd.minimumWidth = 220;
        lstValues.setToolTipText(Messages.getString(ShowHistoryDialog.class, "values.tooltip"));
        lstValues.setLayoutData((Object)gd);
        this.tbl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] itm = ShowHistoryDialog.this.tbl.getSelection();
                ShowHistoryDialog.this.selected = (JournalEntry)itm[0].getData();
                lstValues.removeAll();
                ArrayList tmp = new ArrayList(ShowHistoryDialog.this.selected.resolution.values);
                Collections.sort(tmp, new ResolutionValuesComparator());
                for (ValuesTriplet p : tmp) {
                    Integer prgType;
                    ProgramType t;
                    String val = (String)p.getFirst();
                    String ancestor = (String)p.getThird();
                    if (ancestor != null && !ancestor.isEmpty()) {
                        val = String.valueOf(ancestor) + ":" + val;
                    }
                    if ((t = ProgramType.fromID((Integer)(prgType = (Integer)p.getSecond()))) == null && prgType == -1) {
                        t = ProgramType.UNKNOWN;
                    }
                    String valTypeStr = t.name();
                    String tmpVal = Messages.getString(ShowHistoryDialog.class, "value.text", new String[]{val, valTypeStr});
                    lstValues.add(tmpVal);
                }
                ShowHistoryDialog.this.btnChoose.setEnabled(ShowHistoryDialog.this.tbl.getSelectionCount() > 0);
            }
        });
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = Messages.getString(ShowHistoryDialog.class, "dialog.title");
        newShell.setText(title);
        newShell.setMinimumSize(500, 250);
        newShell.setSize(550, 350);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnChoose = this.createButton(parent, 0, Messages.getString(ShowHistoryDialog.class, "dialog.okButton"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public JournalEntry getSelected() {
        return this.selected;
    }

    class EntryComparator
    implements Comparator<JournalEntry> {
        EntryComparator() {
        }

        @Override
        public int compare(JournalEntry arg0, JournalEntry arg1) {
            int ret = 0;
            if (arg0.rank != -1 && arg1.rank != -1 && (ret = Integer.compare(arg0.rank, arg1.rank)) == 0) {
                L.warn("two entries with the same rank?! it will be ordered by date");
            }
            if (ret == 0) {
                ret = arg0.date.compareTo(arg1.date);
            }
            return -ret;
        }
    }
}

