/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.gui.editresolutionanalysis;

import com.ez.graphs.viewer.odb.utils.ResolutionUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDynamicCall;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.mainframe.override.gui.ResolutionValuesComparator;
import com.ez.mainframe.override.gui.editresolutionanalysis.ShowHistoryDialog;
import com.ez.mainframe.override.gui.internal.Activator;
import com.ez.mainframe.override.gui.internal.Messages;
import com.ez.mainframe.override.gui.utils.ProgressDialogWithoutCancelBtn;
import com.ez.mainframe.override.resolutions.ResolutionException;
import com.ez.mainframe.override.resolutions.ResolutionsProxy;
import com.ez.mainframe.override.resolutions.model.CompilerResolution;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.mainframe.override.resolutions.model.UserAssistedResolution;
import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideResolutionDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(OverrideResolutionDialog.class);
    private static final int DIALOG_MIN_WIDTH = 580;
    private static final int DIALOG_MIN_HEIGHT = 450;
    private static final Image WARN_MESSAGE_IMAGE = Activator.getImageDescriptor("icons/Error.png").createImage();
    private static final Image INFO_MESSAGE_IMAGE = Activator.getImageDescriptor("icons/warn_16x16.png").createImage();
    private static final Integer resType = new Integer(5);
    private static final Integer idx = Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE;
    private Button btnAddResolution;
    private Text txtDefLine;
    private Text txtDefPath;
    private Text txtCtxPath;
    private Text txtCtxName;
    private Text txtDefStmt;
    private org.eclipse.swt.widgets.List lstValues;
    private Text txtAddAncestor;
    private Text txtAddVal;
    private Button addValue;
    private Button remValue;
    private Button btnReset;
    private Label lblRes;
    private Button btnHistory;
    private Combo cmbType;
    private Button btnNested;
    private Label lblMsgTxt;
    private Label lblMsgIcon;
    EZSourceDynamicCall input;
    JournalEntry currentEntry;
    JournalEntry revertedEntry;
    private ProjectInfo pInfo;
    private Data data;

    public OverrideResolutionDialog(Shell shell, EZSourceDynamicCall inpt, Data data) {
        super(shell);
        this.input = inpt;
        this.data = data;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout lay = new GridLayout(3, false);
        container.setLayout((Layout)lay);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Group contextGr = new Group(container, 0);
        contextGr.setText(Messages.getString(OverrideResolutionDialog.class, "context.group.title"));
        contextGr.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        contextGr.setLayoutData((Object)gd);
        lay = new GridLayout(4, false);
        contextGr.setLayout((Layout)lay);
        Label lbl = new Label((Composite)contextGr, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "context.name.label"));
        this.txtCtxName = new Text((Composite)contextGr, 2048);
        this.txtCtxName.setEditable(false);
        gd = new GridData();
        gd.widthHint = 140;
        this.txtCtxName.setLayoutData((Object)gd);
        lbl = new Label((Composite)contextGr, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "context.path.label"));
        this.txtCtxPath = new Text((Composite)contextGr, 2048);
        this.txtCtxPath.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtCtxPath.setLayoutData((Object)gd);
        Group defGr = new Group(container, 0);
        defGr.setText(Messages.getString(OverrideResolutionDialog.class, "definition.group.title"));
        defGr.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        defGr.setLayoutData((Object)gd);
        lay = new GridLayout(6, false);
        defGr.setLayout((Layout)lay);
        lbl = new Label((Composite)defGr, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "definition.path.label"));
        this.txtDefPath = new Text((Composite)defGr, 2048);
        this.txtDefPath.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtDefPath.setLayoutData((Object)gd);
        lbl = new Label((Composite)defGr, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "definition.line.label"));
        this.txtDefLine = new Text((Composite)defGr, 2048);
        this.txtDefLine.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtDefLine.setLayoutData((Object)gd);
        lbl = new Label((Composite)defGr, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "definition.statementType.label"));
        this.txtDefStmt = new Text((Composite)defGr, 2048);
        this.txtDefStmt.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtDefStmt.setLayoutData((Object)gd);
        this.lblRes = new Label(container, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.lblRes.setLayoutData((Object)gd);
        Composite currentRes = new Composite(container, 0);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000008;
        currentRes.setLayoutData((Object)gd);
        GridLayout glayout = new GridLayout(2, false);
        currentRes.setLayout((Layout)glayout);
        this.btnReset = new Button(currentRes, 8);
        this.btnReset.setText(Messages.getString(OverrideResolutionDialog.class, "reset.button"));
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.horizontalAlignment = 0x1000008;
        this.btnReset.setLayoutData((Object)gd);
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideResolutionDialog.this.showCurrentResolution();
            }
        });
        this.btnHistory = new Button(currentRes, 8);
        this.btnHistory.setText(Messages.getString(OverrideResolutionDialog.class, "showHistory.button"));
        gd = new GridData();
        gd.horizontalIndent = 5;
        gd.horizontalAlignment = 0x1000008;
        this.btnHistory.setLayoutData((Object)gd);
        this.btnHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (OverrideResolutionDialog.this.input != null) {
                    OverrideResolutionDialog.this.showHistory();
                }
            }
        });
        lbl = new Label(container, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "values.list.label"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.verticalIndent = 3;
        gd.horizontalIndent = 3;
        lbl.setLayoutData((Object)gd);
        this.lstValues = new org.eclipse.swt.widgets.List(container, 2562);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 200;
        gd.heightHint = 100;
        this.lstValues.setLayoutData((Object)gd);
        this.lstValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideResolutionDialog.this.remValue.setEnabled(OverrideResolutionDialog.this.lstValues.getSelectionCount() > 0);
            }
        });
        Composite rightComp = new Composite(container, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        rightComp.setLayoutData((Object)gd);
        glayout = new GridLayout(2, false);
        glayout.marginTop = -5;
        glayout.marginBottom = -5;
        rightComp.setLayout((Layout)glayout);
        Composite btnComp = new Composite(rightComp, 0);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        btnComp.setLayoutData((Object)gd);
        glayout = new GridLayout();
        btnComp.setLayout((Layout)glayout);
        this.addValue = new Button(btnComp, 8);
        this.addValue.setImage(Activator.getImageDescriptor("icons/add.png").createImage());
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 1;
        this.addValue.setLayoutData((Object)gd);
        this.addValue.setEnabled(false);
        this.addValue.setToolTipText(Messages.getString(OverrideResolutionDialog.class, "addValue.button.tooltip"));
        this.addValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String val = OverrideResolutionDialog.this.txtAddVal.getText();
                String ancestor = OverrideResolutionDialog.this.txtAddAncestor.getText();
                if (val != null && !val.isEmpty()) {
                    boolean added;
                    int i = OverrideResolutionDialog.this.cmbType.getSelectionIndex();
                    ProgramType t = (ProgramType)OverrideResolutionDialog.this.cmbType.getData("" + i);
                    if (!(ProgramType.ASSEMBLER_CSECT.equals((Object)t) || ProgramType.ASSEMBLER_ENTRY.equals((Object)t) || ProgramType.COBOL.equals((Object)t) || ProgramType.PL1.equals((Object)t))) {
                        ancestor = null;
                    }
                    if (ProgramType.COBOL.equals((Object)t) && (OverrideResolutionDialog.this.btnNested.isEnabled() && !OverrideResolutionDialog.this.btnNested.getSelection() || !OverrideResolutionDialog.this.btnNested.isEnabled())) {
                        ancestor = null;
                    }
                    if (added = OverrideResolutionDialog.this.addValue(val, ancestor, t.getProgramTypeId())) {
                        OverrideResolutionDialog.this.txtAddVal.setText("");
                        OverrideResolutionDialog.this.txtAddAncestor.setText("");
                    }
                }
                OverrideResolutionDialog.this.checkApplyAvailability();
            }
        });
        this.remValue = new Button(btnComp, 8);
        this.remValue.setImage(Activator.getImageDescriptor("icons/remove.png").createImage());
        this.remValue.setToolTipText(Messages.getString(OverrideResolutionDialog.class, "removeValue.button.tooltip"));
        this.remValue.setEnabled(this.lstValues.getSelectionCount() > 0);
        gd = new GridData(16384, 0x1000008, false, true);
        this.remValue.setLayoutData((Object)gd);
        this.remValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] idx = OverrideResolutionDialog.this.lstValues.getSelectionIndices();
                String[] toRem = OverrideResolutionDialog.this.lstValues.getSelection();
                OverrideResolutionDialog.this.lstValues.remove(idx);
                String[] stringArray = toRem;
                int n = toRem.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    OverrideResolutionDialog.this.lstValues.setData(val, null);
                    ++n2;
                }
                OverrideResolutionDialog.this.remValue.setEnabled(OverrideResolutionDialog.this.lstValues.getSelectionCount() > 0);
                OverrideResolutionDialog.this.checkApplyAvailability();
            }
        });
        this.createAddValueArea(rightComp);
        this.createMessagesArea(rightComp);
        return container;
    }

    private void createMessagesArea(Composite rightComp) {
        Group msgComp = new Group(rightComp, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        msgComp.setLayoutData((Object)gd);
        msgComp.setLayout((Layout)new GridLayout(2, false));
        this.lblMsgIcon = new Label((Composite)msgComp, 0);
        this.lblMsgIcon.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.lblMsgTxt = new Label((Composite)msgComp, 64);
        gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 200;
        this.lblMsgTxt.setLayoutData((Object)gd);
        this.clearMessages();
    }

    private void clearMessages() {
        if (this.lblMsgIcon != null) {
            this.lblMsgIcon.setImage(null);
            this.lblMsgTxt.setText("");
        }
    }

    private void showMessage(Message msg) {
        if (msg != null) {
            this.lblMsgIcon.setImage(msg.getImage());
            this.lblMsgTxt.setText(msg.text);
            this.lblMsgTxt.setForeground(msg.getTextColor());
            this.getContents().getParent().pack();
            this.lblMsgTxt.getParent().layout(true, true);
        }
    }

    private void createAddValueArea(Composite rightComp) {
        Group addValComp = new Group(rightComp, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        gd.grabExcessVerticalSpace = false;
        addValComp.setLayoutData((Object)gd);
        addValComp.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label((Composite)addValComp, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "txtValue.name.label"));
        this.txtAddVal = new Text((Composite)addValComp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtAddVal.setLayoutData((Object)gd);
        ProgNameVerifyListener progNameVerifier = new ProgNameVerifyListener();
        this.txtAddVal.addVerifyListener((VerifyListener)progNameVerifier);
        lbl = new Label((Composite)addValComp, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "txtValue.ancestor.label"));
        this.txtAddAncestor = new Text((Composite)addValComp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.txtAddAncestor.setLayoutData((Object)gd);
        this.txtAddAncestor.addVerifyListener((VerifyListener)progNameVerifier);
        lbl = new Label((Composite)addValComp, 0);
        lbl.setText(Messages.getString(OverrideResolutionDialog.class, "valueTypes.combo.label"));
        this.cmbType = new Combo((Composite)addValComp, 2056);
        this.cmbType.setToolTipText(Messages.getString(OverrideResolutionDialog.class, "valueTypes.combo.tooltip"));
        gd = new GridData();
        gd.widthHint = 180;
        gd.horizontalAlignment = 4;
        this.cmbType.setLayoutData((Object)gd);
        this.cmbType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = OverrideResolutionDialog.this.cmbType.getSelectionIndex();
                ProgramType t = (ProgramType)OverrideResolutionDialog.this.cmbType.getData("" + i);
                if (ProgramType.ASSEMBLER_CSECT.equals((Object)t) || ProgramType.ASSEMBLER_ENTRY.equals((Object)t) || ProgramType.PL1.equals((Object)t)) {
                    OverrideResolutionDialog.this.txtAddAncestor.setEnabled(true);
                } else {
                    OverrideResolutionDialog.this.txtAddAncestor.setEnabled(false);
                }
                OverrideResolutionDialog.this.checkNestedEnabled();
                OverrideResolutionDialog.this.btnNested.setSelection(false);
                OverrideResolutionDialog.this.checkNestedSelection();
                OverrideResolutionDialog.this.checkAddValue(null, null);
            }
        });
        this.btnNested = new Button((Composite)addValComp, 32);
        this.btnNested.setText(Messages.getString(OverrideResolutionDialog.class, "btnCblNested.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        this.btnNested.setLayoutData((Object)gd);
        this.btnNested.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverrideResolutionDialog.this.checkNestedSelection();
            }
        });
        this.fillComboTypes();
    }

    private void fillComboTypes() {
        if (this.pInfo != null && this.cmbType.getItemCount() < 1) {
            List<ProgramType> tmp = Arrays.asList(ProgramType.values());
            Collections.sort(tmp, new Comparator<ProgramType>(){

                @Override
                public int compare(ProgramType o1, ProgramType o2) {
                    return o1.name().compareToIgnoreCase(o2.name());
                }
            });
            List ls = (List)this.pInfo.getInfo().get("languages");
            int k = 0;
            int defSelection = 0;
            for (ProgramType t : tmp) {
                if (!ls.contains(t.name()) && !t.equals((Object)ProgramType.UNKNOWN)) continue;
                if (ProgramType.ASSEMBLER.equals((Object)t)) {
                    this.cmbType.add(ProgramType.ASSEMBLER_CSECT.name());
                    this.cmbType.setData("" + k, (Object)ProgramType.ASSEMBLER_CSECT);
                    this.cmbType.add(ProgramType.ASSEMBLER_ENTRY.name());
                    this.cmbType.setData("" + ++k, (Object)ProgramType.ASSEMBLER_ENTRY);
                    ++k;
                    continue;
                }
                this.cmbType.add(t.name());
                this.cmbType.setData("" + k, (Object)t);
                if (ProgramType.COBOL.equals((Object)t)) {
                    defSelection = k;
                }
                ++k;
            }
            this.cmbType.select(defSelection);
            this.checkAddAncestorEnabled();
            this.checkNestedEnabled();
            this.btnNested.setSelection(false);
            this.checkNestedSelection();
        }
    }

    private void checkAddAncestorEnabled() {
        int i = this.cmbType.getSelectionIndex();
        ProgramType t = (ProgramType)this.cmbType.getData("" + i);
        boolean enabled = ProgramType.PL1.equals((Object)t) || ProgramType.ASSEMBLER_CSECT.equals((Object)t) || ProgramType.ASSEMBLER_ENTRY.equals((Object)t);
        this.txtAddAncestor.setEnabled(enabled);
    }

    private void checkNestedEnabled() {
        int i = this.cmbType.getSelectionIndex();
        ProgramType t = (ProgramType)this.cmbType.getData("" + i);
        boolean enabled = ProgramType.COBOL.equals((Object)t);
        if (enabled && this.currentEntry != null) {
            enabled = ProgramType.COBOL.getProgramTypeId() == this.currentEntry.programType.intValue() && (this.currentEntry.programAncestor == null || this.currentEntry.programAncestor.isEmpty());
        }
        this.btnNested.setEnabled(enabled);
    }

    private void showHistory() {
        Job j = Job.create((String)Messages.getString(OverrideResolutionDialog.class, "showHistory.jobname"), (IJobFunction)new IJobFunction(){

            public IStatus run(IProgressMonitor pmonitor) {
                Integer contextSeq;
                String ancestor;
                IStatus status = Status.OK_STATUS;
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
                EZObjectType objCtx = (EZObjectType)OverrideResolutionDialog.this.input.getProperty("call_context");
                EZSourceProgram prog = (EZSourceProgram)objCtx;
                String prgPath = (String)prog.getProperty("program_path");
                if (prgPath == null) {
                    Set context = (Set)objCtx.getProperty("FILE");
                    prgPath = ((TextSelectionInFile)context.iterator().next()).getFileName();
                }
                EZSourceProgramIDSg prgSg = prog != null && prog.getEntID() != null ? (EZSourceProgramIDSg)prog.getEntID().getSegment(EZSourceProgramIDSg.class) : null;
                String prgName = (String)prog.getProperty("program name");
                if (prgName == null && prgName == null) {
                    prgName = prgSg.getProgramName();
                }
                String string = ancestor = prgSg != null ? prgSg.getAncestorName() : null;
                if (ancestor != null && !ancestor.isEmpty()) {
                    prgName = String.valueOf(ancestor) + ":" + prgName;
                }
                if ((contextSeq = (Integer)OverrideResolutionDialog.this.input.getProperty("contextSeq")) == null) {
                    contextSeq = Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE;
                }
                String stmtTypeId = (String)OverrideResolutionDialog.this.input.getProperty("stmtTypeId");
                TextSelectionInFile definition = (TextSelectionInFile)OverrideResolutionDialog.this.input.getProperty("file");
                String defPath = definition.getFileName();
                int defLine = definition.getBounds()[0];
                try {
                    final Map resrs = ResolutionsProxy.getAllAppliedResolutions((ProjectInfo)OverrideResolutionDialog.this.pInfo, (String)defPath, (int)defLine, (int)new Integer(stmtTypeId), (Integer)resType, (Integer)idx, (String)prgName, (String)prgPath, (Integer)contextSeq);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ShowHistoryDialog dialog = new ShowHistoryDialog(OverrideResolutionDialog.this.getShell(), resrs);
                            dialog.create();
                            if (dialog.open() == 0) {
                                (this).OverrideResolutionDialog.this.revertedEntry = dialog.getSelected();
                                if ((this).OverrideResolutionDialog.this.revertedEntry != null) {
                                    OverrideResolutionDialog.this.showResolution((this).OverrideResolutionDialog.this.revertedEntry.resolution);
                                }
                            }
                        }
                    });
                }
                catch (RuntimeException ex) {
                    String msg = Messages.getString(OverrideResolutionDialog.class, "readResolutionHistory.exception");
                    if (ex instanceof ResolutionException) {
                        msg = ((ResolutionException)ex).getMessage();
                    }
                    LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
                    status = Status.CANCEL_STATUS;
                }
                monitor.done();
                return status;
            }
        });
        j.schedule();
    }

    private void showCurrentResolution() {
        this.showResolution(this.currentEntry != null ? this.currentEntry.resolution : null);
    }

    private void showResolution(Resolution res) {
        String resText = "";
        this.lstValues.removeAll();
        this.checkNestedEnabled();
        if (res != null) {
            String resolutionType = ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)res.getType());
            resText = Messages.getString(OverrideResolutionDialog.class, "resolutionType.label", new String[]{resolutionType});
            this.btnReset.setEnabled(true);
            this.btnHistory.setEnabled(true);
            ArrayList tmp = new ArrayList(res.values);
            Collections.sort(tmp, new ResolutionValuesComparator());
            for (ValuesTriplet p : tmp) {
                String name = (String)p.getFirst();
                Integer valType = (Integer)p.getSecond();
                String ancestor = (String)p.getThird();
                this.addValue(name, ancestor, valType);
            }
        } else {
            resText = Messages.getString(OverrideResolutionDialog.class, "resolutionType.label.none");
            this.btnReset.setEnabled(false);
            this.btnHistory.setEnabled(false);
        }
        this.lblRes.setText(resText);
        this.lblRes.getParent().layout(true, true);
        this.checkAddValue(null, null);
        this.checkApplyAvailability();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = Messages.getString(OverrideResolutionDialog.class, "dialog.title");
        newShell.setText(title);
        newShell.setMinimumSize(580, 450);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnAddResolution = this.createButton(parent, 0, Messages.getString(OverrideResolutionDialog.class, "dialog.okButton"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.fillUI();
        this.checkApplyAvailability();
        return c;
    }

    protected boolean isResizable() {
        return true;
    }

    public static Data prepareData(ProjectInfo pInfo, EZSourceDynamicCall input) {
        String defPath;
        Integer contextSeq;
        String prefix;
        String ancestor;
        Data data = new Data();
        EZObjectType objCtx = (EZObjectType)input.getProperty("call_context");
        EZSourceProgram prg = (EZSourceProgram)objCtx;
        String prgPath = (String)prg.getProperty("program_path");
        if (prgPath == null) {
            Set context = (Set)objCtx.getProperty("FILE");
            prgPath = ((TextSelectionInFile)context.iterator().next()).getFileName();
        }
        EZSourceProgramIDSg prgSg = prg != null && prg.getEntID() != null ? (EZSourceProgramIDSg)prg.getEntID().getSegment(EZSourceProgramIDSg.class) : null;
        String prgName = (String)prg.getProperty("program name");
        if (prgName == null && prgName == null) {
            prgName = prgSg.getProgramName();
        }
        String string = ancestor = prgSg != null ? prgSg.getAncestorName() : null;
        if (ancestor != null && !ancestor.isEmpty() && !prgName.startsWith(prefix = String.valueOf(ancestor) + ":")) {
            prgName = String.valueOf(prefix) + prgName;
        }
        if ((contextSeq = (Integer)input.getProperty("contextSeq")) == null) {
            contextSeq = Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE;
        }
        data.prgName = prgName;
        data.prgPath = prgPath;
        data.contextSeq = contextSeq;
        EZEntityID entID = input.getEntID();
        EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entID.getSegment(EZSourceProjectIDSg.class);
        data.pInfo = prjSg == null ? null : prjSg.getProjectInfo();
        data.pTypeId = prgSg == null ? null : prgSg.getTypeId();
        data.ancestor = ancestor;
        data.contextSid = prgSg == null ? null : prgSg.getProgramId().toString();
        String stmtTypeId = (String)input.getProperty("stmtTypeId");
        EZSourceMainframeNodeIdSg stmtSg = (EZSourceMainframeNodeIdSg)entID.getSegment(EZSourceMainframeNodeIdSg.class);
        StatementNode node = (StatementNode)stmtSg.getResNode();
        data.stmtDescription = node.getStatementDescription();
        data.stmtTypeId = stmtTypeId;
        TextSelectionInFile definition = (TextSelectionInFile)input.getProperty("file");
        data.defPath = defPath = definition.getFileName();
        int defLine = definition.getBounds()[0];
        data.defLine = defLine;
        data.currentEntry = ResolutionsProxy.getLastEntry((ProjectInfo)pInfo, (String)defPath, (int)defLine, (int)new Integer(stmtTypeId), (Integer)resType, (Integer)idx, (String)prgName, (String)prgPath, (Integer)contextSeq, (boolean)false);
        return data;
    }

    private void fillUI() {
        if (this.input != null) {
            this.txtCtxName.setText(this.data.prgName);
            this.txtCtxPath.setText(this.data.prgPath);
            this.pInfo = this.data.pInfo;
            this.fillComboTypes();
            this.txtDefStmt.setText(this.data.stmtDescription);
            this.txtDefStmt.setData((Object)this.data.stmtTypeId);
            this.txtDefPath.setText(this.data.defPath);
            this.txtDefLine.setText("" + this.data.defLine);
            this.currentEntry = this.data.currentEntry;
            if (this.currentEntry == null) {
                L.info("no compiler resolution find at defLine={} and defPath={}; a fake one is presented in dialog in order to let user create his own manual resolution instead", (Object)this.data.defLine, (Object)this.data.defPath);
                CompilerResolution compRes = new CompilerResolution(false);
                compRes.path = this.data.defPath;
                compRes.line = this.data.defLine;
                compRes.contextName = this.data.prgName;
                compRes.contextPath = this.data.prgPath;
                compRes.contextSeq = this.data.contextSeq;
                compRes.stmtType = new Integer(this.data.stmtTypeId);
                compRes.resType = resType;
                compRes.index = idx;
                compRes.values = new HashSet();
                compRes.creationDate = Calendar.getInstance().getTime();
                this.currentEntry = new JournalEntry();
                this.currentEntry.resolution = compRes;
                this.currentEntry.date = Calendar.getInstance().getTime();
                this.currentEntry.newValues = new HashSet();
                this.currentEntry.callLine = compRes.line;
                this.currentEntry.callPath = compRes.path;
                this.currentEntry.contextPath = compRes.contextPath;
                this.currentEntry.contextName = compRes.contextName;
                this.currentEntry.contextSeq = compRes.contextSeq;
                this.currentEntry.stmtType = compRes.stmtType;
                this.currentEntry.resType = compRes.resType;
                this.currentEntry.index = compRes.index;
                this.currentEntry.user = "";
                this.currentEntry.programType = this.data.pTypeId;
                this.currentEntry.programAncestor = this.data.ancestor;
                this.currentEntry.contextSid = this.data.contextSid;
            }
            this.showCurrentResolution();
        } else {
            this.cleanUI();
        }
    }

    private void cleanUI() {
        this.txtCtxName.setText("");
        this.txtCtxPath.setText("");
        this.txtDefPath.setText("");
        this.txtDefLine.setText("");
        this.txtDefStmt.setText("");
        this.txtDefStmt.setData(null);
        this.lstValues.removeAll();
        this.lstValues.setData(null);
    }

    private void checkApplyAvailability() {
        boolean available;
        boolean bl = available = this.currentEntry != null;
        if (available) {
            if (this.txtCtxPath.getText() != null && !this.txtCtxPath.getText().isEmpty() && this.txtDefPath.getText() != null && !this.txtDefPath.getText().isEmpty() && this.lstValues.getItemCount() < 1) {
                available = false;
            }
            if (available) {
                available = !this.checkValues(this.currentEntry.resolution.values);
            }
        }
        this.btnAddResolution.setEnabled(available);
    }

    private boolean checkValues(Set<ValuesTriplet<String, Integer, String>> values) {
        boolean eq;
        boolean bl = eq = this.lstValues.getItemCount() == values.size();
        if (eq) {
            eq = false;
            int i = 0;
            while (i < this.lstValues.getItemCount()) {
                String item = this.lstValues.getItem(i);
                ValuesTriplet guiValues = (ValuesTriplet)this.lstValues.getData(item);
                ValuesTriplet tmp = guiValues;
                eq = values.contains(tmp);
                if (!eq && (((Integer)tmp.getSecond()).equals(ProgramType.UNKNOWN.getProgramTypeId()) ? !(eq = values.contains(tmp = new ValuesTriplet((Object)((String)guiValues.getFirst()), (Object)-1, (Object)((String)guiValues.getThird())))) : !((Integer)tmp.getSecond()).equals(-1) || !(eq = values.contains(tmp = new ValuesTriplet((Object)((String)guiValues.getFirst()), (Object)0, (Object)((String)guiValues.getThird())))))) break;
                ++i;
            }
        }
        return eq;
    }

    protected void okPressed() {
        this.saveResolution();
        super.okPressed();
    }

    private void saveResolution() {
        final long startTime = System.currentTimeMillis();
        L.info("Apply resolution start time: {}", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        final TextSelectionInFile definition = (TextSelectionInFile)this.input.getProperty("file");
        final Integer prgType = this.getContextPrgType();
        final TSEEdge edge = (TSEEdge)this.input.getProperty("edge");
        final Resolution r = this.collectData();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor pmonitor) throws InvocationTargetException, InterruptedException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
                monitor.setTaskName(Messages.getString(OverrideResolutionDialog.class, "apply.resolution.task"));
                IStatus st = OverrideResolutionDialog.this.applyResolution(r, definition, prgType, edge, (IProgressMonitor)monitor.newChild(1));
                if (!st.isOK()) {
                    LogUtil.displayErrorMessage((Status)((Status)st), (boolean)false);
                }
                long duration = System.currentTimeMillis() - startTime;
                L.info("Apply resolution duration: {} ms.", (Object)duration);
            }
        };
        ProgressDialogWithoutCancelBtn pmd = new ProgressDialogWithoutCancelBtn(Display.getCurrent().getActiveShell());
        try {
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            L.error("error at applying resolution", (Throwable)e);
        }
        catch (InterruptedException e) {
            L.error("error at applying resolution", (Throwable)e);
        }
    }

    private Integer getContextPrgType() {
        Integer prgType = null;
        Object callContext = this.input.getProperty("call_context");
        EZEntityID prgID = ((EZObjectType)callContext).getEntID();
        if (prgID == null) {
            Set tf = (Set)((EZObjectType)callContext).getProperty("FILE");
            if (tf != null && !tf.isEmpty()) {
                try {
                    prgType = Integer.valueOf(((TextSelectionInFile)tf.iterator().next()).getPrgType());
                }
                catch (NumberFormatException ex) {
                    L.warn("wrong prog type", (Throwable)ex);
                }
            }
        } else {
            EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)prgID.getSegment(EZSourceProgramIDSg.class);
            if (prgSg != null) {
                prgType = prgSg.getTypeId();
            }
        }
        return prgType;
    }

    private IStatus applyResolution(Resolution r, TextSelectionInFile definition, Integer prgType, TSEEdge edge, IProgressMonitor pmonitor) {
        IStatus st = Status.OK_STATUS;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        String vertexId = (String)definition.getProperty("vertexID");
        L.debug("vertexid={}", (Object)vertexId);
        System.currentTimeMillis();
        monitor.worked(5);
        monitor.subTask(Messages.getString(OverrideResolutionDialog.class, "applying.resolution.subtask"));
        final boolean[] tryAgain = new boolean[]{true};
        while (tryAgain[0]) {
            int status = ResolutionUtils.applyResolution((ProjectInfo)this.pInfo, (String)vertexId, (Resolution)r, (String)(prgType != null ? prgType.toString() : definition.getPrgType()), (this.revertedEntry == null || r != this.revertedEntry.resolution ? 1 : 0) != 0, (IProgressMonitor)monitor.newChild(70));
            monitor.worked(70);
            if (status == 1) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        tryAgain[0] = MessageDialog.openQuestion((Shell)OverrideResolutionDialog.this.getShell(), (String)Messages.getString(OverrideResolutionDialog.class, "resolutionLock.dialog.title"), (String)Messages.getString(OverrideResolutionDialog.class, "resolutionLock.dialog.message"));
                    }
                });
                continue;
            }
            tryAgain[0] = false;
            if (status == 0 && !monitor.isCanceled()) {
                if (edge != null) {
                    edge.setAttribute("changedResolution", (Object)new Pair((Object)this.currentEntry.resolution, (Object)r));
                }
                monitor.done();
                continue;
            }
            L.info("resolution was not added");
            st = new Status(4, "com.ez.mainframe.override.gui", Messages.getString(OverrideResolutionDialog.class, "resolutionNotApplied.errorLog.message"));
        }
        return st;
    }

    private Resolution collectData() {
        UserAssistedResolution r = null;
        if (this.revertedEntry != null && this.checkValues(this.revertedEntry.resolution.values)) {
            r = this.revertedEntry.resolution;
        } else {
            r = new UserAssistedResolution();
            r.creationDate = Calendar.getInstance().getTime();
            r.contextPath = this.txtCtxPath.getText();
            r.contextName = this.txtCtxName.getText();
            Integer stmtOccurId = (Integer)this.input.getProperty("contextSeq");
            r.contextSeq = stmtOccurId != null ? stmtOccurId : Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE;
            r.path = this.txtDefPath.getText();
            r.line = new Integer(this.txtDefLine.getText());
            r.stmtType = new Integer((String)this.txtDefStmt.getData());
            r.resType = resType;
            r.index = idx;
            r.values = new HashSet();
            String[] stringArray = this.lstValues.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                ValuesTriplet oldValues = (ValuesTriplet)this.lstValues.getData(item);
                r.values.add(oldValues);
                ++n2;
            }
        }
        return r;
    }

    private boolean addValue(String progName, String progAncestor, Integer programType) {
        boolean added = false;
        Message msg = null;
        ProgramType t = ProgramType.fromID((Integer)programType);
        if (t == null && programType == -1) {
            t = ProgramType.UNKNOWN;
        }
        if (ProgramType.COBOL.equals((Object)t) && this.btnNested.getSelection()) {
            progAncestor = this.txtCtxName.getText();
        }
        String valStr = progName;
        if (progAncestor != null && !progAncestor.isEmpty()) {
            valStr = String.valueOf(progAncestor) + ":" + valStr;
        }
        String tmpVal = Messages.getString(OverrideResolutionDialog.class, "value.text", new String[]{valStr, t.name()});
        if (programType.intValue() == ProgramType.PL1.ordinal()) {
            progName = progAncestor != null ? progAncestor.concat(":").concat(progName) : progName;
            progAncestor = null;
        }
        if (!this.containsValue(progName, progAncestor, programType)) {
            this.lstValues.add(tmpVal);
            if (progAncestor != null && progAncestor.isEmpty()) {
                progAncestor = null;
            }
            this.lstValues.setData(tmpVal, (Object)new ValuesTriplet((Object)progName, (Object)programType, (Object)progAncestor));
            added = true;
        } else {
            msg = new Message(1, Messages.getString(OverrideResolutionDialog.class, "sameProgramName.warning.message"));
        }
        if (added) {
            msg = null;
            this.clearMessages();
        } else if (msg != null) {
            this.showMessage(msg);
        }
        return added;
    }

    private boolean containsValue(String progName, String progAncestor, Integer progType) {
        boolean ret = false;
        String[] stringArray = this.lstValues.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String itm = stringArray[n2];
            ValuesTriplet p = (ValuesTriplet)this.lstValues.getData(itm);
            ret = ((String)p.getFirst()).equalsIgnoreCase(progName);
            if (ret) break;
            ++n2;
        }
        return ret;
    }

    private void checkAddValue(String prgName, String ancestor) {
        int i;
        ProgramType t;
        boolean enabled;
        if (prgName == null) {
            prgName = this.txtAddVal.getText();
        }
        Message msg = null;
        boolean bl = enabled = prgName != null && !prgName.isEmpty();
        if (enabled && (ProgramType.ASSEMBLER_CSECT.equals((Object)(t = (ProgramType)this.cmbType.getData("" + (i = this.cmbType.getSelectionIndex())))) || ProgramType.ASSEMBLER_ENTRY.equals((Object)t) || ProgramType.PL1.equals((Object)t))) {
            if (ancestor == null) {
                ancestor = this.txtAddAncestor.getText();
            }
            if (ancestor != null && !ancestor.isEmpty()) {
                enabled = ancestor != null && !ancestor.isEmpty();
            } else {
                enabled = false;
                msg = new Message(1, Messages.getString(OverrideResolutionDialog.class, "addAncestor.warning.message"));
            }
        }
        if (enabled) {
            this.clearMessages();
        } else if (msg != null) {
            this.showMessage(msg);
        }
        this.addValue.setEnabled(enabled);
    }

    private void checkNestedSelection() {
        int i = this.cmbType.getSelectionIndex();
        ProgramType t = (ProgramType)this.cmbType.getData("" + i);
        if (ProgramType.COBOL.equals((Object)t)) {
            if (this.btnNested.getSelection()) {
                this.txtAddAncestor.setText(this.txtCtxName.getText());
                String msg = Messages.getString(OverrideResolutionDialog.class, "nestedCobol.info.message", new String[]{this.txtCtxName.getText()});
                this.showMessage(new Message(2, msg));
            } else {
                this.txtAddAncestor.setText("");
                this.clearMessages();
            }
        } else {
            this.txtAddAncestor.setText("");
            this.clearMessages();
        }
    }

    public static class Data {
        String prgName;
        String prgPath;
        ProjectInfo pInfo;
        String stmtDescription;
        String stmtTypeId;
        public String defPath;
        public Integer defLine;
        public JournalEntry currentEntry;
        public Integer contextSeq;
        public Integer pTypeId;
        public String ancestor;
        public String contextSid;
    }

    private final class Message {
        static final int WARN = 1;
        static final int INFO = 2;
        String text;
        int type = 0;

        public Message(int type, String string) {
            this.text = string;
            this.type = type;
        }

        public Image getImage() {
            Image img = null;
            switch (this.type) {
                case 1: {
                    img = WARN_MESSAGE_IMAGE;
                    break;
                }
                case 2: {
                    img = INFO_MESSAGE_IMAGE;
                }
            }
            return img;
        }

        public Color getTextColor() {
            Color c = OverrideResolutionDialog.this.lblMsgIcon.getForeground();
            switch (this.type) {
                case 1: {
                    c = OverrideResolutionDialog.this.lblMsgIcon.getDisplay().getSystemColor(3);
                }
            }
            return c;
        }
    }

    private final class ProgNameVerifyListener
    implements VerifyListener {
        private ProgNameVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            char[] ch = new char[]{',', ':', ';', '|', '[', ']', ' ', '\t', '\n', '\r', '\b', '\f', '\\', '\''};
            boolean found = false;
            char[] cArray = ch;
            int n = ch.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (e.text.indexOf(c) != -1) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) {
                e.doit = false;
            } else {
                e.text = e.text.toUpperCase().trim();
                String toCheck = null;
                boolean isPrg = true;
                if (e.widget.equals(OverrideResolutionDialog.this.txtAddVal) || e.widget.equals(OverrideResolutionDialog.this.txtAddAncestor)) {
                    toCheck = ((Text)e.widget).getText();
                    toCheck = String.valueOf(toCheck.substring(0, e.start)) + e.text + toCheck.substring(e.end);
                    if (e.widget.equals(OverrideResolutionDialog.this.txtAddAncestor)) {
                        isPrg = false;
                    }
                }
                if (toCheck != null) {
                    OverrideResolutionDialog.this.checkAddValue(isPrg ? toCheck : null, isPrg ? null : toCheck);
                }
            }
        }
    }
}

