/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.gui.editresolutionanalysis;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDynamicCall;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.utils.ShowSelectGoToSourceDialog;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.override.gui.editresolutionanalysis.OverrideResolutionDialog;
import com.ez.mainframe.override.gui.internal.Activator;
import com.ez.mainframe.override.gui.internal.Messages;
import com.ez.mainframe.override.resolutions.ResolutionException;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideResolutionAnalysis
extends AbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(OverrideResolutionAnalysis.class);

    protected void continueAnalysisForLocal() {
        Object infos = this.collectInfos();
        if (infos != null) {
            this.openWizard(infos);
        }
    }

    private void openWizard(Object infos) {
        EZSourceDynamicCall input = (EZSourceDynamicCall)infos;
        TextSelectionInFile location = null;
        Object locs = input.getProperty("file");
        if (locs instanceof Set) {
            Set locations = (Set)locs;
            if (locations.size() > 1) {
                ShowSelectGoToSourceDialog showSelectGoToSourceAction = new ShowSelectGoToSourceDialog(locations, Messages.getString(OverrideResolutionAnalysis.class, "chooseLocation.dialog.title"), Messages.getString(OverrideResolutionAnalysis.class, "chooseLocation.dialog.okButton"));
                Display.getDefault().syncExec((Runnable)showSelectGoToSourceAction);
                location = showSelectGoToSourceAction.getSelected();
            } else {
                location = (TextSelectionInFile)locations.iterator().next();
            }
        } else if (locs instanceof TextSelectionInFile) {
            location = (TextSelectionInFile)locs;
        }
        if (location != null) {
            final EZObjectType type = input.copy();
            type.setEntID(input.getEntID());
            Map props = input.getProperties();
            for (String p : props.keySet()) {
                type.addProperty(p, input.getProperty(p));
            }
            type.addProperty("file", (Object)location);
            EZEntityID entID = input.getEntID();
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entID.getSegment(EZSourceProjectIDSg.class);
            OverrideResolutionDialog.Data temp = null;
            try {
                ProjectInfo pInfo = prjSg.getProjectInfo();
                temp = OverrideResolutionDialog.prepareData(pInfo, (EZSourceDynamicCall)type);
            }
            catch (RuntimeException ex) {
                String msg = Messages.getString(OverrideResolutionAnalysis.class, "getResolution.exception");
                if (ex instanceof ResolutionException) {
                    msg = ((ResolutionException)ex).getMessage();
                }
                LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
            }
            if (temp != null) {
                final OverrideResolutionDialog.Data data = temp;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OverrideResolutionDialog dialog = new OverrideResolutionDialog(Display.getCurrent().getActiveShell(), (EZSourceDynamicCall)type, data);
                        dialog.create();
                        if (dialog.open() == 0) {
                            L.debug("resolution saved");
                        } else {
                            L.debug("resolution save canceled");
                        }
                    }
                });
            }
        }
    }

    private Object collectInfos() {
        EZSourceDynamicCall inpt = (EZSourceDynamicCall)((List)this.getContextValue("input_list")).get(0);
        return inpt;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        return null;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.ADD_MANUAL_RESOLUTION;
    }

    public boolean scopeIsShared() {
        return false;
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }
}

