/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.gui.analysis;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.gdb.core.analysis.GdbFilterUtils;
import com.ez.graphs.viewer.odb.utils.ResolutionUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDynamicCall;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.override.gui.ResolutionValuesComparator;
import com.ez.mainframe.override.gui.analysis.ResolutionComparator;
import com.ez.mainframe.override.gui.analysis.ResolutionDescriptor;
import com.ez.mainframe.override.gui.analysis.ResolutionReassignDialog;
import com.ez.mainframe.override.gui.analysis.ResultResolutions;
import com.ez.mainframe.override.gui.editresolutionanalysis.OverrideResolutionDialog;
import com.ez.mainframe.override.gui.internal.Activator;
import com.ez.mainframe.override.gui.internal.Messages;
import com.ez.mainframe.override.gui.utils.ProgressDialogWithoutCancelBtn;
import com.ez.mainframe.override.resolutions.ResolutionException;
import com.ez.mainframe.override.resolutions.ResolutionsProxy;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.mainframe.projects.utils.ProjectUtils;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResolutionViewer.class);
    private static final String IMG_KEY_FILTERS_COLLAPSED = "filtersCollapsed";
    private static final String IMG_KEY_FILTERS_EXPANDED = "filtersExpanded";
    private static final String IMG_KEY_RESOLUTION_UNUSED = "resolutionUnused";
    private static final String IMG_KEY_RESOLUTION_DELETED = "resolutionDeleted";
    private static final String SEARCH_TEXT_CONTEXT_KEY = "searchTextKey";
    private static final String HIDE_UNUSED_CONTEXT_KEY = "hideUnusedKey";
    private static final String RESULTS_CONTEXT_KEY = "results map";
    private static final String SHOW_FILTERS_AREA_KEY = "show filters area";
    private static final String SEARCH_PROGRAMS_CONTEXT_KEY = "searchProgramsKey";
    private static final String RESOLUTION_TYPE_CONTEXT_KEY = "resolutionTypeKey";
    private static final String COLUMN_RESOLUTION_TYPE = Messages.getString(ResolutionViewer.class, "column.resolutionType.title");
    private static final String COLUMN_CONTEXT_NAME = Messages.getString(ResolutionViewer.class, "column.contextName.title");
    private static final String COLUMN_CONTEXT_PATH = Messages.getString(ResolutionViewer.class, "column.contextPath.title");
    private static final String COLUMN_PATH = Messages.getString(ResolutionViewer.class, "column.callPath.title");
    private static final String COLUMN_LINE = Messages.getString(ResolutionViewer.class, "column.callLine.title");
    private static final String COLUMN_STATEMENT = Messages.getString(ResolutionViewer.class, "column.callStmt.title");
    private static final String COLUMN_USER = Messages.getString(ResolutionViewer.class, "column.user.title");
    private static final String COLUMN_DATE = Messages.getString(ResolutionViewer.class, "column.date.title");
    private static final String ALL_RESOLUTION_TYPES = Messages.getString(ResolutionViewer.class, "resolutiontypes.all.label");
    private static final String HIDE_FILTERS_AREA_TOOLTIP = Messages.getString(ResolutionViewer.class, "hide.filters.area.tooltip");
    private static final String SHOW_FILTERS_AREA_TOOLTIP = Messages.getString(ResolutionViewer.class, "show.filters.area.tooltip");
    private static final String WRITE_ACCESS_DIALOG_TITLE = Messages.getString(ResolutionViewer.class, "writeaccess.dialoganderrorlog.title");
    private ResolutionDescriptor descriptor;
    private TableViewer viewer;
    private org.eclipse.swt.widgets.List valuesList;
    private Combo availableProjectsCmb;
    private String projName;
    private ResolutionComparator comparator;
    private ImageRegistry imgRegistry;
    private Text txtPrgFilters;
    private Text searchText;
    private Button hideUnusedBtn;
    private Combo cmbResTypes;
    private List<List<Object>> resolutions = new ArrayList<List<Object>>();
    protected IActionManager manager;
    ResolutionValuesComparator valsComparator = new ResolutionValuesComparator();
    private ResolutionTextFilter filter;

    public ResolutionViewer(ResolutionDescriptor resolutionDescriptor) {
        this.descriptor = resolutionDescriptor;
        this.comparator = new ResolutionComparator();
    }

    public ResolutionViewer() {
        this.resolutions = new ArrayList<List<Object>>();
        this.projName = null;
    }

    private void refreshView() {
        Job j = new Job(Messages.getString(ResolutionViewer.class, "refresh.project", new String[]{this.projName})){

            protected IStatus run(IProgressMonitor monitor) {
                final long startTime = System.currentTimeMillis();
                L.info("{} - display resolutions start time: {}", (Object)ResolutionViewer.this.descriptor.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                SubMonitor childMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ResolutionViewer.this.viewer.setItemCount(ResolutionViewer.this.resolutions.size());
                        ResolutionViewer.this.viewer.setInput((Object)ResolutionViewer.this.resolutions);
                        ResolutionViewer.this.viewer.refresh();
                        long duration = System.currentTimeMillis() - startTime;
                        L.info("{} - display resolutions duration: {}ms.", (Object)ResolutionViewer.this.descriptor.getAnalysisType().toString(), (Object)duration);
                    }
                });
                childMonitor.worked(2);
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private void createTable(Composite tablePanel) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        FormData formDataTable = new FormData();
        formDataTable.top = new FormAttachment(0);
        formDataTable.left = new FormAttachment(0);
        formDataTable.right = new FormAttachment(100);
        formDataTable.bottom = new FormAttachment(100);
        tablePanel.setLayoutData((Object)formDataTable);
        this.viewer = new TableViewer(tablePanel, 0x10010300);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setUseHashlookup(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().pack();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        TableViewerColumn colResolutionState = new TableViewerColumn(this.viewer, 0);
        colResolutionState.getColumn().setText("");
        colResolutionState.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider(new ResolutionTabelLabelProvider(-1)){

            public void update(ViewerCell cell) {
                List rowData = (List)cell.getElement();
                JournalEntry entry = (JournalEntry)rowData.get(9);
                if (entry.isUnused()) {
                    cell.setImage(ResolutionViewer.this.imgRegistry.get(ResolutionViewer.IMG_KEY_RESOLUTION_UNUSED));
                } else if (entry.isDeleted()) {
                    cell.setImage(ResolutionViewer.this.imgRegistry.get(ResolutionViewer.IMG_KEY_RESOLUTION_DELETED));
                }
                cell.setBackground(this.getBackground(rowData));
            }

            public String getToolTipText(Object element) {
                String tooltip = null;
                List rowData = (List)element;
                JournalEntry entry = (JournalEntry)rowData.get(9);
                if (entry.isUnused()) {
                    tooltip = Messages.getString(ResolutionViewer.class, "unused.resolution.tooltip");
                } else if (entry.isDeleted()) {
                    tooltip = Messages.getString(ResolutionViewer.class, "deleted.resolution.tooltip");
                }
                return tooltip;
            }
        });
        tableColumnLayout.setColumnData((Widget)colResolutionState.getColumn(), (ColumnLayoutData)new ColumnPixelData(20));
        TableViewerColumn colResType = new TableViewerColumn(this.viewer, 0);
        colResType.getColumn().setText(COLUMN_RESOLUTION_TYPE);
        colResType.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(0));
        tableColumnLayout.setColumnData((Widget)colResType.getColumn(), (ColumnLayoutData)new ColumnPixelData(100));
        TableViewerColumn colUser = new TableViewerColumn(this.viewer, 0);
        colUser.getColumn().setText(COLUMN_USER);
        colUser.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(1));
        tableColumnLayout.setColumnData((Widget)colUser.getColumn(), (ColumnLayoutData)new ColumnPixelData(100));
        TableViewerColumn colDate = new TableViewerColumn(this.viewer, 0);
        colDate.getColumn().setText(COLUMN_DATE);
        colDate.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(3));
        tableColumnLayout.setColumnData((Widget)colDate.getColumn(), (ColumnLayoutData)new ColumnPixelData(120));
        TableViewerColumn colContextName = new TableViewerColumn(this.viewer, 0);
        colContextName.getColumn().setText(COLUMN_CONTEXT_NAME);
        colContextName.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(4));
        tableColumnLayout.setColumnData((Widget)colContextName.getColumn(), (ColumnLayoutData)new ColumnPixelData(150));
        TableViewerColumn colPath = new TableViewerColumn(this.viewer, 0);
        colPath.getColumn().setText(COLUMN_PATH);
        colPath.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(5));
        tableColumnLayout.setColumnData((Widget)colPath.getColumn(), (ColumnLayoutData)new ColumnPixelData(350));
        TableViewerColumn colLine = new TableViewerColumn(this.viewer, 0);
        colLine.getColumn().setText(COLUMN_LINE);
        colLine.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(6));
        tableColumnLayout.setColumnData((Widget)colLine.getColumn(), (ColumnLayoutData)new ColumnPixelData(70));
        TableViewerColumn colStmtType = new TableViewerColumn(this.viewer, 0);
        colStmtType.getColumn().setText(COLUMN_STATEMENT);
        colStmtType.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(7));
        tableColumnLayout.setColumnData((Widget)colStmtType.getColumn(), (ColumnLayoutData)new ColumnPixelData(150));
        TableViewerColumn colContextPath = new TableViewerColumn(this.viewer, 0);
        colContextPath.getColumn().setText(COLUMN_CONTEXT_PATH);
        colContextPath.setLabelProvider((CellLabelProvider)new ResolutionTabelLabelProvider(8));
        tableColumnLayout.setColumnData((Widget)colContextPath.getColumn(), (ColumnLayoutData)new ColumnPixelData(350));
        tablePanel.setLayout((Layout)tableColumnLayout);
        this.viewer.refresh();
        int i = 1;
        while (i < 9) {
            this.viewer.getTable().getColumn(i).addSelectionListener((SelectionListener)this.getSelectionAdapter(this.viewer.getTable().getColumn(i), i));
            ++i;
        }
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ResolutionViewer.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && ((List)obj).size() > 2) {
                    final Set values = ((JournalEntry)((ArrayList)obj).get((int)9)).newValues;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResolutionViewer.this.clearValuesList();
                            ResolutionViewer.this.fillValuesList(values);
                        }
                    });
                }
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolutionViewer.this.comparator.setColumn(index);
                int dir = ResolutionViewer.this.comparator.getDirection();
                ResolutionViewer.this.viewer.getTable().setSortDirection(dir);
                ResolutionViewer.this.viewer.getTable().setSortColumn(column);
                ResolutionViewer.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void makeContextMenu() {
        this.viewer.getTable().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = ResolutionViewer.this.viewer.getTable().getSelection();
                if (selection.length < 1) {
                    event.doit = false;
                } else {
                    Menu popupMenu = ResolutionViewer.this.viewer.getTable().getMenu();
                    if (popupMenu == null) {
                        popupMenu = new Menu(ResolutionViewer.this.viewer.getControl());
                        ResolutionViewer.this.viewer.getTable().setMenu(popupMenu);
                    } else {
                        MenuItem[] itms = popupMenu.getItems();
                        if (itms != null) {
                            MenuItem[] menuItemArray = itms;
                            int n = itms.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MenuItem m = menuItemArray[n2];
                                m.dispose();
                                ++n2;
                            }
                        }
                    }
                    final JournalEntry entry = ResolutionViewer.this.getSelectedEntry();
                    if (entry != null) {
                        if (popupMenu.getItemCount() == 0) {
                            MenuItem viewItem = new MenuItem(popupMenu, 64);
                            viewItem.setText(Messages.getString(ResolutionViewer.class, "contextmenu.viewsource.text"));
                            viewItem.addListener(13, new Listener(){

                                public void handleEvent(Event event) {
                                    ResolutionViewer.this.viewResolutionSource(entry);
                                }
                            });
                        }
                        if (entry.isUnused()) {
                            final ProjectInfo pInfo = ResolutionViewer.this.getPrjInfo();
                            MenuItem deleteItm = new MenuItem(popupMenu, 64);
                            deleteItm.setText(Messages.getString(ResolutionViewer.class, "contextmenu.deleteresolution.text"));
                            deleteItm.addListener(13, new Listener(){

                                public void handleEvent(Event event) {
                                    ResolutionViewer.this.deleteResolution(entry, pInfo);
                                }
                            });
                            MenuItem reassignItm = new MenuItem(popupMenu, 64);
                            reassignItm.setText(Messages.getString(ResolutionViewer.class, "contextmenu.reassignresolution.text"));
                            reassignItm.addListener(13, new Listener(){

                                public void handleEvent(Event event) {
                                    ResolutionViewer.this.reassignResolution(entry, pInfo);
                                }
                            });
                        } else {
                            MenuItem overrideItem = new MenuItem(popupMenu, 0);
                            overrideItem.setText(Messages.getString(ResolutionViewer.class, "contextmenu.overridesolution.text"));
                            overrideItem.addListener(13, new Listener(){

                                public void handleEvent(Event event) {
                                    ResolutionViewer.this.editResolution(entry);
                                }
                            });
                        }
                    }
                }
            }
        });
    }

    private void showReassignDialog(List<JournalEntry> entries, final JournalEntry entry, final ProjectInfo pInfo) {
        JournalEntry revertedEntry;
        ResolutionReassignDialog dialog = new ResolutionReassignDialog(this.getShell(), entries, entry);
        dialog.create();
        if (dialog.open() == 0 && (revertedEntry = dialog.getSelected()) != null) {
            final long startTime = System.currentTimeMillis();
            L.info("{} - reassign resolution start time: {}", (Object)this.descriptor.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor pmonitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
                    monitor.setTaskName(Messages.getString(ResolutionViewer.class, "reassign.resolution.task"));
                    ResolutionViewer.this.reapplyResolution(entry, revertedEntry, pInfo, (IProgressMonitor)monitor.newChild(1));
                    long duration = System.currentTimeMillis() - startTime;
                    L.info("{} - reassign resolution duration: {}ms.", (Object)ResolutionViewer.this.descriptor.getAnalysisType().toString(), (Object)duration);
                }
            };
            ProgressDialogWithoutCancelBtn pmd = new ProgressDialogWithoutCancelBtn(this.getShell());
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException e) {
                L.error("error at reassigning resolution", (Throwable)e);
            }
            catch (InterruptedException e) {
                L.error("error at reassigning resolution", (Throwable)e);
            }
        }
    }

    private void reassignResolution(final JournalEntry entry, final ProjectInfo pInfo) {
        Job job = new Job(Messages.getString(ResolutionViewer.class, "collectingEntries.jobname")){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    final List entries = ResolutionsProxy.getAllMatchingEntries((JournalEntry)entry, (ProjectInfo)pInfo);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResolutionViewer.this.showReassignDialog(entries, entry, pInfo);
                        }
                    });
                }
                catch (Exception exception) {
                    status = new Status(4, "com.ez.mainframe.override.gui", Messages.getString(ResolutionViewer.class, "collectingEntries.errorMessage"));
                }
                return status;
            }
        };
        job.schedule();
    }

    private void reapplyResolution(JournalEntry unusedEntry, JournalEntry revertedEntry, ProjectInfo pInfo, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
        final boolean[] tryAgain = new boolean[]{true};
        while (tryAgain[0]) {
            int status = ResolutionUtils.reassignResolution((ProjectInfo)pInfo, (JournalEntry)unusedEntry, (JournalEntry)revertedEntry, (IProgressMonitor)monitor.newChild(70));
            monitor.worked(70);
            if (status == 1) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        tryAgain[0] = MessageDialog.openQuestion((Shell)ResolutionViewer.this.getShell(), (String)Messages.getString(ResolutionViewer.class, "resolutionLock.dialog.title"), (String)Messages.getString(ResolutionViewer.class, "resolutionLock.dialog.message"));
                    }
                });
                continue;
            }
            tryAgain[0] = false;
            if (status == 0 && !monitor.isCanceled()) {
                this.loadResolutions(pInfo);
                monitor.done();
                continue;
            }
            L.info("resolution was not reassigned");
            MultiStatus st = LogUtil.getServiceInfo(null, (int)2, (String)Messages.getString(ResolutionViewer.class, "resolutionNotReassigned.errorlog.message"), (Bundle)Activator.getDefault().getBundle());
            LogUtil.displayErrorMessage((Status)st, (boolean)false);
        }
    }

    private void editResolution(final JournalEntry entry) {
        final ProjectInfo pInfo = this.getPrjInfo();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                EZSourceDynamicCall input;
                if (entry != null) {
                    String prgType = entry.programType.toString();
                    Resolution resolution = entry.resolution;
                    input = ResolutionUtils.buildInputType((Resolution)resolution, (ProjectInfo)pInfo, (String)prgType, null);
                } else {
                    input = null;
                }
                OverrideResolutionDialog.Data temp = null;
                try {
                    temp = OverrideResolutionDialog.prepareData(pInfo, input);
                }
                catch (RuntimeException ex) {
                    String msg = Messages.getString(ResolutionViewer.class, "gettingResolution.exception");
                    if (ex instanceof ResolutionException) {
                        msg = ((ResolutionException)ex).getMessage();
                    }
                    LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
                }
                if (temp != null) {
                    final OverrideResolutionDialog.Data data = temp;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OverrideResolutionDialog dlg = new OverrideResolutionDialog(ResolutionViewer.this.getShell(), input, data);
                            dlg.create();
                            if (dlg.open() == 0) {
                                L.debug("resolution saved");
                            } else {
                                L.debug("resolution save canceled");
                            }
                        }
                    });
                }
            }
        });
        t.start();
    }

    private void viewResolutionSource(JournalEntry entry) {
        TextSelectionInFile fileAttr = new TextSelectionInFile(entry.callPath, entry.programType.toString(), new Integer[]{entry.callLine});
        HashSet<TextSelectionInFile> attrSet = new HashSet<TextSelectionInFile>();
        attrSet.add(fileAttr);
        com.ez.cobol.callgraph.utils.Utils.openEditor(attrSet, (String)this.projName);
    }

    private void deleteResolution(final JournalEntry entry, final ProjectInfo pInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean ret = MessageDialog.openQuestion((Shell)ResolutionViewer.this.getShell(), (String)Messages.getString(ResolutionViewer.class, "deleteconfirmation.dialog.title"), (String)Messages.getString(ResolutionViewer.class, "deleteconfirmation.dialog.message"));
                if (ret) {
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor pmonitor) {
                            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
                            ResolutionViewer.this.deleteEntry(pInfo, entry, (IProgressMonitor)monitor);
                        }
                    };
                    ProgressDialogWithoutCancelBtn pmd = new ProgressDialogWithoutCancelBtn(ResolutionViewer.this.getShell());
                    try {
                        pmd.run(true, true, op);
                    }
                    catch (InvocationTargetException e) {
                        L.error("error at removing resolution", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        L.error("error at removing resolution", (Throwable)e);
                    }
                }
            }
        });
    }

    private void deleteEntry(ProjectInfo pInfo, JournalEntry entry, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
        final boolean[] tryAgain = new boolean[]{true};
        while (tryAgain[0]) {
            int status = ResolutionUtils.removeResolution((ProjectInfo)pInfo, (JournalEntry)entry, (IProgressMonitor)monitor.newChild(70));
            monitor.worked(70);
            if (status == 1) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        tryAgain[0] = MessageDialog.openQuestion((Shell)ResolutionViewer.this.getShell(), (String)Messages.getString(ResolutionViewer.class, "resolutionLock.dialog.title"), (String)Messages.getString(ResolutionViewer.class, "resolutionLock.dialog.message"));
                    }
                });
                continue;
            }
            tryAgain[0] = false;
            if (status == 0 && !monitor.isCanceled()) {
                this.loadResolutions(pInfo);
                monitor.done();
                continue;
            }
            L.info("resolution was not removed");
            MultiStatus st = LogUtil.getServiceInfo(null, (int)2, (String)Messages.getString(ResolutionViewer.class, "resolutionNotDeleted.errorlog.message"), (Bundle)Activator.getDefault().getBundle());
            LogUtil.displayErrorMessage((Status)st, (boolean)false);
        }
    }

    private JournalEntry getSelectedEntry() {
        ArrayList row = (ArrayList)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        return row != null ? (JournalEntry)row.get(9) : null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void initImageRegistry(IActionManager manager) {
        if (this.imgRegistry == null) {
            this.imgRegistry = ((BrowserManager)manager).getImageRegistry();
        }
        if (this.imgRegistry.get(IMG_KEY_FILTERS_COLLAPSED) == null) {
            this.imgRegistry.put(IMG_KEY_FILTERS_COLLAPSED, Activator.getImageDescriptor("icons/collapsed_16.png"));
        }
        if (this.imgRegistry.get(IMG_KEY_FILTERS_EXPANDED) == null) {
            this.imgRegistry.put(IMG_KEY_FILTERS_EXPANDED, Activator.getImageDescriptor("icons/expanded_16.png"));
        }
        if (this.imgRegistry.get(IMG_KEY_RESOLUTION_UNUSED) == null) {
            this.imgRegistry.put(IMG_KEY_RESOLUTION_UNUSED, Activator.getImageDescriptor("icons/warning.gif"));
        }
        if (this.imgRegistry.get(IMG_KEY_RESOLUTION_DELETED) == null) {
            this.imgRegistry.put(IMG_KEY_RESOLUTION_DELETED, Activator.getImageDescriptor("icons/remove.png"));
        }
    }

    private void showOrHideFiltersArea(Button toggleFiltersButton, SashForm hSashMain, Composite resultsArea) {
        if (toggleFiltersButton.getSelection()) {
            hSashMain.setMaximizedControl(null);
            toggleFiltersButton.setImage(this.imgRegistry.get(IMG_KEY_FILTERS_EXPANDED));
            toggleFiltersButton.setToolTipText(HIDE_FILTERS_AREA_TOOLTIP);
        } else {
            hSashMain.setMaximizedControl((Control)resultsArea);
            toggleFiltersButton.setImage(this.imgRegistry.get(IMG_KEY_FILTERS_COLLAPSED));
            toggleFiltersButton.setToolTipText(SHOW_FILTERS_AREA_TOOLTIP);
            this.descriptor.getState().getData().put(SHOW_FILTERS_AREA_KEY, false);
        }
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.manager = manager;
        manager.setCurrentContext(null);
        this.initImageRegistry(manager);
        final Composite mainPanel = new Composite(parent, 0);
        FormLayout formMain = new FormLayout();
        formMain.marginHeight = 0;
        formMain.marginWidth = 0;
        mainPanel.setLayout((Layout)formMain);
        FormData formDataMain = new FormData();
        formDataMain.right = new FormAttachment(100);
        formDataMain.left = new FormAttachment(0);
        formDataMain.top = new FormAttachment(0);
        formDataMain.bottom = new FormAttachment(100);
        mainPanel.setLayoutData((Object)formDataMain);
        Composite filters = new Composite(mainPanel, 0);
        FormLayout formLayFilters = new FormLayout();
        formLayFilters.marginHeight = 0;
        formLayFilters.marginWidth = 0;
        filters.setLayout((Layout)formLayFilters);
        FormData formDataFilter = new FormData();
        formDataFilter.height = 30;
        formDataFilter.right = new FormAttachment(100);
        formDataFilter.left = new FormAttachment(0);
        filters.setLayoutData((Object)formDataFilter);
        final Button toggleFiltersButton = new Button(filters, 2);
        FormData formDataButton = new FormData();
        formDataButton.top = new FormAttachment(0);
        formDataButton.left = new FormAttachment(0);
        formDataButton.width = 26;
        formDataButton.height = 26;
        toggleFiltersButton.setLayoutData((Object)formDataButton);
        Label filtersSummary = new Label(filters, 0);
        filtersSummary.setText(Messages.getString(ResolutionViewer.class, "filters.label"));
        FormData formDataLabel = new FormData();
        formDataLabel.top = new FormAttachment((Control)toggleFiltersButton, 0, 0x1000000);
        formDataLabel.left = new FormAttachment((Control)toggleFiltersButton, 5);
        filtersSummary.setLayoutData((Object)formDataLabel);
        Button reloadButton = new Button(filters, 8);
        FormData formDataReload = new FormData();
        formDataReload.top = new FormAttachment(0);
        formDataReload.right = new FormAttachment(100);
        formDataReload.height = DpiScaler.getScaledSize((int)26);
        reloadButton.setLayoutData((Object)formDataReload);
        reloadButton.setText(Messages.getString(ResolutionViewer.class, "filters.button.reload"));
        reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolutionViewer.this.loadResolutions(ResolutionViewer.this.getPrjInfo());
            }
        });
        final SashForm hSashMain = new SashForm(mainPanel, 2560);
        FormLayout formLayoutSashMain = new FormLayout();
        formLayoutSashMain.marginHeight = 0;
        formLayoutSashMain.marginWidth = 0;
        hSashMain.setLayout((Layout)formLayoutSashMain);
        FormData formDataSashMain = new FormData();
        formDataSashMain.left = new FormAttachment(0);
        formDataSashMain.right = new FormAttachment(100);
        formDataSashMain.top = new FormAttachment(0, 30);
        formDataSashMain.bottom = new FormAttachment(100);
        hSashMain.setLayoutData((Object)formDataSashMain);
        ScrolledComposite sc1 = new ScrolledComposite((Composite)hSashMain, 2560);
        sc1.setExpandHorizontal(true);
        sc1.setExpandVertical(true);
        Composite filtersMainArea = new Composite((Composite)sc1, 0);
        FormLayout formLayoutFilters = new FormLayout();
        formLayoutFilters.marginHeight = 0;
        formLayoutFilters.marginWidth = 0;
        filtersMainArea.setLayout((Layout)formLayoutFilters);
        FormData formDataFilters = new FormData();
        formDataFilters.right = new FormAttachment(100);
        formDataFilters.left = new FormAttachment(0);
        formDataFilters.bottom = new FormAttachment(100);
        formDataFilters.top = new FormAttachment(0);
        filtersMainArea.setLayoutData((Object)formDataFilters);
        final SashForm resultsArea = new SashForm((Composite)hSashMain, 2048);
        FormLayout formLayoutResults = new FormLayout();
        formLayoutResults.marginHeight = 0;
        formLayoutResults.marginWidth = 0;
        resultsArea.setLayout((Layout)formLayoutResults);
        FormData formDataResults = new FormData();
        formDataResults.top = new FormAttachment((Control)filtersMainArea, 0);
        formDataResults.left = new FormAttachment(0);
        resultsArea.setLayoutData((Object)formDataResults);
        hSashMain.setWeights(new int[]{15, 85});
        Label lblTextFilters = new Label(filtersMainArea, 0);
        lblTextFilters.setText(Messages.getString(ResolutionViewer.class, "searchintext.label.text"));
        this.searchText = new Text(filtersMainArea, 2176);
        this.searchText.addModifyListener((ModifyListener)new TextboxModifyListener(SEARCH_TEXT_CONTEXT_KEY));
        this.hideUnusedBtn = new Button(filtersMainArea, 32);
        this.hideUnusedBtn.setText(Messages.getString(ResolutionViewer.class, "hideunused.button.text"));
        this.hideUnusedBtn.setSelection(true);
        this.hideUnusedBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolutionViewer.this.descriptor.getState().getData().put(ResolutionViewer.HIDE_UNUSED_CONTEXT_KEY, ResolutionViewer.this.hideUnusedBtn.getSelection());
                ResolutionViewer.this.viewer.refresh();
            }
        });
        Label lblPrgFilters = new Label(filtersMainArea, 0);
        lblPrgFilters.setText(Messages.getString(ResolutionViewer.class, "searchinprograms.label.text"));
        this.txtPrgFilters = new Text(filtersMainArea, 2048);
        this.txtPrgFilters.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                String toSearch = ResolutionViewer.this.txtPrgFilters.getText().toLowerCase().trim();
                ResolutionViewer.this.filter.setSearchedPrograms(toSearch);
                ResolutionViewer.this.clearValuesList();
                ResolutionViewer.this.viewer.refresh();
            }
        });
        this.txtPrgFilters.addModifyListener((ModifyListener)new TextboxModifyListener(SEARCH_PROGRAMS_CONTEXT_KEY));
        Label lblProject = new Label(filtersMainArea, 0);
        lblProject.setText(Messages.getString(ResolutionViewer.class, "projects.label.text"));
        this.availableProjectsCmb = new Combo(filtersMainArea, 2568);
        this.availableProjectsCmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ResolutionViewer.this.availableProjectsCmb.getSelectionIndex();
                ResolutionViewer.this.projName = ResolutionViewer.this.availableProjectsCmb.getItem(selIndex);
                ArrayList<ProjectInfo> lst = new ArrayList<ProjectInfo>();
                lst.add(ResolutionViewer.this.getPrjInfo());
                ResolutionViewer.this.descriptor.getState().getData().put("PROJECT_LIST", lst);
                ResolutionViewer.this.loadResolutions(ResolutionViewer.this.getPrjInfo());
            }
        });
        Label lblResType = new Label(filtersMainArea, 0);
        lblResType.setText(Messages.getString(ResolutionViewer.class, "resolutiontypes.label.text"));
        this.cmbResTypes = new Combo(filtersMainArea, 2056);
        this.cmbResTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolutionViewer.this.descriptor.getState().getData().put(ResolutionViewer.RESOLUTION_TYPE_CONTEXT_KEY, ResolutionViewer.this.cmbResTypes.getSelectionIndex());
                ResolutionViewer.this.clearValuesList();
                ResolutionViewer.this.viewer.refresh();
            }
        });
        this.cmbResTypes.add(ALL_RESOLUTION_TYPES);
        this.cmbResTypes.add(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)Resolution.ResolutionType.AUTOMATICALLY_RESOLVED));
        this.cmbResTypes.add(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)Resolution.ResolutionType.MANUALLY_RESOLVED));
        this.cmbResTypes.add(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)Resolution.ResolutionType.NOT_RESOLVED));
        this.cmbResTypes.setData(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)Resolution.ResolutionType.AUTOMATICALLY_RESOLVED), (Object)Resolution.ResolutionType.AUTOMATICALLY_RESOLVED);
        this.cmbResTypes.setData(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)Resolution.ResolutionType.MANUALLY_RESOLVED), (Object)Resolution.ResolutionType.MANUALLY_RESOLVED);
        this.cmbResTypes.setData(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)Resolution.ResolutionType.NOT_RESOLVED), (Object)Resolution.ResolutionType.NOT_RESOLVED);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)this.searchText);
        lblTextFilters.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)lblTextFilters, 10);
        formData.right = new FormAttachment(65, 5);
        this.searchText.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)this.searchText, 10);
        lblProject.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment((Control)lblProject, 10);
        formData.right = new FormAttachment(100, -5);
        this.availableProjectsCmb.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblTextFilters, 15);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment((Control)this.txtPrgFilters);
        lblPrgFilters.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblTextFilters, 15);
        formData.left = new FormAttachment((Control)lblPrgFilters, 10);
        formData.right = new FormAttachment((Control)this.hideUnusedBtn, -5, 16384);
        this.txtPrgFilters.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblTextFilters, 15);
        formData.right = new FormAttachment(100, -5);
        this.hideUnusedBtn.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblPrgFilters, 15);
        formData.left = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment((Control)this.cmbResTypes);
        lblResType.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)lblPrgFilters, 15);
        formData.left = new FormAttachment((Control)lblResType, 10);
        formData.right = new FormAttachment(40, -5);
        this.cmbResTypes.setLayoutData((Object)formData);
        sc1.setContent((Control)filtersMainArea);
        Point sizeFiltersArea = filtersMainArea.computeSize(-1, -1);
        sc1.setMinSize(sizeFiltersArea);
        Composite tablePanel = new Composite((Composite)resultsArea, 2048);
        FormLayout formTable = new FormLayout();
        tablePanel.setLayout((Layout)formTable);
        FormData formDataTable = new FormData();
        formDataTable.top = new FormAttachment(0);
        formDataTable.left = new FormAttachment(0);
        formDataTable.bottom = new FormAttachment(100);
        tablePanel.setLayoutData((Object)formDataTable);
        this.createTable(tablePanel);
        toggleFiltersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolutionViewer.this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, (Composite)resultsArea);
                mainPanel.layout();
            }
        });
        Composite resolutionVal = new Composite((Composite)resultsArea, 0);
        FormLayout formLayoutResolutions = new FormLayout();
        resolutionVal.setLayout((Layout)formLayoutResolutions);
        FormData formDataResolutions = new FormData();
        formDataResolutions.top = new FormAttachment((Control)tablePanel, 10);
        formDataResolutions.bottom = new FormAttachment(100);
        formDataResolutions.left = new FormAttachment(0);
        formDataResolutions.right = new FormAttachment(100);
        resolutionVal.setLayoutData((Object)formDataResolutions);
        Label labelListDescription = new Label(resolutionVal, 0);
        labelListDescription.setText(Messages.getString(ResolutionViewer.class, "list.resolutions.label"));
        FormData formDatalabelList = new FormData();
        formDatalabelList.top = new FormAttachment(0);
        formDatalabelList.left = new FormAttachment(0, 5);
        labelListDescription.setLayoutData((Object)formDatalabelList);
        Composite textPanel = new Composite(resolutionVal, 2048);
        FormLayout textLayout = new FormLayout();
        textPanel.setLayout((Layout)textLayout);
        FormData formTextPanel = new FormData();
        formTextPanel.top = new FormAttachment((Control)labelListDescription, 10);
        formTextPanel.bottom = new FormAttachment(100);
        formTextPanel.left = new FormAttachment(0);
        formTextPanel.right = new FormAttachment(100);
        textPanel.setLayoutData((Object)formTextPanel);
        this.valuesList = new org.eclipse.swt.widgets.List(textPanel, 512);
        FormData formListText = new FormData();
        formListText.left = new FormAttachment(0);
        formListText.right = new FormAttachment(100);
        formListText.top = new FormAttachment(0);
        formListText.bottom = new FormAttachment(100);
        this.valuesList.setLayoutData((Object)formListText);
        this.valuesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = ResolutionViewer.this.valuesList.getSelectionIndex();
                if (selIndex > -1) {
                    String item = ResolutionViewer.this.valuesList.getItem(selIndex);
                    ValuesTriplet p = (ValuesTriplet)ResolutionViewer.this.valuesList.getData(item);
                    String programName = (String)p.getFirst();
                    Integer prgType = (Integer)p.getSecond();
                    if ((Integer)p.getSecond() == -1) {
                        prgType = ProgramType.UNKNOWN.getProgramTypeId();
                    }
                    ResolutionViewer.this.handleResultElementSelection(programName, prgType, (String)p.getThird());
                }
            }
        });
        this.comparator = new ResolutionComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        resultsArea.setWeights(new int[]{7, 9});
        resultsArea.setOrientation(512);
        this.filter = new ResolutionTextFilter();
        this.viewer.setFilters(new ViewerFilter[]{this.filter, new ResolutionStateFilter()});
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                String regexString = ResolutionViewer.this.computeForm(ResolutionViewer.this.searchText.getText().toLowerCase());
                ResolutionViewer.this.filter.setSearchText(regexString);
                ResolutionViewer.this.clearValuesList();
                ResolutionViewer.this.viewer.refresh();
            }
        });
        Boolean showFiltersArea = (Boolean)this.descriptor.getState().getData().get(SHOW_FILTERS_AREA_KEY);
        toggleFiltersButton.setSelection(showFiltersArea != null ? showFiltersArea : true);
        this.showOrHideFiltersArea(toggleFiltersButton, hSashMain, (Composite)resultsArea);
        this.loadResultsFromContext();
        this.makeContextMenu();
        return mainPanel;
    }

    private String computeForm(String temporary) {
        String tempBuilder = "";
        if (temporary != null && !temporary.isEmpty()) {
            if (temporary.contains("*") || temporary.contains("?")) {
                while (temporary.contains("*") || temporary.contains("?")) {
                    if (temporary.indexOf("*") > temporary.indexOf("?")) {
                        if (temporary.indexOf("?") > -1) {
                            tempBuilder = tempBuilder.concat(Pattern.quote(temporary.substring(0, temporary.indexOf("?")))).concat(".");
                            if (temporary.length() <= 0) continue;
                            temporary = temporary.substring(temporary.indexOf("?") + 1, temporary.length());
                            continue;
                        }
                        tempBuilder = tempBuilder.concat(Pattern.quote(temporary.substring(0, temporary.indexOf("*")))).concat(".*");
                        if (temporary.length() <= 0) continue;
                        temporary = temporary.substring(temporary.indexOf("*") + 1, temporary.length());
                        continue;
                    }
                    if (temporary.indexOf("*") > -1) {
                        tempBuilder = tempBuilder.concat(Pattern.quote(temporary.substring(0, temporary.indexOf("*")))).concat(".*");
                        if (temporary.length() <= 0) continue;
                        temporary = temporary.substring(temporary.indexOf("*") + 1, temporary.length());
                        continue;
                    }
                    tempBuilder = tempBuilder.concat(Pattern.quote(temporary.substring(0, temporary.indexOf("?")))).concat(".");
                    if (temporary.length() <= 0) continue;
                    temporary = temporary.substring(temporary.indexOf("?") + 1, temporary.length());
                }
                if (temporary.length() > 0) {
                    tempBuilder = tempBuilder.concat(Pattern.quote(temporary));
                }
            } else {
                tempBuilder = ".*" + temporary + ".*";
            }
        }
        return tempBuilder;
    }

    private void fillProjectsCombo(ProjectInfo selectedProject) {
        Integer selectedIndex = 0;
        IProjectsService projectsService = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        List infos = ProjectUtils.filterMainframeProjectsOnly((List)projectsService.getProjects());
        int i = 0;
        while (i < infos.size()) {
            ProjectInfo projInfo = (ProjectInfo)infos.get(i);
            if (GdbFilterUtils.checkDefinition((ProjectInfo)projInfo)) {
                this.availableProjectsCmb.add(projInfo.getName());
                this.availableProjectsCmb.setData(projInfo.getName(), (Object)projInfo);
                if (selectedProject.equals((Object)projInfo)) {
                    selectedIndex = this.availableProjectsCmb.getItemCount() - 1;
                }
            }
            ++i;
        }
        this.availableProjectsCmb.select(selectedIndex.intValue());
    }

    private void loadResolutions(final ProjectInfo pInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int selIndex = ResolutionViewer.this.availableProjectsCmb.getSelectionIndex();
                if (selIndex > -1) {
                    ResolutionViewer.this.resolutions.clear();
                    ResolutionViewer.this.clearValuesList();
                    if (pInfo != null) {
                        Job j = new Job(Messages.getString(ResolutionViewer.class, "reload.project", new String[]{ResolutionViewer.this.projName})){

                            protected IStatus run(IProgressMonitor monitor) {
                                SubMonitor childMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                ResolutionViewer.this.fillResolutions(pInfo);
                                childMonitor.worked(2);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Map data = ResolutionViewer.this.descriptor.getState().getData();
                                        ResultResolutions resultPrjData = new ResultResolutions(pInfo, null, 0, null);
                                        resultPrjData.setResolutions(ResolutionViewer.this.resolutions);
                                        data.put(ResolutionViewer.RESULTS_CONTEXT_KEY, resultPrjData);
                                        ResolutionViewer.this.refreshView();
                                    }
                                });
                                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                            }
                        };
                        j.setUser(true);
                        j.schedule();
                    }
                }
            }
        });
    }

    private void loadResultsFromContext() {
        Map data = this.descriptor.getState().getData();
        Object d = data.get(HIDE_UNUSED_CONTEXT_KEY);
        if (d != null) {
            this.hideUnusedBtn.setSelection(((Boolean)d).booleanValue());
        }
        if ((d = data.get(SEARCH_TEXT_CONTEXT_KEY)) != null) {
            this.searchText.setText(d.toString());
        }
        if ((d = data.get(SEARCH_PROGRAMS_CONTEXT_KEY)) != null) {
            this.txtPrgFilters.setText(d.toString());
        }
        if ((d = data.get(RESOLUTION_TYPE_CONTEXT_KEY)) != null) {
            this.cmbResTypes.select(((Integer)d).intValue());
        } else {
            this.cmbResTypes.select(0);
        }
        List selectedProjectLst = (List)this.descriptor.getState().getData().get("PROJECT_LIST");
        if (selectedProjectLst != null) {
            ProjectInfo pInfo = (ProjectInfo)selectedProjectLst.get(0);
            this.projName = pInfo.getName();
            this.fillProjectsCombo(pInfo);
        }
        this.resolutions.clear();
        this.clearValuesList();
        ResultResolutions resolutionsCtx = (ResultResolutions)data.get(RESULTS_CONTEXT_KEY);
        if (resolutionsCtx != null) {
            this.resolutions = resolutionsCtx.getResult();
            this.refreshView();
        } else {
            final ProjectInfo info = this.getPrjInfo();
            Job j = new Job(Messages.getString(ResolutionViewer.class, "search.in.project", new String[]{this.projName})){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor childMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ResolutionViewer.this.fillResolutions(info);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String txt = ResolutionViewer.this.searchText.getText();
                            if (txt != null && !txt.isEmpty()) {
                                String regexString = ResolutionViewer.this.computeForm(txt.toLowerCase());
                                ResolutionViewer.this.filter.setSearchText(regexString);
                            }
                            ResolutionViewer.this.refreshView();
                        }
                    });
                    childMonitor.worked(2);
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            j.setUser(true);
            j.schedule();
        }
    }

    private void handleResultElementSelection(final String progrName, final int progrType, final String ancestorName) {
        final ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
        if (progrName != null && !progrName.isEmpty() && progrType != -1 && ProgramType.UNKNOWN.getProgramTypeId() != progrType) {
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(this.projName, null);
            final String[][][] data = new String[1][][];
            try {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        String ancPart = ancestorName != null && !ancestorName.isEmpty() ? " AND UPPER(Ancestor) = '" + ancestorName.toUpperCase() + "' " : "";
                        String query = "SELECT Programs.ProgramID, Programs.OccurID, Ancestor\tFROM Programs INNER JOIN ProgramAliases ON ProgramAliases.ProgramId = Programs.ProgramID and ProgramAliases.AliasType = 0  WHERE ( UPPER(ProgramAliases.AliasName) = ?  AND Programs.ProgramTypeID = ?) ";
                        String[][] rows = conn.executeSQL(query, new Object[]{progrName.toUpperCase(), String.valueOf(progrType) + ancPart});
                        data[0] = rows;
                    }
                }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                L.error("unexpected interrupt", (Throwable)e);
            }
            catch (ExecutionException e) {
                L.error("while getting info", (Throwable)e);
            }
            EZSourceProgramIDSg resourceSg = null;
            EZObjectType inputType = null;
            Integer sid = -1;
            boolean occurid = false;
            String ancName = null;
            if (data[0] != null) {
                sid = Integer.parseInt(data[0][0][0]);
                occurid = Integer.parseInt(data[0][0][1]) > 0;
                ancName = data[0][0][2];
            } else {
                L.debug("null data trying to find details for progName={}", (Object)progrName);
                if (ancestorName != null && !ancestorName.isEmpty()) {
                    ancName = ancestorName;
                }
            }
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(progrType));
            resourceSg = new EZSourceProgramIDSg(progrName, sid, Integer.valueOf(progrType), Boolean.valueOf(occurid));
            if (ancName != null && !ancName.isEmpty()) {
                resourceSg.setAncestorName(ancName);
            }
            if (inputType.getName() == null) {
                inputType.setName(progrName);
            }
            ProjectInfo projInfo = this.getPrjInfo();
            EZEntityID entityId = new EZEntityID();
            entityId.addSegment((EZSegment)new EZSourceProjectIDSg(projInfo));
            entityId.addSegment((EZSegment)resourceSg);
            inputType.setEntID(entityId);
            inputType.addProperty("program occur", (Object)occurid);
            inputs.add(inputType);
        }
        final Object availablePrjs = this.descriptor.getState().getData().get("projects");
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("projects", availablePrjs);
                data.put("ANALYSIS_TYPE_INPUTS", inputs);
                data.put("sourceView", new Pair((Object)"com.ez.analysisbrowser.views.AnalysisBrowserView", (Object)((BrowserManager)ResolutionViewer.this.manager).getViewSecondaryId()));
                return data;
            }

            public String getId() {
                return ResolutionViewer.this.descriptor.getId();
            }
        };
        this.descriptor.getState().getData().put("selectedContext", context);
        this.manager.setCurrentContext((IActionContext)context);
    }

    private ProjectInfo getPrjInfo() {
        ProjectInfo projInfo = (ProjectInfo)this.availableProjectsCmb.getData(this.projName);
        return projInfo;
    }

    private void fillValuesList(Set<ValuesTriplet<String, Integer, String>> newValues) {
        ArrayList<ValuesTriplet<String, Integer, String>> values = new ArrayList<ValuesTriplet<String, Integer, String>>(newValues);
        Collections.sort(values, this.valsComparator);
        for (ValuesTriplet valuesTriplet : values) {
            Integer type = (Integer)valuesTriplet.getSecond();
            ProgramType pType = ProgramType.fromID((Integer)type);
            if (pType == null && type == -1) {
                pType = ProgramType.UNKNOWN;
            }
            String ancestor = (String)valuesTriplet.getThird();
            String prg = (String)valuesTriplet.getFirst();
            if (ancestor != null && !ancestor.isEmpty()) {
                prg = String.valueOf(ancestor) + ":" + prg;
            }
            String toString = Messages.getString(ResolutionViewer.class, "value.toprint", new String[]{prg, pType.name()});
            this.valuesList.add(toString);
            this.valuesList.setData(toString, (Object)valuesTriplet);
        }
        this.manager.setCurrentContext(null);
    }

    private void clearValuesList() {
        String[] stringArray = this.valuesList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String it = stringArray[n2];
            this.valuesList.setData(it, null);
            ++n2;
        }
        this.valuesList.removeAll();
    }

    private void fillResolutions(ProjectInfo proj) {
        long startTime = System.currentTimeMillis();
        L.info("{} - load resolutions start time: {}", (Object)this.descriptor.getAnalysisType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        List inputs = null;
        try {
            inputs = ResolutionsProxy.getAllCurrentResolutions((ProjectInfo)proj);
        }
        catch (Throwable th) {
            String msg = Messages.getString(ResolutionViewer.class, "getAllResolutions.exception");
            LogUtil.displayErrorMessage((Throwable)th, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
        }
        if (inputs != null) {
            for (JournalEntry row : inputs) {
                ArrayList<String> rowList = new ArrayList<String>();
                if (row.resolution == null) continue;
                rowList.add(ResolutionsProxy.getLocalizedResolutionType((Resolution.ResolutionType)row.resolution.getType()));
                rowList.add(row.user);
                StringBuilder val = new StringBuilder();
                rowList.add(val.toString());
                rowList.add(Resolution.sdf.format(row.date));
                String prg = row.contextName;
                rowList.add(prg);
                rowList.add(row.callPath);
                rowList.add(row.callLine.toString());
                StmtType type = (StmtType)Utils.readStmtTypes().get(row.stmtType);
                rowList.add(type.getListableName());
                rowList.add(row.contextPath);
                rowList.add((String)row);
                this.resolutions.add(rowList);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        L.info("{} - load resolutions duration: {}ms.", (Object)this.descriptor.getAnalysisType().toString(), (Object)duration);
    }

    public void close() {
        if (this.resolutions != null) {
            this.resolutions.clear();
            this.resolutions = null;
        }
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    private void showWriteAccessError(String operationName) {
        LogUtil.displayErrorMessage(null, (String)Messages.getString(ResolutionViewer.class, "writeaccess.errorlog.message", new String[]{operationName}), (String)WRITE_ACCESS_DIALOG_TITLE, (Plugin)Activator.getDefault(), (boolean)false);
        MessageDialog.openError((Shell)this.getShell(), (String)WRITE_ACCESS_DIALOG_TITLE, (String)Messages.getString(ResolutionViewer.class, "writeaccess.dialog.message", new String[]{operationName}));
    }

    class ResolutionStateFilter
    extends ViewerFilter {
        ResolutionStateFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean hide = ResolutionViewer.this.hideUnusedBtn.getSelection();
            int idx = ResolutionViewer.this.cmbResTypes.getSelectionIndex();
            String resType = ResolutionViewer.this.cmbResTypes.getItem(idx);
            Resolution.ResolutionType type = (Resolution.ResolutionType)ResolutionViewer.this.cmbResTypes.getData(resType);
            ArrayList row = (ArrayList)element;
            if (row != null) {
                JournalEntry entry = (JournalEntry)row.get(9);
                if (hide && entry.isUnused()) {
                    return false;
                }
                if (!resType.equals(ALL_RESOLUTION_TYPES) && !type.equals((Object)entry.resolution.getType())) {
                    return false;
                }
            }
            return true;
        }
    }

    class ResolutionTabelLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        int index = -100;

        ResolutionTabelLabelProvider(int dataIndex) {
            this.index = dataIndex;
        }

        public String getText(Object element) {
            if (this.index > -1) {
                String colValue = "";
                List rowData = (List)element;
                if (rowData.size() >= 9) {
                    colValue = (String)rowData.get(this.index);
                }
                return colValue;
            }
            return null;
        }

        public Color getBackground(Object element) {
            List rowData = (List)element;
            JournalEntry entry = (JournalEntry)rowData.get(9);
            Color gray = Display.getDefault().getSystemColor(15);
            if (entry.isUnused()) {
                return gray;
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class ResolutionTextFilter
    extends ViewerFilter {
        private String searchString;
        private String searchProgs;
        private String[] progs;

        ResolutionTextFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if ((this.searchProgs == null || this.searchProgs.isEmpty()) && this.progs == null && (this.searchString == null || this.searchString.isEmpty())) {
                return true;
            }
            List row = (List)element;
            String prg = (String)row.get(4);
            boolean ret = true;
            if (this.searchProgs != null && !this.searchProgs.isEmpty()) {
                if (!prg.toString().toLowerCase().matches(this.searchProgs)) {
                    ret = false;
                }
            } else if (this.progs != null) {
                int i = 0;
                while (i < this.progs.length) {
                    if (prg.toString().toLowerCase().indexOf(this.progs[i]) < 0) {
                        ret = false;
                        break;
                    }
                    ++i;
                }
            }
            if (ret && this.searchString != null && !this.searchString.isEmpty()) {
                ret = false;
                int count = 0;
                int i = 0;
                while (i < row.size()) {
                    Object cell = row.get(i);
                    if (count != 2 && count != 9 && cell.toString().toLowerCase().matches(this.searchString)) {
                        ret = true;
                        break;
                    }
                    ++count;
                    ++i;
                }
            }
            return ret;
        }

        public void setSearchedPrograms(String toSearch) {
            String[] parts = toSearch.split(",");
            if (parts.length > 1) {
                this.progs = parts;
                this.searchProgs = null;
            } else {
                this.searchProgs = ResolutionViewer.this.computeForm(toSearch);
                this.progs = null;
            }
        }

        public void setSearchText(String s) {
            this.searchString = s != null && !s.isEmpty() ? ".*" + s + ".*" : null;
        }
    }

    class TextboxModifyListener
    implements ModifyListener {
        private String key;

        TextboxModifyListener(String key) {
            this.key = key;
        }

        public void modifyText(ModifyEvent e) {
            if (this.key != null) {
                Text text = (Text)e.getSource();
                ResolutionViewer.this.descriptor.getState().getData().put(this.key, text.getText());
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }
    }
}

