/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.gui.analysis;

import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.override.gui.analysis.LineLabelProvider;
import com.ez.mainframe.override.gui.internal.Messages;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ResolutionReassignDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private TableViewer lineViewer;
    private TableViewer valuesViewer;
    private Collection<JournalEntry> entries;
    private JournalEntry entry;
    private JournalEntry selected;

    public ResolutionReassignDialog(Shell parentShell, Collection<JournalEntry> entries, JournalEntry entry) {
        this(parentShell);
        this.entries = entries;
        this.entry = entry;
        this.selected = null;
    }

    public ResolutionReassignDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        FormLayout containerForm = new FormLayout();
        containerForm.marginWidth = 5;
        container.setLayout((Layout)containerForm);
        Composite resolutionDetails = new Composite(container, 2048);
        FormLayout detailsForm = new FormLayout();
        resolutionDetails.setLayout((Layout)detailsForm);
        FormData formDataRes = new FormData();
        formDataRes.top = new FormAttachment(0, 10);
        formDataRes.left = new FormAttachment(0);
        formDataRes.right = new FormAttachment(100);
        resolutionDetails.setLayoutData((Object)formDataRes);
        Label programLabel = new Label(resolutionDetails, 0);
        programLabel.setText(Messages.getString(ResolutionReassignDialog.class, "label.program"));
        FormData formDataProgrLabel = new FormData();
        formDataProgrLabel.top = new FormAttachment(0, 15);
        formDataProgrLabel.left = new FormAttachment(0, 10);
        programLabel.setLayoutData((Object)formDataProgrLabel);
        Text programVal = new Text(resolutionDetails, 2048);
        String prg = this.entry.contextName;
        programVal.setText(prg);
        programVal.setEditable(false);
        FormData formDataProgrData = new FormData();
        formDataProgrData.top = new FormAttachment(0, 10);
        formDataProgrData.left = new FormAttachment((Control)programLabel, 10, 131072);
        programVal.setLayoutData((Object)formDataProgrData);
        Label statementLabel = new Label(resolutionDetails, 0);
        statementLabel.setText(Messages.getString(ResolutionReassignDialog.class, "label.statement.type"));
        FormData formDataStmtLabel = new FormData();
        formDataStmtLabel.top = new FormAttachment(0, 15);
        formDataStmtLabel.left = new FormAttachment((Control)programVal, 30);
        statementLabel.setLayoutData((Object)formDataStmtLabel);
        StmtType stmtType = (StmtType)Utils.readStmtTypes().get(this.entry.resolution.stmtType);
        Text statementVal = new Text(resolutionDetails, 2048);
        statementVal.setEditable(false);
        statementVal.setText(stmtType.getListableName());
        FormData formDataStmtData = new FormData();
        formDataStmtData.top = new FormAttachment(0, 10);
        formDataStmtData.left = new FormAttachment((Control)statementLabel, 10, 128);
        formDataStmtData.right = new FormAttachment(100, -10);
        statementVal.setLayoutData((Object)formDataStmtData);
        Label pathLabel = new Label(resolutionDetails, 0);
        pathLabel.setText(Messages.getString(ResolutionReassignDialog.class, "label.file"));
        FormData formDataPathLabel = new FormData();
        formDataPathLabel.top = new FormAttachment((Control)programLabel, 15);
        formDataPathLabel.left = new FormAttachment(0, 10);
        pathLabel.setLayoutData((Object)formDataPathLabel);
        Text pathVal = new Text(resolutionDetails, 2048);
        pathVal.setEditable(false);
        pathVal.setText(this.entry.resolution.path);
        FormData formDataPathData = new FormData();
        formDataPathData.top = new FormAttachment((Control)programLabel, 10);
        formDataPathData.left = new FormAttachment((Control)programLabel, 10, 128);
        formDataPathData.right = new FormAttachment(100, -10);
        formDataPathData.bottom = new FormAttachment(100, -10);
        pathVal.setLayoutData((Object)formDataPathData);
        Object[] valArray = new String[this.entry.resolution.values.size()];
        int count = 0;
        for (ValuesTriplet p : this.entry.resolution.values) {
            String ancestor;
            String singleVal = (String)p.getFirst();
            Integer valType = (Integer)p.getSecond();
            ProgramType type = ProgramType.fromID((Integer)valType);
            if (type == null) {
                type = ProgramType.UNKNOWN;
            }
            if ((ancestor = (String)p.getThird()) != null && !ancestor.isEmpty()) {
                singleVal = String.valueOf(ancestor) + ":" + singleVal;
            }
            valArray[count] = String.valueOf(singleVal) + " (" + type.toString() + ")";
            ++count;
        }
        Composite currentListContainer = new Composite(container, 2052);
        FormLayout currentForm = new FormLayout();
        currentListContainer.setLayout((Layout)currentForm);
        FormData formDataCurrent = new FormData();
        formDataCurrent.top = new FormAttachment((Control)resolutionDetails, 10);
        formDataCurrent.left = new FormAttachment(0);
        formDataCurrent.right = new FormAttachment(30);
        formDataCurrent.bottom = new FormAttachment(95);
        currentListContainer.setLayoutData((Object)formDataCurrent);
        Label reassignLabel = new Label(currentListContainer, 0);
        reassignLabel.setText(Messages.getString(ResolutionReassignDialog.class, "label.reassign"));
        FormData formReassignLabel = new FormData();
        formReassignLabel.top = new FormAttachment(0, 10);
        formReassignLabel.left = new FormAttachment(0, 10);
        reassignLabel.setLayoutData((Object)formReassignLabel);
        Text lineVal = new Text(currentListContainer, 2048);
        lineVal.setText(this.entry.resolution.line.toString());
        lineVal.setEditable(false);
        FormData formDataLineData = new FormData();
        formDataLineData.top = new FormAttachment(0, 5);
        formDataLineData.left = new FormAttachment((Control)reassignLabel, 10, 128);
        lineVal.setLayoutData((Object)formDataLineData);
        List currentValList = new List(currentListContainer, 2560);
        currentValList.setToolTipText(Messages.getString(ResolutionReassignDialog.class, "tooltip.valuestoreassign"));
        FormData currentListForm = new FormData();
        currentListForm.top = new FormAttachment((Control)lineVal, 5);
        currentListForm.left = new FormAttachment(0);
        currentListForm.right = new FormAttachment(100);
        currentListForm.bottom = new FormAttachment(100);
        currentValList.setLayoutData((Object)currentListForm);
        Arrays.sort(valArray);
        currentValList.setItems((String[])valArray);
        Composite rightContainer = new Composite(container, 2052);
        FormLayout rightLayout = new FormLayout();
        rightContainer.setLayout((Layout)rightLayout);
        FormData formRight = new FormData();
        formRight.top = new FormAttachment((Control)resolutionDetails, 10);
        formRight.left = new FormAttachment((Control)currentListContainer, 10);
        formRight.right = new FormAttachment(100);
        formRight.bottom = new FormAttachment(95);
        rightContainer.setLayoutData((Object)formRight);
        Label automaticLabel = new Label(rightContainer, 0);
        automaticLabel.setText(Messages.getString(ResolutionReassignDialog.class, "label.automatic.resolutions"));
        FormData formAutomaticLabel = new FormData();
        formAutomaticLabel.top = new FormAttachment(0, 10);
        formAutomaticLabel.left = new FormAttachment(0, 10);
        automaticLabel.setLayoutData((Object)formAutomaticLabel);
        Composite tableContainer = new Composite(rightContainer, 2052);
        TableColumnLayout lineTableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)lineTableLayout);
        FormData formDataTable = new FormData();
        formDataTable.top = new FormAttachment((Control)automaticLabel, 10);
        formDataTable.left = new FormAttachment(0);
        formDataTable.right = new FormAttachment(20);
        formDataTable.bottom = new FormAttachment(100);
        tableContainer.setLayoutData((Object)formDataTable);
        this.lineViewer = new TableViewer(tableContainer, 268501764);
        this.lineViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.lineViewer.setUseHashlookup(true);
        this.lineViewer.setLabelProvider((IBaseLabelProvider)new LineLabelProvider());
        this.lineViewer.setItemCount(this.entries.size());
        this.lineViewer.setInput(this.entries);
        this.lineViewer.refresh();
        this.lineViewer.getTable().setLinesVisible(true);
        this.lineViewer.getTable().setHeaderVisible(true);
        this.lineViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                JournalEntry r1 = (JournalEntry)e1;
                JournalEntry r2 = (JournalEntry)e2;
                return r1.callLine.compareTo(r2.callLine);
            }
        });
        TableViewerColumn colLine = new TableViewerColumn(this.lineViewer, 0);
        colLine.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String colValue = "";
                JournalEntry rowData = (JournalEntry)element;
                colValue = rowData.resolution.line.toString();
                return colValue;
            }
        });
        colLine.getColumn().setText(Messages.getString(ResolutionReassignDialog.class, "column.line"));
        colLine.getColumn().pack();
        this.lineViewer.getTable().pack();
        TableColumn lineColumn = this.lineViewer.getTable().getColumn(0);
        lineTableLayout.setColumnData((Widget)lineColumn, (ColumnLayoutData)new ColumnWeightData(100, lineColumn.getWidth()));
        Composite listContainer = new Composite(rightContainer, 2052);
        TableColumnLayout valTableLayout = new TableColumnLayout();
        listContainer.setLayout((Layout)valTableLayout);
        FormData formDataList = new FormData();
        formDataList.top = new FormAttachment((Control)automaticLabel, 10);
        formDataList.left = new FormAttachment((Control)tableContainer);
        formDataList.right = new FormAttachment(100);
        formDataList.bottom = new FormAttachment(100);
        listContainer.setLayoutData((Object)formDataList);
        this.valuesViewer = new TableViewer(listContainer, 268501764);
        FormData formList = new FormData();
        formList.top = new FormAttachment(0);
        formList.left = new FormAttachment(0);
        formList.right = new FormAttachment(100);
        formList.bottom = new FormAttachment(100);
        this.valuesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.valuesViewer.setUseHashlookup(true);
        this.valuesViewer.refresh();
        this.valuesViewer.getTable().setLinesVisible(true);
        this.valuesViewer.getTable().setHeaderVisible(true);
        FormData formValuesTable = new FormData();
        formValuesTable.top = new FormAttachment(0);
        formValuesTable.left = new FormAttachment(0);
        formValuesTable.right = new FormAttachment(100);
        formValuesTable.bottom = new FormAttachment(100);
        this.valuesViewer.getTable().setLayoutData((Object)formList);
        TableViewerColumn colValues = new TableViewerColumn(this.valuesViewer, 0);
        colValues.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        colValues.getColumn().setText(Messages.getString(ResolutionReassignDialog.class, "column.values"));
        colValues.getColumn().pack();
        this.valuesViewer.getTable().pack();
        TableColumn valuesColumn = this.valuesViewer.getTable().getColumn(0);
        valTableLayout.setColumnData((Widget)valuesColumn, (ColumnLayoutData)new ColumnWeightData(100, valuesColumn.getWidth()));
        this.lineViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ResolutionReassignDialog.this.lineViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    final Set values = ((JournalEntry)obj).resolution.values;
                    ResolutionReassignDialog.this.selected = (JournalEntry)obj;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object[] valArray = new String[values.size()];
                            int count = 0;
                            for (ValuesTriplet p : values) {
                                String ancestor;
                                String singleVal = (String)p.getFirst();
                                Integer valType = (Integer)p.getSecond();
                                ProgramType type = ProgramType.fromID((Integer)valType);
                                if (type == null) {
                                    type = ProgramType.UNKNOWN;
                                }
                                if ((ancestor = (String)p.getThird()) != null && !ancestor.isEmpty()) {
                                    singleVal = String.valueOf(ancestor) + ":" + singleVal;
                                }
                                valArray[count] = String.valueOf(singleVal) + " (" + type.toString() + ")";
                                ++count;
                            }
                            Arrays.sort(valArray);
                            ResolutionReassignDialog.this.valuesViewer.setItemCount(valArray.length);
                            ResolutionReassignDialog.this.valuesViewer.setInput((Object)valArray);
                        }
                    });
                }
                ResolutionReassignDialog.this.getButton(0).setEnabled(obj != null);
            }
        });
        this.lineViewer.refresh();
        return container;
    }

    protected void createButtonsForButtonBar(final Composite parent) {
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 4;
        parentLayout.marginBottom = 10;
        parentLayout.marginTop = 10;
        parent.setLayout((Layout)parentLayout);
        GridData parentData = new GridData(4, 0x1000000, true, true);
        parentData.horizontalAlignment = 4;
        parentData.horizontalSpan = 1;
        parentData.verticalAlignment = 128;
        parent.setLayoutData((Object)parentData);
        Label emptyLabel = new Label(parent, 0);
        GridData labelData = new GridData(4, 0x1000000, true, true);
        labelData.horizontalAlignment = 4;
        labelData.horizontalSpan = 2;
        emptyLabel.setLayoutData((Object)labelData);
        Button okButton = this.createButton(parent, 0, Messages.getString(ResolutionReassignDialog.class, "button.reassign"), true);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.getParent().getParent().getParent().dispose();
            }
        });
        okButton.setEnabled(false);
        Button cancelButton = this.createButton(parent, 1, Messages.getString(ResolutionReassignDialog.class, "button.cancel"), false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.getParent().getParent().getParent().dispose();
            }
        });
    }

    public boolean close() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(550, 400);
        newShell.setText(Messages.getString(ResolutionReassignDialog.class, "dialog.title"));
        newShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = true;
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(760, 500);
    }

    protected boolean isResizable() {
        return true;
    }

    public JournalEntry getSelected() {
        return this.selected;
    }
}

