/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.gui.analysis;

import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.util.ActionUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.override.gui.analysis.ResolutionDescriptor;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ResolutionAction
implements IAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ResolutionDescriptor descriptor;
    private EZAnalysisType analysisType;
    private EZInputFilter filter;
    private IActionContext context;

    public ResolutionAction(ResolutionDescriptor mainframeProjectStructureDescriptor) {
        this.descriptor = mainframeProjectStructureDescriptor;
        this.analysisType = this.descriptor.getAnalysisType();
        this.filter = this.analysisType.getInputFilterInstance();
    }

    public boolean canHandle(IActionContext context) {
        return ActionUtils.canHandle((EZAnalysisType)this.analysisType, (EZInputFilter)this.filter, (IActionContext)context);
    }

    public void setInputContext(IActionContext context) {
        Map data;
        List inputs;
        this.context = context;
        if (context != null && (inputs = (List)(data = context.getData()).get("ANALYSIS_TYPE_INPUTS")) != null && !inputs.isEmpty()) {
            this.context = this.createdContextFromData(data);
        }
    }

    public IActionContext getOutputContext() {
        return this.context;
    }

    public void execute(IProgressMonitor pmonitor) {
        SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        Boolean doRestore = (Boolean)this.context.getData().get("IActionContext.restored.key");
        if (doRestore != null) {
            doRestore.booleanValue();
        }
        if (this.context != null) {
            this.descriptor.getState().getData().putAll(this.context.getData());
        }
    }

    private IActionContext createdContextFromData(final Map<String, Object> initialData) {
        AbstractActionContext context = new AbstractActionContext(){

            public Map<String, Object> getData() {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("projects", initialData.get("projects"));
                List inputProjects = (ArrayList)initialData.get("PROJECT_LIST");
                if (inputProjects == null) {
                    List objTypes = (List)initialData.get("ANALYSIS_TYPE_INPUTS");
                    inputProjects = Utils.computeInputProjectList((List)objTypes);
                } else {
                    inputProjects = new ArrayList(inputProjects);
                }
                data.put("PROJECT_LIST", inputProjects);
                return data;
            }

            public String getId() {
                return "com.ez.mainframe.override.gui.analysis";
            }
        };
        return context;
    }
}

