/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ddcl.callgraph.nodes;

import com.ez.ddcl.callgraph.nodes.AMApplication;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMBatchProgram;
import com.ez.ddcl.callgraph.nodes.AMCobol;
import com.ez.ddcl.callgraph.nodes.AMComponent;
import com.ez.ddcl.callgraph.nodes.AMDialogue;
import com.ez.ddcl.callgraph.nodes.AMExchange;
import com.ez.ddcl.callgraph.nodes.AMFile;
import com.ez.ddcl.callgraph.nodes.AMModule;
import com.ez.ddcl.callgraph.nodes.AMRecord;
import com.ez.ddcl.callgraph.nodes.AMReportProgram;
import com.ez.ddcl.callgraph.nodes.AMSCL;
import com.ez.ddcl.callgraph.nodes.AMScreen;
import com.ez.ddcl.callgraph.nodes.AMSet;
import com.ez.ddcl.callgraph.nodes.AMTPService;
import com.ez.ddcl.callgraph.nodes.AMUnknownProgram;
import com.ez.mainframe.model.ProgramType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMNodesFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AMNodesFactory.class);
    private static final String ELEM_NODE_KEY_CHAR_SEPARATOR = "!";
    private static final String EDGE_SOURCE_INFO_PREFIX = "relationTo";

    public static AMBaseNode createNode(Integer type, String name, Integer id) {
        AMBaseNode node = null;
        switch (type) {
            case 24: {
                node = new AMTPService(type, name, id);
                break;
            }
            case 25: {
                node = new AMApplication(type, name, id);
                break;
            }
            case 26: {
                node = new AMDialogue(type, name, id);
                break;
            }
            case 16: {
                node = new AMExchange(type, name, id);
                break;
            }
            case 11: {
                node = new AMComponent(type, name, id);
                break;
            }
            case 4: {
                node = new AMModule(type, name, id);
                break;
            }
            case 27: {
                node = new AMReportProgram(type, name, id);
                break;
            }
            case 28: {
                node = new AMBatchProgram(type, name, id);
                break;
            }
            case 14: {
                node = new AMScreen(type, name, id);
                break;
            }
            case 12: {
                node = new AMFile(type, name, id);
                break;
            }
            case 3: {
                node = new AMRecord(type, name, id);
                break;
            }
            case 10: {
                node = new AMSet(type, name, id);
                break;
            }
            case -19: 
            case -13: {
                node = new AMSCL(type, name, id);
                break;
            }
            case -1: {
                node = new AMCobol(type, name, id);
                break;
            }
            case 0: {
                node = new AMUnknownProgram(ProgramType.UNKNOWN.getProgramTypeId(), name, id);
                break;
            }
            default: {
                L.debug("cannot make an aplication master node for type: {}", (Object)type);
            }
        }
        return node;
    }

    public static String makeElemNodeKey(Integer id, Integer type, String name) {
        if (id != null) {
            return String.valueOf(id);
        }
        return type + ELEM_NODE_KEY_CHAR_SEPARATOR + name;
    }

    public static String getEdgeSrcInfoKey(String key) {
        return EDGE_SOURCE_INFO_PREFIX + key;
    }
}

