/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ddcl.callgraph.nodes;

import com.ez.ddcl.callgraph.ComponentRelationship;
import com.ez.internal.id.EZEntityID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AMBaseNode {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Integer type;
    private String name;
    private Integer id;
    private EZEntityID entityID;
    protected HashMap<String, Object> properties = null;
    protected Map<ComponentRelationship, List<AMBaseNode>> relationsMap = new HashMap<ComponentRelationship, List<AMBaseNode>>();
    public static final String IS_SCL = "is a scl program";
    public static final String IS_REPORT = "file is report when is 'called' by Report-program and is LISTING FILE";
    public static final String CREATE_DATE = "create date";
    public static final String UPDATE_DATE = "update date";
    public static final String IS_IDENTIFIED_WITH_PROGRAM = "ddcl element(DIALOG, COMPONENT, BATCH-PROGRAM, REPORT-PROGRAM) that is identified with program";

    protected AMBaseNode(Integer type, String name, Integer id) {
        this.type = type;
        this.name = name;
        this.id = id;
    }

    public Integer getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getAMType() {
        return this.type;
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public boolean hasRelations() {
        return this.relationsMap.size() > 0;
    }

    public Set<ComponentRelationship> getRelationKeys() {
        if (this.hasRelations()) {
            return this.relationsMap.keySet();
        }
        return null;
    }

    public List<AMBaseNode> getNodes(ComponentRelationship key) {
        return this.relationsMap.get((Object)key);
    }

    public void addRelation(ComponentRelationship key, AMBaseNode node) {
        List<AMBaseNode> nodes = this.relationsMap.get((Object)key);
        if (nodes == null) {
            nodes = new ArrayList<AMBaseNode>();
            this.relationsMap.put(key, nodes);
        }
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
    }

    public String getDisplayName() {
        String displayName = this.getProperty(IS_IDENTIFIED_WITH_PROGRAM) != null ? String.valueOf(this.name.concat("(")) + ((AMBaseNode)this.getProperty(IS_IDENTIFIED_WITH_PROGRAM)).getName().concat(")") : this.name;
        return displayName;
    }

    public EZEntityID getEntityID() {
        return this.entityID;
    }

    public void setEZEntityID(EZEntityID entID) {
        this.entityID = entID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMBaseNode other = (AMBaseNode)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.getProperty(IS_REPORT) == null ? other.getProperty(IS_REPORT) != null : !this.getProperty(IS_REPORT).equals(other.getProperty(IS_REPORT)));
    }
}

