/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ddcl.callgraph;

import com.ez.cobol.callgraph.internal.Messages;
import com.ez.ddcl.callgraph.ApplicationMasterGraphModel;
import com.ez.ddcl.callgraph.ComponentRelationship;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMNodesFactory;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.Direction;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCLGraphBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLGraphBuilder.class);
    private Map<Integer, AMBaseNode> inputsMap = new HashMap<Integer, AMBaseNode>();
    private static final String AM_Child_Applications_SP_Name = "EZViewer_AM_Child_Applications";
    private static final String AM_Child_Dialogues_Dialogues_SP_Name = "EZViewer_AM_Child_Dialogues_DIALOGUES";
    private static final String AM_Child_Dialogues_ProcessingStructure_SP_Name = "EZViewer_AM_Child_Dialogues_PROCESSING_STRUCTURE";
    private static final String AM_Child_Exchange_SP_Name = "EZViewer_AM_Child_Exchange_PROCESSING_STRUCTURE";
    private static final String AM_Child_CompAndModule_ProcessingStructure_SP_Name = "EZViewer_AM_Child_CompAndModule_PROCESSING_STRUCTURE";
    private static final String AM_Child_Screen_fromComponents_SP_Name = "EZViewer_AM_Child_Screen_fromComponents";
    private static final String AM_Child_Screen_fromDialogues_SP_Name = "EZViewer_AM_Child_Screen_fromDialogues";
    private static final String AM_Child_Screen_fromExchanges_SP_Name = "EZViewer_AM_Child_Screen_fromExchanges";
    private static final String AM_Child_Files_Files_SP_Name = "EZViewer_AM_Child_Files";
    private static final String AM_Child_Records_FromExchange_SP_Name = "EZViewer_AM_Child_Records_fromExchanges";
    private static final String AM_Child_Records_FromPrg_SP_Name = "EZViewer_AM_Child_Records_fromPrograms";
    private static final String AM_Child_Records_FromComp_SP_Name = "EZViewer_AM_Child_Records_fromComponents";
    private static final String AM_Child_Program_fromModule_And_Pgmd_from_DDCL_ELEMS_SP_Name = "EZViewer_AM_Child_Program_fromModule";
    private static final String AM_Child_Module_Call_SP_Name = "EZViewer_AM_Child_Module_CALL";
    private static final String AM_Child_Sets_SP_Name = "EZViewer_AM_Child_Sets";
    private static final String AM_Parents_Of_Applications_SP_Name = "EZViewer_AM_Parents_Of_Applications";
    private static final String AM_Parents_Of_Dialogues_Applications_SP_Name = "EZViewer_AM_Parents_Of_Dialogues_Applications";
    private static final String AM_Parents_Of_Dialogues_DIALOGUES_SP_Name = "EZViewer_AM_Parents_Of_Dialogues_DIALOGUES";
    private static final String AM_Parents_Of_Exchange_DIALOGUES_SP_Name = "EZViewer_AM_Parents_Of_Exchange_DIALOGUES";
    private static final String AM_Parents_Of_ComponentsOrModules_SP_Name = "EZViewer_AM_Parents_Of_ComponentsOrModules";
    private static final String AM_Parents_Of_Modules_Programs_SP_Name = "EZViewer_AM_Parents_Of_Modules_Programs";
    private static final String AM_Parents_Of_Screens_SP_Name = "EZViewer_AM_Parents_Of_Screens";
    private static final String AM_Parents_Of_Files_SP_Name = "EZViewer_AM_Parents_Of_Files";
    private static final String AM_Parents_Of_Records_SP_Name = "EZViewer_AM_Parents_Of_Records";
    private static final String AM_Parents_Of_Sets_SP_Name = "EZViewer_AM_Parents_Of_Sets";
    private static final String AM_SourceInfo_forInputs = "EZViewer_AM_SrcInfo_forInputs";
    public static final String idmsxViewName = "EZViewer_IDMSX_View";
    public static final String idmsxCacheTableName = "cacheEZViewer_IDMSX_View";
    public static final String FILE_ELEMENT_LISTING_FILE_NAME = "LISTING";
    public static final String FILE_ELEMENT_DERIVED_FILE_NAME = "DERIVED";
    public static final String inputsQuery = "SELECT DDCLElement.Id, DDCLElement.Name, DDCLElement.DdsTypeId FROM DDCLElement WHERE DDCLElement.isLocal = 'false' AND (\t DDCLElement.DdsTypeId IN (4,11,12,14,16,24,25,26,27,28)\t or (\t\tDDCLElement.DdsTypeId IN (3,10) \t\tand DDCLElement.Name in (\t\t\tselect distinct ElementName from cacheEZViewer_IDMSX_View)\t ) ) ORDER BY DDCLElement.DdsTypeId, DDCLElement.Name";
    private List<EZEntityID> inputs;
    private ApplicationMasterGraphModel model;
    private Direction graphDirection;
    private Integer graphLimitation = null;
    private boolean considerSrc = true;
    private Boolean continueGraphOnPrograms = true;
    private boolean continueWithResources = true;

    public DDCLGraphBuilder(List<EZEntityID> inputs, ApplicationMasterGraphModel graphModel, Direction direction, Integer graphLimitation, boolean considerSourceInfo) {
        this.inputs = inputs;
        this.model = graphModel;
        this.graphDirection = direction;
        this.graphLimitation = graphLimitation;
        this.considerSrc = considerSourceInfo;
    }

    public Map<Integer, AMBaseNode> buildGraph(SubMonitor monitor, Set<Integer> inputIds) {
        return this.buildGraph((IProgressMonitor)monitor, inputIds, null);
    }

    public Map<Integer, AMBaseNode> buildGraph(IProgressMonitor pmonitor, Set<Integer> inputIds, EZSourceConnection conn) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        Map<Integer, TextSelectionInFile> infos = null;
        if (this.considerSrc) {
            infos = this.getSrcInfo4Inputs(conn, inputIds, (IProgressMonitor)monitor);
        }
        HashMap<Integer, Map<String, AMBaseNode>> allNodesMap = new HashMap<Integer, Map<String, AMBaseNode>>();
        for (Integer id : this.inputsMap.keySet()) {
            AMBaseNode amNode = this.inputsMap.get(id);
            amNode.addProperty("node is input for callgraph", Boolean.TRUE);
            String key = AMNodesFactory.makeElemNodeKey(id, amNode.getAMType(), amNode.getName());
            this.addAMNode(amNode.getAMType(), allNodesMap, key, amNode);
            if (!this.considerSrc) continue;
            TextSelectionInFile infoSel = infos.remove(id);
            if (infoSel != null) {
                amNode.addProperty("FILE", infoSel);
                continue;
            }
            L.warn("input {} has no srcInfo (id={})", (Object)amNode.getName(), (Object)id);
        }
        Boolean isForward = Direction.doForward((Direction)this.graphDirection);
        L.debug("graph direction forward : {}", (Object)isForward);
        if (isForward.booleanValue()) {
            this.createForward(conn, allNodesMap, monitor.newChild(100));
        }
        if (monitor.isCanceled()) {
            return null;
        }
        Boolean isBackward = Direction.doBackward((Direction)this.graphDirection);
        L.debug("graph direction backward : {}", (Object)isBackward);
        if (isBackward.booleanValue()) {
            this.createBackward(conn, allNodesMap, monitor.newChild(100));
        }
        return this.inputsMap;
    }

    public Map<Integer, AMBaseNode> buildGraph(IProgressMonitor monitor, EZSourceConnection conn) {
        this.inputsMap.clear();
        Set<Integer> ids = this.processInputs();
        return this.buildGraph(monitor, ids, conn);
    }

    private Set<Integer> processInputs() {
        HashSet<Integer> inptIDs = new HashSet<Integer>();
        for (EZEntityID entity : this.inputs) {
            EZSourceDDCLElementIDSg ddclElemIdSg = (EZSourceDDCLElementIDSg)entity.getSegment(EZSourceDDCLElementIDSg.class);
            String name = ddclElemIdSg.getName();
            Integer typeId = ddclElemIdSg.getType();
            Integer id = ddclElemIdSg.getId();
            inptIDs.add(id);
            AMBaseNode amInput = AMNodesFactory.createNode(typeId, name, id);
            amInput.setEZEntityID(entity);
            this.inputsMap.put(id, amInput);
        }
        return inptIDs;
    }

    private Map<Integer, TextSelectionInFile> getSrcInfo4Inputs(EZSourceConnection conn, Set<Integer> ids, IProgressMonitor monitor) {
        HashMap<Integer, TextSelectionInFile> ret = new HashMap<Integer, TextSelectionInFile>();
        if (ids != null && !ids.isEmpty()) {
            String[][] results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_SourceInfo_forInputs, null, ids, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor);
            String DDCL_PGROGRAM_TYPE = String.valueOf(14);
            if (results != null) {
                int i = 0;
                while (i < results.length) {
                    String[] result = results[i];
                    TextSelectionInFile infoSel = new TextSelectionInFile(result[5], DDCL_PGROGRAM_TYPE, new String[]{result[1], result[3], result[2], result[4]});
                    ret.put(Integer.valueOf(result[0]), infoSel);
                    ++i;
                }
            }
        }
        return ret;
    }

    private void addAMNode(Integer type, Map<Integer, Map<String, AMBaseNode>> allNodesMap, String key, AMBaseNode amNode) {
        Map<String, AMBaseNode> nodes = allNodesMap.get(type);
        if (nodes == null) {
            nodes = new HashMap<String, AMBaseNode>();
            allNodesMap.put(type, nodes);
        }
        nodes.put(key, amNode);
    }

    private void createForward(EZSourceConnection conn, Map<Integer, Map<String, AMBaseNode>> allNodesMap, SubMonitor monitor) {
        Map<Integer, Set<Integer>> compAndModuleMap;
        String[][] results;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2800);
        pmonitor.subTask(Messages.getString(DDCLGraphBuilder.class, (String)"compute.forward.taskName"));
        Map<Integer, Set<Integer>> allParamMap = this.processInputIds();
        Set<Integer> tpServiceParams = allParamMap.get(24);
        Set<Integer> appParams = allParamMap.get(25);
        Set<Integer> dialogParams = allParamMap.get(26);
        Set<Integer> exchangeParams = allParamMap.get(16);
        Set<Integer> compParams = allParamMap.get(11);
        Set<Integer> moduleParams = allParamMap.get(4);
        Set<Integer> screenParams = allParamMap.get(14);
        Set<Integer> fileParams = allParamMap.get(12);
        Set<Integer> batchPrgParams = allParamMap.get(28);
        Set<Integer> reportPrgParams = allParamMap.get(27);
        HashMap<Integer, Triplet<String, String, TextSelectionInFile>> prgParams = new HashMap<Integer, Triplet<String, String, TextSelectionInFile>>();
        if (!pmonitor.isCanceled() && !tpServiceParams.isEmpty()) {
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Applications_SP_Name, null, tpServiceParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> appFromTPServiceParams = this.processChildResults(results, 24, ComponentRelationship.PART_OF, allNodesMap);
            appParams.addAll(appFromTPServiceParams);
        }
        pmonitor.setWorkRemaining(2700);
        if (!pmonitor.isCanceled() && !appParams.isEmpty()) {
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Dialogues_Dialogues_SP_Name, null, appParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> dialogFromApp_D_Params = this.processChildResults(results, 25, ComponentRelationship.BELONGS_TO, allNodesMap);
            dialogParams.addAll(dialogFromApp_D_Params);
        }
        pmonitor.setWorkRemaining(2600);
        if (!pmonitor.isCanceled() && !dialogParams.isEmpty()) {
            Set<Integer> dialogFromDialogParams = this.createDialogTree(dialogParams, allNodesMap, false, pmonitor.newChild(100), conn);
            dialogParams.addAll(dialogFromDialogParams);
            String[][] results2 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Exchange_SP_Name, null, dialogParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> exchangeFromDialogParams = this.processChildResults(results2, 26, ComponentRelationship.INVOKES, allNodesMap);
            exchangeParams.addAll(exchangeFromDialogParams);
            results2 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_CompAndModule_ProcessingStructure_SP_Name, null, dialogParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> compAndModuleMap2 = this.processCompAndModuleChildResults(results2, 26, ComponentRelationship.INVOKES, allNodesMap);
            Set<Integer> compFromDialogParams = compAndModuleMap2.get(11);
            compParams.addAll(compFromDialogParams);
            Set<Integer> moduleFromDialogParams = compAndModuleMap2.get(4);
            moduleParams.addAll(moduleFromDialogParams);
            results2 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Screen_fromDialogues_SP_Name, null, dialogParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> scrFromDialogParams = this.processChildResults(results2, 26, ComponentRelationship.DISPLAYS, allNodesMap);
            screenParams.addAll(scrFromDialogParams);
        }
        pmonitor.setWorkRemaining(2100);
        if (!pmonitor.isCanceled() && !exchangeParams.isEmpty()) {
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_CompAndModule_ProcessingStructure_SP_Name, null, exchangeParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            compAndModuleMap = this.processCompAndModuleChildResults(results, 16, ComponentRelationship.INVOKES, allNodesMap);
            Set<Integer> compFromExchangeParams = compAndModuleMap.get(11);
            compParams.addAll(compFromExchangeParams);
            Set<Integer> moduleFromExchangeParams = compAndModuleMap.get(4);
            moduleParams.addAll(moduleFromExchangeParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Screen_fromExchanges_SP_Name, null, exchangeParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> scrFromExchangeParams = this.processChildResults(results, 16, ComponentRelationship.DISPLAYS, allNodesMap);
            screenParams.addAll(scrFromExchangeParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Records_FromExchange_SP_Name, null, exchangeParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.processChildResults(results, 16, ComponentRelationship.BACK_USES, allNodesMap);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Sets_SP_Name, null, exchangeParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.processChildResults(results, 16, ComponentRelationship.USES, allNodesMap);
        }
        pmonitor.setWorkRemaining(1700);
        if (!pmonitor.isCanceled() && !batchPrgParams.isEmpty()) {
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_CompAndModule_ProcessingStructure_SP_Name, null, batchPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            compAndModuleMap = this.processCompAndModuleChildResults(results, 28, ComponentRelationship.INVOKES, allNodesMap);
            Set<Integer> compFromBatchPrgParams = compAndModuleMap.get(11);
            compParams.addAll(compFromBatchPrgParams);
            Set<Integer> moduleFromBatchPrgParams = compAndModuleMap.get(4);
            moduleParams.addAll(moduleFromBatchPrgParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Module_Call_SP_Name, null, batchPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> moduleFromBatchPrg_Call_Params = this.processChildResults(results, 28, ComponentRelationship.INVOKES, allNodesMap);
            moduleParams.addAll(moduleFromBatchPrg_Call_Params);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Files_Files_SP_Name, null, batchPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> fileFromBatchPrgParams = this.processChildResults(results, 28, ComponentRelationship.USES, allNodesMap);
            fileParams.addAll(fileFromBatchPrgParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Records_FromPrg_SP_Name, null, batchPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.processChildResults(results, 28, ComponentRelationship.BACK_USES, allNodesMap);
        }
        pmonitor.setWorkRemaining(1300);
        if (!pmonitor.isCanceled() && !reportPrgParams.isEmpty()) {
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_CompAndModule_ProcessingStructure_SP_Name, null, reportPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            compAndModuleMap = this.processCompAndModuleChildResults(results, 27, ComponentRelationship.INVOKES, allNodesMap);
            Set<Integer> compFromRepPrgParams = compAndModuleMap.get(11);
            compParams.addAll(compFromRepPrgParams);
            Set<Integer> moduleFromRepPrgParams = compAndModuleMap.get(4);
            moduleParams.addAll(moduleFromRepPrgParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Module_Call_SP_Name, null, reportPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> moduleFromRepPrg_Call_Params = this.processChildResults(results, 27, ComponentRelationship.INVOKES, allNodesMap);
            moduleParams.addAll(moduleFromRepPrg_Call_Params);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Files_Files_SP_Name, null, reportPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> fileFromRepPrgParams = this.processChildResults(results, 27, ComponentRelationship.USES, allNodesMap);
            fileParams.addAll(fileFromRepPrgParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Records_FromPrg_SP_Name, null, reportPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.processChildResults(results, 27, ComponentRelationship.BACK_USES, allNodesMap);
        }
        pmonitor.setWorkRemaining(900);
        if (!pmonitor.isCanceled() && !compParams.isEmpty()) {
            Map<Integer, Set<Integer>> compAndModuleMap3 = this.createComponentTree(conn, compParams, allNodesMap, false, pmonitor.newChild(100));
            Set<Integer> compFromCompParams = compAndModuleMap3.get(11);
            compParams.addAll(compFromCompParams);
            Set<Integer> moduleFromCompParams = compAndModuleMap3.get(4);
            if (moduleFromCompParams != null) {
                moduleParams.addAll((Collection<Integer>)moduleFromCompParams);
            }
            String[][] results3 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Records_FromComp_SP_Name, null, compParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.processChildResults(results3, 11, ComponentRelationship.BACK_USES, allNodesMap);
            results3 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Screen_fromComponents_SP_Name, null, compParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> scrFromCompParams = this.processChildResults(results3, 11, ComponentRelationship.DISPLAYS, allNodesMap);
            screenParams.addAll(scrFromCompParams);
            results3 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Sets_SP_Name, null, compParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            this.processChildResults(results3, 11, ComponentRelationship.USES, allNodesMap);
        }
        pmonitor.setWorkRemaining(400);
        if (!pmonitor.isCanceled() && !allParamMap.isEmpty()) {
            HashSet ddcl4PgmsParams = new HashSet();
            for (Integer type : allParamMap.keySet()) {
                if (type != 28 && type != 27 && type != 26 && type != 11 && type != 4) continue;
                ddcl4PgmsParams.addAll(allParamMap.get(type));
            }
            boolean vb = PreferenceUtils.isShowingSCLProcs();
            String[] showStandardProcedures = new String[]{String.valueOf(vb)};
            String[][] pgmresults = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Program_fromModule_And_Pgmd_from_DDCL_ELEMS_SP_Name, (String[])showStandardProcedures, ddcl4PgmsParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Triplet<String, String, TextSelectionInFile>> prgsMap = this.processPrgResults(pgmresults, allNodesMap);
            prgParams.putAll(prgsMap);
        }
        pmonitor.setWorkRemaining(200);
        if (this.continueGraphOnPrograms.booleanValue() && !prgParams.isEmpty() && this.model != null) {
            L.debug("start computing callgraph on programs");
            this.model.programs.putAll(prgParams);
            this.model.computeCg((IProgressMonitor)pmonitor.newChild(200), prgParams, true, this.graphLimitation, this.continueWithResources);
        }
        pmonitor.done();
    }

    private Map<Integer, Set<Integer>> processInputIds() {
        HashMap<Integer, Set<Integer>> allParamMap = new HashMap<Integer, Set<Integer>>();
        allParamMap.put(3, new HashSet());
        allParamMap.put(10, new HashSet());
        allParamMap.put(24, new HashSet());
        allParamMap.put(25, new HashSet());
        allParamMap.put(26, new HashSet());
        allParamMap.put(16, new HashSet());
        allParamMap.put(11, new HashSet());
        allParamMap.put(4, new HashSet());
        allParamMap.put(14, new HashSet());
        allParamMap.put(27, new HashSet());
        allParamMap.put(28, new HashSet());
        allParamMap.put(12, new HashSet());
        allParamMap.put(-1, new HashSet());
        allParamMap.put(-13, new HashSet());
        allParamMap.put(-19, new HashSet());
        allParamMap.put(0, new HashSet());
        for (Integer id : this.inputsMap.keySet()) {
            AMBaseNode amNode = this.inputsMap.get(id);
            Integer type = amNode.getAMType();
            Set idsByType = (Set)allParamMap.get(type);
            idsByType.add(id);
        }
        return allParamMap;
    }

    private Set<Integer> processChildResults(String[][] results, Integer parentType, ComponentRelationship relationship, Map<Integer, Map<String, AMBaseNode>> allNodesMap) {
        ComponentRelationship defaultRelationship = relationship;
        HashSet<Integer> params = new HashSet<Integer>();
        if (results != null && results.length > 0) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                AMBaseNode elemNode;
                String key;
                String[] result = stringArray[n2];
                Integer id = Utils.filterNullValue((String)result[0]) == null ? null : Integer.valueOf(result[0]);
                String name = result[1];
                Integer type = Integer.valueOf(result[2]);
                Integer parentId = Integer.valueOf(result[3]);
                String callTypeName = null;
                String keyForMap = key = AMNodesFactory.makeElemNodeKey(id, type, name);
                if (type.equals(12) && result[10] != null) {
                    keyForMap = key.concat("!" + result[10]);
                }
                if ((elemNode = this.getAMNode(type, allNodesMap, keyForMap)) == null) {
                    elemNode = AMNodesFactory.createNode(type, name, id);
                    this.addAMNode(type, allNodesMap, keyForMap, elemNode);
                    if (type.equals(12) && this.isReport(type, parentType, result[10])) {
                        elemNode.addProperty("file is report when is 'called' by Report-program and is LISTING FILE", Boolean.TRUE);
                    }
                    if (id != null) {
                        params.add(id);
                    }
                    if (this.considerSrc) {
                        this.putSrcInfo(result, elemNode);
                    }
                }
                String parentKey = AMNodesFactory.makeElemNodeKey(parentId, null, null);
                AMBaseNode parentNode = this.getAMNode(parentType, allNodesMap, parentKey);
                boolean singleEdgePerProperty = false;
                if (type.equals(12)) {
                    callTypeName = result[10];
                    relationship = this.getRelationshipForFile(callTypeName, true);
                    singleEdgePerProperty = true;
                }
                if (type.equals(3)) {
                    callTypeName = result[10];
                    relationship = this.getRelationshipForRecord(callTypeName, true, defaultRelationship);
                    singleEdgePerProperty = true;
                }
                if (type.equals(10)) {
                    callTypeName = result[10];
                    relationship = this.getRelationshipForSet(callTypeName, true);
                    singleEdgePerProperty = true;
                }
                parentNode.addRelation(relationship, elemNode);
                if (this.considerSrc) {
                    this.putSrcInfo(result, parentNode, true, key, singleEdgePerProperty, relationship);
                }
                ++n2;
            }
        }
        return params;
    }

    private AMBaseNode getAMNode(Integer type, Map<Integer, Map<String, AMBaseNode>> allNodesMap, String key) {
        Map<String, AMBaseNode> nodesByType = allNodesMap.get(type);
        return nodesByType != null ? nodesByType.get(key) : null;
    }

    private boolean isReport(Integer childType, Integer parentType, String callTypeName) {
        return callTypeName != null ? 27 == parentType && 12 == childType && callTypeName.equalsIgnoreCase(FILE_ELEMENT_LISTING_FILE_NAME) : false;
    }

    private void putSrcInfo(String[] result, AMBaseNode node) {
        this.putSrcInfo(result, node, false, null, false, null);
    }

    private void putSrcInfo(String[] result, AMBaseNode elemNode, boolean isForEdge, String key, boolean singleEdgePerProperty, ComponentRelationship relationship) {
        int minLength;
        String name = result[1];
        String type = result[2];
        int n = minLength = isForEdge ? 9 : 6;
        if (result.length > minLength) {
            String fileName;
            String string = fileName = isForEdge ? result[9] : result[6];
            if (Utils.filterNullValue((String)fileName) != null) {
                Integer prgType = 14;
                Integer fileType = elemNode.getAMType();
                boolean isSCL = false;
                switch (fileType) {
                    case -19: 
                    case -13: 
                    case -1: {
                        prgType = -fileType.intValue();
                        if (fileType == -1) break;
                        isSCL = true;
                    }
                }
                String startLine = isForEdge ? result[7] : result[4];
                String endLine = isForEdge ? result[8] : result[5];
                TextSelectionInFile infoSel = null;
                infoSel = isSCL ? new TextSelectionInFile(fileName, String.valueOf(prgType)) : new TextSelectionInFile(fileName, String.valueOf(prgType), new String[]{startLine, "0", endLine});
                if (isForEdge) {
                    String relKey = AMNodesFactory.getEdgeSrcInfoKey(key);
                    if (singleEdgePerProperty) {
                        HashSet<TextSelectionInFile> st;
                        HashMap<String, HashSet<TextSelectionInFile>> edgeSrcInfoMap = (HashMap<String, HashSet<TextSelectionInFile>>)elemNode.getProperty(relKey);
                        if (edgeSrcInfoMap == null) {
                            edgeSrcInfoMap = new HashMap<String, HashSet<TextSelectionInFile>>();
                            elemNode.addProperty(relKey, edgeSrcInfoMap);
                        }
                        if ((st = (HashSet<TextSelectionInFile>)edgeSrcInfoMap.get(relationship.getEdgeTypeInfo().name())) == null) {
                            st = new HashSet<TextSelectionInFile>();
                            edgeSrcInfoMap.put(relationship.getEdgeTypeInfo().name(), st);
                        }
                        st.add(infoSel);
                    } else {
                        HashSet<TextSelectionInFile> st = (HashSet<TextSelectionInFile>)elemNode.getProperty(relKey);
                        if (st == null) {
                            st = new HashSet<TextSelectionInFile>();
                            elemNode.addProperty(relKey, st);
                        }
                        st.add(infoSel);
                    }
                } else {
                    elemNode.addProperty("FILE", infoSel);
                }
            } else {
                L.warn("1. no src info for: {}, type: {}", (Object)name, (Object)type);
            }
        } else {
            L.warn("2. no src info for: {}, type: {}", (Object)name, (Object)type);
        }
    }

    private ComponentRelationship getRelationshipForFile(String callTypeName, boolean parentToChild) {
        ComponentRelationship relationshipType = null;
        if (parentToChild) {
            relationshipType = ComponentRelationship.FILES_SWITCH_DIR;
            if (callTypeName != null && (callTypeName.equalsIgnoreCase(FILE_ELEMENT_DERIVED_FILE_NAME) || callTypeName.equalsIgnoreCase(FILE_ELEMENT_LISTING_FILE_NAME))) {
                relationshipType = ComponentRelationship.FILES_KEEP_DIR;
            }
        } else {
            relationshipType = ComponentRelationship.FILES_KEEP_DIR;
            if (callTypeName != null && (callTypeName.equalsIgnoreCase(FILE_ELEMENT_DERIVED_FILE_NAME) || callTypeName.equalsIgnoreCase(FILE_ELEMENT_LISTING_FILE_NAME))) {
                relationshipType = ComponentRelationship.FILES_SWITCH_DIR;
            }
        }
        return relationshipType;
    }

    private ComponentRelationship getRelationshipForRecord(String callTypeName, boolean parentToChild, ComponentRelationship defaultRelationshipType) {
        ComponentRelationship relationshipType = defaultRelationshipType;
        if (callTypeName != null && callTypeName.equalsIgnoreCase("CHANGES")) {
            relationshipType = parentToChild ? ComponentRelationship.CHANGES_KEEP_DIR : ComponentRelationship.CHANGES_SWITCH_DIR;
        }
        if (callTypeName != null && callTypeName.equalsIgnoreCase("OUTPUT")) {
            relationshipType = parentToChild ? ComponentRelationship.OUTPUT_KEEP_DIR : ComponentRelationship.OUTPUT_SWITCH_DIR;
        }
        if (callTypeName != null && callTypeName.equalsIgnoreCase("SELECTION")) {
            relationshipType = parentToChild ? ComponentRelationship.SELECTION_SWITCH_DIR : ComponentRelationship.SELECTION_KEEP_DIR;
        }
        if (callTypeName != null && callTypeName.equalsIgnoreCase("VIEW")) {
            relationshipType = parentToChild ? ComponentRelationship.VIEW_SWITCH_DIR : ComponentRelationship.VIEW_KEEP_DIR;
        }
        if (callTypeName != null && callTypeName.equalsIgnoreCase("SINGULAR-VIEW")) {
            relationshipType = parentToChild ? ComponentRelationship.SINGULAR_VIEW_SWITCH_DIR : ComponentRelationship.SINGULAR_VIEW_KEEP_DIR;
        }
        return relationshipType;
    }

    private ComponentRelationship getRelationshipForSet(String callTypeName, boolean parentToChild) {
        ComponentRelationship relationshipType = null;
        if (callTypeName != null && callTypeName.equalsIgnoreCase("CHANGES")) {
            relationshipType = parentToChild ? ComponentRelationship.CHANGES_KEEP_DIR : ComponentRelationship.CHANGES_SWITCH_DIR;
        }
        if (callTypeName != null && callTypeName.equalsIgnoreCase("SINGULAR-VIEW")) {
            relationshipType = parentToChild ? ComponentRelationship.SINGULAR_VIEW_SWITCH_DIR : ComponentRelationship.SINGULAR_VIEW_KEEP_DIR;
        }
        return relationshipType;
    }

    private Set<Integer> createDialogTree(Set<Integer> dialogParams, Map<Integer, Map<String, AMBaseNode>> allNodesMap, boolean isBack, SubMonitor pmonitor, EZSourceConnection conn) {
        boolean run;
        boolean bl = run = this.graphLimitation == null || this.graphLimitation > 0;
        if (!run) {
            this.markUnexpandedGraphNodes(dialogParams, 26, allNodesMap);
            return dialogParams;
        }
        String spName = AM_Child_Dialogues_ProcessingStructure_SP_Name;
        if (isBack) {
            spName = AM_Parents_Of_Dialogues_DIALOGUES_SP_Name;
        }
        HashSet<Integer> localDialogParams = new HashSet<Integer>(dialogParams);
        int step = 1;
        while (!pmonitor.isCanceled() && run && !localDialogParams.isEmpty()) {
            boolean alreadyProcessed;
            String[][] results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)spName, null, localDialogParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Set<Integer> dialogFromDialog_PS_Params = null;
            if (isBack) {
                Map<Integer, Set<Integer>> idsMap = this.processParentResults(results, 26, ComponentRelationship.BACK_INVOKES, allNodesMap);
                dialogFromDialog_PS_Params = idsMap.get(26);
            } else {
                dialogFromDialog_PS_Params = this.processChildResults(results, 26, ComponentRelationship.INVOKES, allNodesMap);
            }
            localDialogParams.clear();
            if (dialogFromDialog_PS_Params != null) {
                localDialogParams.addAll(dialogFromDialog_PS_Params);
            }
            if (alreadyProcessed = localDialogParams.removeAll(dialogParams)) {
                L.debug("remove some dialog ids because are already processed.");
            }
            dialogParams.addAll(localDialogParams);
            boolean bl2 = run = this.graphLimitation == null || step < this.graphLimitation;
            if (!run) {
                this.markUnexpandedGraphNodes(localDialogParams, 26, allNodesMap);
            }
            ++step;
        }
        return dialogParams;
    }

    private void markUnexpandedGraphNodes(Collection<Integer> params, Integer type, Map<Integer, Map<String, AMBaseNode>> allNodesMap) {
        if (params == null) {
            return;
        }
        for (Integer id : params) {
            String key = AMNodesFactory.makeElemNodeKey(id, null, null);
            AMBaseNode amNode = this.getAMNode(type, allNodesMap, key);
            amNode.addProperty("node is not expanded in callgraph", Boolean.TRUE);
        }
    }

    private Map<Integer, Set<Integer>> processParentResults(String[][] results, Integer childType, ComponentRelationship relationship, Map<Integer, Map<String, AMBaseNode>> allNodesMap) {
        ComponentRelationship defaultRelationship = relationship;
        HashMap<Integer, Set<Integer>> idsMap = new HashMap<Integer, Set<Integer>>();
        if (results != null && results.length > 0) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer id = Utils.filterNullValue((String)result[0]) == null ? null : Integer.valueOf(result[0]);
                String name = result[1];
                Integer type = Integer.valueOf(result[2]);
                Integer childId = Integer.valueOf(result[3]);
                String callTypeName = null;
                String key = AMNodesFactory.makeElemNodeKey(id, type, name);
                AMBaseNode elemNode = this.getAMNode(type, allNodesMap, key);
                if (elemNode == null) {
                    elemNode = AMNodesFactory.createNode(type, name, id);
                    this.addAMNode(type, allNodesMap, key, elemNode);
                    if (id != null) {
                        HashSet<Integer> ids = (HashSet<Integer>)idsMap.get(type);
                        if (ids == null) {
                            ids = new HashSet<Integer>();
                            idsMap.put(type, ids);
                        }
                        ids.add(id);
                    }
                    if (this.considerSrc) {
                        this.putSrcInfo(result, elemNode);
                    }
                }
                String childKey = AMNodesFactory.makeElemNodeKey(childId, null, null);
                AMBaseNode childNode = this.getAMNode(childType, allNodesMap, childKey);
                boolean singleEdgePerProperty = false;
                if (childType.equals(12)) {
                    callTypeName = result[10];
                    relationship = this.getRelationshipForFile(callTypeName, false);
                    singleEdgePerProperty = true;
                }
                if (childType.equals(3)) {
                    callTypeName = result[10];
                    relationship = this.getRelationshipForRecord(callTypeName, false, defaultRelationship);
                    singleEdgePerProperty = true;
                }
                if (childType.equals(10)) {
                    callTypeName = result[10];
                    relationship = this.getRelationshipForSet(callTypeName, false);
                    singleEdgePerProperty = true;
                }
                childNode.addRelation(relationship, elemNode);
                if (this.considerSrc) {
                    this.putSrcInfo(result, childNode, true, key, singleEdgePerProperty, relationship);
                }
                ++n2;
            }
        }
        return idsMap;
    }

    private Map<Integer, Set<Integer>> processCompAndModuleChildResults(String[][] results, Integer parentType, ComponentRelationship relationship, Map<Integer, Map<String, AMBaseNode>> allNodesMap) {
        HashMap<Integer, Set<Integer>> compAndModuleMap = new HashMap<Integer, Set<Integer>>();
        HashSet<Integer> compParams = new HashSet<Integer>();
        HashSet<Integer> moduleParams = new HashSet<Integer>();
        compAndModuleMap.put(4, moduleParams);
        compAndModuleMap.put(11, compParams);
        if (results != null && results.length > 0) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer id = Utils.filterNullValue((String)result[0]) == null ? null : Integer.valueOf(result[0]);
                String name = result[1];
                Integer type = Integer.valueOf(result[2]);
                Integer parentId = Integer.valueOf(result[3]);
                String key = AMNodesFactory.makeElemNodeKey(id, type, name);
                AMBaseNode elemNode = this.getAMNode(type, allNodesMap, key);
                if (elemNode == null) {
                    elemNode = AMNodesFactory.createNode(type, name, id);
                    if (this.considerSrc) {
                        this.putSrcInfo(result, elemNode);
                    }
                    this.addAMNode(type, allNodesMap, key, elemNode);
                    if (id != null) {
                        if (11 == type) {
                            compParams.add(id);
                        } else {
                            moduleParams.add(id);
                        }
                    }
                }
                String parentKey = AMNodesFactory.makeElemNodeKey(parentId, null, null);
                AMBaseNode parentNode = this.getAMNode(parentType, allNodesMap, parentKey);
                parentNode.addRelation(relationship, elemNode);
                if (this.considerSrc) {
                    this.putSrcInfo(result, parentNode, true, key, false, null);
                }
                ++n2;
            }
        }
        return compAndModuleMap;
    }

    private Map<Integer, Set<Integer>> createComponentTree(EZSourceConnection conn, Set<Integer> compParams, Map<Integer, Map<String, AMBaseNode>> allNodesMap, boolean isBack, SubMonitor pmonitor) {
        boolean run;
        HashMap<Integer, Set<Integer>> compModuleMap = new HashMap<Integer, Set<Integer>>();
        boolean bl = run = this.graphLimitation == null || this.graphLimitation > 0;
        if (!run) {
            this.markUnexpandedGraphNodes(compParams, 11, allNodesMap);
            compModuleMap.put(11, compParams);
        }
        String spName = AM_Child_CompAndModule_ProcessingStructure_SP_Name;
        if (isBack) {
            spName = AM_Parents_Of_ComponentsOrModules_SP_Name;
        }
        HashSet<Integer> componParams = new HashSet<Integer>();
        HashSet<Integer> localCompParams = new HashSet<Integer>(compParams);
        int step = 1;
        while (!pmonitor.isCanceled() && run && !localCompParams.isEmpty()) {
            String[][] results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)spName, null, localCompParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> idsMap = null;
            idsMap = isBack ? this.processParentResults(results, 11, ComponentRelationship.BACK_INVOKES, allNodesMap) : this.processCompAndModuleChildResults(results, 11, ComponentRelationship.INVOKES, allNodesMap);
            Set<Integer> compFromCompParams = idsMap.get(11);
            localCompParams.clear();
            if (compFromCompParams != null && !compFromCompParams.isEmpty()) {
                localCompParams.addAll(compFromCompParams);
                boolean alreadyProcessed = localCompParams.removeAll(componParams);
                if (alreadyProcessed) {
                    L.debug("remove some component ids because are already processed.");
                }
                componParams.addAll(compFromCompParams);
            }
            for (Integer type : idsMap.keySet()) {
                Set<Integer> params = idsMap.get(type);
                HashSet<Integer> amParams = (HashSet<Integer>)compModuleMap.get(type);
                if (amParams == null) {
                    amParams = new HashSet<Integer>();
                    compModuleMap.put(type, amParams);
                }
                amParams.addAll(params);
            }
            boolean bl2 = run = this.graphLimitation == null || step < this.graphLimitation;
            if (!run) {
                this.markUnexpandedGraphNodes(localCompParams, 11, allNodesMap);
            }
            ++step;
        }
        return compModuleMap;
    }

    private Map<Integer, Triplet<String, String, TextSelectionInFile>> processPrgResults(String[][] results, Map<Integer, Map<String, AMBaseNode>> allNodesMap) {
        HashMap<Integer, Triplet<String, String, TextSelectionInFile>> prgFromModuleParams = new HashMap<Integer, Triplet<String, String, TextSelectionInFile>>();
        if (results != null && results.length > 0) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Integer parentType;
                String[] result = stringArray[n2];
                Integer id = Utils.filterNullValue((String)result[0]) == null ? null : Integer.valueOf(result[0]);
                String name = result[1];
                Integer n3 = parentType = Utils.filterNullValue((String)result[12]) == null ? null : Integer.valueOf(result[12]);
                Integer type = Utils.filterNullValue((String)result[2]) == null ? (parentType == 4 ? -19 : 0) : -Integer.valueOf(result[2]).intValue();
                Integer parentId = Integer.valueOf(result[3]);
                String key = AMNodesFactory.makeElemNodeKey(id, type, name);
                AMBaseNode elemNode = this.getAMNode(type, allNodesMap, key);
                if (elemNode == null) {
                    elemNode = AMNodesFactory.createNode(type, name, id);
                    this.addAMNode(type, allNodesMap, key, elemNode);
                    if (elemNode.getProperty("is a scl program") != null) {
                        String ancestorName = Utils.filterNullValue((String)result[10]) != null && !result[10].isEmpty() ? result[10] : null;
                        elemNode.addProperty("ANCESTOR_NAME", ancestorName);
                        if (Utils.filterNullValue((String)result[11]) != null) {
                            elemNode.addProperty("ANCESTOR_PRG_ID", Integer.valueOf(result[11]));
                        }
                        L.debug("ancestor name: {} for SCL {}", (Object)ancestorName, (Object)elemNode.getName());
                    }
                    if (this.considerSrc) {
                        this.putSrcInfo(result, elemNode);
                    }
                }
                if (id != null) {
                    prgFromModuleParams.put(id, (Triplet<String, String, TextSelectionInFile>)new Triplet((Object)name, (Object)result[2], (Object)((TextSelectionInFile)elemNode.getProperty("FILE"))));
                }
                String parentKey = AMNodesFactory.makeElemNodeKey(parentId, null, null);
                AMBaseNode parentNode = this.getAMNode(parentType, allNodesMap, parentKey);
                parentNode.addProperty("ddcl element(DIALOG, COMPONENT, BATCH-PROGRAM, REPORT-PROGRAM) that is identified with program", elemNode);
                parentNode.addRelation(ComponentRelationship.IDENTIFIED, elemNode);
                if (this.considerSrc) {
                    this.putSrcInfo(result, parentNode, true, key, false, null);
                }
                ++n2;
            }
        }
        return prgFromModuleParams;
    }

    private void createBackward(EZSourceConnection conn, Map<Integer, Map<String, AMBaseNode>> allNodesMap, SubMonitor monitor) {
        Map<Integer, Set<Integer>> idsMap;
        String[][] results;
        Map<Integer, Set<Integer>> idsMap2;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1400);
        pmonitor.subTask(Messages.getString(DDCLGraphBuilder.class, (String)"compute.backward.taskName"));
        Map<Integer, Set<Integer>> allParamMap = this.processInputIds();
        HashMap<Integer, Triplet<String, String, TextSelectionInFile>> prgParams = new HashMap<Integer, Triplet<String, String, TextSelectionInFile>>();
        Set<Integer> recordParams = allParamMap.get(3);
        if (!pmonitor.isCanceled() && !recordParams.isEmpty()) {
            String[][] results2 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Records_SP_Name, null, recordParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> idsMap3 = this.processParentResults(results2, 3, ComponentRelationship.USES, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap3);
        }
        pmonitor.setWorkRemaining(1300);
        Set<Integer> setParams = allParamMap.get(10);
        if (!pmonitor.isCanceled() && !setParams.isEmpty()) {
            String[][] results3 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Sets_SP_Name, null, setParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> idsMap4 = this.processParentResults(results3, 10, ComponentRelationship.BACK_USES, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap4);
        }
        pmonitor.setWorkRemaining(1200);
        Set<Integer> screenParams = allParamMap.get(14);
        if (!pmonitor.isCanceled() && !screenParams.isEmpty()) {
            String[][] results4 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Screens_SP_Name, null, screenParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> idsMap5 = this.processParentResults(results4, 14, ComponentRelationship.BACK_DISPLAYS, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap5);
        }
        pmonitor.setWorkRemaining(1100);
        Set<Integer> fileParams = allParamMap.get(12);
        if (!pmonitor.isCanceled() && !fileParams.isEmpty()) {
            String[][] results5 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Files_SP_Name, null, fileParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> idsMap6 = this.processParentResults(results5, 12, ComponentRelationship.BACK_USES, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap6);
        }
        pmonitor.setWorkRemaining(1000);
        Set<Integer> modParams = allParamMap.get(4);
        if (!pmonitor.isCanceled() && !modParams.isEmpty()) {
            String[][] results6 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Modules_Programs_SP_Name, null, modParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            idsMap2 = this.processParentResults(results6, 4, ComponentRelationship.BACK_INVOKES, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap2);
            results6 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_ComponentsOrModules_SP_Name, null, modParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            idsMap2 = this.processParentResults(results6, 4, ComponentRelationship.BACK_INVOKES, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap2);
        }
        pmonitor.setWorkRemaining(800);
        Set<Integer> compParams = allParamMap.get(11);
        if (!pmonitor.isCanceled() && !compParams.isEmpty()) {
            idsMap2 = this.createComponentTree(conn, compParams, allNodesMap, true, pmonitor.newChild(100));
            this.fillComputedIds(allParamMap, idsMap2);
        }
        pmonitor.setWorkRemaining(700);
        Set<Integer> exchangeParams = allParamMap.get(16);
        if (!pmonitor.isCanceled() && !exchangeParams.isEmpty()) {
            String[][] results7 = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Exchange_DIALOGUES_SP_Name, null, exchangeParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Set<Integer>> idsMap7 = this.processParentResults(results7, 16, ComponentRelationship.BACK_INVOKES, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap7);
        }
        pmonitor.setWorkRemaining(600);
        Set<Integer> dialogParams = allParamMap.get(26);
        if (!pmonitor.isCanceled() && !dialogParams.isEmpty()) {
            Set<Integer> dialogFromDialogParams = this.createDialogTree(dialogParams, allNodesMap, true, pmonitor.newChild(100), conn);
            dialogParams.addAll(dialogFromDialogParams);
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Dialogues_Applications_SP_Name, null, dialogParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            idsMap = this.processParentResults(results, 26, ComponentRelationship.BACK_BELONGS_TO, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap);
        }
        pmonitor.setWorkRemaining(400);
        Set<Integer> appParams = allParamMap.get(25);
        if (!pmonitor.isCanceled() && !appParams.isEmpty()) {
            results = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Parents_Of_Applications_SP_Name, null, appParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            idsMap = this.processParentResults(results, 25, ComponentRelationship.BACK_PART_OF, allNodesMap);
            this.fillComputedIds(allParamMap, idsMap);
        }
        pmonitor.setWorkRemaining(300);
        if (!pmonitor.isCanceled() && !allParamMap.isEmpty()) {
            HashSet ddcl4PgmsParams = new HashSet();
            for (Integer type : allParamMap.keySet()) {
                if (type != 28 && type != 27 && type != 26 && type != 11 && type != 4) continue;
                ddcl4PgmsParams.addAll(allParamMap.get(type));
            }
            boolean vb = PreferenceUtils.isShowingSCLProcs();
            String[] showStandardProcedures = new String[]{String.valueOf(vb)};
            String[][] pgmresults = com.ez.cobol.callgraph.utils.Utils.runStoredProcedure((EZSourceConnection)conn, (String)AM_Child_Program_fromModule_And_Pgmd_from_DDCL_ELEMS_SP_Name, (String[])showStandardProcedures, ddcl4PgmsParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            Map<Integer, Triplet<String, String, TextSelectionInFile>> prgsMap = this.processPrgResults(pgmresults, allNodesMap);
            prgParams.putAll(prgsMap);
        }
        pmonitor.setWorkRemaining(200);
        if (this.continueGraphOnPrograms.booleanValue() && !prgParams.isEmpty() && this.model != null) {
            L.debug("start computing callgraph on programs");
            this.model.programs.putAll(prgParams);
            this.model.computeCg((IProgressMonitor)pmonitor.newChild(200), prgParams, false, this.graphLimitation, this.continueWithResources);
        }
        pmonitor.done();
    }

    private void fillComputedIds(Map<Integer, Set<Integer>> allParamMap, Map<Integer, Set<Integer>> idsMap) {
        if (idsMap == null) {
            return;
        }
        for (Integer type : idsMap.keySet()) {
            Set<Integer> params = idsMap.get(type);
            Set<Integer> amParams = allParamMap.get(type);
            amParams.addAll(params);
        }
    }

    public void setInputNodes(Map<Integer, AMBaseNode> inptNodes) {
        this.inputsMap = inptNodes;
    }

    public void setContinueWithPrograms(Boolean doCgOnPrograms) {
        this.continueGraphOnPrograms = doCgOnPrograms;
    }

    public void setContinueWithResources(boolean vb) {
        this.continueWithResources = vb;
    }
}

