/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ddcl.callgraph;

import com.ez.cobol.callgraph.CallGraphBuilder;
import com.ez.cobol.callgraph.CallGraphModel;
import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.internal.Messages;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ddcl.callgraph.AMEdgeLegendInfo;
import com.ez.ddcl.callgraph.AMEdgeProperties;
import com.ez.ddcl.callgraph.AMNodeLegendInfo;
import com.ez.ddcl.callgraph.ComponentRelationship;
import com.ez.ddcl.callgraph.TSENodeComparator;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMCobol;
import com.ez.ddcl.callgraph.nodes.AMNodesFactory;
import com.ez.ddcl.callgraph.nodes.AMSCL;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.callgraph.GraphNode;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProgramType;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.ez.workspace.utils.LevelObject;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import images.LoadSVGImageClsLoader;
import images.LoadSVGImages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMasterGraphModel
extends CallGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ApplicationMasterGraphModel.class);
    public static String EDGE_TYPE_INFO_KEY = "edgeTypeInfo";
    private Map<Integer, AMBaseNode> inputAMNodes;
    private Map<String, GraphNode> prgGraphNodes = new HashMap<String, GraphNode>();
    Map<Integer, Triplet<String, String, TextSelectionInFile>> programs = new HashMap<Integer, Triplet<String, String, TextSelectionInFile>>();
    private CallGraphBuilder cgBuilder;
    private Map<Integer, TSENode> prgTSNodes = new HashMap<Integer, TSENode>();
    private List<TSENode> reportPrgNodes = new ArrayList<TSENode>();
    private List<TSENode> batchPrgNodes = new ArrayList<TSENode>();
    private List<TSENode> fileNodes = new ArrayList<TSENode>();
    private List<TSENode> exchangeNodes = new ArrayList<TSENode>();
    private List<TSENode> componentNodes = new ArrayList<TSENode>();
    private List<TSENode> recordNodes = new ArrayList<TSENode>();
    private List<TSENode> setNodes = new ArrayList<TSENode>();
    private List<TSENode> dialogueNodes = new ArrayList<TSENode>();
    private List<TSENode> moduleNodes = new ArrayList<TSENode>();
    Map<Integer, List<GraphNode>> resources = null;

    public ApplicationMasterGraphModel(AnalysisGraphManager graphManager, Direction direction, Integer limit) {
        super(graphManager, direction, limit);
    }

    public ApplicationMasterGraphModel(AnalysisGraphManager graphManager, Direction direction, Integer limit, boolean needTS) {
        super(graphManager, direction, limit, needTS);
    }

    public void setInputNodes(Map<Integer, AMBaseNode> inputAMNodes) {
        this.inputAMNodes = inputAMNodes;
    }

    public void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.graphManager.getNodeBuilder().setResizability(3);
        this.outForGISV.clear();
        this.tsNodeLevels = new HashMap();
        this.prgTSNodes.clear();
        this.reportPrgNodes.clear();
        this.batchPrgNodes.clear();
        this.exchangeNodes.clear();
        this.componentNodes.clear();
        this.fileNodes.clear();
        this.recordNodes.clear();
        this.setNodes.clear();
        this.dialogueNodes.clear();
        this.moduleNodes.clear();
        this.prgGraphNodes.clear();
        this.resources = null;
        if (this.uiStyle == 2) {
            this.graphManager.getNodeBuilder().setAttribute("uiStyle", (Object)"svg");
        } else {
            this.graphManager.getNodeBuilder().setAttribute("uiStyle", (Object)"!svg");
        }
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ApplicationMasterGraphModel.class, (String)"loading.graph"));
        LinkedList<AMBaseNode> toExpand = new LinkedList<AMBaseNode>();
        HashMap<AMBaseNode, TSENode> allTSNodes = new HashMap<AMBaseNode, TSENode>();
        HashSet<AMBaseNode> visitedComponents = new HashSet<AMBaseNode>();
        for (AMBaseNode sn : this.inputAMNodes.values()) {
            toExpand.clear();
            toExpand.add(sn);
            while (!toExpand.isEmpty()) {
                AMBaseNode cNode = (AMBaseNode)toExpand.poll();
                if (visitedComponents.contains(cNode)) continue;
                visitedComponents.add(cNode);
                TSENode tsNode = this.getOrCreateTSNode(cNode, allTSNodes);
                this.makeNodeRelationship(cNode, tsNode, allTSNodes, toExpand);
            }
        }
        if (this.programs != null && this.programs.size() > 0) {
            GraphNode gn;
            L.debug("start callgraph on programs");
            HashMap<Integer, TSENode> tsnodes = new HashMap<Integer, TSENode>();
            for (TSENode node : this.recordNodes) {
                gn = this.cgBuilder.handleResource(node.getText(), 75, this.resources);
                tsnodes.put(gn.getId(), node);
            }
            for (TSENode node : this.setNodes) {
                gn = this.cgBuilder.handleResource(node.getText(), 76, this.resources);
                tsnodes.put(gn.getId(), node);
            }
            tsnodes.putAll(this.prgTSNodes);
            this.drawCg((IProgressMonitor)monitor, this.programs.keySet(), tsnodes);
        }
    }

    private void makeNodeRelationship(AMBaseNode node, TSENode tsNode, Map<AMBaseNode, TSENode> allTSNodes, Queue<AMBaseNode> toExpand) {
        if (!node.hasRelations()) {
            return;
        }
        TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
        for (ComponentRelationship key : node.getRelationKeys()) {
            List<AMBaseNode> components = node.getNodes(key);
            for (AMBaseNode rNode : components) {
                TSENode rTSNode = this.getOrCreateTSNode(rNode, allTSNodes);
                TSENode from = key.keepLinkDirection() ? tsNode : rTSNode;
                TSENode to = key.keepLinkDirection() ? rTSNode : tsNode;
                String nodeKey = AMNodesFactory.makeElemNodeKey(rNode.getID(), rNode.getAMType(), rNode.getName());
                String relKey = AMNodesFactory.getEdgeSrcInfoKey(nodeKey);
                Object edgeSourceInfoObj = node.getProperty(relKey);
                if (edgeSourceInfoObj == null) {
                    nodeKey = AMNodesFactory.makeElemNodeKey(node.getID(), node.getAMType(), node.getName());
                    relKey = AMNodesFactory.getEdgeSrcInfoKey(nodeKey);
                    edgeSourceInfoObj = rNode.getProperty(relKey);
                }
                if (edgeSourceInfoObj instanceof Map) {
                    Map edgeSrcInfoMap = (Map)edgeSourceInfoObj;
                    Set st = (Set)edgeSrcInfoMap.get(key.getEdgeTypeInfo().name());
                    TSEEdge edge = this.getOrCreateEdge(edgeBuilder, from, to, key.getEdgeTypeInfo(), st);
                    edge.setAttribute("Application_Master_Edge", (Object)new AMEdgeProperties(key.toString(), st));
                    continue;
                }
                if (!(edgeSourceInfoObj instanceof Set)) continue;
                Set st = (Set)edgeSourceInfoObj;
                TSEEdge edge = this.getOrCreateEdge(edgeBuilder, from, to, key.getEdgeTypeInfo(), st);
                edge.setAttribute("Application_Master_Edge", (Object)new AMEdgeProperties(key.toString(), st));
            }
            toExpand.addAll(components);
        }
    }

    private TSENode getOrCreateTSNode(AMBaseNode node, Map<AMBaseNode, TSENode> allTSNodes) {
        String name = node.getName();
        node.getID();
        Integer type = node.getAMType();
        TSENode tsNode = allTSNodes.get(node);
        if (tsNode == null) {
            tsNode = this.graphManager.getNodeBuilder().addNode(this.graph);
            tsNode.setName((Object)name);
            tsNode.setTooltipText(name);
            tsNode.setAttribute("Application_Master_Node", (Object)node);
            if (node.getProperty("node is input for callgraph") != null) {
                tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                tsNode.setAttribute("Text_Color", (Object)TSEColor.blue);
            } else if (node.getProperty("node is not expanded in callgraph") != null) {
                tsNode.setAttribute("node is not expanded in callgraph", (Object)Boolean.TRUE);
                tsNode.setAttribute("Text_Color", (Object)TSEColor.darkRed);
            }
            TextSelectionInFile srcInfo = (TextSelectionInFile)node.getProperty("FILE");
            if (srcInfo != null) {
                tsNode.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
                HashSet<TextSelectionInFile> st = new HashSet<TextSelectionInFile>();
                st.add(srcInfo);
                tsNode.setAttribute("FILE", st);
            } else {
                L.info("node without srcInfo: {} (type: {})", (Object)name, (Object)type);
            }
            this.fillEntityId(node);
            tsNode.setAttribute("file is report when is 'called' by Report-program and is LISTING FILE", node.getProperty("file is report when is 'called' by Report-program and is LISTING FILE"));
            this.setNodeUI(tsNode, type, true);
            allTSNodes.put(node, tsNode);
            switch (type) {
                case 27: {
                    this.reportPrgNodes.add(tsNode);
                    break;
                }
                case 28: {
                    this.batchPrgNodes.add(tsNode);
                    break;
                }
                case 16: {
                    this.exchangeNodes.add(tsNode);
                    break;
                }
                case 11: {
                    this.componentNodes.add(tsNode);
                    break;
                }
                case 12: {
                    this.fileNodes.add(tsNode);
                    break;
                }
                case 3: {
                    this.recordNodes.add(tsNode);
                    break;
                }
                case 10: {
                    this.setNodes.add(tsNode);
                    break;
                }
                case 26: {
                    this.dialogueNodes.add(tsNode);
                    break;
                }
                case 4: {
                    this.moduleNodes.add(tsNode);
                }
            }
        }
        return tsNode;
    }

    private void fillEntityId(AMBaseNode res) {
        EZSourceDDCLElementIDSg sg = null;
        EZSourceIDMSRecordIDSg idmsxRecordSg = null;
        if (res instanceof AMSCL || res instanceof AMCobol) {
            if (res.getID() != null) {
                Triplet<String, String, TextSelectionInFile> triplet = this.programs.get(res.getID());
                Boolean occur = triplet != null && triplet.getThird() != null;
                sg = new EZSourceProgramIDSg(res.getName(), res.getID(), Integer.valueOf(-res.getAMType().intValue()), occur);
                if (res.getProperty("is a scl program") != null) {
                    ((EZSourceProgramIDSg)sg).setAncestorName((String)res.getProperty("ANCESTOR_NAME"));
                    ((EZSourceProgramIDSg)sg).setAncestorId((Integer)res.getProperty("ANCESTOR_PRG_ID"));
                }
            }
        } else if (res.getID() != null) {
            sg = new EZSourceDDCLElementIDSg(res.getName(), res.getAMType(), res.getID());
            if (3 == res.getAMType()) {
                idmsxRecordSg = new EZSourceIDMSRecordIDSg(res.getName());
            } else if (10 == res.getAMType()) {
                idmsxRecordSg = new EZSourceIDMSSetIDSg(res.getName());
            }
        }
        if (sg != null) {
            EZEntityID id = new EZEntityID();
            EZSourceProjectIDSg prjSg = new EZSourceProjectIDSg(this.ezsourcePrj);
            id.addSegment((EZSegment)prjSg);
            if (idmsxRecordSg != null) {
                id.addSegment(idmsxRecordSg);
            }
            id.addSegment((EZSegment)sg);
            res.setEZEntityID(id);
        }
    }

    private TSEEdge getOrCreateEdge(TSEdgeBuilder edgeBuilder, TSENode from, TSENode to, AMEdgeLegendInfo edgeTypeInfo, Set<TextSelectionInFile> sourceInfos) {
        TSEEdge edge = null;
        List outs = from.outEdges();
        for (TSEEdge ed : outs) {
            boolean sameEdge = false;
            if (!ed.getTargetNode().equals(to)) continue;
            switch (edgeTypeInfo) {
                case CHANGES: 
                case SELECTION: 
                case SINGULAR_VIEW: 
                case OUTPUT: 
                case VIEW: {
                    if (!edgeTypeInfo.equals(ed.getAttributeValue(EDGE_TYPE_INFO_KEY))) break;
                    sameEdge = true;
                    break;
                }
                default: {
                    sameEdge = true;
                }
            }
            if (!sameEdge) continue;
            edge = ed;
            L.debug("Edge already drawn from {} to {}", from.getName(), to.getName());
            break;
        }
        if (edge == null) {
            edge = edgeBuilder.addEdge(this.graphManager, from, to);
            edge.setAttribute("Color", (Object)edgeTypeInfo.getTSEColor());
            edge.setAttribute(EDGE_TYPE_INFO_KEY, (Object)edgeTypeInfo);
        }
        this.edgeTypesSetForLegend.add(edgeTypeInfo);
        if (sourceInfos != null && !sourceInfos.isEmpty()) {
            edge.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
            HashSet<TextSelectionInFile> infos = (HashSet<TextSelectionInFile>)edge.getAttributeValue("FILE");
            if (infos == null) {
                infos = new HashSet<TextSelectionInFile>();
                edge.setAttribute("FILE", infos);
            }
            infos.addAll(sourceInfos);
        } else {
            L.warn("no src for edge: {} -> {}", from.getName(), to.getName());
        }
        return edge;
    }

    public void setNodeUI(TSENode tsNode, Integer typeId, boolean addToInventory) {
        TSESVGImage svgimage = null;
        String inventoryLbl = null;
        switch (typeId) {
            case 24: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.TP_SERVICE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.TP_SERVICE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.TP_SERVICE.getTSEColor(), TSEColor.white);
                inventoryLbl = AMNodeLegendInfo.TP_SERVICE.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.TP_SERVICE);
                break;
            }
            case 25: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.APPLICATION.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.APPLICATION.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.APPLICATION.getTSEColor());
                inventoryLbl = AMNodeLegendInfo.APPLICATION.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.APPLICATION);
                break;
            }
            case 26: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.DIALOGUE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.DIALOGUE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.DIALOGUE.getTSEColor(), TSEColor.white);
                inventoryLbl = AMNodeLegendInfo.DIALOGUE.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.DIALOGUE);
                break;
            }
            case 16: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.EXCHANGE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.EXCHANGE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.EXCHANGE.getTSEColor(), TSEColor.white);
                inventoryLbl = AMNodeLegendInfo.EXCHANGE.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.EXCHANGE);
                break;
            }
            case 11: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.COMPONENT.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.COMPONENT.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.COMPONENT.getTSEColor());
                inventoryLbl = AMNodeLegendInfo.COMPONENT.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.COMPONENT);
                break;
            }
            case 4: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.MODULE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.MODULE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.MODULE.getTSEColor(), TSEColor.white);
                inventoryLbl = AMNodeLegendInfo.MODULE.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.MODULE);
                break;
            }
            case 14: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.SCREEN.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.SCREEN.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.SCREEN.getTSEColor(), TSEColor.white);
                inventoryLbl = AMNodeLegendInfo.SCREEN.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.SCREEN);
                break;
            }
            case 27: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.REPORT_PROGRAM.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.REPORT_PROGRAM.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.REPORT_PROGRAM.getTSEColor());
                inventoryLbl = AMNodeLegendInfo.REPORT_PROGRAM.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.REPORT_PROGRAM);
                break;
            }
            case 28: {
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.BATCH_PROGRAM.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.BATCH_PROGRAM.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.BATCH_PROGRAM.getTSEColor());
                inventoryLbl = AMNodeLegendInfo.BATCH_PROGRAM.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.BATCH_PROGRAM);
                break;
            }
            case 12: {
                if (tsNode.hasAttribute("file is report when is 'called' by Report-program and is LISTING FILE") && ((Boolean)tsNode.getAttributeValue("file is report when is 'called' by Report-program and is LISTING FILE")).booleanValue()) {
                    tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.REPORT.getNodeTypeClass());
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.REPORT.getGraphImagePath());
                    this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.REPORT.getTSEColor());
                    inventoryLbl = AMNodeLegendInfo.REPORT.getLegendLabel();
                    this.nodeTypesSetForLegend.add(AMNodeLegendInfo.REPORT);
                    break;
                }
                tsNode.setAttribute("class_name", (Object)AMNodeLegendInfo.FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)AMNodeLegendInfo.FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, AMNodeLegendInfo.FILE.getTSEColor());
                inventoryLbl = AMNodeLegendInfo.FILE.getLegendLabel();
                this.nodeTypesSetForLegend.add(AMNodeLegendInfo.FILE);
                break;
            }
            case 3: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMSX_RECORD.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)CallgraphNodeLegendInfo.IDMSX_RECORD.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMSX_RECORD.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.IDMSX_RECORD.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IDMSX_RECORD);
                break;
            }
            case 10: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMSX_SET.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImageClsLoader.class, (String)CallgraphNodeLegendInfo.IDMSX_SET.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMSX_SET.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.IDMSX_SET.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IDMSX_SET);
                break;
            }
            case -1: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.COBOL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.COBOL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.COBOL.getTSEColor(), TSEColor.white);
                this.prepare4PrgCg(tsNode, -typeId.intValue());
                inventoryLbl = CallgraphNodeLegendInfo.COBOL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.COBOL);
                break;
            }
            case -19: 
            case -13: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SCL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SCL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SCL.getTSEColor());
                this.prepare4PrgCg(tsNode, -typeId.intValue());
                inventoryLbl = CallgraphNodeLegendInfo.SCL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.SCL);
                break;
            }
            case 0: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.UNKNOWN.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.UNKNOWN.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.UNKNOWN.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.UNKNOWN.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.UNKNOWN);
            }
        }
        if (addToInventory) {
            this.putEntriesInGISV(inventoryLbl, tsNode);
        }
    }

    private void setNodeUI(TSENode node, TSESVGImage svgimage, TSEColor fillColor) {
        this.setNodeUI(node, svgimage, fillColor, null);
    }

    private void setNodeUI(TSENode node, TSESVGImage svgimage, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("uiImage", (Object)svgimage);
        node.setAttribute("Fill_Color", (Object)fillColor);
        node.setAttribute("Color", (Object)textColor);
        this.setNodeUI(node);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            TSEColor color = (TSEColor)node.getAttributeValue("Color");
            if (color != null) {
                node.setAttribute("Text_Color", (Object)color);
            }
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        } else if (node.hasAttribute("node is not expanded in callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.darkRed);
        }
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        AMBaseNode o = (AMBaseNode)gNode.getAttributeValue("Application_Master_Node");
        if (o != null && o.getEntityID() != null) {
            Integer type = o.getAMType();
            EZObjectType res = null;
            res = 3 == type ? (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(75)) : (10 == type ? (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(76)) : (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(type, "EZ_OBJECT_TYPE_FOR_DDCL_ELEMENT"));
            if (res != null) {
                EZEntityID id = o.getEntityID();
                res.setEntID(id);
                EZSourceDDCLElementIDSg sg = (EZSourceDDCLElementIDSg)id.getSegment(EZSourceDDCLElementIDSg.class);
                if (sg != null) {
                    res.setName(sg.getName());
                }
            }
            return res;
        }
        return super.getApplicableInputType(gNode);
    }

    public void updateDrawing() {
        TSDGraph hide;
        super.updateDrawing();
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    private void prepare4PrgCg(TSENode tsNode, Integer typeId) {
        GraphNode graphNode;
        AMBaseNode amNode = (AMBaseNode)tsNode.getAttributeValue("Application_Master_Node");
        if (amNode != null && amNode.getID() != null && (graphNode = this.prgGraphNodes.get(String.valueOf(amNode.getID()))) != null) {
            Integer graphnodeId = graphNode.getId();
            this.prgTSNodes.put(graphnodeId, tsNode);
            tsNode.setAttribute("level", (Object)0);
            String programType = ProgramType.COBOL.toString();
            if (13 == typeId) {
                programType = ProgramType.SCL.toString();
            } else if (19 == typeId) {
                programType = ProgramType.SCL_PROCEDURE.toString();
            }
            tsNode.setAttribute("program_type", (Object)programType);
            tsNode.setAttribute("RESOURCE_TYPE", (Object)String.valueOf(typeId));
        }
    }

    protected void computeCg(final IProgressMonitor monitor, Map<Integer, Triplet<String, String, TextSelectionInFile>> programs, boolean isForward, Integer cgLimitation, boolean continueWithResources) {
        Runnable stopCode = new Runnable(){

            @Override
            public void run() {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException("action canceled on closed by OS");
                }
            }
        };
        L.debug("start program call graph in application master graph");
        HashMap<Integer, String> prgs = new HashMap<Integer, String>();
        if (continueWithResources) {
            if (this.resources == null) {
                this.resources = new HashMap<Integer, List<GraphNode>>();
            }
        } else {
            this.resources = null;
        }
        HashMap<String, String> prgInfos = new HashMap<String, String>();
        for (Integer dbid : programs.keySet()) {
            Triplet<String, String, TextSelectionInFile> triplet = programs.get(dbid);
            prgs.put(dbid, (String)triplet.getFirst());
            String prgType = (String)triplet.getSecond();
            prgInfos.put(dbid.toString(), prgType);
        }
        if (!prgInfos.isEmpty()) {
            L.debug("build callgraph on {}", prgInfos.keySet());
            this.cgBuilder = new CallGraphBuilder(stopCode, new EZSourceProjectIDSg(this.ezsourcePrj));
            this.graphManager.setAttribute("outForGISV", (Object)this.outForGISV);
            SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.cgBuilder.buildGraph(prgInfos, prgs, this.prgGraphNodes, this.resources, isForward, !isForward, cgLimitation, (IProgressMonitor)pmonitor.newChild(100));
            pmonitor.done();
        }
    }

    private void drawCg(IProgressMonitor monitor, Set<Integer> prgSet, Map<Integer, TSENode> tsnodes) {
        int layer = this.tsNodeLevels.size();
        ArrayList<TSENode> currentLevel = new ArrayList<TSENode>();
        this.tsNodeLevels.put(new LevelObject(Integer.valueOf(layer)), currentLevel);
        currentLevel.addAll(this.prgTSNodes.values());
        for (Integer dbid : prgSet) {
            GraphNode start = this.prgGraphNodes.get(dbid.toString());
            this.cgBuilder.createTreeGraph(this.graphManager, this.graph, start, layer, this.tsNodeLevels, tsnodes);
            TSENode prgStartNode = this.prgTSNodes.get(start.getId());
            if (prgStartNode != null) {
                TextSelectionInFile sel;
                Triplet<String, String, TextSelectionInFile> triplet = this.programs.get(dbid);
                if (triplet != null && (sel = (TextSelectionInFile)triplet.getThird()) != null) {
                    prgStartNode.removeAttribute("FILE");
                    Utils.setFileAttribute((TSGraphMember)prgStartNode, (TextSelectionInFile)sel);
                    if (!prgStartNode.hasAttribute("Node_Mainframe")) {
                        String pId = sel.getPrgType();
                        String pType = com.ez.mainframe.data.utils.Utils.getPrgType((String)pId);
                        MainframeSourceNode prgNode = new MainframeSourceNode(pType, sel.getFileName());
                        prgStartNode.setAttribute("Node_Mainframe", (Object)prgNode);
                    }
                }
                if (start.getProperty("node is not expanded in callgraph") == null) continue;
                prgStartNode.setAttribute("node is not expanded in callgraph", start.getProperty("node is not expanded in callgraph"));
                continue;
            }
            L.debug("program node not found: {}", (Object)start.getName());
        }
    }

    public Map<String, GraphNode> getProgramNodes() {
        return this.prgGraphNodes;
    }

    public void applySeparationConstraint() {
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSLayoutInputTailor inputTaylor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        inputTaylor.addSeparationConstraint(this.reportPrgNodes, this.fileNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.batchPrgNodes, this.fileNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.reportPrgNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.batchPrgNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.exchangeNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.componentNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.fileNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.dialogueNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.moduleNodes, this.recordNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.exchangeNodes, this.setNodes, 3, 50.0, 0);
        inputTaylor.addSeparationConstraint(this.componentNodes, this.setNodes, 3, 50.0, 0);
    }

    public void writeGraphToFile(TSEGraph graph, List<EZSegment> fileName, String pathSelected) {
        block22: {
            EZSourceDDCLElementIDSg programName;
            String prgName = "";
            if (fileName.get(1) instanceof EZSourceDDCLElementIDSg) {
                programName = (EZSourceDDCLElementIDSg)fileName.get(1);
                prgName = programName.getName();
            } else if (fileName.get(2) instanceof EZSourceDDCLElementIDSg) {
                programName = (EZSourceDDCLElementIDSg)fileName.get(2);
                prgName = programName.getName();
            } else if (fileName.get(1) instanceof EZSourceJobIDSg) {
                programName = (EZSourceJobIDSg)fileName.get(1);
                prgName = programName.getJobExpandedName();
            } else if (fileName.get(1) instanceof EZSourceTransactionIDSg) {
                programName = (EZSourceTransactionIDSg)fileName.get(1);
                prgName = programName.getTransactionName();
            } else if (fileName.get(1) instanceof EZSourceScreenIDSg) {
                programName = (EZSourceScreenIDSg)fileName.get(1);
                prgName = programName.getScreenNameToPrint();
            } else if (fileName.get(1) instanceof EZSourceIDMSRecordIDSg) {
                programName = (EZSourceIDMSRecordIDSg)fileName.get(1);
                prgName = programName.getIDMSRecordName();
            }
            String pathToWrite = String.valueOf(pathSelected) + "/" + prgName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block22;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + prgName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                StringBuilder locationValue = new StringBuilder();
                                if (tsf.getFileName() != null && tsf.getFileName().contains("\\")) {
                                    locationValue.append(newLine);
                                    locationValue.append("File name :");
                                    locationValue.append(tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                }
                                if (tsf.getPrgType() != null) {
                                    locationValue.append(newLine);
                                    locationValue.append("Program type :");
                                    locationValue.append(tsf.getPrgType());
                                    locationValue.append(newLine);
                                }
                                fw.write(locationValue.toString());
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("JCL to programs") || allAttrNames.toString().trim().equals("Sources") || allAttrNames.toString().trim().equals("PROGRAM_ID") || allAttrNames.toString().trim().equals("Application_Master_Node") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        StringBuilder textValue = new StringBuilder();
                        if (textLine.getFileName() != null && textLine.getFileName().contains("\\")) {
                            textValue.append(newLine);
                            textValue.append("\t\tProgram ");
                            textValue.append(textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1));
                        }
                        if (textLine.getPrgType() != null) {
                            textValue.append(" of type ");
                            textValue.append(textLine.getPrgType());
                            textValue.append(newLine);
                        }
                        fileAttrToWrite.add(textValue.toString());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (stmtType != null && !stmtType.isEmpty()) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        Collections.sort(listToWrite);
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

