/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ddcl.callgraph;

import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.model.StatementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AMEdgeProperties
implements StatementInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected String name;
    protected Set<TextSelectionInFile> sourceInfo;

    public AMEdgeProperties(String name, Set<TextSelectionInFile> sel) {
        this.name = name;
        this.sourceInfo = sel;
    }

    public List<Object[]> getLocations() {
        ArrayList<Object[]> loc = new ArrayList<Object[]>();
        if (this.sourceInfo != null && this.sourceInfo.size() > 0) {
            for (TextSelectionInFile tsf : this.sourceInfo) {
                int[] bounds = tsf.getBounds();
                Integer startLine = null;
                Integer startCol = null;
                if (bounds != null && bounds.length > 1) {
                    startLine = bounds[0];
                    startCol = bounds[1];
                }
                String prgTypeId = tsf.getPrgType();
                String prgType = Utils.getPrgType((String)prgTypeId);
                Object[] l = new Object[]{tsf.getFileName(), prgType, startLine, startCol};
                loc.add(l);
            }
        }
        return loc;
    }

    public String getStatementName() {
        return this.name;
    }
}

